/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.ex;

import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GlassPanel
extends JComponent {
    private final Set<JComponent> myLightComponents = new HashSet<JComponent>();
    private final JComponent myPanel;
    private static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
    private static final String SPOTLIGHT_BACKGROUND_COLOR_KEY = "Settings.Spotlight.backgroundColor";
    private static final String SPOTLIGHT_BORDER_COLOR_KEY = "Settings.Spotlight.borderColor";
    private static final JBColor FALLBACK_SPOTLIGHT_BORDER_COLOR = new JBColor((Color)JBColor.namedColor((String)"ColorPalette.Orange6", (int)14714965), (Color)JBColor.namedColor((String)"ColorPalette.Orange4", (int)10709838));

    public GlassPanel(JComponent containingPanel) {
        this.myPanel = containingPanel;
        this.setVisible(false);
    }

    @Override
    public void paintComponent(Graphics g) {
        this.paintSpotlights(g);
    }

    private void paintSpotlights(Graphics g) {
        this.paintSpotlight(g, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintSpotlight(Graphics g, JComponent surfaceComponent) {
        Dimension size2 = surfaceComponent.getSize();
        if (!this.myLightComponents.isEmpty()) {
            int stroke = 2;
            Rectangle visibleRect = this.myPanel.getVisibleRect();
            Point leftPoint = SwingUtilities.convertPoint(this.myPanel, new Point(visibleRect.x, visibleRect.y), surfaceComponent);
            Area innerPanel = new Area(new Rectangle2D.Double(leftPoint.x, leftPoint.y, visibleRect.width, visibleRect.height));
            Area mask = new Area(new Rectangle(-stroke, -stroke, 2 * stroke + size2.width, 2 * stroke + size2.height));
            for (JComponent lightComponent : this.myLightComponents) {
                Area labelForArea;
                JLabel label2;
                Component labelFor;
                Area area = GlassPanel.getComponentArea(surfaceComponent, lightComponent, 1);
                if (area == null) continue;
                if (lightComponent instanceof JLabel && (labelFor = (label2 = (JLabel)lightComponent).getLabelFor()) instanceof JComponent && (labelForArea = GlassPanel.getComponentArea(surfaceComponent, (JComponent)labelFor, 1)) != null) {
                    area.add(labelForArea);
                }
                area.intersect(innerPanel);
                mask.subtract(area);
            }
            Graphics clip = g.create(0, 0, size2.width, size2.height);
            try {
                Graphics2D g2 = (Graphics2D)clip;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
                Color background = GlassPanel.getOverlayColor(surfaceComponent);
                g2.setColor(background);
                g2.fill(mask);
                g2.setStroke(new BasicStroke(stroke));
                Color borderColor = UIManager.getColor(SPOTLIGHT_BORDER_COLOR_KEY);
                g2.setColor(borderColor != null ? borderColor : FALLBACK_SPOTLIGHT_BORDER_COLOR);
                g2.draw(mask);
            }
            finally {
                clip.dispose();
            }
        }
    }

    @Nullable
    private static Area getComponentArea(JComponent surfaceComponent, JComponent lightComponent, int offset) {
        if (!lightComponent.isShowing()) {
            return null;
        }
        Point panelPoint = SwingUtilities.convertPoint(lightComponent, new Point(0, 0), surfaceComponent);
        int x = panelPoint.x;
        int y = panelPoint.y;
        Insets insetsToIgnore = lightComponent.getInsets();
        boolean isWithBorder = Boolean.TRUE.equals(lightComponent.getClientProperty("searchUtil.highlightWithBorder"));
        boolean isLabelFromTabbedPane = Boolean.TRUE.equals(lightComponent.getClientProperty("JBTabbedPane.labelFromTabbedPane"));
        if (insetsToIgnore == null || isWithBorder) {
            insetsToIgnore = EMPTY_INSETS;
        }
        int hInset = GlassPanel.getComponentHInset(isWithBorder, isLabelFromTabbedPane);
        int vInset = GlassPanel.getComponentVInset(isWithBorder, isLabelFromTabbedPane);
        int xCoord = x - (hInset += offset) + insetsToIgnore.left;
        int yCoord = y - (vInset += offset) + insetsToIgnore.top;
        int width = lightComponent.getWidth() + hInset * 2 - insetsToIgnore.right - insetsToIgnore.left;
        int height = lightComponent.getHeight() + vInset * 2 - insetsToIgnore.top - insetsToIgnore.bottom;
        return new Area(new RoundRectangle2D.Double(xCoord, yCoord, width, height, Math.min(height, 30), Math.min(height, 30)));
    }

    private static int getComponentHInset(boolean isWithBorder, boolean isLabelFromTabbedPane) {
        return isWithBorder ? 7 : (isLabelFromTabbedPane ? 20 : 7);
    }

    private static int getComponentVInset(boolean isWithBorder, boolean isLabelFromTabbedPane) {
        return isWithBorder ? 1 : (isLabelFromTabbedPane ? 10 : 5);
    }

    public static double getArea(JComponent component2) {
        return Math.PI * (double)component2.getWidth() * (double)component2.getHeight() / 4.0;
    }

    @NotNull
    private static Color getOverlayColor(JComponent surfaceComponent) {
        Color fallbackBackground;
        Color background = UIManager.getColor(SPOTLIGHT_BACKGROUND_COLOR_KEY);
        if (background != null) {
            Color color = background;
            if (color == null) {
                GlassPanel.$$$reportNull$$$0(0);
            }
            return color;
        }
        Color surfaceComponentBackground = surfaceComponent.getBackground();
        Color color = fallbackBackground = ColorUtil.toAlpha((Color)(surfaceComponentBackground == null ? null : surfaceComponentBackground.darker()), (int)100);
        if (color == null) {
            GlassPanel.$$$reportNull$$$0(1);
        }
        return color;
    }

    public void addSpotlight(JComponent component2) {
        this.myLightComponents.add(component2);
        this.setVisible(true);
    }

    public void removeSpotlight(JComponent component2) {
        this.myLightComponents.remove(component2);
        if (this.myLightComponents.isEmpty()) {
            this.setVisible(false);
        }
    }

    public void clear() {
        this.myLightComponents.clear();
        this.setVisible(false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/ex/GlassPanel", "getOverlayColor"));
    }
}

