/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.util.io.StorageLockContext;
import com.intellij.util.io.storage.AbstractRecordsTable;
import com.intellij.util.io.storage.RecordIdIterator;
import java.io.IOException;
import java.nio.file.Path;
import java.util.BitSet;
import java.util.concurrent.locks.Lock;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class CompactRecordsTable
extends AbstractRecordsTable {
    private final byte[] zeroes;
    private final boolean forceSplit;
    private static final int ADDRESS_OFFSET = 0;
    private static final int SIZE_AND_CAPACITY_OFFSET = 4;
    private static final int SIZE_OFFSET_IN_INDIRECT_RECORD = 0;
    private static final int CAPACITY_OFFSET_IN_INDIRECT_RECORD = 4;
    private static final int SIZE_MASK = 65535;
    private static final int CAPACITY_MASK = 0x7FFF0000;
    private static final int CAPACITY_SHIFT = 16;
    private static final int SPECIAL_POSITIVE_VALUE_FOR_SPECIAL_NEGATIVE_SIZE = 65535;

    @VisibleForTesting
    public CompactRecordsTable(@NotNull Path recordsFile, StorageLockContext pool, boolean forceSplit) throws IOException {
        if (recordsFile == null) {
            CompactRecordsTable.$$$reportNull$$$0(0);
        }
        super(recordsFile, pool);
        this.zeroes = new byte[this.getRecordSize()];
        this.forceSplit = forceSplit;
    }

    protected int getImplVersion() {
        return 1;
    }

    protected int getRecordSize() {
        return 8;
    }

    protected byte[] getZeros() {
        return this.zeroes;
    }

    public long getAddress(int record) throws IOException {
        int address = this.myStorage.getInt((long)this.getOffset(record, 0));
        if (address < 0) {
            return super.getAddress(-address);
        }
        return address;
    }

    public void setAddress(int record, long address) throws IOException {
        this.markDirty();
        int addressOfRecordAbsoluteOffset = this.getOffset(record, 0);
        int existing_address = this.myStorage.getInt((long)addressOfRecordAbsoluteOffset);
        if (existing_address < 0) {
            super.setAddress(-existing_address, address);
            return;
        }
        if (address > Integer.MAX_VALUE || address < 0L || this.forceSplit) {
            int extendedRecord = this.doCreateNewRecord();
            super.setAddress(extendedRecord, address);
            this.myStorage.putInt((long)addressOfRecordAbsoluteOffset, -extendedRecord);
        } else {
            this.myStorage.putInt((long)addressOfRecordAbsoluteOffset, (int)address);
        }
    }

    private int doCreateNewRecord() {
        try {
            return this.createNewRecord();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize(int record) throws IOException {
        Lock readLock = this.myStorage.getStorageLockContext().readLock();
        readLock.lock();
        try {
            int currentValue = this.myStorage.getInt((long)this.getOffset(record, 4));
            if (currentValue < 0) {
                int n = this.myStorage.getInt((long)this.getOffset(-currentValue, 0));
                return n;
            }
            int i2 = currentValue & 0xFFFF;
            if (i2 == 65535) {
                i2 = -1;
            }
            int n = i2;
            return n;
        }
        finally {
            readLock.unlock();
        }
    }

    public void setSize(int record, int size2) throws IOException {
        this.markDirty();
        int sizeAndCapacityOfRecordAbsoluteOffset = this.getOffset(record, 4);
        int currentValue = this.myStorage.getInt((long)sizeAndCapacityOfRecordAbsoluteOffset);
        if (currentValue < 0) {
            this.myStorage.putInt((long)this.getOffset(-currentValue, 0), size2);
            this.myStorage.putInt((long)this.getOffset(-currentValue, 4), size2);
            return;
        }
        if (size2 >= 65535 || size2 < -1 || this.forceSplit) {
            this.extendSizeAndCapacityRecord(record, size2, this.getCapacity(record));
            return;
        }
        if (size2 == -1) {
            size2 = 65535;
        }
        this.myStorage.putInt((long)sizeAndCapacityOfRecordAbsoluteOffset, size2 | currentValue & 0x7FFF0000);
    }

    private void extendSizeAndCapacityRecord(int record, int size2, int capacity) throws IOException {
        int extendedRecord = this.doCreateNewRecord();
        this.myStorage.putInt((long)this.getOffset(extendedRecord, 0), size2);
        this.myStorage.putInt((long)this.getOffset(extendedRecord, 4), capacity);
        this.myStorage.putInt((long)this.getOffset(record, 4), -extendedRecord);
    }

    public int getCapacity(int record) throws IOException {
        int currentValue = this.myStorage.getInt((long)this.getOffset(record, 4));
        if (currentValue < 0) {
            return this.myStorage.getInt((long)this.getOffset(-currentValue, 4));
        }
        return (currentValue & 0x7FFF0000) >> 16;
    }

    public void setCapacity(int record, int capacity) throws IOException {
        this.markDirty();
        int sizeAndCapacityOfRecordAbsoluteOffset = this.getOffset(record, 4);
        int currentValue = this.myStorage.getInt((long)sizeAndCapacityOfRecordAbsoluteOffset);
        if (currentValue < 0) {
            this.myStorage.putInt((long)this.getOffset(-currentValue, 4), capacity);
            return;
        }
        if (capacity > Short.MAX_VALUE || capacity < 0 || this.forceSplit) {
            this.extendSizeAndCapacityRecord(record, this.getSize(record), capacity);
            return;
        }
        this.myStorage.putInt((long)sizeAndCapacityOfRecordAbsoluteOffset, currentValue & 0xFFFF | capacity << 16);
    }

    public void deleteRecord(int record) throws IOException {
        int sizeAndCapacityOfRecordAbsoluteOffset = this.getOffset(record, 4);
        int sizeAndCapacityValue = this.myStorage.getInt((long)sizeAndCapacityOfRecordAbsoluteOffset);
        int addressOfRecordAbsoluteOffset = this.getOffset(record, 0);
        int existingAddressValue = this.myStorage.getInt((long)addressOfRecordAbsoluteOffset);
        super.deleteRecord(record);
        if (sizeAndCapacityValue < 0) {
            super.deleteRecord(-sizeAndCapacityValue);
        }
        if (existingAddressValue < 0) {
            super.deleteRecord(-existingAddressValue);
        }
    }

    public RecordIdIterator createRecordIdIterator() throws IOException {
        final BitSet extraRecordsIds = this.buildIdSetOfExtraRecords();
        final RecordIdIterator iterator2 = super.createRecordIdIterator();
        return new RecordIdIterator(){
            int nextId = this.scanToNextId();

            private int scanToNextId() {
                while (iterator2.hasNextId()) {
                    int next = iterator2.nextId();
                    if (extraRecordsIds.get(next)) continue;
                    return next;
                }
                return -1;
            }

            public boolean hasNextId() {
                return this.nextId != -1;
            }

            public int nextId() {
                assert (this.hasNextId());
                int result2 = this.nextId;
                this.nextId = this.scanToNextId();
                return result2;
            }

            @TestOnly
            public boolean validId() throws IOException {
                assert (this.hasNextId());
                return CompactRecordsTable.isSizeOfLiveRecord((int)CompactRecordsTable.this.getSize(this.nextId));
            }
        };
    }

    @NotNull
    private BitSet buildIdSetOfExtraRecords() throws IOException {
        BitSet extraRecords = new BitSet();
        RecordIdIterator iterator2 = super.createRecordIdIterator();
        while (iterator2.hasNextId()) {
            int recordId = iterator2.nextId();
            int sizeAndCapacityOfRecordAbsoluteOffset = this.getOffset(recordId, 4);
            int sizeAndCapacityValue = this.myStorage.getInt((long)sizeAndCapacityOfRecordAbsoluteOffset);
            int addressOfRecordAbsoluteOffset = this.getOffset(recordId, 0);
            int existingAddressValue = this.myStorage.getInt((long)addressOfRecordAbsoluteOffset);
            if (sizeAndCapacityValue < 0) {
                extraRecords.set(-sizeAndCapacityValue);
            }
            if (existingAddressValue >= 0) continue;
            extraRecords.set(-existingAddressValue);
        }
        BitSet bitSet = extraRecords;
        if (bitSet == null) {
            CompactRecordsTable.$$$reportNull$$$0(1);
        }
        return bitSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordsFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/persistent/CompactRecordsTable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/CompactRecordsTable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildIdSetOfExtraRecords";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

