/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSRecordsLockFreeOverMMappedFile;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSRecordsOverInMemoryStorage;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSRecordsStorage;
import com.intellij.platform.util.io.storages.StorageFactory;
import com.intellij.platform.util.io.storages.mmapped.MMappedFileStorage;
import com.intellij.platform.util.io.storages.mmapped.MMappedFileStorageFactory;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.StorageAlreadyInUseException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.optionals.OptionalsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b'\u0018\u0000 \u000b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\t\n\u000bB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/vfs/newvfs/persistent/PersistentFSRecordsStorageFactory;", "Lcom/intellij/platform/util/io/storages/StorageFactory;", "Lcom/intellij/openapi/vfs/newvfs/persistent/PersistentFSRecordsStorage;", "id", "", "<init>", "(I)V", "getId", "()I", "OverMMappedFile", "InMemory", "Companion", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public abstract class PersistentFSRecordsStorageFactory
implements StorageFactory<PersistentFSRecordsStorage> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int id;
    @NotNull
    private static PersistentFSRecordsStorageFactory storageFactory = com.intellij.openapi.vfs.newvfs.persistent.PersistentFSRecordsStorageFactory$Companion.access$defaultFromSystemProperties(Companion);

    public PersistentFSRecordsStorageFactory(int id2) {
        this.id = id2;
    }

    public final int getId() {
        return this.id;
    }

    @JvmStatic
    @NotNull
    public static final PersistentFSRecordsStorageFactory storageImplementation() {
        return Companion.storageImplementation();
    }

    @JvmStatic
    @VisibleForTesting
    @JvmName(name="setStorageImplementation")
    public static final void setStorageImplementation(@NotNull PersistentFSRecordsStorageFactory value) {
        Companion.setStorageImplementation(value);
    }

    @JvmStatic
    @VisibleForTesting
    @JvmName(name="resetStorageImplementation")
    public static final void resetStorageImplementation() {
        Companion.resetStorageImplementation();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0005H\u0007J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005H\u0007J\b\u0010\n\u001a\u00020\bH\u0007J\b\u0010\u000b\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/vfs/newvfs/persistent/PersistentFSRecordsStorageFactory$Companion;", "", "<init>", "()V", "storageFactory", "Lcom/intellij/openapi/vfs/newvfs/persistent/PersistentFSRecordsStorageFactory;", "storageImplementation", "setStorageImplementation", "", "value", "resetStorageImplementation", "defaultFromSystemProperties", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final PersistentFSRecordsStorageFactory storageImplementation() {
            return storageFactory;
        }

        @JvmStatic
        @VisibleForTesting
        @JvmName(name="setStorageImplementation")
        public final void setStorageImplementation(@NotNull PersistentFSRecordsStorageFactory value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            storageFactory = value;
        }

        @JvmStatic
        @VisibleForTesting
        @JvmName(name="resetStorageImplementation")
        public final void resetStorageImplementation() {
            storageFactory = this.defaultFromSystemProperties();
        }

        private final PersistentFSRecordsStorageFactory defaultFromSystemProperties() {
            return Intrinsics.areEqual((Object)System.getProperty("vfs.records-storage.impl", "OVER_MMAPPED_FILE"), (Object)"IN_MEMORY") ? (PersistentFSRecordsStorageFactory)new InMemory(0, 1, null) : (PersistentFSRecordsStorageFactory)new OverMMappedFile(0, false, 3, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final /* synthetic */ PersistentFSRecordsStorageFactory access$defaultFromSystemProperties(Companion $this) {
            return $this.defaultFromSystemProperties();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0083\u0004J\n\u0010\u0012\u001a\u00020\u0003H\u00d6\u0081\u0004J\n\u0010\u0013\u001a\u00020\u0014H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openapi/vfs/newvfs/persistent/PersistentFSRecordsStorageFactory$InMemory;", "Lcom/intellij/openapi/vfs/newvfs/persistent/PersistentFSRecordsStorageFactory;", "maxRecordsCount", "", "<init>", "(I)V", "getMaxRecordsCount", "()I", "open", "Lcom/intellij/openapi/vfs/newvfs/persistent/PersistentFSRecordsOverInMemoryStorage;", "storagePath", "Ljava/nio/file/Path;", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "", "intellij.platform.ide.impl"})
    public static final class InMemory
    extends PersistentFSRecordsStorageFactory {
        private final int maxRecordsCount;

        public InMemory(int maxRecordsCount) {
            super(2);
            this.maxRecordsCount = maxRecordsCount;
        }

        public /* synthetic */ InMemory(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                n = 0x1000000;
            }
            this(n);
        }

        public final int getMaxRecordsCount() {
            return this.maxRecordsCount;
        }

        @NotNull
        public PersistentFSRecordsOverInMemoryStorage open(@NotNull Path storagePath) {
            Intrinsics.checkNotNullParameter((Object)storagePath, (String)"storagePath");
            return new PersistentFSRecordsOverInMemoryStorage(storagePath, this.maxRecordsCount);
        }

        public final int component1() {
            return this.maxRecordsCount;
        }

        @NotNull
        public final InMemory copy(int maxRecordsCount) {
            return new InMemory(maxRecordsCount);
        }

        public static /* synthetic */ InMemory copy$default(InMemory inMemory, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = inMemory.maxRecordsCount;
            }
            return inMemory.copy(n);
        }

        @NotNull
        public String toString() {
            return "InMemory(maxRecordsCount=" + this.maxRecordsCount + ")";
        }

        public int hashCode() {
            return Integer.hashCode(this.maxRecordsCount);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof InMemory)) {
                return false;
            }
            InMemory inMemory = (InMemory)other;
            return this.maxRecordsCount == inMemory.maxRecordsCount;
        }

        public InMemory() {
            this(0, 1, null);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u0013\u001a\u00020\u00052\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0083\u0004J\n\u0010\u0016\u001a\u00020\u0003H\u00d6\u0081\u0004J\n\u0010\u0017\u001a\u00020\u0018H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lcom/intellij/openapi/vfs/newvfs/persistent/PersistentFSRecordsStorageFactory$OverMMappedFile;", "Lcom/intellij/openapi/vfs/newvfs/persistent/PersistentFSRecordsStorageFactory;", "pageSize", "", "acquireStorageOwnership", "", "<init>", "(IZ)V", "getPageSize", "()I", "getAcquireStorageOwnership", "()Z", "open", "Lcom/intellij/openapi/vfs/newvfs/persistent/PersistentFSRecordsLockFreeOverMMappedFile;", "storagePath", "Ljava/nio/file/Path;", "component1", "component2", "copy", "equals", "other", "", "hashCode", "toString", "", "intellij.platform.ide.impl"})
    public static final class OverMMappedFile
    extends PersistentFSRecordsStorageFactory {
        private final int pageSize;
        private final boolean acquireStorageOwnership;

        public OverMMappedFile(int pageSize, boolean acquireStorageOwnership) {
            super(0);
            this.pageSize = pageSize;
            this.acquireStorageOwnership = acquireStorageOwnership;
        }

        public /* synthetic */ OverMMappedFile(int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                n = PersistentFSRecordsLockFreeOverMMappedFile.DEFAULT_MAPPED_CHUNK_SIZE;
            }
            if ((n2 & 2) != 0) {
                bl = true;
            }
            this(n, bl);
        }

        public final int getPageSize() {
            return this.pageSize;
        }

        public final boolean getAcquireStorageOwnership() {
            return this.acquireStorageOwnership;
        }

        @NotNull
        public PersistentFSRecordsLockFreeOverMMappedFile open(@NotNull Path storagePath) {
            Intrinsics.checkNotNullParameter((Object)storagePath, (String)"storagePath");
            Object object = MMappedFileStorageFactory.withDefaults().pageSize(this.pageSize).wrapStorageSafely(storagePath, arg_0 -> OverMMappedFile.open$lambda$1(arg_0 -> OverMMappedFile.open$lambda$0(this, storagePath, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"wrapStorageSafely(...)");
            return (PersistentFSRecordsLockFreeOverMMappedFile)object;
        }

        public final int component1() {
            return this.pageSize;
        }

        public final boolean component2() {
            return this.acquireStorageOwnership;
        }

        @NotNull
        public final OverMMappedFile copy(int pageSize, boolean acquireStorageOwnership) {
            return new OverMMappedFile(pageSize, acquireStorageOwnership);
        }

        public static /* synthetic */ OverMMappedFile copy$default(OverMMappedFile overMMappedFile, int n, boolean bl, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = overMMappedFile.pageSize;
            }
            if ((n2 & 2) != 0) {
                bl = overMMappedFile.acquireStorageOwnership;
            }
            return overMMappedFile.copy(n, bl);
        }

        @NotNull
        public String toString() {
            return "OverMMappedFile(pageSize=" + this.pageSize + ", acquireStorageOwnership=" + this.acquireStorageOwnership + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.pageSize);
            result2 = result2 * 31 + Boolean.hashCode(this.acquireStorageOwnership);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OverMMappedFile)) {
                return false;
            }
            OverMMappedFile overMMappedFile = (OverMMappedFile)other;
            if (this.pageSize != overMMappedFile.pageSize) {
                return false;
            }
            return this.acquireStorageOwnership == overMMappedFile.acquireStorageOwnership;
        }

        private static final PersistentFSRecordsLockFreeOverMMappedFile open$lambda$0(OverMMappedFile this$0, Path $storagePath, MMappedFileStorage mappedFileStorage) {
            Intrinsics.checkNotNullParameter((Object)mappedFileStorage, (String)"mappedFileStorage");
            PersistentFSRecordsLockFreeOverMMappedFile recordsStorage = new PersistentFSRecordsLockFreeOverMMappedFile(mappedFileStorage);
            if (this$0.acquireStorageOwnership) {
                try {
                    ProcessHandle currentProcess = ProcessHandle.current();
                    int currentProcessPid = (int)currentProcess.pid();
                    PersistentFSRecordsLockFreeOverMMappedFile.OwnershipInfo ownershipInfo = recordsStorage.tryAcquireExclusiveAccess(currentProcessPid, System.currentTimeMillis(), false);
                    Intrinsics.checkNotNullExpressionValue((Object)ownershipInfo, (String)"tryAcquireExclusiveAccess(...)");
                    PersistentFSRecordsLockFreeOverMMappedFile.OwnershipInfo acquiredBy = ownershipInfo;
                    if (acquiredBy.ownerProcessPid != currentProcessPid) {
                        Optional<ProcessHandle> optional = ProcessHandle.of(acquiredBy.ownerProcessPid);
                        Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
                        ProcessHandle ownerProcess = (ProcessHandle)OptionalsKt.getOrNull(optional);
                        if (ownerProcess != null && ownerProcess.isAlive()) {
                            boolean likelyTrueOwner;
                            Optional<Instant> optional2 = ownerProcess.info().startInstant();
                            Intrinsics.checkNotNullExpressionValue(optional2, (String)"startInstant(...)");
                            Instant instant = (Instant)OptionalsKt.getOrNull(optional2);
                            long ownerStartedAtMs = instant != null ? instant.toEpochMilli() : 0L;
                            boolean bl = likelyTrueOwner = ownerStartedAtMs <= acquiredBy.ownershipAcquiredAtMs;
                            if (likelyTrueOwner) {
                                String message = "Records storage [" + $storagePath + "] is in use by another process [" + acquiredBy + ", info: " + ownerProcess.info() + "]";
                                boolean failIfUsedByAnotherProcess = SystemProperties.getBooleanProperty((String)"vfs.fail-if-used-by-another-process", (boolean)true);
                                if (failIfUsedByAnotherProcess) {
                                    throw new StorageAlreadyInUseException(message);
                                }
                                FSRecords.LOG.error(message);
                            } else {
                                FSRecords.LOG.warn("Records storage [" + $storagePath + "] was in use by process [" + acquiredBy + "] which is not exist now (wasn't closed properly/crashed?) -> re-acquiring forcibly (pid-collision with " + ownerProcess.info() + " was successfully resolved)");
                            }
                        } else {
                            FSRecords.LOG.warn("Records storage [" + $storagePath + "] was in use by process [" + acquiredBy + "] which is not exist now (wasn't closed properly/crashed?) -> re-acquiring forcibly");
                        }
                        PersistentFSRecordsLockFreeOverMMappedFile.OwnershipInfo ownershipInfo2 = recordsStorage.tryAcquireExclusiveAccess(currentProcessPid, System.currentTimeMillis(), true);
                        Intrinsics.checkNotNullExpressionValue((Object)ownershipInfo2, (String)"tryAcquireExclusiveAccess(...)");
                        PersistentFSRecordsLockFreeOverMMappedFile.OwnershipInfo acquiredByPidForcibly = ownershipInfo2;
                        if (acquiredByPidForcibly.ownerProcessPid != currentProcessPid) {
                            ProcessHandle concurrentlyOwnedProcess;
                            Optional<ProcessHandle> optional3 = ProcessHandle.of(acquiredByPidForcibly.ownerProcessPid);
                            Intrinsics.checkNotNullExpressionValue(optional3, (String)"of(...)");
                            ProcessHandle processHandle = concurrentlyOwnedProcess = (ProcessHandle)OptionalsKt.getOrNull(optional3);
                            throw new StorageAlreadyInUseException("Records storage [" + $storagePath + "] is in use by another process [pid: " + acquiredByPidForcibly + ", info: " + (processHandle != null ? processHandle.info() : null) + "]");
                        }
                    }
                }
                catch (Throwable e) {
                    FSRecords.LOG.warn("VFS.acquireStorageOwnership is failed", e);
                }
            }
            return recordsStorage;
        }

        private static final PersistentFSRecordsLockFreeOverMMappedFile open$lambda$1(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            return (PersistentFSRecordsLockFreeOverMMappedFile)$tmp0.invoke(p0);
        }

        public OverMMappedFile() {
            this(0, false, 3, null);
        }
    }
}

