/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.zip.signer.metadata;

import com.google.protobuf.ByteString;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.zip.signer.metadata.SignatureAlgorithm;
import org.jetbrains.zip.signer.proto.SignatureDataProto;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001B!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\nB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/zip/signer/metadata/SignatureData;", "", "algorithm", "Lorg/jetbrains/zip/signer/metadata/SignatureAlgorithm;", "signatureBytes", "", "protobufRepresentation", "Lorg/jetbrains/zip/signer/proto/SignatureDataProto;", "<init>", "(Lorg/jetbrains/zip/signer/metadata/SignatureAlgorithm;[BLorg/jetbrains/zip/signer/proto/SignatureDataProto;)V", "(Lorg/jetbrains/zip/signer/proto/SignatureDataProto;)V", "(Lorg/jetbrains/zip/signer/metadata/SignatureAlgorithm;[B)V", "getAlgorithm", "()Lorg/jetbrains/zip/signer/metadata/SignatureAlgorithm;", "getSignatureBytes", "()[B", "getProtobufRepresentation", "()Lorg/jetbrains/zip/signer/proto/SignatureDataProto;", "lib"})
public final class SignatureData {
    @NotNull
    private final SignatureAlgorithm algorithm;
    @NotNull
    private final byte[] signatureBytes;
    @NotNull
    private final SignatureDataProto protobufRepresentation;

    private SignatureData(SignatureAlgorithm algorithm, byte[] signatureBytes, SignatureDataProto protobufRepresentation) {
        this.algorithm = algorithm;
        this.signatureBytes = signatureBytes;
        this.protobufRepresentation = protobufRepresentation;
    }

    @NotNull
    public final SignatureAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    @NotNull
    public final byte[] getSignatureBytes() {
        return this.signatureBytes;
    }

    @NotNull
    public final SignatureDataProto getProtobufRepresentation() {
        return this.protobufRepresentation;
    }

    public SignatureData(@NotNull SignatureDataProto protobufRepresentation) {
        Intrinsics.checkNotNullParameter((Object)protobufRepresentation, (String)"protobufRepresentation");
        SignatureDataProto.AlgorithmId algorithmId = protobufRepresentation.getAlgorithmId();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)algorithmId), (String)"getAlgorithmId(...)");
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.Companion.fromProtobufEnum(algorithmId);
        byte[] byArray = protobufRepresentation.getSignatureBytes().toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        this(signatureAlgorithm, byArray, protobufRepresentation);
    }

    public SignatureData(@NotNull SignatureAlgorithm algorithm, @NotNull byte[] signatureBytes) {
        Intrinsics.checkNotNullParameter((Object)((Object)algorithm), (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)signatureBytes, (String)"signatureBytes");
        SignatureDataProto signatureDataProto = SignatureDataProto.newBuilder().setAlgorithmId(algorithm.toProtobufEnum()).setSignatureBytes(ByteString.copyFrom((byte[])signatureBytes)).build();
        Intrinsics.checkNotNullExpressionValue((Object)signatureDataProto, (String)"build(...)");
        this(algorithm, signatureBytes, signatureDataProto);
    }
}

