/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore.kdbx;

import com.intellij.credentialStore.kdbx.HashedBlockInputStream;
import com.intellij.credentialStore.kdbx.IncorrectMainPasswordException;
import com.intellij.credentialStore.kdbx.KdbxHeader;
import com.intellij.credentialStore.kdbx.KeePassCredentials;
import com.intellij.credentialStore.kdbx.KeePassDatabase;
import com.intellij.credentialStore.kdbx.XmlProtectedValueTransformer;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.io.DigestUtil;
import com.intellij.util.io.DigestUtilKt;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.SkippingStreamCipher;
import org.bouncycastle.crypto.engines.ChaCha7539Engine;
import org.bouncycastle.crypto.engines.Salsa20Engine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0018\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0000\u001a\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0000\"\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"loadKdbx", "Lcom/intellij/credentialStore/kdbx/KeePassDatabase;", "file", "Ljava/nio/file/Path;", "credentials", "Lcom/intellij/credentialStore/kdbx/KeePassCredentials;", "readKeePassDatabase", "inputStream", "Ljava/io/InputStream;", "SALSA20_IV", "", "createSalsa20StreamCipher", "Lorg/bouncycastle/crypto/SkippingStreamCipher;", "key", "createChaCha20StreamCipher", "intellij.platform.credentialStore.impl"})
@SourceDebugExtension(value={"SMAP\nkdbx.kt\nKotlin\n*S Kotlin\n*F\n+ 1 kdbx.kt\ncom/intellij/credentialStore/kdbx/KdbxKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,89:1\n1#2:90\n*E\n"})
public final class KdbxKt {
    @NotNull
    private static final byte[] SALSA20_IV;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final KeePassDatabase loadKdbx(@NotNull Path file, @NotNull KeePassCredentials credentials) throws IncorrectMainPasswordException {
        KeePassDatabase keePassDatabase;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        OpenOption[] openOptionArray = new OpenOption[]{};
        InputStream inputStream = Files.newInputStream(file, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        Closeable closeable = inputStream;
        int n = 8192;
        closeable = closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n);
        Throwable throwable = null;
        try {
            BufferedInputStream it = (BufferedInputStream)closeable;
            boolean bl = false;
            keePassDatabase = KdbxKt.readKeePassDatabase(credentials, it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return keePassDatabase;
    }

    private static final KeePassDatabase readKeePassDatabase(KeePassCredentials credentials, InputStream inputStream) {
        KdbxHeader kdbxHeader = new KdbxHeader(inputStream);
        InputStream decryptedInputStream = kdbxHeader.createDecryptedStream(credentials.getKey(), inputStream);
        byte[] startBytes = decryptedInputStream.readNBytes(32);
        if (!Arrays.equals(startBytes, kdbxHeader.getStreamStartBytes())) {
            throw new IncorrectMainPasswordException(false, 1, null);
        }
        InputStream resultInputStream = new HashedBlockInputStream(decryptedInputStream);
        if (kdbxHeader.getCompressionFlags() == KdbxHeader.CompressionFlags.GZIP) {
            resultInputStream = new GZIPInputStream(resultInputStream);
        }
        Element element = JDOMUtil.load((InputStream)resultInputStream);
        Element element2 = element.getChild("Root");
        if (element2 != null) {
            Element rootElement = element2;
            boolean bl = false;
            SkippingStreamCipher streamCipher = kdbxHeader.getProtectedStreamAlgorithm() == KdbxHeader.ProtectedStreamAlgorithm.CHA_CHA ? KdbxKt.createChaCha20StreamCipher(kdbxHeader.getProtectedStreamKey()) : KdbxKt.createSalsa20StreamCipher(kdbxHeader.getProtectedStreamKey());
            new XmlProtectedValueTransformer(streamCipher).processEntries(rootElement);
        }
        Intrinsics.checkNotNull((Object)element);
        return new KeePassDatabase(element);
    }

    @NotNull
    public static final SkippingStreamCipher createSalsa20StreamCipher(@NotNull byte[] key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Salsa20Engine streamCipher = new Salsa20Engine();
        KeyParameter keyParameter = new KeyParameter(DigestUtil.sha256().digest(key));
        streamCipher.init(true, (CipherParameters)new ParametersWithIV((CipherParameters)keyParameter, SALSA20_IV));
        return (SkippingStreamCipher)streamCipher;
    }

    @NotNull
    public static final SkippingStreamCipher createChaCha20StreamCipher(@NotNull byte[] key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        ChaCha7539Engine streamCipher = new ChaCha7539Engine();
        byte[] keyHash = DigestUtilKt.sha2_512().digest(key);
        Intrinsics.checkNotNull((Object)keyHash);
        byte[] byArray = Arrays.copyOf(keyHash, 32);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(...)");
        KeyParameter keyParameter = new KeyParameter(byArray);
        streamCipher.init(true, (CipherParameters)new ParametersWithIV((CipherParameters)keyParameter, ArraysKt.copyOfRange((byte[])keyHash, (int)32, (int)44)));
        return (SkippingStreamCipher)streamCipher;
    }

    static {
        byte[] byArray = new byte[]{-24, 48, 9, 75, -105, 32, 93, 42};
        SALSA20_IV = byArray;
    }
}

