/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.paint;

import com.intellij.ui.JBColor;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.SmartList;
import com.intellij.vcs.log.VcsLogHighlighter;
import com.intellij.vcs.log.graph.EdgePrintElement;
import com.intellij.vcs.log.graph.NodePrintElement;
import com.intellij.vcs.log.graph.PrintElement;
import com.intellij.vcs.log.graph.impl.print.elements.TerminalEdgePrintElement;
import com.intellij.vcs.log.paint.ColorGenerator;
import com.intellij.vcs.log.paint.GraphCellPainter;
import com.intellij.vcs.log.paint.HeadNodePainter;
import com.intellij.vcs.log.paint.PaintParameters;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u0000 \u00192\u00020\u0001:\u0002\u0018\u0019B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J0\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001a"}, d2={"Lcom/intellij/vcs/log/paint/SimpleGraphCellPainter;", "Lcom/intellij/vcs/log/paint/GraphCellPainter;", "colorGenerator", "Lcom/intellij/vcs/log/paint/ColorGenerator;", "<init>", "(Lcom/intellij/vcs/log/paint/ColorGenerator;)V", "rowHeight", "", "getRowHeight", "()I", "paint", "", "g2", "Ljava/awt/Graphics2D;", "commitStyle", "Lcom/intellij/vcs/log/VcsLogHighlighter$VcsCommitStyle;", "printElements", "", "Lcom/intellij/vcs/log/graph/PrintElement;", "getElementUnderCursor", "scaleContext", "Lcom/intellij/ui/scale/ScaleContext;", "x", "y", "MyPainter", "Companion", "intellij.platform.vcs.log.impl"})
@ApiStatus.Internal
public class SimpleGraphCellPainter
implements GraphCellPainter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ColorGenerator colorGenerator;
    @NotNull
    private static final Color MARK_COLOR;
    @NotNull
    private static final Color NEUTRAL_COLOR;
    private static final double ARROW_ANGLE_COS2 = 0.7;
    private static final double ARROW_LENGTH = 0.3;

    public SimpleGraphCellPainter(@NotNull ColorGenerator colorGenerator) {
        Intrinsics.checkNotNullParameter((Object)colorGenerator, (String)"colorGenerator");
        this.colorGenerator = colorGenerator;
    }

    protected int getRowHeight() {
        return 22;
    }

    @Override
    public void paint(@NotNull Graphics2D g2, @NotNull VcsLogHighlighter.VcsCommitStyle commitStyle, @NotNull Collection<? extends PrintElement> printElements) {
        Intrinsics.checkNotNullParameter((Object)g2, (String)"g2");
        Intrinsics.checkNotNullParameter((Object)commitStyle, (String)"commitStyle");
        Intrinsics.checkNotNullParameter(printElements, (String)"printElements");
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        MyPainter painter = new MyPainter(ScaleContext.Companion.create(g2), this.getRowHeight());
        List selected = (List)new SmartList();
        for (PrintElement printElement : printElements) {
            if (printElement.isSelected()) {
                selected.add(printElement);
                continue;
            }
            Color color = this.colorGenerator.getColor(printElement.getColorId());
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getColor(...)");
            painter.paintElement(g2, printElement, commitStyle, color, false);
        }
        for (PrintElement printElement : selected) {
            painter.paintElement(g2, printElement, commitStyle, MARK_COLOR, true);
        }
        for (PrintElement printElement : selected) {
            Color color = this.colorGenerator.getColor(printElement.getColorId());
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getColor(...)");
            painter.paintElement(g2, printElement, commitStyle, color, false);
        }
    }

    @Override
    @Nullable
    public PrintElement getElementUnderCursor(@NotNull ScaleContext scaleContext, @NotNull Collection<? extends PrintElement> printElements, int x, int y) {
        Intrinsics.checkNotNullParameter((Object)scaleContext, (String)"scaleContext");
        Intrinsics.checkNotNullParameter(printElements, (String)"printElements");
        MyPainter painter = new MyPainter(scaleContext, this.getRowHeight());
        for (PrintElement printElement : printElements) {
            if (!(printElement instanceof NodePrintElement) || !painter.isOverNode(printElement.getPositionInCurrentRow(), x, y)) continue;
            return printElement;
        }
        for (PrintElement printElement : printElements) {
            if (!(printElement instanceof EdgePrintElement) || !painter.isOverEdge(printElement.getPositionInCurrentRow(), ((EdgePrintElement)printElement).getPositionInOtherRow(), ((EdgePrintElement)printElement).getType(), x, y)) continue;
            return printElement;
        }
        return null;
    }

    static {
        JBColor jBColor = JBColor.BLACK;
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"BLACK");
        MARK_COLOR = (Color)jBColor;
        JBColor jBColor2 = JBColor.GRAY;
        Intrinsics.checkNotNullExpressionValue((Object)jBColor2, (String)"GRAY");
        NEUTRAL_COLOR = (Color)jBColor2;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JL\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u000b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\bH\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/vcs/log/paint/SimpleGraphCellPainter$Companion;", "", "<init>", "()V", "MARK_COLOR", "Ljava/awt/Color;", "NEUTRAL_COLOR", "ARROW_ANGLE_COS2", "", "ARROW_LENGTH", "rotate", "Lkotlin/Pair;", "x", "y", "centerX", "centerY", "cos", "sin", "arrowLength", "getDashLength", "", "edgeLength", "rowHeight", "", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final Pair<Double, Double> rotate(double x, double y, double centerX, double centerY, double cos, double sin, double arrowLength) {
            double translateX = x - centerX;
            double translateY = y - centerY;
            double d = Math.hypot(translateX, translateY);
            double scaleX = arrowLength * translateX / d;
            double scaleY = arrowLength * translateY / d;
            double rotateX = scaleX * cos - scaleY * sin;
            double rotateY = scaleX * sin + scaleY * cos;
            return new Pair((Object)(rotateX + centerX), (Object)(rotateY + centerY));
        }

        private final float[] getDashLength(double edgeLength, int rowHeight) {
            int dashCount = Math.max(1, (int)Math.floor(edgeLength / (double)rowHeight));
            float spaceLength = (float)rowHeight / 2.0f - (float)2;
            float dashLength = (float)(edgeLength / (double)dashCount - (double)spaceLength);
            float[] fArray = new float[]{dashLength, spaceLength};
            return fArray;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J.\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u0005J\u001e\u0010&\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u0005JX\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\t2\u0006\u0010,\u001a\u00020\t2\u0006\u0010-\u001a\u00020\t2\u0006\u0010.\u001a\u00020\t2\u0006\u0010/\u001a\u00020\t2\u0006\u00100\u001a\u00020\t2\u0006\u00101\u001a\u00020\u001f2\u0006\u00102\u001a\u00020\u001f2\u0006\u00103\u001a\u00020\u001fH\u0002J \u00104\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u00105\u001a\u0002062\u0006\u00103\u001a\u00020\u001fH\u0002J(\u00107\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u00108\u001a\u0002092\u0006\u00103\u001a\u00020\u001f2\u0006\u0010:\u001a\u00020;H\u0002J.\u0010<\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u00108\u001a\u00020=2\u0006\u0010:\u001a\u00020;2\u0006\u0010>\u001a\u00020?2\u0006\u00103\u001a\u00020\u001fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/intellij/vcs/log/paint/SimpleGraphCellPainter$MyPainter;", "", "scaleContext", "Lcom/intellij/ui/scale/ScaleContext;", "rowHeight", "", "<init>", "(Lcom/intellij/ui/scale/ScaleContext;I)V", "pixel", "", "rowCenter", "elementWidth", "elementCenter", "lineThickness", "", "selectedLineThickness", "circleDiameter", "selectedCircleDiameter", "circleRadius", "selectedCircleRadius", "ordinaryStroke", "Ljava/awt/BasicStroke;", "selectedStroke", "headNodePainter", "Lcom/intellij/vcs/log/paint/HeadNodePainter;", "getDashedStroke", "Ljava/awt/Stroke;", "dash", "", "getSelectedDashedStroke", "isOverEdge", "", "position", "otherPosition", "edgeType", "Lcom/intellij/vcs/log/graph/EdgePrintElement$Type;", "x", "y", "isOverNode", "paintLine", "", "g2", "Ljava/awt/Graphics2D;", "x1", "y1", "x2", "y2", "startArrowX", "startArrowY", "hasArrow", "isUsual", "isSelected", "paintEdge", "edge", "Lcom/intellij/vcs/log/graph/EdgePrintElement;", "paintCircle", "element", "Lcom/intellij/vcs/log/graph/NodePrintElement;", "commitStyle", "Lcom/intellij/vcs/log/VcsLogHighlighter$VcsCommitStyle;", "paintElement", "Lcom/intellij/vcs/log/graph/PrintElement;", "color", "Ljava/awt/Color;", "intellij.platform.vcs.log.impl"})
    private static final class MyPainter {
        private final int rowHeight;
        private final double pixel;
        private final double rowCenter;
        private final double elementWidth;
        private final double elementCenter;
        private final float lineThickness;
        private final float selectedLineThickness;
        private final double circleDiameter;
        private final double selectedCircleDiameter;
        private final double circleRadius;
        private final double selectedCircleRadius;
        @NotNull
        private final BasicStroke ordinaryStroke;
        @NotNull
        private final BasicStroke selectedStroke;
        @NotNull
        private final HeadNodePainter headNodePainter;

        public MyPainter(@NotNull ScaleContext scaleContext, int rowHeight) {
            Intrinsics.checkNotNullParameter((Object)scaleContext, (String)"scaleContext");
            this.rowHeight = rowHeight;
            this.pixel = 1.0 / PaintUtil.devValue((double)1.0, (ScaleContext)scaleContext);
            this.rowCenter = PaintUtil.alignToInt((double)((double)this.rowHeight / 2.0), (ScaleContext)scaleContext, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.FLOOR, (PaintUtil.ParityMode)PaintUtil.ParityMode.ODD);
            this.elementWidth = PaintUtil.alignToInt((double)PaintParameters.getElementWidth(this.rowHeight), (ScaleContext)scaleContext, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.FLOOR, (PaintUtil.ParityMode)PaintUtil.ParityMode.ODD);
            this.elementCenter = PaintUtil.alignToInt((double)(PaintParameters.getElementWidth(this.rowHeight) / (double)2), (ScaleContext)scaleContext, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.FLOOR, null);
            this.lineThickness = (float)RangesKt.coerceAtLeast((double)PaintUtil.alignToInt((double)PaintParameters.getLineThickness(this.rowHeight), (ScaleContext)scaleContext, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.FLOOR, (PaintUtil.ParityMode)PaintUtil.ParityMode.ODD), (double)this.pixel);
            this.selectedLineThickness = (float)RangesKt.coerceAtLeast((double)PaintUtil.alignToInt((double)PaintParameters.getSelectedLineThickness(this.rowHeight), (ScaleContext)scaleContext, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.FLOOR, (PaintUtil.ParityMode)PaintUtil.ParityMode.ODD), (double)((double)this.lineThickness + (double)2 * this.pixel));
            this.circleDiameter = PaintUtil.alignToInt((double)((double)2 * PaintParameters.getCircleRadius(this.rowHeight)), (ScaleContext)scaleContext, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.FLOOR, (PaintUtil.ParityMode)PaintUtil.ParityMode.ODD);
            this.selectedCircleDiameter = this.circleDiameter + (double)this.selectedLineThickness - (double)this.lineThickness;
            this.circleRadius = PaintUtil.alignToInt((double)(this.circleDiameter / (double)2), (ScaleContext)scaleContext, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.FLOOR, null);
            this.selectedCircleRadius = PaintUtil.alignToInt((double)(this.selectedCircleDiameter / (double)2), (ScaleContext)scaleContext, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.FLOOR, null);
            this.ordinaryStroke = new BasicStroke(this.lineThickness, 1, 1);
            this.selectedStroke = new BasicStroke(this.selectedLineThickness, 1, 1);
            this.headNodePainter = new HeadNodePainter(scaleContext, this.selectedLineThickness, this.lineThickness, this.rowHeight);
        }

        private final Stroke getDashedStroke(float[] dash) {
            return new BasicStroke(this.lineThickness, 1, 1, 0.0f, dash, dash[0] / (float)2);
        }

        private final Stroke getSelectedDashedStroke(float[] dash) {
            return new BasicStroke(this.selectedLineThickness, 1, 1, 0.0f, dash, dash[0] / (float)2);
        }

        public final boolean isOverEdge(int position, int otherPosition, @NotNull EdgePrintElement.Type edgeType, int x, int y) {
            Intrinsics.checkNotNullParameter((Object)edgeType, (String)"edgeType");
            double x1 = this.elementWidth * (double)position + this.elementCenter;
            double y1 = this.rowCenter;
            double x2 = this.elementWidth * (double)otherPosition + this.elementCenter;
            double y2 = edgeType == EdgePrintElement.Type.DOWN ? (double)this.rowHeight + this.rowCenter : this.rowCenter - (double)this.rowHeight;
            return Math.hypot(x1 - (double)x, y1 - (double)y) + Math.hypot(x2 - (double)x, y2 - (double)y) < Math.hypot(x1 - x2, y1 - y2) + (double)this.lineThickness;
        }

        public final boolean isOverNode(int position, int x, int y) {
            double x0 = this.elementWidth * (double)position + this.elementCenter;
            double y0 = this.rowCenter;
            return Math.hypot(x0 - (double)x, y0 - (double)y) <= this.circleRadius;
        }

        private final void paintLine(Graphics2D g2, double x1, double y1, double x2, double y2, double startArrowX, double startArrowY, boolean hasArrow, boolean isUsual, boolean isSelected) {
            Stroke stroke;
            if (isUsual || hasArrow) {
                stroke = isSelected ? this.selectedStroke : this.ordinaryStroke;
            } else {
                double edgeLength = x1 == x2 ? (double)this.rowHeight : Math.hypot(x1 - x2, y1 - y2);
                float[] dashLength = Companion.getDashLength(edgeLength, this.rowHeight);
                stroke = isSelected ? this.getSelectedDashedStroke(dashLength) : this.getDashedStroke(dashLength);
            }
            g2.setStroke(stroke);
            g2.draw(new Line2D.Double(x1, y1, x2, y2));
            if (hasArrow) {
                Pair pair = Companion.rotate(x1, y1, startArrowX, startArrowY, Math.sqrt(0.7), Math.sqrt(0.30000000000000004), 0.3 * (double)this.rowHeight);
                double endArrowX1 = ((Number)pair.component1()).doubleValue();
                double endArrowY1 = ((Number)pair.component2()).doubleValue();
                Pair pair2 = Companion.rotate(x1, y1, startArrowX, startArrowY, Math.sqrt(0.7), -Math.sqrt(0.30000000000000004), 0.3 * (double)this.rowHeight);
                double endArrowX2 = ((Number)pair2.component1()).doubleValue();
                double endArrowY2 = ((Number)pair2.component2()).doubleValue();
                g2.draw(new Line2D.Double(startArrowX, startArrowY, endArrowX1, endArrowY1));
                g2.draw(new Line2D.Double(startArrowX, startArrowY, endArrowX2, endArrowY2));
            }
        }

        private final void paintEdge(Graphics2D g2, EdgePrintElement edge, boolean isSelected) {
            boolean isDown = edge.getType() == EdgePrintElement.Type.DOWN;
            boolean isUsual = edge.getLineStyle() == EdgePrintElement.LineStyle.SOLID;
            boolean hasArrow = edge.hasArrow();
            boolean isTerminal = edge instanceof TerminalEdgePrintElement;
            int from = edge.getPositionInCurrentRow();
            int to = edge.getPositionInOtherRow();
            double x1 = this.elementWidth * (double)from + this.elementCenter;
            double y1 = this.rowCenter;
            if (from == to) {
                double arrowGap = isTerminal ? this.circleRadius / (double)2 + 1.0 : 0.0;
                double y2 = isDown ? (double)this.rowHeight - arrowGap : arrowGap;
                this.paintLine(g2, x1, y1, x1, y2, x1, y2, hasArrow, isUsual, isSelected);
            } else {
                boolean arrowGap;
                boolean bl = arrowGap = !isTerminal;
                if (_Assertions.ENABLED && !arrowGap) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                double x2 = this.elementWidth * (double)to + this.elementCenter;
                double y2 = isDown ? (double)this.rowHeight + this.rowCenter : this.rowCenter - (double)this.rowHeight;
                this.paintLine(g2, x1, y1, x2, y2, (x1 + x2) / (double)2, (y1 + y2) / (double)2, hasArrow, isUsual, isSelected);
            }
        }

        private final void paintCircle(Graphics2D g2, NodePrintElement element, boolean isSelected, VcsLogHighlighter.VcsCommitStyle commitStyle) {
            double x0 = this.elementWidth * (double)element.getPositionInCurrentRow() + this.elementCenter;
            double y0 = this.rowCenter;
            double radius = isSelected ? this.selectedCircleRadius : this.circleRadius;
            double diameter = isSelected ? this.selectedCircleDiameter : this.circleDiameter;
            Ellipse2D.Double circle = new Ellipse2D.Double(x0 - radius, y0 - radius, diameter, diameter);
            switch (WhenMappings.$EnumSwitchMapping$0[element.getNodeType().ordinal()]) {
                case 1: {
                    g2.fill(circle);
                    break;
                }
                case 2: {
                    this.headNodePainter.paint(g2, x0, y0, isSelected, commitStyle);
                    break;
                }
                case 3: {
                    g2.setColor(NEUTRAL_COLOR);
                    g2.draw(circle);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }

        public final void paintElement(@NotNull Graphics2D g2, @NotNull PrintElement element, @NotNull VcsLogHighlighter.VcsCommitStyle commitStyle, @NotNull Color color, boolean isSelected) {
            Intrinsics.checkNotNullParameter((Object)g2, (String)"g2");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)commitStyle, (String)"commitStyle");
            Intrinsics.checkNotNullParameter((Object)color, (String)"color");
            g2.setColor(color);
            PrintElement printElement = element;
            if (printElement instanceof EdgePrintElement) {
                this.paintEdge(g2, (EdgePrintElement)element, isSelected);
            } else if (printElement instanceof NodePrintElement) {
                this.paintCircle(g2, (NodePrintElement)element, isSelected, commitStyle);
            }
        }

        @Metadata(mv={2, 3, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[NodePrintElement.Type.values().length];
                try {
                    nArray[NodePrintElement.Type.FILL.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[NodePrintElement.Type.OUTLINE_AND_FILL.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[NodePrintElement.Type.OUTLINE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

