/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManagerKt;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManagerListener;
import com.intellij.openapi.vcs.changes.ui.CloseWindowedFloatingTwOnCommit;
import com.intellij.openapi.vcs.changes.ui.CommitToolWindowUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0012\u0010\t\u001a\u00020\u0001*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u0010\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000fH\u0001\u001a\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a3\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f2!\u0010\u0013\u001a\u001d\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u00020\u00010\u0014H\u0002\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"selectFirstContent", "", "Lcom/intellij/ui/content/ContentManager;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getContentWeight", "", "content", "Lcom/intellij/ui/content/Content;", "subscribeOnVcsToolWindowLayoutChanges", "Lcom/intellij/util/messages/MessageBusConnection;", "updateLayout", "Ljava/lang/Runnable;", "hideWindowedFloatingTwOnCommit", "project", "Lcom/intellij/openapi/project/Project;", "getCommitToolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "ifCommitTwOpenInWindow", "handler", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "commitTw", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nChangesViewContentManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangesViewContentManager.kt\ncom/intellij/openapi/vcs/changes/ui/ChangesViewContentManagerKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,382:1\n13#2:383\n*S KotlinDebug\n*F\n+ 1 ChangesViewContentManager.kt\ncom/intellij/openapi/vcs/changes/ui/ChangesViewContentManagerKt\n*L\n43#1:383\n*E\n"})
public final class ChangesViewContentManagerKt {
    @NotNull
    private static final Logger LOG;

    public static final void selectFirstContent(@NotNull ContentManager $this$selectFirstContent) {
        Intrinsics.checkNotNullParameter((Object)$this$selectFirstContent, (String)"<this>");
        Content firstContent = $this$selectFirstContent.getContent(0);
        if (firstContent != null && !Intrinsics.areEqual((Object)$this$selectFirstContent.getSelectedContent(), (Object)firstContent)) {
            $this$selectFirstContent.setSelectedContent(firstContent);
        }
    }

    private static final int getContentWeight(Content content) {
        Integer userData = (Integer)content.getUserData(ChangesViewContentManager.ORDER_WEIGHT_KEY);
        if (userData != null) {
            return userData;
        }
        String string = content.getTabName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTabName(...)");
        String tabName = string;
        for (ChangesViewContentManager.TabOrderWeight value : ChangesViewContentManager.TabOrderWeight.getEntries()) {
            if (value.getTabName() == null || !Intrinsics.areEqual((Object)value.getTabName(), (Object)tabName)) continue;
            return value.getWeight();
        }
        return ChangesViewContentManager.TabOrderWeight.OTHER.getWeight();
    }

    public static final void subscribeOnVcsToolWindowLayoutChanges(@NotNull MessageBusConnection $this$subscribeOnVcsToolWindowLayoutChanges, @NotNull Runnable updateLayout) {
        Intrinsics.checkNotNullParameter((Object)$this$subscribeOnVcsToolWindowLayoutChanges, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)updateLayout, (String)"updateLayout");
        $this$subscribeOnVcsToolWindowLayoutChanges.subscribe(ChangesViewContentManagerListener.TOPIC, (Object)new ChangesViewContentManagerListener(updateLayout){
            final /* synthetic */ Runnable $updateLayout;
            {
                this.$updateLayout = $updateLayout;
            }

            public void toolWindowMappingChanged() {
                this.$updateLayout.run();
            }
        });
        Topic topic = ToolWindowManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        $this$subscribeOnVcsToolWindowLayoutChanges.subscribe(topic, (Object)new ToolWindowManagerListener(updateLayout){
            final /* synthetic */ Runnable $updateLayout;
            {
                this.$updateLayout = $updateLayout;
            }

            public void stateChanged(ToolWindowManager toolWindowManager) {
                Intrinsics.checkNotNullParameter((Object)toolWindowManager, (String)"toolWindowManager");
                WriteIntentReadAction.run(() -> subscribeOnVcsToolWindowLayoutChanges.2.stateChanged$lambda$0(this.$updateLayout));
            }

            private static final void stateChanged$lambda$0(Runnable $updateLayout) {
                $updateLayout.run();
            }
        });
    }

    @RequiresEdt
    public static final void hideWindowedFloatingTwOnCommit(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!CloseWindowedFloatingTwOnCommit.INSTANCE.isSelected()) {
            return;
        }
        ChangesViewContentManagerKt.ifCommitTwOpenInWindow(project, (Function1<? super ToolWindow, Unit>)((Function1)ChangesViewContentManagerKt::hideWindowedFloatingTwOnCommit$lambda$0));
    }

    private static final ToolWindow getCommitToolWindow(Project project) {
        return ToolWindowManager.Companion.getInstance(project).getToolWindow("Commit");
    }

    private static final void ifCommitTwOpenInWindow(Project project, Function1<? super ToolWindow, Unit> handler) {
        ToolWindow toolWindow = ChangesViewContentManagerKt.getCommitToolWindow(project);
        if (toolWindow == null) {
            return;
        }
        ToolWindow commitTw = toolWindow;
        if (!commitTw.isActive() || !commitTw.isVisible()) {
            return;
        }
        ToolWindowType toolWindowType = commitTw.getType();
        Intrinsics.checkNotNullExpressionValue((Object)toolWindowType, (String)"getType(...)");
        if (!CommitToolWindowUtil.isInWindow(toolWindowType)) {
            return;
        }
        handler.invoke((Object)commitTw);
    }

    private static final Unit hideWindowedFloatingTwOnCommit$lambda$0(ToolWindow it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.hide();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ int access$getContentWeight(Content content) {
        return ChangesViewContentManagerKt.getContentWeight(content);
    }

    public static final /* synthetic */ void access$ifCommitTwOpenInWindow(Project project, Function1 handler) {
        ChangesViewContentManagerKt.ifCommitTwOpenInWindow(project, (Function1<? super ToolWindow, Unit>)handler);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ChangesViewContentManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

