/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.modcompletion.ModCompletionItem;
import com.intellij.modcompletion.ModCompletionItemProvider;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DumbModeAccessType;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNullByDefault;

@NotNullByDefault
@ApiStatus.Internal
public final class LightModCompletionServiceImpl {
    public static void getItems(PsiFile file, int caretOffset, int invocationCount, CompletionType type, Consumer<ModCompletionItem> sink) {
        CharSequence sequence = file.getFileDocument().getCharsSequence();
        int start = LightModCompletionServiceImpl.findStart(caretOffset, sequence);
        DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> LightModCompletionServiceImpl.getItems(file, start, caretOffset, invocationCount, type, sink));
    }

    private static int findStart(int caretOffset, CharSequence sequence) {
        int start;
        for (start = caretOffset; start > 0 && StringUtil.isJavaIdentifierPart((char)sequence.charAt(start - 1)); --start) {
        }
        return start;
    }

    public static void getItems(PsiFile file, int startOffset, int caretOffset, int invocationCount, CompletionType type, Consumer<ModCompletionItem> sink) {
        PsiElement element;
        PsiElement original = file.findElementAt(startOffset);
        if (startOffset == caretOffset) {
            PsiFile copy = (PsiFile)file.copy();
            Document document = copy.getFileDocument();
            document.insertString(caretOffset, (CharSequence)"IntellijIdeaRulezzz");
            PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)file.getProject());
            manager.commitDocument(document);
            element = Objects.requireNonNull(copy.findElementAt(caretOffset));
        } else {
            element = (PsiElement)Objects.requireNonNullElse(original, file);
        }
        List providers = ModCompletionItemProvider.EP_NAME.allForLanguage(file.getLanguage());
        String prefix = file.getFileDocument().getText(TextRange.create((int)startOffset, (int)caretOffset));
        CamelHumpMatcher matcher = new CamelHumpMatcher(prefix);
        ModCompletionItemProvider.CompletionContext context = new ModCompletionItemProvider.CompletionContext(file, caretOffset, original, element, (PrefixMatcher)matcher, invocationCount, type);
        for (ModCompletionItemProvider provider : providers) {
            provider.provideItems(context, item -> {
                block3: {
                    block2: {
                        if (matcher.prefixMatches(item.mainLookupString())) break block2;
                        if (!ContainerUtil.exists((Iterable)item.additionalLookupStrings(), matcher::prefixMatches)) break block3;
                    }
                    sink.accept((ModCompletionItem)item);
                }
            });
        }
    }
}

