/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.extapi.psi.ASTDelegatePsiElement;
import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.pom.Navigatable;
import com.intellij.pom.PomTarget;
import com.intellij.psi.BasicInspectionVisitorBean;
import com.intellij.psi.HintedPsiElementVisitor;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.impl.ElementBase;
import com.intellij.psi.impl.PsiElementBase;
import com.intellij.psi.impl.ReparseableASTNode;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ClearableClassValue;
import com.intellij.util.containers.CollectionFactory;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.Internal
public final class InspectionVisitorOptimizer {
    private static final Logger LOG = Logger.getInstance(InspectionVisitorOptimizer.class);
    @NotNull
    private final Map<Class<?>, Collection<Class<?>>> myTargetPsiClasses;
    private static final List<Class<?>> ALL_ELEMENTS_VISIT_LIST = List.of(PsiElement.class);
    private static final boolean useOptimizedVisitors = Registry.is((String)"ide.optimize.inspection.visitors");
    private static final boolean inTests = ApplicationManager.getApplication().isUnitTestMode();
    private static final Function<Class<?>, Collection<Class<?>>> TARGET_PSI_CLASSES_INIT = aSuper -> {
        ArrayList<Class> c = new ArrayList<Class>(10);
        if (!aSuper.isInterface() && !Modifier.isAbstract(aSuper.getModifiers())) {
            c.add((Class)aSuper);
        }
        return c;
    };
    private static final ClearableClassValue<Class<?>[]> SELF_AND_SUPERS = new ClearableClassValue<Class<?>[]>(){

        public Class<?> @NotNull [] computeValueImpl(@NotNull Class<?> type) {
            if (type == null) {
                1.$$$reportNull$$$0(0);
            }
            return 1.getAllSupers(type);
        }

        private static Class<?> @NotNull [] getAllSupers(@NotNull Class<?> clazz) {
            if (clazz == null) {
                1.$$$reportNull$$$0(1);
            }
            HashSet<Class> supers = new HashSet<Class>();
            supers.add(clazz);
            1.addInterfaces(clazz, supers);
            for (Class<?> superClass = clazz.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
                if (superClass == Object.class) continue;
                supers.add(superClass);
                1.addInterfaces(superClass, supers);
            }
            supers.removeIf(aSuper -> aSuper == UserDataHolder.class || aSuper == UserDataHolderBase.class || aSuper == UserDataHolderEx.class || aSuper == CompositePsiElement.class || aSuper == StubBasedPsiElementBase.class || aSuper == ASTNode.class || aSuper == ReparseableASTNode.class || aSuper == ElementBase.class || aSuper == Cloneable.class || aSuper == Iconable.class || aSuper == Serializable.class || aSuper == PomTarget.class || aSuper == Queryable.class || aSuper == Navigatable.class || aSuper == AtomicReference.class || aSuper == NavigationItem.class || aSuper == NavigatablePsiElement.class || aSuper == PsiElementBase.class || aSuper == TreeElement.class || aSuper == LeafElement.class || aSuper == ASTDelegatePsiElement.class);
            Class[] classArray = supers.toArray(ArrayUtil.EMPTY_CLASS_ARRAY);
            if (classArray == null) {
                1.$$$reportNull$$$0(2);
            }
            return classArray;
        }

        private static void addInterfaces(@NotNull Class<?> clazz, @NotNull Collection<? super Class<?>> supers) {
            if (clazz == null) {
                1.$$$reportNull$$$0(3);
            }
            if (supers == null) {
                1.$$$reportNull$$$0(4);
            }
            Class<?>[] interfaces = clazz.getInterfaces();
            Collections.addAll(supers, interfaces);
            for (Class<?> anInterface : interfaces) {
                Collections.addAll(supers, 1.getAllSupers(anInterface));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clazz";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/InspectionVisitorOptimizer$1";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "supers";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/InspectionVisitorOptimizer$1";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllSupers";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "computeValueImpl";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getAllSupers";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "addInterfaces";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    };
    private static final ClassValue<VisitorTypes> VISITOR_TYPES = new ClassValue<VisitorTypes>(){

        @Override
        protected VisitorTypes computeValue(@NotNull Class<?> type) {
            if (type == null) {
                2.$$$reportNull$$$0(0);
            }
            ArrayList visitClasses = new ArrayList();
            Collection visitorClasses = BasicInspectionVisitorBean.getVisitorClasses();
            block0: for (Class<?> superClass = type; superClass != null; superClass = superClass.getSuperclass()) {
                if (superClass == PsiElementVisitor.class) {
                    return new VisitorTypes(ALL_ELEMENTS_VISIT_LIST, visitClasses.contains(PsiElement.class));
                }
                if (visitorClasses.contains(superClass.getName())) break;
                for (Method declaredMethod : superClass.getDeclaredMethods()) {
                    if (declaredMethod.getParameterCount() != 1 || !declaredMethod.getName().startsWith("visit") || !Modifier.isPublic(declaredMethod.getModifiers()) || Modifier.isAbstract(declaredMethod.getModifiers()) || Modifier.isStatic(declaredMethod.getModifiers())) continue;
                    Class<?> parameterType = declaredMethod.getParameterTypes()[0];
                    visitClasses.add(parameterType);
                    if (parameterType == PsiElement.class) break block0;
                }
                if (HintedPsiElementVisitor.class.isAssignableFrom(superClass)) break;
            }
            if (visitClasses.contains(PsiElement.class)) {
                return new VisitorTypes(ALL_ELEMENTS_VISIT_LIST, true);
            }
            return new VisitorTypes(List.copyOf(visitClasses), false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInsight/daemon/impl/InspectionVisitorOptimizer$2", "computeValue"));
        }
    };

    public InspectionVisitorOptimizer(@NotNull List<? extends PsiElement> elements) {
        if (elements == null) {
            InspectionVisitorOptimizer.$$$reportNull$$$0(0);
        }
        this.myTargetPsiClasses = InspectionVisitorOptimizer.getTargetPsiClasses(elements);
    }

    @ApiStatus.Internal
    @NotNull
    public static @Unmodifiable List<? extends Class<?>> getAcceptingPsiTypes(@NotNull PsiElementVisitor visitor) {
        List<Class<?>> acceptingPsiTypes;
        if (visitor == null) {
            InspectionVisitorOptimizer.$$$reportNull$$$0(1);
        }
        if (!useOptimizedVisitors) {
            List<Class<?>> list = ALL_ELEMENTS_VISIT_LIST;
            if (list == null) {
                InspectionVisitorOptimizer.$$$reportNull$$$0(2);
            }
            return list;
        }
        if (visitor instanceof HintedPsiElementVisitor) {
            VisitorTypes handlesTypes;
            HintedPsiElementVisitor hinted = (HintedPsiElementVisitor)visitor;
            acceptingPsiTypes = hinted.getHintPsiElements();
            if (inTests && !(handlesTypes = VISITOR_TYPES.get(visitor.getClass())).overridesVisitPsiElement() && !handlesTypes.handlesElementTypes().equals(acceptingPsiTypes)) {
                LOG.error("HintedPsiElementVisitor implementations must override PsiElementVisitor.visitElement", new String[]{visitor.getClass().getName()});
            }
            if (acceptingPsiTypes.contains(PsiElement.class) || acceptingPsiTypes.isEmpty()) {
                acceptingPsiTypes = ALL_ELEMENTS_VISIT_LIST;
            }
        } else {
            acceptingPsiTypes = VISITOR_TYPES.get(visitor.getClass()).handlesElementTypes();
        }
        List<Class<?>> list = acceptingPsiTypes;
        if (list == null) {
            InspectionVisitorOptimizer.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    private static Map<Class<?>, Collection<Class<?>>> getTargetPsiClasses(@NotNull List<? extends PsiElement> elements) {
        if (elements == null) {
            InspectionVisitorOptimizer.$$$reportNull$$$0(4);
        }
        if (!useOptimizedVisitors) {
            Map<Class<?>, Collection<Class<?>>> map = Collections.emptyMap();
            if (map == null) {
                InspectionVisitorOptimizer.$$$reportNull$$$0(5);
            }
            return map;
        }
        IdentityHashMap targetPsiClasses = new IdentityHashMap(100);
        Set uniqueElementClasses = CollectionFactory.createSmallMemoryFootprintSet((int)100);
        for (int i = 0; i < elements.size(); ++i) {
            PsiElement element = elements.get(i);
            Class elementClass = element.getClass();
            if (!uniqueElementClasses.add(elementClass)) continue;
            for (Class aSuper : (Class[])SELF_AND_SUPERS.get(elementClass)) {
                Collection<Class<?>> classes = targetPsiClasses.computeIfAbsent(aSuper, TARGET_PSI_CLASSES_INIT);
                classes.add(elementClass);
            }
        }
        IdentityHashMap identityHashMap = targetPsiClasses;
        if (identityHashMap == null) {
            InspectionVisitorOptimizer.$$$reportNull$$$0(6);
        }
        return identityHashMap;
    }

    private Set<Class<?>> getVisitorAcceptClasses(@NotNull List<? extends Class<?>> acceptingPsiTypes) {
        if (acceptingPsiTypes == null) {
            InspectionVisitorOptimizer.$$$reportNull$$$0(7);
        }
        Map<Class<?>, Collection<Class<?>>> targetPsiClasses = this.myTargetPsiClasses;
        if (acceptingPsiTypes.size() == 1) {
            return Set.copyOf(targetPsiClasses.getOrDefault(acceptingPsiTypes.get(0), Collections.emptyList()));
        }
        HashSet accepts = null;
        for (Class<?> psiType : acceptingPsiTypes) {
            Collection classes = targetPsiClasses.getOrDefault(psiType, Collections.emptyList());
            if (classes.isEmpty()) continue;
            if (accepts == null) {
                accepts = new HashSet(classes);
                continue;
            }
            accepts.addAll(classes);
        }
        return accepts;
    }

    @ApiStatus.Internal
    public static void clearCache() {
        SELF_AND_SUPERS.clear();
    }

    public void acceptElements(@NotNull List<? extends PsiElement> elements, @NotNull PsiElementVisitor elementVisitor) {
        if (elements == null) {
            InspectionVisitorOptimizer.$$$reportNull$$$0(8);
        }
        if (elementVisitor == null) {
            InspectionVisitorOptimizer.$$$reportNull$$$0(9);
        }
        List<? extends Class<?>> acceptingPsiTypes = InspectionVisitorOptimizer.getAcceptingPsiTypes(elementVisitor);
        this.acceptElements(elements, acceptingPsiTypes, element -> element.accept(elementVisitor));
    }

    @ApiStatus.Internal
    public void acceptElements(@NotNull @Unmodifiable List<? extends PsiElement> elements, @NotNull @Unmodifiable List<? extends Class<?>> acceptingPsiTypes, @NotNull Consumer<? super PsiElement> consumer) {
        block6: {
            block5: {
                if (elements == null) {
                    InspectionVisitorOptimizer.$$$reportNull$$$0(10);
                }
                if (acceptingPsiTypes == null) {
                    InspectionVisitorOptimizer.$$$reportNull$$$0(11);
                }
                if (consumer == null) {
                    InspectionVisitorOptimizer.$$$reportNull$$$0(12);
                }
                if (acceptingPsiTypes != ALL_ELEMENTS_VISIT_LIST) break block5;
                for (int i = 0; i < elements.size(); ++i) {
                    PsiElement element = elements.get(i);
                    ProgressManager.checkCanceled();
                    consumer.accept((PsiElement)element);
                }
                break block6;
            }
            Set<Class<?>> accepts = this.getVisitorAcceptClasses(acceptingPsiTypes);
            if (accepts == null || accepts.isEmpty()) break block6;
            for (int i = 0; i < elements.size(); ++i) {
                PsiElement element = elements.get(i);
                if (!accepts.contains(element.getClass())) continue;
                ProgressManager.checkCanceled();
                consumer.accept((PsiElement)element);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/InspectionVisitorOptimizer";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "acceptingPsiTypes";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementVisitor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/InspectionVisitorOptimizer";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAcceptingPsiTypes";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetPsiClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAcceptingPsiTypes";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTargetPsiClasses";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getVisitorAcceptClasses";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "acceptElements";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5, 6 -> new IllegalStateException(string);
        };
    }

    private record VisitorTypes(@NotNull @Unmodifiable List<? extends Class<?>> handlesElementTypes, boolean overridesVisitPsiElement) {
        @NotNull
        private final @Unmodifiable List<? extends Class<?>> handlesElementTypes;

        private VisitorTypes(@NotNull @Unmodifiable List<? extends Class<?>> handlesElementTypes, boolean overridesVisitPsiElement) {
            if (handlesElementTypes == null) {
                VisitorTypes.$$$reportNull$$$0(0);
            }
        }

        @NotNull
        public @Unmodifiable List<? extends Class<?>> handlesElementTypes() {
            List<? extends Class<?>> list = this.handlesElementTypes;
            if (list == null) {
                VisitorTypes.$$$reportNull$$$0(1);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handlesElementTypes";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/InspectionVisitorOptimizer$VisitorTypes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/InspectionVisitorOptimizer$VisitorTypes";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "handlesElementTypes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

