/*
 * Decompiled with CFR 0.152.
 */
package runtime.collections;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import libraries.collections.MultiMap;
import libraries.collections.MultiMapKt;
import libraries.collections.UtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u00020\u0002B1\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00028\u0001\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0013\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0014J\u0014\u0010\u0015\u001a\u00020\u00122\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00010\u0016J\u0013\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0014J\u0015\u0010\u0019\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0013\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u001aJ\u0019\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00010\u001c2\u0006\u0010\u0013\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u001dJ\u0019\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00010\u000e2\u0006\u0010\u0013\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u001fJ\u0015\u0010 \u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0018\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001aJ\u001b\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00010\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\u0002\u0010\u001fJ\f\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00010\u000eJ\u0019\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00010\u000e2\u0006\u0010\u0013\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u001fJ)\u0010#\u001a\u00020\u00122!\u0010$\u001a\u001d\u0012\u0013\u0012\u00118\u0001\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u00120\u0005J8\u0010#\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00028\u00012!\u0010$\u001a\u001d\u0012\u0013\u0012\u00118\u0001\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u00120\u0005H\u0002\u00a2\u0006\u0002\u0010'R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00028\u0001\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0012\u0004\u0012\u00028\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00010\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006("}, d2={"Lruntime/collections/Hierarchy;", "TKey", "", "T", "index", "Lkotlin/Function1;", "parentF", "<init>", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "items", "", "children", "Llibraries/collections/MultiMap;", "values", "", "getValues", "()Ljava/util/List;", "put", "", "value", "(Ljava/lang/Object;)V", "putAll", "", "remove", "id", "parent", "(Ljava/lang/Object;)Ljava/lang/Object;", "parents", "Lkotlin/sequences/Sequence;", "(Ljava/lang/Object;)Lkotlin/sequences/Sequence;", "path", "(Ljava/lang/Object;)Ljava/util/List;", "item", "roots", "subTree", "dfs", "visitor", "Lkotlin/ParameterName;", "name", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)V", "libraries-collections"})
@SourceDebugExtension(value={"SMAP\nHierarchy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Hierarchy.kt\nruntime/collections/Hierarchy\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,76:1\n1863#2,2:77\n1863#2,2:79\n1863#2,2:81\n*S KotlinDebug\n*F\n+ 1 Hierarchy.kt\nruntime/collections/Hierarchy\n*L\n19#1:77,2\n63#1:79,2\n70#1:81,2\n*E\n"})
public final class Hierarchy<TKey, T> {
    @NotNull
    private final Function1<T, TKey> index;
    @NotNull
    private final Function1<T, TKey> parentF;
    @NotNull
    private final Map<TKey, T> items;
    @NotNull
    private final MultiMap<TKey, T> children;

    public Hierarchy(@NotNull Function1<? super T, ? extends TKey> index, @NotNull Function1<? super T, ? extends TKey> parentF) {
        Intrinsics.checkNotNullParameter(index, (String)"index");
        Intrinsics.checkNotNullParameter(parentF, (String)"parentF");
        this.index = index;
        this.parentF = parentF;
        this.items = new LinkedHashMap();
        this.children = MultiMapKt.linkedMultiMap$default(null, 1, null);
    }

    @NotNull
    public final List<T> getValues() {
        return CollectionsKt.toList((Iterable)this.items.values());
    }

    public final void put(@NotNull T value2) {
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        Object id2 = this.index.invoke(value2);
        this.items.put(id2, value2);
        Object par = this.parentF.invoke(value2);
        this.children.put(par, value2);
    }

    public final void putAll(@NotNull Iterable<? extends T> values) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        Iterable<T> $this$forEach$iv = values;
        boolean $i$f$forEach = false;
        Iterator<T> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            T element$iv;
            T it = element$iv = iterator2.next();
            boolean bl = false;
            this.put(it);
        }
    }

    public final void remove(@NotNull TKey id2) {
        Intrinsics.checkNotNullParameter(id2, (String)"id");
        T t = this.items.get(id2);
        Intrinsics.checkNotNull(t);
        this.parentF.invoke(t);
        this.children.get(id2);
        this.items.remove(id2);
        String string = "impl";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Nullable
    public final T parent(@NotNull T value2) {
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        Object par = this.parentF.invoke(value2);
        return this.items.get(par);
    }

    @NotNull
    public final Sequence<T> parents(@NotNull T value2) {
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        return SequencesKt.generateSequence(value2, arg_0 -> Hierarchy.parents$lambda$1(this, arg_0));
    }

    @NotNull
    public final List<T> path(@NotNull T value2) {
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        return CollectionsKt.reversed((Iterable)SequencesKt.toList((Sequence)SequencesKt.generateSequence(value2, arg_0 -> Hierarchy.path$lambda$2(this, arg_0))));
    }

    @Nullable
    public final T item(@NotNull TKey id2) {
        Intrinsics.checkNotNullParameter(id2, (String)"id");
        return this.items.get(id2);
    }

    @NotNull
    public final List<T> children(@Nullable T value2) {
        if (value2 != null) {
            return CollectionsKt.toList((Iterable)this.children.get(this.index.invoke(value2)));
        }
        return this.roots();
    }

    @NotNull
    public final List<T> roots() {
        return CollectionsKt.toList((Iterable)this.children.get(null));
    }

    @NotNull
    public final List<T> subTree(@NotNull T value2) {
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        return UtilsKt.generateSequenceFlatMap(value2, arg_0 -> Hierarchy.subTree$lambda$3(this, arg_0));
    }

    public final void dfs(@NotNull Function1<? super T, Unit> visitor) {
        Intrinsics.checkNotNullParameter(visitor, (String)"visitor");
        Iterable $this$forEach$iv = this.roots();
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator2.next();
            boolean bl = false;
            this.dfs(it, visitor);
        }
    }

    private final void dfs(T parent, Function1<? super T, Unit> visitor) {
        visitor.invoke(parent);
        Iterable $this$forEach$iv = this.children(parent);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator2.next();
            boolean bl = false;
            this.dfs(it, visitor);
        }
    }

    private static final Object parents$lambda$1(Hierarchy this$0, Object it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.parent(it);
    }

    private static final Object path$lambda$2(Hierarchy this$0, Object it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.parent(it);
    }

    private static final Iterable subTree$lambda$3(Hierarchy this$0, Object it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.children(it);
    }
}

