/*
 * Decompiled with CFR 0.152.
 */
package runtime.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0000\u001a/\u0010\u0000\u001a\u001d\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"bezier", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "t", "points", "", "binomRow", "", "n", "", "platform-runtime"})
@SourceDebugExtension(value={"SMAP\nBezier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Bezier.kt\nruntime/utils/BezierKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,62:1\n1567#2:63\n1598#2,4:64\n*S KotlinDebug\n*F\n+ 1 Bezier.kt\nruntime/utils/BezierKt\n*L\n41#1:63\n41#1:64,4\n*E\n"})
public final class BezierKt {
    @NotNull
    public static final Function1<Double, Double> bezier(@NotNull List<Double> points) {
        Function1 function1;
        Intrinsics.checkNotNullParameter(points, (String)"points");
        switch (points.size()) {
            case 0: {
                throw new IllegalArgumentException("No point in running bezier without reference points");
            }
            case 1: {
                double p0 = ((Number)points.get(0)).doubleValue();
                function1 = arg_0 -> BezierKt.bezier$lambda$0(p0, arg_0);
                break;
            }
            case 2: {
                double p0 = ((Number)points.get(0)).doubleValue();
                double p1 = ((Number)points.get(1)).doubleValue();
                function1 = arg_0 -> BezierKt.bezier$lambda$1(p0, p1, arg_0);
                break;
            }
            case 3: {
                double p0 = ((Number)points.get(0)).doubleValue();
                double p1 = ((Number)points.get(1)).doubleValue();
                double p2 = ((Number)points.get(2)).doubleValue();
                function1 = arg_0 -> BezierKt.bezier$lambda$2(p0, p1, p2, arg_0);
                break;
            }
            case 4: {
                double p0 = ((Number)points.get(0)).doubleValue();
                double p1 = ((Number)points.get(1)).doubleValue();
                double p2 = ((Number)points.get(2)).doubleValue();
                double p3 = ((Number)points.get(3)).doubleValue();
                function1 = arg_0 -> BezierKt.bezier$lambda$3(p0, p1, p2, p3, arg_0);
                break;
            }
            default: {
                int[] binomRow = BezierKt.binomRow(points.size() - 1);
                return arg_0 -> BezierKt.bezier$lambda$5(points, binomRow, arg_0);
            }
        }
        return function1;
    }

    private static final int[] binomRow(int n) {
        int[] nArray;
        if (n <= 0) {
            int[] nArray2 = new int[]{1};
            nArray = nArray2;
        } else {
            int[] prevRow = BezierKt.binomRow(n - 1);
            int n2 = prevRow.length + 1;
            int[] nArray3 = new int[n2];
            for (int i = 0; i < n2; ++i) {
                int n3 = i;
                int n4 = n3;
                nArray3[n3] = n4 == 0 ? 1 : (n4 == prevRow.length ? 1 : prevRow[n3 - 1] + prevRow[n3]);
            }
            nArray = nArray3;
        }
        return nArray;
    }

    private static final double bezier$lambda$0(double $p0, double it) {
        return $p0;
    }

    private static final double bezier$lambda$1(double $p0, double $p1, double t) {
        return $p0 + t * ($p1 - $p0);
    }

    private static final double bezier$lambda$2(double $p0, double $p1, double $p2, double t) {
        double u = 1.0 - t;
        return u * u * $p0 + (double)2 * u * t * $p1 + t * t * $p2;
    }

    private static final double bezier$lambda$3(double $p0, double $p1, double $p2, double $p3, double t) {
        double u = 1.0 - t;
        return u * u * u * $p0 + (double)3 * u * u * t * $p1 + (double)3 * u * t * t * $p2 + t * t * t * $p3;
    }

    /*
     * WARNING - void declaration
     */
    private static final double bezier$lambda$5(List $points, int[] $binomRow, double t) {
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        Intrinsics.checkNotNullParameter((Object)$points, (String)"$points");
        Intrinsics.checkNotNullParameter((Object)$binomRow, (String)"$binomRow");
        double u = 1.0 - t;
        Iterable iterable = $points;
        boolean $i$f$mapIndexed = false;
        void var8_6 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void p;
            void index;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            double d = ((Number)item$iv$iv).doubleValue();
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((double)$binomRow[index] * Math.pow(u, $binomRow.length - 1 - index) * Math.pow(t, (double)index) * p);
        }
        return CollectionsKt.sumOfDouble((Iterable)((List)destination$iv$iv));
    }
}

