/*
 * Decompiled with CFR 0.152.
 */
package runtime.utils;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import libraries.klogging.KLogger;
import org.jetbrains.annotations.NotNull;
import org.joda.time.Duration;
import runtime.utils.LogUtilsKt;
import runtime.utils.TimedValue;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00006\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a?\u0010\u0000\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00010\tH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\n\u001a5\u0010\u0000\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00010\tH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000b\u001a;\u0010\f\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u00012\u0014\b\u0002\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00010\tH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012\u001aK\u0010\f\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u00012\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\t2\u0014\b\u0002\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00010\tH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014\u001a&\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0015\"\u0004\b\u0000\u0010\u00012\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00010\tH\u0086\b\u00f8\u0001\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0017"}, d2={"measureTimeMillisAndLog", "T", "opName", "", "log", "Llibraries/klogging/KLogger;", "printStartMsg", "", "block", "Lkotlin/Function0;", "(Ljava/lang/String;Llibraries/klogging/KLogger;ZLkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "(Ljava/lang/String;Llibraries/klogging/KLogger;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "measureAndReturn", "afterAction", "Lkotlin/Function1;", "", "", "action", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "beforeAction", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Lruntime/utils/TimedValue;", "body", "platform-runtime"})
@SourceDebugExtension(value={"SMAP\nLogUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogUtils.kt\nruntime/utils/LogUtilsKt\n*L\n1#1,48:1\n27#1,11:49\n8#1:60\n27#1,3:61\n10#1,4:64\n31#1,5:68\n16#1,2:73\n37#1:75\n20#1:76\n27#1,11:77\n*S KotlinDebug\n*F\n+ 1 LogUtils.kt\nruntime/utils/LogUtilsKt\n*L\n8#1:49,11\n22#1:60\n22#1:61,3\n22#1:64,4\n22#1:68,5\n22#1:73,2\n22#1:75\n22#1:76\n24#1:77,11\n*E\n"})
public final class LogUtilsKt {
    public static final <T> T measureTimeMillisAndLog(@NotNull String opName, @NotNull KLogger log, boolean printStartMsg, @NotNull Function0<? extends T> block) {
        long ms$iv;
        Intrinsics.checkNotNullParameter((Object)opName, (String)"opName");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$measureTimeMillisAndLog = false;
        boolean $i$f$measureAndReturn = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        if (printStartMsg) {
            log.debug(opName + ". Started.");
        }
        Object res$iv = block.invoke();
        long ms = ms$iv = System.currentTimeMillis() - start$iv;
        boolean bl2 = false;
        String string = "%.3f";
        Object[] objectArray = new Object[]{(double)ms / (double)1000};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        log.debug(opName + " took " + string2 + "s");
        return (T)res$iv;
    }

    public static /* synthetic */ Object measureTimeMillisAndLog$default(String opName, KLogger log, boolean printStartMsg, Function0 block, int n, Object object) {
        long ms$iv;
        if ((n & 4) != 0) {
            printStartMsg = false;
        }
        Intrinsics.checkNotNullParameter((Object)opName, (String)"opName");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        boolean $i$f$measureTimeMillisAndLog = false;
        boolean $i$f$measureAndReturn = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        if (printStartMsg) {
            log.debug(opName + ". Started.");
        }
        Object res$iv = block.invoke();
        long ms = ms$iv = System.currentTimeMillis() - start$iv;
        boolean bl2 = false;
        String string = "%.3f";
        Object[] objectArray = new Object[]{(double)ms / (double)1000};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        log.debug(opName + " took " + string2 + "s");
        return res$iv;
    }

    public static final <T> T measureTimeMillisAndLog(@NotNull String opName, @NotNull KLogger log, @NotNull Function0<? extends T> block) {
        long ms$iv$iv;
        Intrinsics.checkNotNullParameter((Object)opName, (String)"opName");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$measureTimeMillisAndLog = false;
        boolean printStartMsg$iv = false;
        boolean $i$f$measureTimeMillisAndLog2 = false;
        boolean $i$f$measureAndReturn = false;
        long start$iv$iv = System.currentTimeMillis();
        boolean bl = false;
        Object res$iv$iv = block.invoke();
        long ms$iv = ms$iv$iv = System.currentTimeMillis() - start$iv$iv;
        boolean bl2 = false;
        String string = "%.3f";
        Object[] objectArray = new Object[]{(double)ms$iv / (double)1000};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        log.debug(opName + " took " + string2 + "s");
        return (T)res$iv$iv;
    }

    public static final <T> T measureAndReturn(@NotNull Function1<? super Long, Unit> afterAction, @NotNull Function0<? extends T> action2) {
        Intrinsics.checkNotNullParameter(afterAction, (String)"afterAction");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        boolean $i$f$measureAndReturn = false;
        boolean $i$f$measureAndReturn2 = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        Object res$iv = action2.invoke();
        long ms$iv = System.currentTimeMillis() - start$iv;
        afterAction.invoke((Object)ms$iv);
        return (T)res$iv;
    }

    public static /* synthetic */ Object measureAndReturn$default(Function1 afterAction, Function0 action2, int n, Object object) {
        if ((n & 1) != 0) {
            afterAction = measureAndReturn.1.INSTANCE;
        }
        Intrinsics.checkNotNullParameter((Object)afterAction, (String)"afterAction");
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        boolean $i$f$measureAndReturn = false;
        boolean $i$f$measureAndReturn2 = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        Object res$iv = action2.invoke();
        long ms$iv = System.currentTimeMillis() - start$iv;
        afterAction.invoke((Object)ms$iv);
        return res$iv;
    }

    public static final <T> T measureAndReturn(@NotNull Function0<Unit> beforeAction, @NotNull Function1<? super Long, Unit> afterAction, @NotNull Function0<? extends T> action2) {
        Intrinsics.checkNotNullParameter(beforeAction, (String)"beforeAction");
        Intrinsics.checkNotNullParameter(afterAction, (String)"afterAction");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        boolean $i$f$measureAndReturn = false;
        long start2 = System.currentTimeMillis();
        beforeAction.invoke();
        Object res = action2.invoke();
        long ms = System.currentTimeMillis() - start2;
        afterAction.invoke((Object)ms);
        return (T)res;
    }

    public static /* synthetic */ Object measureAndReturn$default(Function0 beforeAction, Function1 afterAction, Function0 action2, int n, Object object) {
        if ((n & 1) != 0) {
            beforeAction = measureAndReturn.3.INSTANCE;
        }
        if ((n & 2) != 0) {
            afterAction = measureAndReturn.4.INSTANCE;
        }
        Intrinsics.checkNotNullParameter((Object)beforeAction, (String)"beforeAction");
        Intrinsics.checkNotNullParameter((Object)afterAction, (String)"afterAction");
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        boolean $i$f$measureAndReturn = false;
        long start2 = System.currentTimeMillis();
        beforeAction.invoke();
        Object res = action2.invoke();
        long ms = System.currentTimeMillis() - start2;
        afterAction.invoke((Object)ms);
        return res;
    }

    @NotNull
    public static final <T> TimedValue<T> measureAndReturn(@NotNull Function0<? extends T> body) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        boolean $i$f$measureAndReturn = false;
        long start2 = System.currentTimeMillis();
        Object result2 = body.invoke();
        Duration duration = new Duration(System.currentTimeMillis() - start2);
        return new TimedValue<Object>(duration, result2);
    }
}

