/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsFacade;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultCodeStyleSettingsFacade
implements CodeStyleSettingsFacade {
    @NotNull
    private final CodeStyleSettings mySettings;
    @Nullable
    private Language myLanguage;
    @Nullable
    private final FileType myFileType;

    public DefaultCodeStyleSettingsFacade(@NotNull CodeStyleSettings settings, @Nullable FileType fileType) {
        if (settings == null) {
            DefaultCodeStyleSettingsFacade.$$$reportNull$$$0(0);
        }
        this.mySettings = settings;
        this.myFileType = fileType;
        this.myLanguage = fileType instanceof LanguageFileType ? ((LanguageFileType)fileType).getLanguage() : Language.ANY;
    }

    public DefaultCodeStyleSettingsFacade withLanguage(@NotNull Language language) {
        if (language == null) {
            DefaultCodeStyleSettingsFacade.$$$reportNull$$$0(1);
        }
        this.myLanguage = language;
        return this;
    }

    @NotNull
    private CommonCodeStyleSettings.IndentOptions getIndentOptions() {
        CommonCodeStyleSettings.IndentOptions indentOptions = this.myFileType != null ? this.mySettings.getIndentOptions(this.myFileType) : this.mySettings.getIndentOptions();
        if (indentOptions == null) {
            DefaultCodeStyleSettingsFacade.$$$reportNull$$$0(2);
        }
        return indentOptions;
    }

    @NotNull
    private CommonCodeStyleSettings getCommonSettings() {
        CommonCodeStyleSettings commonCodeStyleSettings = this.mySettings.getCommonSettings(this.myLanguage);
        if (commonCodeStyleSettings == null) {
            DefaultCodeStyleSettingsFacade.$$$reportNull$$$0(3);
        }
        return commonCodeStyleSettings;
    }

    public final int getTabSize() {
        return this.getIndentOptions().TAB_SIZE;
    }

    public final int getIndentSize() {
        return this.getIndentOptions().INDENT_SIZE;
    }

    public boolean isSpaceBeforeComma() {
        return this.getCommonSettings().SPACE_BEFORE_COMMA;
    }

    public boolean isSpaceAfterComma() {
        return this.getCommonSettings().SPACE_AFTER_COMMA;
    }

    public boolean isSpaceAroundAssignmentOperators() {
        return this.getCommonSettings().SPACE_AROUND_ASSIGNMENT_OPERATORS;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/DefaultCodeStyleSettingsFacade";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/DefaultCodeStyleSettingsFacade";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndentOptions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "withLanguage";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

