/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.runners.RunContentBuilder;
import com.intellij.execution.runners.RunTab;
import com.intellij.execution.testframework.FailedTestsNavigator;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkPropertyListener;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.TestRunnerBundle;
import com.intellij.execution.testframework.ToggleModelAction;
import com.intellij.execution.testframework.ToggleModelActionProvider;
import com.intellij.execution.testframework.actions.ScrollToTestSourceAction;
import com.intellij.execution.testframework.actions.TestFrameworkActions;
import com.intellij.execution.testframework.actions.TestTreeExpander;
import com.intellij.execution.testframework.autotest.AdjustAutotestDelayActionGroup;
import com.intellij.execution.testframework.export.ExportTestResultsAction;
import com.intellij.execution.testframework.ui.AbstractTestTreeBuilderBase;
import com.intellij.execution.ui.UIExperiment;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.ide.TreeExpander;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.MoreActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.config.DumbAwareToggleBooleanProperty;
import com.intellij.util.config.DumbAwareToggleInvertedBooleanProperty;
import com.intellij.util.config.ToggleBooleanProperty;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolbarPanel
extends JPanel
implements OccurenceNavigator,
Disposable {
    private static final Logger LOG = Logger.getInstance(ToolbarPanel.class);
    private final TestTreeExpander myTreeExpander = new TestTreeExpander();
    private final FailedTestsNavigator myOccurenceNavigator;
    private final ScrollToTestSourceAction myScrollToSource;
    @Nullable
    private ExportTestResultsAction myExportAction;
    private final ArrayList<ToggleModelAction> myActions = new ArrayList();
    private final AnAction[] actionsToMerge;
    private final AnAction[] additionalActionsToMerge;

    public ToolbarPanel(final TestConsoleProperties properties, JComponent parent) {
        super(new BorderLayout());
        RunProfile configuration;
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.addAction((AnAction)new DumbAwareToggleInvertedBooleanProperty(ExecutionBundle.message("junit.run.hide.passed.action.name", new Object[0]), ExecutionBundle.message("junit.run.hide.passed.action.description", new Object[0]), AllIcons.RunConfigurations.ShowPassed, (AbstractProperty.AbstractPropertyContainer)properties, TestConsoleProperties.HIDE_PASSED_TESTS));
        actionGroup.add((AnAction)new DumbAwareToggleInvertedBooleanProperty(TestRunnerBundle.message("action.show.ignored.text", new Object[0]), TestRunnerBundle.message("action.show.ignored.description", new Object[0]), AllIcons.RunConfigurations.ShowIgnored, (AbstractProperty.AbstractPropertyContainer)properties, TestConsoleProperties.HIDE_IGNORED_TEST));
        actionGroup.addSeparator();
        boolean isNewLayout = UIExperiment.isNewDebuggerUIEnabled();
        DefaultActionGroup sortGroup = !isNewLayout ? actionGroup : DefaultActionGroup.createPopupGroup(() -> ExecutionBundle.message("junit.running.info.sort.group.name", new Object[0]));
        DumbAwareToggleBooleanProperty suitesAlwaysOnTop = new DumbAwareToggleBooleanProperty(ExecutionBundle.message("junit.running.info.folders.on.top.action.name", new Object[0]), ExecutionBundle.message("junit.running.info.folders.on.top.action.description", new Object[0]), null, (AbstractProperty.AbstractPropertyContainer)properties, TestConsoleProperties.SUITES_ALWAYS_ON_TOP);
        if (isNewLayout) {
            sortGroup.addAction((AnAction)suitesAlwaysOnTop);
        }
        sortGroup.addAction((AnAction)new DumbAwareToggleBooleanProperty(this, ExecutionBundle.message("junit.running.info.sort.alphabetically.action.name", new Object[0]), ExecutionBundle.message("junit.running.info.sort.alphabetically.action.description", new Object[0]), AllIcons.ObjectBrowser.Sorted, (AbstractProperty.AbstractPropertyContainer)properties, TestConsoleProperties.SORT_ALPHABETICALLY){

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.setSelected(e, state);
                if (state) {
                    TestConsoleProperties.SORT_BY_DURATION.primSet((AbstractProperty.AbstractPropertyContainer)properties, false);
                    TestConsoleProperties.SORT_BY_DECLARATION_ORDER.primSet((AbstractProperty.AbstractPropertyContainer)properties, false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/testframework/ToolbarPanel$1", "setSelected"));
            }
        });
        sortGroup.addAction((AnAction)new DumbAwareToggleBooleanProperty(this, ExecutionBundle.message("junit.running.info.sort.by.declaration.order.action.name", new Object[0]), ExecutionBundle.message("junit.running.info.sort.by.declaration.order.action.description", new Object[0]), AllIcons.ObjectBrowser.SortByType, (AbstractProperty.AbstractPropertyContainer)properties, TestConsoleProperties.SORT_BY_DECLARATION_ORDER){

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                super.setSelected(e, state);
                if (state) {
                    TestConsoleProperties.SORT_ALPHABETICALLY.primSet((AbstractProperty.AbstractPropertyContainer)properties, false);
                    TestConsoleProperties.SORT_BY_DURATION.primSet((AbstractProperty.AbstractPropertyContainer)properties, false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/testframework/ToolbarPanel$2", "setSelected"));
            }
        });
        SortByDurationAction sortByStatistics = new SortByDurationAction(properties);
        this.myActions.add(sortByStatistics);
        sortGroup.addAction((AnAction)((Object)sortByStatistics));
        if (isNewLayout) {
            sortGroup.getTemplatePresentation().setIcon(sortByStatistics.getTemplatePresentation().getIcon());
            actionGroup.add((AnAction)sortGroup);
        } else {
            actionGroup.addSeparator();
        }
        DefaultActionGroup moreGroup = isNewLayout ? new MoreActionGroup() : actionGroup;
        AnAction action = CommonActionsManager.getInstance().createExpandAllAction((TreeExpander)this.myTreeExpander, parent);
        action.getTemplatePresentation().setDescription(ExecutionBundle.messagePointer("junit.running.info.expand.test.action.name", new Object[0]));
        moreGroup.add(action);
        action = CommonActionsManager.getInstance().createCollapseAllAction((TreeExpander)this.myTreeExpander, parent);
        action.getTemplatePresentation().setDescription(ExecutionBundle.messagePointer("junit.running.info.collapse.test.action.name", new Object[0]));
        moreGroup.add(action);
        moreGroup.addSeparator();
        CommonActionsManager actionsManager = CommonActionsManager.getInstance();
        this.myOccurenceNavigator = new FailedTestsNavigator();
        moreGroup.add(actionsManager.createPrevOccurenceAction((OccurenceNavigator)this.myOccurenceNavigator));
        moreGroup.add(actionsManager.createNextOccurenceAction((OccurenceNavigator)this.myOccurenceNavigator));
        for (ToggleModelActionProvider actionProvider : ToggleModelActionProvider.EP_NAME.getExtensionList()) {
            ToggleModelAction toggleModelAction = actionProvider.createToggleModelAction(properties);
            this.myActions.add(toggleModelAction);
            actionGroup.add((AnAction)((Object)toggleModelAction));
        }
        AnAction[] importActions = properties.createImportActions();
        if (importActions != null) {
            RunContentBuilder.addActionsWithConstraints((AnAction[])importActions, (Constraints)Constraints.LAST, (DefaultActionGroup)actionGroup, (DefaultActionGroup)moreGroup);
        }
        if ((configuration = properties.getConfiguration()) instanceof RunConfiguration) {
            RunConfiguration runConfiguration = (RunConfiguration)configuration;
            this.myExportAction = ExportTestResultsAction.create(properties.getExecutor().getToolWindowId(), runConfiguration, parent);
            moreGroup.addAction((AnAction)((Object)this.myExportAction));
        }
        DefaultActionGroup secondaryGroup = new DefaultActionGroup();
        secondaryGroup.setPopup(true);
        secondaryGroup.getTemplatePresentation().setText(ExecutionBundle.message("junit.running.info.test.runner.options.group.name", new Object[0]));
        secondaryGroup.getTemplatePresentation().setIcon(AllIcons.General.GearPlain);
        secondaryGroup.add((AnAction)new DumbAwareToggleBooleanProperty(ExecutionBundle.message("junit.running.info.track.test.action.name", new Object[0]), ExecutionBundle.message("junit.running.info.track.test.action.description", new Object[0]), null, (AbstractProperty.AbstractPropertyContainer)properties, TestConsoleProperties.TRACK_RUNNING_TEST));
        secondaryGroup.add((AnAction)new DumbAwareToggleBooleanProperty(TestRunnerBundle.message("action.show.inline.statistics.text", new Object[0]), TestRunnerBundle.message("action.toggle.visibility.test.duration.in.tree.description", new Object[0]), null, (AbstractProperty.AbstractPropertyContainer)properties, TestConsoleProperties.SHOW_INLINE_STATISTICS));
        if (!isNewLayout) {
            secondaryGroup.add((AnAction)suitesAlwaysOnTop);
        }
        secondaryGroup.addSeparator();
        DefaultActionGroup scrollToGroup = new DefaultActionGroup();
        scrollToGroup.getTemplatePresentation().setText(ExecutionBundle.message("junit.running.info.scroll.to.group.name", new Object[0]));
        scrollToGroup.setPopup(true);
        scrollToGroup.add((AnAction)new DumbAwareToggleBooleanProperty(ExecutionBundle.message("junit.running.info.scroll.to.stacktrace.action.name", new Object[0]), ExecutionBundle.message("junit.running.info.scroll.to.stacktrace.action.description", new Object[0]), null, (AbstractProperty.AbstractPropertyContainer)properties, TestConsoleProperties.SCROLL_TO_STACK_TRACE));
        scrollToGroup.addSeparator();
        scrollToGroup.add((AnAction)new DumbAwareToggleInvertedBooleanProperty(ExecutionBundle.message("junit.running.info.scroll.to.top.action.name", new Object[0]), ExecutionBundle.message("junit.running.info.scroll.to.top.action.description", new Object[0]), null, (AbstractProperty.AbstractPropertyContainer)properties, TestConsoleProperties.SCROLL_TO_BOTTOM));
        scrollToGroup.add((AnAction)new DumbAwareToggleBooleanProperty(ExecutionBundle.message("junit.running.info.scroll.to.bottom.action.name", new Object[0]), ExecutionBundle.message("junit.running.info.scroll.to.bottom.action.description", new Object[0]), null, (AbstractProperty.AbstractPropertyContainer)properties, TestConsoleProperties.SCROLL_TO_BOTTOM));
        secondaryGroup.add((AnAction)scrollToGroup);
        secondaryGroup.add((AnAction)new ToggleBooleanProperty(ExecutionBundle.message("junit.running.info.open.source.at.exception.action.name", new Object[0]), ExecutionBundle.message("junit.running.info.open.source.at.exception.action.description", new Object[0]), null, (AbstractProperty.AbstractPropertyContainer)properties, TestConsoleProperties.OPEN_FAILURE_LINE));
        this.myScrollToSource = new ScrollToTestSourceAction(properties);
        secondaryGroup.add((AnAction)((Object)this.myScrollToSource));
        secondaryGroup.add((AnAction)new AdjustAutotestDelayActionGroup());
        secondaryGroup.add((AnAction)new ToggleBooleanProperty(ExecutionBundle.message("junit.running.info.show.auto.test.status.text", new Object[0]), ExecutionBundle.message("junit.running.info.show.auto.test.status.description", new Object[0]), null, (AbstractProperty.AbstractPropertyContainer)properties, TestConsoleProperties.SHOW_AUTO_TEST_TOOLBAR));
        secondaryGroup.addSeparator();
        secondaryGroup.add((AnAction)new DumbAwareToggleBooleanProperty(ExecutionBundle.message("junit.running.info.select.first.failed.action.name", new Object[0]), null, null, (AbstractProperty.AbstractPropertyContainer)properties, TestConsoleProperties.SELECT_FIRST_DEFECT));
        properties.appendAdditionalActions(secondaryGroup, parent, properties);
        moreGroup.addSeparator();
        moreGroup.add((AnAction)secondaryGroup);
        this.actionsToMerge = actionGroup.getChildActionsOrStubs();
        this.additionalActionsToMerge = moreGroup.getChildActionsOrStubs();
        if (isNewLayout) {
            actionGroup.add((AnAction)moreGroup);
            actionGroup = new RunTab.ToolbarActionGroup((ActionGroup)actionGroup);
        }
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("TestTreeViewToolbar", (ActionGroup)actionGroup, true);
        actionToolbar.setTargetComponent(parent);
        this.add((Component)actionToolbar.getComponent(), "Center");
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = this.myOccurenceNavigator.getActionUpdateThread();
        if (actionUpdateThread == null) {
            ToolbarPanel.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void setModel(TestFrameworkRunningModel model2) {
        TestFrameworkActions.installFilterAction(model2);
        this.myScrollToSource.setModel(model2);
        this.myTreeExpander.setModel(model2);
        this.myOccurenceNavigator.setModel(model2);
        if (this.myExportAction != null) {
            this.myExportAction.setModel(model2);
        }
        for (ToggleModelAction action : this.myActions) {
            action.setModel(model2);
        }
        TestFrameworkActions.addPropertyListener((AbstractProperty<Boolean>)TestConsoleProperties.SORT_ALPHABETICALLY, ToolbarPanel.createComparatorPropertyListener(model2), model2, true);
        TestFrameworkActions.addPropertyListener((AbstractProperty<Boolean>)TestConsoleProperties.SORT_BY_DECLARATION_ORDER, ToolbarPanel.createComparatorPropertyListener(model2), model2, true);
        TestFrameworkActions.addPropertyListener((AbstractProperty<Boolean>)TestConsoleProperties.SORT_BY_DURATION, ToolbarPanel.createComparatorPropertyListener(model2), model2, true);
        TestFrameworkActions.addPropertyListener((AbstractProperty<Boolean>)TestConsoleProperties.SUITES_ALWAYS_ON_TOP, ToolbarPanel.createComparatorPropertyListener(model2), model2, true);
    }

    public AnAction[] getActionsToMerge() {
        return this.actionsToMerge;
    }

    public AnAction[] getAdditionalActionsToMerge() {
        return this.additionalActionsToMerge;
    }

    private static TestFrameworkPropertyListener<Boolean> createComparatorPropertyListener(final TestFrameworkRunningModel model2) {
        return new TestFrameworkPropertyListener<Boolean>(){

            @Override
            public void onChanged(Boolean value) {
                try {
                    AbstractTestTreeBuilderBase builder = (AbstractTestTreeBuilderBase)model2.getClass().getMethod("getTreeBuilder", new Class[0]).invoke((Object)model2, new Object[0]);
                    if (builder != null) {
                        builder.setTestsComparator(model2);
                    }
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
        };
    }

    public boolean hasNextOccurence() {
        return this.myOccurenceNavigator.hasNextOccurence();
    }

    public boolean hasPreviousOccurence() {
        return this.myOccurenceNavigator.hasPreviousOccurence();
    }

    public OccurenceNavigator.OccurenceInfo goNextOccurence() {
        return this.myOccurenceNavigator.goNextOccurence();
    }

    public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
        return this.myOccurenceNavigator.goPreviousOccurence();
    }

    @NotNull
    public String getNextOccurenceActionName() {
        String string = this.myOccurenceNavigator.getNextOccurenceActionName();
        if (string == null) {
            ToolbarPanel.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getPreviousOccurenceActionName() {
        String string = this.myOccurenceNavigator.getPreviousOccurenceActionName();
        if (string == null) {
            ToolbarPanel.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void dispose() {
        this.myScrollToSource.setModel(null);
        if (this.myExportAction != null) {
            this.myExportAction.setModel(null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/execution/testframework/ToolbarPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextOccurenceActionName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreviousOccurenceActionName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class SortByDurationAction
    extends ToggleModelAction
    implements DumbAware {
        private TestFrameworkRunningModel myModel;

        SortByDurationAction(TestConsoleProperties properties) {
            super(ExecutionBundle.message("junit.running.info.sort.by.statistics.action.name", new Object[0]), ExecutionBundle.message("junit.running.info.sort.by.statistics.action.description", new Object[0]), AllIcons.RunConfigurations.SortbyDuration, (AbstractProperty.AbstractPropertyContainer)properties, TestConsoleProperties.SORT_BY_DURATION);
        }

        protected boolean isEnabled() {
            TestFrameworkRunningModel model2 = this.myModel;
            return model2 != null && !model2.isRunning();
        }

        @Override
        public void setModel(TestFrameworkRunningModel model2) {
            this.myModel = model2;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                SortByDurationAction.$$$reportNull$$$0(0);
            }
            super.setSelected(e, state);
            if (state) {
                TestConsoleProperties.SORT_BY_DECLARATION_ORDER.primSet((AbstractProperty.AbstractPropertyContainer)this.myModel.getProperties(), false);
                TestConsoleProperties.SORT_ALPHABETICALLY.primSet((AbstractProperty.AbstractPropertyContainer)this.myModel.getProperties(), false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/testframework/ToolbarPanel$SortByDurationAction", "setSelected"));
        }
    }
}

