/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.similarity.clustering;

import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.Usage;
import com.intellij.usages.similarity.bag.Bag;
import com.intellij.usages.similarity.clustering.Distance;
import com.intellij.usages.similarity.clustering.UsageCluster;
import com.intellij.usages.similarity.usageAdapter.SimilarUsage;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClusteringSearchSession {
    @NotNull
    private final @NotNull List<@NotNull UsageCluster> myClusters = Collections.synchronizedList(new ArrayList());
    @NotNull
    private final Distance myDistance = new Distance(Registry.doubleValue((String)"similarity.find.usages.groups.threshold"));

    @NotNull
    public @NotNull List<@NotNull UsageCluster> getClusters() {
        return new ArrayList<UsageCluster>(this.myClusters);
    }

    @RequiresBackgroundThread
    @NotNull
    public synchronized SimilarUsage clusterUsage(@NotNull SimilarUsage similarUsageAdapter) {
        if (similarUsageAdapter == null) {
            ClusteringSearchSession.$$$reportNull$$$0(0);
        }
        ThreadingAssertions.assertBackgroundThread();
        UsageCluster cluster = this.getTheMostSimilarCluster(similarUsageAdapter.getFeatures());
        if (cluster == null) {
            cluster = this.createNewCluster();
        }
        cluster.addUsage(similarUsageAdapter);
        SimilarUsage similarUsage = similarUsageAdapter;
        if (similarUsage == null) {
            ClusteringSearchSession.$$$reportNull$$$0(1);
        }
        return similarUsage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public UsageCluster findCluster(@Nullable UsageInfo usageInfo) {
        List<UsageCluster> list2 = this.myClusters;
        synchronized (list2) {
            for (UsageCluster cluster : this.myClusters) {
                if (!cluster.contains(usageInfo)) continue;
                return cluster;
            }
        }
        return null;
    }

    @RequiresBackgroundThread
    @RequiresReadLock
    @NotNull
    public @NotNull List<@NotNull UsageCluster> getClustersForSelectedUsages(@NotNull Set<Usage> selectedUsages2) {
        if (selectedUsages2 == null) {
            ClusteringSearchSession.$$$reportNull$$$0(2);
        }
        ThreadingAssertions.softAssertReadAccess();
        List<UsageCluster> list2 = this.getClusters().stream().map(cluster -> new UsageCluster(cluster.getOnlySelectedUsages(selectedUsages2))).filter(usageCluster -> !usageCluster.getUsages().isEmpty()).sorted((o1, o2) -> Integer.compare(o2.getUsages().size(), o1.getUsages().size())).collect(Collectors.toList());
        if (list2 == null) {
            ClusteringSearchSession.$$$reportNull$$$0(3);
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateClusters(@NotNull @NotNull Collection<? extends @NotNull UsageCluster> clusters) {
        if (clusters == null) {
            ClusteringSearchSession.$$$reportNull$$$0(4);
        }
        List<UsageCluster> list2 = this.myClusters;
        synchronized (list2) {
            this.myClusters.clear();
            this.myClusters.addAll(clusters);
        }
    }

    @NotNull
    private UsageCluster createNewCluster() {
        UsageCluster newCluster = new UsageCluster();
        this.myClusters.add(newCluster);
        UsageCluster usageCluster = newCluster;
        if (usageCluster == null) {
            ClusteringSearchSession.$$$reportNull$$$0(5);
        }
        return usageCluster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private UsageCluster getTheMostSimilarCluster(@NotNull Bag features) {
        if (features == null) {
            ClusteringSearchSession.$$$reportNull$$$0(6);
        }
        UsageCluster mostUsageCluster = null;
        double maxSimilarity = 0.0;
        List<UsageCluster> list2 = this.myClusters;
        synchronized (list2) {
            for (UsageCluster cluster : this.myClusters) {
                double similarity = this.myDistance.findMinimalSimilarity(cluster, features);
                if (Distance.isCompleteMatch(similarity)) {
                    return cluster;
                }
                if (!Distance.lessThen(maxSimilarity, similarity)) continue;
                mostUsageCluster = cluster;
                maxSimilarity = similarity;
            }
        }
        return mostUsageCluster;
    }

    @Nullable
    public static ClusteringSearchSession createClusteringSessionIfEnabled() {
        return ClusteringSearchSession.isSimilarUsagesClusteringEnabled() ? new ClusteringSearchSession() : null;
    }

    public static boolean isSimilarUsagesClusteringEnabled() {
        return AdvancedSettings.getBoolean("ide.similar.usages.clustering.enable");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "similarUsageAdapter";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/usages/similarity/clustering/ClusteringSearchSession";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedUsages";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clusters";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "features";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/usages/similarity/clustering/ClusteringSearchSession";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "clusterUsage";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getClustersForSelectedUsages";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewCluster";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "clusterUsage";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getClustersForSelectedUsages";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateClusters";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTheMostSimilarCluster";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 5 -> new IllegalStateException(string);
        };
    }
}

