/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.roots.PersistentOrderRootType;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class OrderRootType {
    private final String myName;
    public static final ExtensionPointName<OrderRootType> EP_NAME = ExtensionPointName.create((String)"com.intellij.orderRootType");
    public static final OrderRootType CLASSES = new PersistentOrderRootType("CLASSES", "classPath", null, "classPathEntry");
    public static final OrderRootType SOURCES = new PersistentOrderRootType("SOURCES", "sourcePath", null, "sourcePathEntry");
    @NotNull
    private static final @Unmodifiable List<PersistentOrderRootType> PREDEFINED_PERSISTENT_TYPES = List.of((PersistentOrderRootType)CLASSES, (PersistentOrderRootType)SOURCES);
    public static final OrderRootType DOCUMENTATION = new DocumentationRootType();

    protected OrderRootType(@NotNull String name) {
        if (name == null) {
            OrderRootType.$$$reportNull$$$0(0);
        }
        this.myName = name;
    }

    @NotNull
    public String name() {
        String string = this.myName;
        if (string == null) {
            OrderRootType.$$$reportNull$$$0(1);
        }
        return string;
    }

    @ApiStatus.Internal
    public boolean skipWriteIfEmpty() {
        return false;
    }

    @ApiStatus.Obsolete
    public static OrderRootType @NotNull [] getAllTypes() {
        return OrderRootType.getAllPersistentTypes();
    }

    @ApiStatus.Obsolete
    public static PersistentOrderRootType @NotNull [] getAllPersistentTypes() {
        PersistentOrderRootType[] persistentOrderRootTypeArray = OrderRootType.getAllPersistentTypesList().toArray(new PersistentOrderRootType[0]);
        if (persistentOrderRootTypeArray == null) {
            OrderRootType.$$$reportNull$$$0(2);
        }
        return persistentOrderRootTypeArray;
    }

    @NotNull
    public static @Unmodifiable List<PersistentOrderRootType> getAllPersistentTypesList() {
        List list = ContainerUtil.concat(PREDEFINED_PERSISTENT_TYPES, (List)ContainerUtil.filterIsInstance((Collection)EP_NAME.getExtensionList(), PersistentOrderRootType.class));
        if (list == null) {
            OrderRootType.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public static @Unmodifiable List<PersistentOrderRootType> getSortedRootTypes() {
        ArrayList<PersistentOrderRootType> allTypes = new ArrayList<PersistentOrderRootType>(OrderRootType.getAllPersistentTypesList());
        allTypes.sort((o1, o2) -> o1.name().compareToIgnoreCase(o2.name()));
        ArrayList<PersistentOrderRootType> arrayList = allTypes;
        if (arrayList == null) {
            OrderRootType.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    protected static <T> T getOrderRootType(@NotNull Class<? extends T> orderRootTypeClass) {
        if (orderRootTypeClass == null) {
            OrderRootType.$$$reportNull$$$0(5);
        }
        List rootTypes = EP_NAME.getExtensionList();
        for (OrderRootType rootType : rootTypes) {
            OrderRootType t;
            if (!orderRootTypeClass.isInstance(rootType)) continue;
            OrderRootType orderRootType = t = rootType;
            if (orderRootType == null) {
                OrderRootType.$$$reportNull$$$0(6);
            }
            return (T)orderRootType;
        }
        assert (false) : "Root type " + String.valueOf(orderRootTypeClass) + " not found. All roots: " + String.valueOf(rootTypes);
        if (null == null) {
            OrderRootType.$$$reportNull$$$0(7);
        }
        return null;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    public String toString() {
        return "Root " + this.name();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/OrderRootType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderRootTypeClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/OrderRootType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "name";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPersistentTypes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPersistentTypesList";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedRootTypes";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderRootType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getOrderRootType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 6, 7 -> new IllegalStateException(string);
        };
    }

    public static class DocumentationRootType
    extends OrderRootType {
        public DocumentationRootType() {
            super("DOCUMENTATION");
        }

        @Override
        public boolean skipWriteIfEmpty() {
            return true;
        }
    }
}

