/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.nio.file.Path;

public final class ReadOnlyAttributeUtil {
    public static void setReadOnlyAttribute(VirtualFile file, boolean readOnlyStatus) throws IOException {
        boolean writable;
        if (file.getFileSystem().isReadOnly()) {
            throw new IllegalArgumentException("Wrong file system: " + String.valueOf(file.getFileSystem()));
        }
        boolean bl = writable = !readOnlyStatus;
        if (file.isWritable() != writable) {
            file.setWritable(writable);
        }
    }

    @Deprecated(forRemoval=true)
    public static void setReadOnlyAttribute(String path, boolean readOnlyStatus) throws IOException {
        NioFiles.setReadOnly((Path)Path.of(path, new String[0]), (boolean)readOnlyStatus);
    }
}

