/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl.legacyBridge.module.roots;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.OrderRootsCache;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.workspaceModel.ide.impl.VirtualFileUrlBridge;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0001!B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J9\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0014\u0010\u0016\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\u0017H\u0016\u00a2\u0006\u0002\u0010\u001aJ9\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00190\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0014\u0010\u0016\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\u0017H\u0016\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001d\u001a\u00020\u001eH\u0016J.\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0014\u0010 \u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\u0017H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/workspaceModel/ide/impl/legacyBridge/module/roots/OrderRootsCacheBridge;", "Lcom/intellij/openapi/roots/impl/OrderRootsCache;", "project", "Lcom/intellij/openapi/project/Project;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;)V", "virtualFileUrlManager", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;", "myRootUrlsAndFiles", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/openapi/roots/impl/OrderRootsCache$CacheKey;", "Lcom/intellij/workspaceModel/ide/impl/legacyBridge/module/roots/OrderRootsCacheBridge$UrlsAndVirtualFiles;", "getOrComputeRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "rootType", "Lcom/intellij/openapi/roots/OrderRootType;", "flags", "", "computer", "Ljava/util/function/Supplier;", "", "", "(Lcom/intellij/openapi/roots/OrderRootType;ILjava/util/function/Supplier;)[Lcom/intellij/openapi/vfs/VirtualFile;", "getOrComputeUrls", "(Lcom/intellij/openapi/roots/OrderRootType;ILjava/util/function/Supplier;)[Ljava/lang/String;", "clearCache", "", "ensureCached", "rootUrlsComputer", "UrlsAndVirtualFiles", "intellij.platform.projectModel.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nOrderRootsCacheBridge.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OrderRootsCacheBridge.kt\ncom/intellij/workspaceModel/ide/impl/legacyBridge/module/roots/OrderRootsCacheBridge\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,51:1\n1586#2:52\n1661#2,3:53\n1586#2:56\n1661#2,3:57\n1642#2,10:60\n1915#2:70\n1916#2:72\n1652#2:73\n1#3:71\n*S KotlinDebug\n*F\n+ 1 OrderRootsCacheBridge.kt\ncom/intellij/workspaceModel/ide/impl/legacyBridge/module/roots/OrderRootsCacheBridge\n*L\n46#1:52\n46#1:53,3\n47#1:56\n47#1:57,3\n48#1:60,10\n48#1:70\n48#1:72\n48#1:73\n48#1:71\n*E\n"})
public final class OrderRootsCacheBridge
extends OrderRootsCache {
    @NotNull
    private final VirtualFileUrlManager virtualFileUrlManager;
    @NotNull
    private final AtomicReference<ConcurrentMap<OrderRootsCache.CacheKey, UrlsAndVirtualFiles>> myRootUrlsAndFiles;

    public OrderRootsCacheBridge(@NotNull Project project, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        super(parentDisposable);
        this.virtualFileUrlManager = WorkspaceModel.Companion.getInstance(project).getVirtualFileUrlManager();
        this.myRootUrlsAndFiles = new AtomicReference();
    }

    @Override
    @NotNull
    public VirtualFile[] getOrComputeRoots(@NotNull OrderRootType rootType, int flags, @NotNull Supplier<? extends Collection<String>> computer) {
        Intrinsics.checkNotNullParameter((Object)rootType, (String)"rootType");
        Intrinsics.checkNotNullParameter(computer, (String)"computer");
        UrlsAndVirtualFiles urlsAndFiles = this.ensureCached(rootType, flags, computer);
        return urlsAndFiles.getVirtualFiles();
    }

    @Override
    @NotNull
    public String[] getOrComputeUrls(@NotNull OrderRootType rootType, int flags, @NotNull Supplier<? extends Collection<String>> computer) {
        Intrinsics.checkNotNullParameter((Object)rootType, (String)"rootType");
        Intrinsics.checkNotNullParameter(computer, (String)"computer");
        UrlsAndVirtualFiles urlsAndFiles = this.ensureCached(rootType, flags, computer);
        return urlsAndFiles.getUrls();
    }

    @Override
    public void clearCache() {
        ApplicationManager.getApplication().assertWriteIntentLockAcquired();
        this.myRootUrlsAndFiles.set(null);
    }

    /*
     * WARNING - void declaration
     */
    private final UrlsAndVirtualFiles ensureCached(OrderRootType rootType, int flags, Supplier<? extends Collection<String>> rootUrlsComputer) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        UrlsAndVirtualFiles entry;
        OrderRootsCache.CacheKey key = new OrderRootsCache.CacheKey(rootType, flags);
        ConcurrentMap<OrderRootsCache.CacheKey, UrlsAndVirtualFiles> concurrentMap = this.myRootUrlsAndFiles.get();
        UrlsAndVirtualFiles urlsAndVirtualFiles = entry = concurrentMap != null ? (UrlsAndVirtualFiles)concurrentMap.get(key) : null;
        if (urlsAndVirtualFiles != null) {
            return urlsAndVirtualFiles;
        }
        Collection<String> collection2 = rootUrlsComputer.get();
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"get(...)");
        Iterable $this$map$iv = collection2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            Iterator it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            VirtualFileUrl virtualFileUrl = this.virtualFileUrlManager.getOrCreateFromUrl((String)((Object)it));
            Intrinsics.checkNotNull((Object)virtualFileUrl, (String)"null cannot be cast to non-null type com.intellij.workspaceModel.ide.impl.VirtualFileUrlBridge");
            collection.add((VirtualFileUrlBridge)virtualFileUrl);
        }
        List virtualFileUrls = (List)destination$iv$iv;
        Iterable $this$map$iv2 = virtualFileUrls;
        boolean $i$f$map2 = false;
        Iterable $i$f$mapTo22 = $this$map$iv2;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VirtualFileUrlBridge virtualFileUrlBridge = (VirtualFileUrlBridge)((Object)item$iv$iv);
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(it.getUrl());
        }
        String[] stringArray = ArrayUtil.toStringArray((Collection)((List)destination$iv$iv2));
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"toStringArray(...)");
        String[] urls = stringArray;
        Iterable $this$mapNotNull$iv = virtualFileUrls;
        boolean $i$f$mapNotNull = false;
        destination$iv$iv2 = $this$mapNotNull$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            VirtualFile it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            VirtualFileUrlBridge it = (VirtualFileUrlBridge)((Object)element$iv$iv);
            boolean bl2 = false;
            if (it.getFile() == null) continue;
            boolean bl3 = false;
            destination$iv$iv3.add(it$iv$iv);
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray((Collection)((List)destination$iv$iv3));
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"toVirtualFileArray(...)");
        VirtualFile[] virtualFiles = virtualFileArray;
        UrlsAndVirtualFiles urlsAndVirtualFiles2 = ((ConcurrentMap)ConcurrencyUtil.cacheOrGet(this.myRootUrlsAndFiles, new ConcurrentHashMap())).computeIfAbsent(key, arg_0 -> OrderRootsCacheBridge.ensureCached$lambda$4(arg_0 -> OrderRootsCacheBridge.ensureCached$lambda$3(urls, virtualFiles, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)urlsAndVirtualFiles2, (String)"computeIfAbsent(...)");
        return urlsAndVirtualFiles2;
    }

    private static final UrlsAndVirtualFiles ensureCached$lambda$3(String[] $urls, VirtualFile[] $virtualFiles, OrderRootsCache.CacheKey it) {
        return new UrlsAndVirtualFiles($urls, $virtualFiles);
    }

    private static final UrlsAndVirtualFiles ensureCached$lambda$4(Function1 $tmp0, Object p0) {
        return (UrlsAndVirtualFiles)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0004\b\u0007\u0010\bR\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0019\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000f"}, d2={"Lcom/intellij/workspaceModel/ide/impl/legacyBridge/module/roots/OrderRootsCacheBridge$UrlsAndVirtualFiles;", "", "urls", "", "", "virtualFiles", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "([Ljava/lang/String;[Lcom/intellij/openapi/vfs/VirtualFile;)V", "getUrls", "()[Ljava/lang/String;", "[Ljava/lang/String;", "getVirtualFiles", "()[Lcom/intellij/openapi/vfs/VirtualFile;", "[Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.platform.projectModel.impl"})
    public static final class UrlsAndVirtualFiles {
        @NotNull
        private final String[] urls;
        @NotNull
        private final VirtualFile[] virtualFiles;

        public UrlsAndVirtualFiles(@NotNull String[] urls, @NotNull VirtualFile[] virtualFiles) {
            Intrinsics.checkNotNullParameter((Object)urls, (String)"urls");
            Intrinsics.checkNotNullParameter((Object)virtualFiles, (String)"virtualFiles");
            this.urls = urls;
            this.virtualFiles = virtualFiles;
        }

        @NotNull
        public final String[] getUrls() {
            return this.urls;
        }

        @NotNull
        public final VirtualFile[] getVirtualFiles() {
            return this.virtualFiles;
        }
    }
}

