/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ui;

import com.intellij.CommonBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.FilePathSplittingPolicy;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;

public class ReplaceFileConfirmationDialog {
    private final FileStatusManager myFileStatusManager;
    ProgressIndicator myProgressIndicator = ProgressManager.getInstance().getProgressIndicator();
    @Nls
    private final String myActionName;

    public ReplaceFileConfirmationDialog(Project project, @Nls String actionName) {
        this.myFileStatusManager = FileStatusManager.getInstance((Project)project);
        this.myActionName = actionName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean confirmFor(VirtualFile[] files) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        if (this.myProgressIndicator != null) {
            this.myProgressIndicator.pushState();
        }
        try {
            Collection<VirtualFile> modifiedFiles = this.collectModifiedFiles(files);
            if (modifiedFiles.isEmpty()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = this.requestConfirmation(modifiedFiles);
            return bl;
        }
        finally {
            if (this.myProgressIndicator != null) {
                this.myProgressIndicator.popState();
            }
        }
    }

    public boolean requestConfirmation(Collection modifiedFiles) {
        if (modifiedFiles.isEmpty()) {
            return true;
        }
        return Messages.showOkCancelDialog((String)this.createMessage(modifiedFiles), (String)this.myActionName, (String)this.createOverwriteButtonName(modifiedFiles), (String)this.getCancelButtonText(), (Icon)Messages.getWarningIcon()) == 0;
    }

    @NlsContexts.Button
    protected String getCancelButtonText() {
        return CommonBundle.getCancelButtonText();
    }

    @NlsContexts.Button
    private String createOverwriteButtonName(Collection modifiedFiles) {
        return modifiedFiles.size() > 1 ? this.getOkButtonTextForFiles() : this.getOkButtonTextForOneFile();
    }

    @NlsContexts.Button
    protected String getOkButtonTextForOneFile() {
        return VcsBundle.message((String)"button.text.overwrite.modified.file", (Object[])new Object[0]);
    }

    @NlsContexts.Button
    protected String getOkButtonTextForFiles() {
        return VcsBundle.message((String)"button.text.overwrite.modified.files", (Object[])new Object[0]);
    }

    @NlsContexts.DialogMessage
    protected String createMessage(Collection modifiedFiles) {
        if (modifiedFiles.size() == 1) {
            VirtualFile virtualFile = (VirtualFile)modifiedFiles.iterator().next();
            return VcsBundle.message((String)"message.text.file.locally.modified", (Object[])new Object[]{FilePathSplittingPolicy.SPLIT_BY_LETTER.getPresentableName(new File(virtualFile.getPath()), 40)});
        }
        return VcsBundle.message((String)"message.text.several.files.locally.modified", (Object[])new Object[0]);
    }

    public Collection<VirtualFile> collectModifiedFiles(VirtualFile[] files) {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        if (files == null) {
            return result;
        }
        for (VirtualFile file : files) {
            FileStatus status;
            if (this.myProgressIndicator != null) {
                this.myProgressIndicator.setText(VcsBundle.message((String)"progress.text.searching.for.modified.files", (Object[])new Object[0]));
                this.myProgressIndicator.setText2(file.getPresentableUrl());
            }
            if ((status = this.myFileStatusManager.getStatus(file)) != FileStatus.NOT_CHANGED) {
                result.add(file);
                if (result.size() > 1) {
                    return result;
                }
            }
            result.addAll(this.collectModifiedFiles(file.getChildren()));
        }
        return result;
    }
}

