/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.connection;

import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class StatisticsCachingSupplier<T>
implements Supplier<T> {
    private final long myTimeoutMs;
    @NotNull
    private final Supplier<? extends T> myValueSupplier;
    private long myLastCalcTime;
    private T myCache;

    public StatisticsCachingSupplier(@NotNull Supplier<? extends T> valueSupplier, long timeoutMs) {
        if (valueSupplier == null) {
            StatisticsCachingSupplier.$$$reportNull$$$0(0);
        }
        this.myTimeoutMs = timeoutMs;
        this.myValueSupplier = valueSupplier;
    }

    @Override
    public synchronized T get() {
        if (this.hasUpToDateValue()) {
            return this.myCache;
        }
        this.myCache = this.myValueSupplier.get();
        this.myLastCalcTime = System.currentTimeMillis();
        return this.myCache;
    }

    private synchronized boolean hasUpToDateValue() {
        return this.myTimeoutMs > System.currentTimeMillis() - this.myLastCalcTime;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueSupplier", "com/intellij/internal/statistic/eventLog/connection/StatisticsCachingSupplier", "<init>"));
    }
}

