/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.rules.impl;

import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.extensions.ExtensionPointName;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B)\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000b\u001a\u00020\bH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0014R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lcom/intellij/internal/statistic/eventLog/validator/rules/impl/ExtensionIdValidationRule;", "T", "", "Lcom/intellij/internal/statistic/eventLog/validator/rules/impl/CustomValidationRule;", "epName", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "idGetter", "Lkotlin/Function1;", "", "<init>", "(Lcom/intellij/openapi/extensions/ExtensionPointName;Lkotlin/jvm/functions/Function1;)V", "getRuleId", "extensions", "", "getExtensions", "()Ljava/lang/Iterable;", "doValidate", "Lcom/intellij/internal/statistic/eventLog/validator/ValidationResultType;", "data", "context", "Lcom/intellij/internal/statistic/eventLog/validator/rules/EventContext;", "intellij.platform.statistics"})
@SourceDebugExtension(value={"SMAP\nExtensionIdValidationRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtensionIdValidationRule.kt\ncom/intellij/internal/statistic/eventLog/validator/rules/impl/ExtensionIdValidationRule\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,25:1\n1#2:26\n*E\n"})
public class ExtensionIdValidationRule<T>
extends CustomValidationRule {
    @NotNull
    private final ExtensionPointName<T> epName;
    @NotNull
    private final Function1<T, String> idGetter;

    public ExtensionIdValidationRule(@NotNull ExtensionPointName<T> epName, @NotNull Function1<? super T, String> idGetter) {
        Intrinsics.checkNotNullParameter(epName, (String)"epName");
        Intrinsics.checkNotNullParameter(idGetter, (String)"idGetter");
        this.epName = epName;
        this.idGetter = idGetter;
    }

    @Override
    @NotNull
    public String getRuleId() {
        return "extension." + this.epName.getName();
    }

    @NotNull
    protected Iterable<T> getExtensions() {
        return this.epName.getExtensionList();
    }

    @NotNull
    protected ValidationResultType doValidate(@NotNull String data, @NotNull EventContext context) {
        Object object;
        block2: {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Iterable<T> iterable = this.getExtensions();
            Iterator<T> iterator = iterable.iterator();
            while (iterator.hasNext()) {
                T t;
                T it = t = iterator.next();
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)this.idGetter.invoke(it), (Object)data)) continue;
                object = t;
                break block2;
            }
            object = null;
        }
        if (object == null) {
            return ValidationResultType.REJECTED;
        }
        Object extension = object;
        PluginInfo info = PluginInfoDetectorKt.getPluginInfo(extension.getClass());
        return info.isSafeToReport() ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
    }
}

