/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.containers.PeekableIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public final class FilteringIterator<Dom, E extends Dom>
implements PeekableIterator<E> {
    private final Iterator<? extends Dom> delegate;
    private final Predicate<? super Dom> condition;
    private boolean isNextObtained;
    private boolean isCurrentIsValid;
    private Dom current;
    private Boolean currentPassedFilter;

    @Deprecated
    public FilteringIterator(@NotNull Iterator<? extends Dom> delegate, @NotNull Condition<? super Dom> condition) {
        if (delegate == null) {
            FilteringIterator.$$$reportNull$$$0(0);
        }
        if (condition == null) {
            FilteringIterator.$$$reportNull$$$0(1);
        }
        this.delegate = delegate;
        this.condition = condition;
    }

    private FilteringIterator(@NotNull Predicate<? super Dom> condition, @NotNull Iterator<? extends Dom> delegate) {
        if (condition == null) {
            FilteringIterator.$$$reportNull$$$0(2);
        }
        if (delegate == null) {
            FilteringIterator.$$$reportNull$$$0(3);
        }
        this.delegate = delegate;
        this.condition = condition;
    }

    private void obtainNext() {
        if (this.isNextObtained) {
            return;
        }
        boolean hasNext = this.delegate.hasNext();
        this.setCurrent(hasNext ? (Dom)this.delegate.next() : null);
        this.isCurrentIsValid = hasNext;
        this.isNextObtained = true;
    }

    @Override
    public boolean hasNext() {
        this.obtainNext();
        if (!this.isCurrentIsValid) {
            return false;
        }
        boolean value = this.isCurrentPassesFilter();
        while (!value && this.delegate.hasNext()) {
            Dom next = this.delegate.next();
            this.setCurrent(next);
            value = this.isCurrentPassesFilter();
        }
        return value;
    }

    private void setCurrent(Dom next) {
        this.current = next;
        this.currentPassedFilter = null;
    }

    private boolean isCurrentPassesFilter() {
        if (this.currentPassedFilter != null) {
            return this.currentPassedFilter;
        }
        boolean passed = this.condition.test(this.current);
        this.currentPassedFilter = passed;
        return passed;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Dom result = this.current;
        this.isNextObtained = false;
        return (E)result;
    }

    @Override
    public void remove() {
        if (this.isNextObtained) {
            throw new IllegalStateException();
        }
        this.delegate.remove();
    }

    @Override
    public E peek() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return (E)this.current;
    }

    public static <T> Iterator<T> skipNulls(@NotNull Iterator<? extends T> iterator2) {
        if (iterator2 == null) {
            FilteringIterator.$$$reportNull$$$0(4);
        }
        return FilteringIterator.create(iterator2, Objects::nonNull);
    }

    public static <T> Iterator<T> create(@NotNull Iterator<? extends T> iterator2, @NotNull Predicate<? super T> condition) {
        if (iterator2 == null) {
            FilteringIterator.$$$reportNull$$$0(5);
        }
        if (condition == null) {
            FilteringIterator.$$$reportNull$$$0(6);
        }
        if (condition == Conditions.alwaysTrue()) {
            return iterator2;
        }
        return new FilteringIterator(condition, iterator2);
    }

    public static <T> InstanceOf<T> instanceOf(Class<T> aClass) {
        return new InstanceOf<T>(aClass);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/containers/FilteringIterator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "skipNulls";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class InstanceOf<T>
    implements Condition<Object> {
        private final Class<T> myInstancesClass;

        public InstanceOf(@NotNull Class<T> instancesClass) {
            if (instancesClass == null) {
                InstanceOf.$$$reportNull$$$0(0);
            }
            this.myInstancesClass = instancesClass;
        }

        @Override
        public boolean value(Object object) {
            return this.myInstancesClass.isInstance(object);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instancesClass", "com/intellij/util/containers/FilteringIterator$InstanceOf", "<init>"));
        }
    }
}

