/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.tokenizer;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.spellchecker.inspections.SpellCheckingInspection;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/spellchecker/tokenizer/PlainTextSpellcheckingStrategy;", "Lcom/intellij/spellchecker/tokenizer/SpellcheckingStrategy;", "<init>", "()V", "getTokenizer", "Lcom/intellij/spellchecker/tokenizer/Tokenizer;", "element", "Lcom/intellij/psi/PsiElement;", "scope", "", "Lcom/intellij/spellchecker/inspections/SpellCheckingInspection$SpellCheckingScope;", "useTextLevelSpellchecking", "", "intellij.spellchecker"})
public final class PlainTextSpellcheckingStrategy
extends SpellcheckingStrategy {
    @NotNull
    public Tokenizer<?> getTokenizer(@NotNull PsiElement element, @NotNull Set<? extends SpellCheckingInspection.SpellCheckingScope> scope) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(scope, (String)"scope");
        String string = element.getContainingFile().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (StringsKt.endsWith$default((String)string, (String)".sha1", (boolean)false, (int)2, null)) {
            Tokenizer tokenizer = SpellcheckingStrategy.EMPTY_TOKENIZER;
            Intrinsics.checkNotNullExpressionValue((Object)tokenizer, (String)"EMPTY_TOKENIZER");
            return tokenizer;
        }
        Tokenizer tokenizer = super.getTokenizer(element, scope);
        Intrinsics.checkNotNullExpressionValue((Object)tokenizer, (String)"getTokenizer(...)");
        return tokenizer;
    }

    @Override
    public boolean useTextLevelSpellchecking() {
        return Registry.Companion.is("spellchecker.grazie.enabled", false);
    }
}

