/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.composeFile;

import com.intellij.docker.DockerCloudType;
import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.composeFile.ComposeFileUtil;
import com.intellij.docker.composeFile.dsl.Markers;
import com.intellij.docker.composeFile.model.ComposeMetaTypeProvider;
import com.intellij.docker.deployment.DockerRunConfigurationProducerBase;
import com.intellij.docker.deploymentSource.DockerComposeDeploymentSourceType;
import com.intellij.docker.deploymentSource.DockerSingletonDeploymentSourceType;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.remoteServer.configuration.deployment.DeploymentSourceType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeProvider;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;

final class ComposeFileRunConfigurationProducer
extends DockerRunConfigurationProducerBase {
    ComposeFileRunConfigurationProducer() {
    }

    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        ConfigurationFactory configurationFactory = DockerCloudType.getRunConfigurationType().getFactoryForType((DeploymentSourceType)DockerComposeDeploymentSourceType.getInstance());
        if (configurationFactory == null) {
            ComposeFileRunConfigurationProducer.$$$reportNull$$$0(0);
        }
        return configurationFactory;
    }

    @Nullable
    protected DockerSingletonDeploymentSourceType getDeploymentSourceType(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            ComposeFileRunConfigurationProducer.$$$reportNull$$$0(1);
        }
        return ComposeFileRunConfigurationProducer.isComposeFile(psiFile) ? DockerComposeDeploymentSourceType.getInstance() : null;
    }

    protected void customizeConfiguration(@NotNull DockerDeploymentConfiguration configuration, @NotNull PsiElement psi, @NotNull PsiFile contextFile) {
        if (configuration == null) {
            ComposeFileRunConfigurationProducer.$$$reportNull$$$0(2);
        }
        if (psi == null) {
            ComposeFileRunConfigurationProducer.$$$reportNull$$$0(3);
        }
        if (contextFile == null) {
            ComposeFileRunConfigurationProducer.$$$reportNull$$$0(4);
        }
        configuration.getServices().clear();
        String serviceName = ComposeFileRunConfigurationProducer.findComposeServiceName(psi);
        if (serviceName != null) {
            configuration.getServices().add(serviceName);
        }
    }

    protected boolean isConfigurationFromContext(@NotNull DockerDeploymentConfiguration configuration, @NotNull PsiElement contextPsi, @NotNull PsiFile contextFile) {
        if (configuration == null) {
            ComposeFileRunConfigurationProducer.$$$reportNull$$$0(5);
        }
        if (contextPsi == null) {
            ComposeFileRunConfigurationProducer.$$$reportNull$$$0(6);
        }
        if (contextFile == null) {
            ComposeFileRunConfigurationProducer.$$$reportNull$$$0(7);
        }
        return super.isConfigurationFromContext(configuration, contextPsi, contextFile) && ComposeFileRunConfigurationProducer.isForTheSameService(configuration, contextPsi);
    }

    private static boolean isForTheSameService(DockerDeploymentConfiguration configuration, PsiElement psi) {
        String expectedService = ComposeFileRunConfigurationProducer.findComposeServiceName(psi);
        List actualServices = configuration.getServices();
        return expectedService == null ? actualServices.isEmpty() : actualServices.size() == 1 && actualServices.contains(expectedService);
    }

    private static String findComposeServiceName(@NotNull PsiElement contextPsi) {
        if (contextPsi == null) {
            ComposeFileRunConfigurationProducer.$$$reportNull$$$0(8);
        }
        YAMLKeyValue keyValue = ComposeFileRunConfigurationProducer.getParentKeyValueOrSelf(contextPsi);
        while (keyValue != null) {
            YamlMetaTypeProvider.MetaTypeProxy type = ComposeMetaTypeProvider.getInstance().getKeyValueMetaType(keyValue);
            if (type != null && type.getMetaType() instanceof Markers.SingleComposeService) {
                return keyValue.getKeyText();
            }
            keyValue = ComposeFileRunConfigurationProducer.getParentKeyValue((PsiElement)keyValue);
        }
        return null;
    }

    private static boolean isComposeFile(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            ComposeFileRunConfigurationProducer.$$$reportNull$$$0(9);
        }
        return psiFile instanceof YAMLFile && ComposeFileUtil.isDockerComposeYamlFile((YAMLFile)psiFile);
    }

    @Nullable
    private static YAMLKeyValue getParentKeyValueOrSelf(PsiElement psi) {
        return (YAMLKeyValue)PsiTreeUtil.getParentOfType((PsiElement)psi, YAMLKeyValue.class, (boolean)false);
    }

    @Nullable
    private static YAMLKeyValue getParentKeyValue(PsiElement psi) {
        return (YAMLKeyValue)PsiTreeUtil.getParentOfType((PsiElement)psi, YAMLKeyValue.class, (boolean)true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/composeFile/ComposeFileRunConfigurationProducer";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextPsi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFactory";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/composeFile/ComposeFileRunConfigurationProducer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDeploymentSourceType";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "customizeConfiguration";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationFromContext";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findComposeServiceName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isComposeFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9 -> new IllegalArgumentException(string);
        };
    }
}

