/*
 * Decompiled with CFR 0.152.
 */
package circlet.platform.metrics.product;

import circlet.platform.api.ClientBrowser;
import circlet.platform.api.ClientDeviceType;
import circlet.platform.api.ClientIDE;
import circlet.platform.api.ClientInfo;
import circlet.platform.api.ClientOS;
import circlet.platform.metrics.product.ClientInfoKt$special$;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import libraries.klogging.KLogger;
import libraries.klogging.KLoggers;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0000\u001a\u001e\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\u00072\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0007H\u0002\u001a\u001e\u0010\n\u001a\u00020\u000b*\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000f0\u000e\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"CLIENT_VERSION_REGEX", "Lkotlin/text/Regex;", "CLIENT_BROWSER_VERSION_REGEX", "CLIENT_IDE_VERSION_REGEX", "logger", "Llibraries/klogging/KLogger;", "trimVersion", "", "regex", "name", "writeTo", "", "Lcirclet/platform/api/ClientInfo;", "props", "", "", "platform-product-metrics-core"})
@SourceDebugExtension(value={"SMAP\nClientInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientInfo.kt\ncirclet/platform/metrics/product/ClientInfoKt\n+ 2 KLogger.kt\nlibraries/klogging/KLogger\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 KLoggersJvm.kt\nlibraries/klogging/KLoggersJvmKt\n*L\n1#1,32:1\n35#2,5:33\n1#3:38\n7#4:39\n*S KotlinDebug\n*F\n+ 1 ClientInfo.kt\ncirclet/platform/metrics/product/ClientInfoKt\n*L\n15#1:33,5\n10#1:39\n*E\n"})
public final class ClientInfoKt {
    @NotNull
    private static final Regex CLIENT_VERSION_REGEX = new Regex("^\\d{4}(?:.\\d{1,2}){1,2}(?:\\sEAP)?");
    @NotNull
    private static final Regex CLIENT_BROWSER_VERSION_REGEX = new Regex("^\\d+(?:.\\d+){1,2}");
    @NotNull
    private static final Regex CLIENT_IDE_VERSION_REGEX = new Regex("^\\d{4}(?:.\\d{1,2}){1,2}");
    @NotNull
    private static final KLogger logger;

    private static final String trimVersion(String $this$trimVersion, Regex regex, String name) {
        String res;
        MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)$this$trimVersion, (int)0, (int)2, null);
        String string = matchResult != null && (matchResult = matchResult.getGroups()) != null && (matchResult = matchResult.get(0)) != null ? matchResult.getValue() : (res = null);
        if (res == null) {
            KLogger this_$iv = logger;
            boolean $i$f$error = false;
            if (this_$iv.isErrorEnabled()) {
                boolean bl = false;
                String msgStr$iv = name + " " + $this$trimVersion + " doesn't match regular expression " + regex.getPattern();
                this_$iv.error(msgStr$iv);
            }
            return null;
        }
        return res;
    }

    public static final void writeTo(@NotNull ClientInfo $this$writeTo, @NotNull Map<String, Object> props) {
        block7: {
            String string;
            String string2;
            Object it;
            Intrinsics.checkNotNullParameter((Object)$this$writeTo, (String)"<this>");
            Intrinsics.checkNotNullParameter(props, (String)"props");
            String string3 = $this$writeTo.getVersion();
            if (string3 != null && (string3 = ClientInfoKt.trimVersion(string3, CLIENT_VERSION_REGEX, "Client version")) != null) {
                String it2 = string3;
                boolean bl = false;
                props.put("clientVersion", it2);
            }
            ClientOS clientOS = $this$writeTo.getOs();
            if (clientOS != null) {
                it = clientOS;
                boolean bl = false;
                props.put("clientOS", ((Enum)it).toString());
            }
            String string4 = $this$writeTo.getOsVersion();
            if (string4 != null) {
                it = string4;
                boolean bl = false;
                props.put("clientOSVersion", it);
            }
            ClientBrowser clientBrowser = $this$writeTo.getBrowser();
            if (clientBrowser != null) {
                it = clientBrowser;
                boolean bl = false;
                props.put("clientBrowser", ((Enum)it).toString());
            }
            if ((string2 = $this$writeTo.getBrowserVersion()) != null && (string2 = ClientInfoKt.trimVersion(string2, CLIENT_BROWSER_VERSION_REGEX, "Browser version")) != null) {
                String it3 = string2;
                boolean bl = false;
                props.put("clientBrowserVersion", it3);
            }
            ClientIDE clientIDE = $this$writeTo.getIde();
            if (clientIDE != null) {
                it = clientIDE;
                boolean bl = false;
                props.put("clientIDE", ((Enum)it).toString());
            }
            if ((string = $this$writeTo.getIdeVersion()) != null && (string = ClientInfoKt.trimVersion(string, CLIENT_IDE_VERSION_REGEX, "IDE version")) != null) {
                String it4 = string;
                boolean bl = false;
                props.put("clientIDEVersion", it4);
            }
            ClientDeviceType clientDeviceType = $this$writeTo.getDeviceType();
            if (clientDeviceType == null) break block7;
            it = clientDeviceType;
            boolean bl = false;
            props.put("clientDeviceType", ((Enum)it).toString());
        }
    }

    static {
        KLoggers $this$logger$iv = KLoggers.INSTANCE;
        boolean $i$f$logger = false;
        logger = $this$logger$iv.logger((Function0<String>)((Function0)special$$inlined$logger$1.INSTANCE));
    }
}

