/*
 * Decompiled with CFR 0.152.
 */
package libraries.io;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.RoundingMode;
import java.nio.channels.Channel;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import libraries.io.CheckedInputStream;
import libraries.io.CheckedOutputStream;
import libraries.io.CountingStream;
import libraries.io.DataSizeKt;
import libraries.io.DirectoryInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u001c\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001bJ\u000e\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u0018J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0018H\u0007J\u000e\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\u000eJ\"\u0010#\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020%2\b\b\u0002\u0010&\u001a\u00020%2\b\b\u0002\u0010'\u001a\u00020\u001fJ\"\u0010#\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\t2\b\b\u0002\u0010&\u001a\u00020%2\b\b\u0002\u0010'\u001a\u00020\u001fJ\u0012\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020\u0018H\u0007J1\u0010+\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u00182\u0006\u0010,\u001a\u00020-2\u0012\u0010.\u001a\n\u0012\u0006\b\u0001\u0012\u0002000/\"\u000200H\u0007\u00a2\u0006\u0002\u00101J\u0016\u00102\u001a\u00020\u00142\u0006\u00103\u001a\u00020\u00182\u0006\u00104\u001a\u00020\u0018J\u0016\u00105\u001a\u00020\u00142\u0006\u00103\u001a\u00020\u00182\u0006\u00104\u001a\u00020\u0018J\u001f\u00106\u001a\u00020\u00142\u0012\u00107\u001a\n\u0012\u0006\b\u0001\u0012\u0002080/\"\u000208\u00a2\u0006\u0002\u00109J\u0018\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020;2\b\b\u0002\u0010=\u001a\u00020>J\u0006\u0010?\u001a\u00020@J\u0006\u0010A\u001a\u00020BR\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Llibraries/io/FileUtil;", "", "<init>", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "KB", "", "MB", "GB", "TB", "B_POSTFIX", "", "KB_POSTFIX", "MB_POSTFIX", "GB_POSTFIX", "TB_POSTFIX", "close", "", "c", "Ljava/io/Closeable;", "child", "Ljava/io/File;", "root", "parts", "", "mkdirs", "path", "delete", "", "file", "parseFileSize", "fileSizeStr", "formatFileSize", "fileSize", "", "maxFractionDigits", "withWhitespace", "directorySize", "Llibraries/io/DirectoryInfo;", "repositoryPath", "writeAndFlush", "data", "", "options", "", "Ljava/nio/file/OpenOption;", "(Ljava/io/File;[B[Ljava/nio/file/OpenOption;)V", "move", "from", "to", "copy", "flushAndCatch", "streams", "Ljava/io/OutputStream;", "([Ljava/io/OutputStream;)V", "countingStream", "Ljava/io/InputStream;", "stream", "counter", "Ljava/util/concurrent/atomic/AtomicLong;", "nullOutputStream", "Llibraries/io/CheckedOutputStream;", "nullInputStream", "Llibraries/io/CheckedInputStream;", "libraries-io"})
@SourceDebugExtension(value={"SMAP\nFileUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileUtil.kt\nlibraries/io/FileUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,285:1\n1797#2,3:286\n37#3,2:289\n13346#4,2:291\n*S KotlinDebug\n*F\n+ 1 FileUtil.kt\nlibraries/io/FileUtil\n*L\n45#1:286,3\n186#1:289,2\n140#1:291,2\n*E\n"})
public final class FileUtil {
    @NotNull
    public static final FileUtil INSTANCE = new FileUtil();
    private static final Logger LOG = LoggerFactory.getLogger(FileUtil.class);
    public static final long KB = 1000L;
    public static final long MB = 1000000L;
    public static final long GB = 1000000000L;
    public static final long TB = 1000000000000L;
    @NotNull
    public static final String B_POSTFIX = "B";
    @NotNull
    public static final String KB_POSTFIX = "KB";
    @NotNull
    public static final String MB_POSTFIX = "MB";
    @NotNull
    public static final String GB_POSTFIX = "GB";
    @NotNull
    public static final String TB_POSTFIX = "TB";

    private FileUtil() {
    }

    public final void close(@Nullable Closeable c) {
        try {
            Closeable closeable = c;
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final File child(@NotNull File root, @NotNull List<String> parts) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(parts, (String)"parts");
        Iterable $this$fold$iv = parts;
        boolean $i$f$fold = false;
        File accumulator$iv = root;
        for (Object element$iv : $this$fold$iv) {
            void b;
            String string = (String)element$iv;
            File a = accumulator$iv;
            boolean bl = false;
            accumulator$iv = new File(a, (String)b);
        }
        return accumulator$iv;
    }

    public final void mkdirs(@NotNull File path) throws IOException {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        path.mkdirs();
        if (!path.isDirectory()) {
            if (path.isFile()) {
                throw new IOException("Failed to create directory (target is a file) at " + path);
            }
            throw new IOException("Failed to create directory at " + path);
        }
    }

    @JvmStatic
    public static final boolean delete(@NotNull File file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Object[] files2 = file2.listFiles();
        if (files2 != null) {
            Iterator iterator2 = ArrayIteratorKt.iterator((Object[])files2);
            while (iterator2.hasNext()) {
                File child = (File)iterator2.next();
                Intrinsics.checkNotNull((Object)child);
                if (FileUtil.delete(child)) continue;
                return false;
            }
        }
        for (int i = 0; i < 10; ++i) {
            if (file2.delete() || !file2.exists()) {
                return true;
            }
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return false;
    }

    public final long parseFileSize(@NotNull String fileSizeStr) throws NumberFormatException {
        Intrinsics.checkNotNullParameter((Object)fileSizeStr, (String)"fileSizeStr");
        return DataSizeKt.parseDataSize(fileSizeStr);
    }

    @NotNull
    public final String formatFileSize(int fileSize, int maxFractionDigits, boolean withWhitespace) {
        return this.formatFileSize((long)fileSize, maxFractionDigits, withWhitespace);
    }

    public static /* synthetic */ String formatFileSize$default(FileUtil fileUtil, int n, int n2, boolean bl, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 2;
        }
        if ((n3 & 4) != 0) {
            bl = false;
        }
        return fileUtil.formatFileSize(n, n2, bl);
    }

    @NotNull
    public final String formatFileSize(long fileSize, int maxFractionDigits, boolean withWhitespace) {
        String whitespace;
        DecimalFormat f = new DecimalFormat();
        DecimalFormatSymbols custom = new DecimalFormatSymbols();
        custom.setDecimalSeparator('.');
        f.setDecimalFormatSymbols(custom);
        f.setRoundingMode(RoundingMode.FLOOR);
        f.setMaximumFractionDigits(maxFractionDigits);
        String string = whitespace = withWhitespace ? " " : "";
        if (fileSize >= 1000000000000L) {
            return f.format((double)fileSize / (double)1000000000000L) + whitespace + TB_POSTFIX;
        }
        if (fileSize >= 1000000000L) {
            return f.format((double)fileSize / (double)1000000000L) + whitespace + GB_POSTFIX;
        }
        if (fileSize >= 1000000L) {
            return f.format((double)fileSize / (double)1000000L) + whitespace + MB_POSTFIX;
        }
        return fileSize >= 1000L ? f.format((double)fileSize / (double)1000L) + whitespace + KB_POSTFIX : fileSize + whitespace + B_POSTFIX;
    }

    public static /* synthetic */ String formatFileSize$default(FileUtil fileUtil, long l, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 2;
        }
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return fileUtil.formatFileSize(l, n, bl);
    }

    @JvmStatic
    @Nullable
    public static final DirectoryInfo directorySize(@NotNull File repositoryPath) {
        Intrinsics.checkNotNullParameter((Object)repositoryPath, (String)"repositoryPath");
        if (repositoryPath.isFile()) {
            return new DirectoryInfo(Math.max(0L, repositoryPath.length()), 1);
        }
        if (!repositoryPath.isDirectory()) {
            return null;
        }
        try {
            AtomicLong size = new AtomicLong(0L);
            AtomicInteger files2 = new AtomicInteger(0);
            FileUtil.directorySize$visit(files2, size, repositoryPath);
            return new DirectoryInfo(size.get(), files2.get());
        }
        catch (Throwable e) {
            LOG.warn("Failed to list files. " + e.getMessage(), e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final void writeAndFlush(@NotNull File file2, @NotNull byte[] data2, OpenOption ... options) throws IOException {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        File parent = file2.getParentFile();
        if (parent != null) {
            INSTANCE.mkdirs(parent);
        }
        HashSet<StandardOpenOption> effectiveOptions = new HashSet<StandardOpenOption>();
        if (options.length == 0) {
            effectiveOptions.add(StandardOpenOption.WRITE);
            effectiveOptions.add(StandardOpenOption.CREATE);
            bl = effectiveOptions.add(StandardOpenOption.TRUNCATE_EXISTING);
        } else {
            bl = CollectionsKt.addAll((Collection)effectiveOptions, (Object[])options);
        }
        effectiveOptions.add(StandardOpenOption.SYNC);
        Collection $this$toTypedArray$iv = effectiveOptions;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Object object = thisCollection$iv.toArray(new OpenOption[0]);
        object = Files.newOutputStream(file2.toPath(), Arrays.copyOf(object, ((OpenOption[])object).length));
        Throwable throwable = null;
        try {
            OutputStream out = (OutputStream)object;
            boolean bl2 = false;
            out.write(data2);
            out.flush();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    public final void move(@NotNull File from, @NotNull File to) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE, LinkOption.NOFOLLOW_LINKS};
        Files.move(from.toPath(), to.toPath(), copyOptionArray);
    }

    public final void copy(@NotNull File from, @NotNull File to) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING, LinkOption.NOFOLLOW_LINKS};
        Files.copy(from.toPath(), to.toPath(), copyOptionArray);
    }

    public final void flushAndCatch(OutputStream ... streams) {
        Intrinsics.checkNotNullParameter((Object)streams, (String)"streams");
        for (OutputStream stream : streams) {
            if (stream instanceof Channel && !((Channel)((Object)stream)).isOpen()) continue;
            try {
                stream.flush();
            }
            catch (Throwable t) {
                LOG.info("Failed to flush stream. " + t.getMessage(), t);
            }
        }
    }

    @NotNull
    public final InputStream countingStream(@NotNull InputStream stream, @NotNull AtomicLong counter) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Intrinsics.checkNotNullParameter((Object)counter, (String)"counter");
        return (InputStream)((Object)new CountingStream(stream, counter){
            final /* synthetic */ InputStream $stream;
            final /* synthetic */ AtomicLong $counter;
            {
                this.$stream = $stream;
                this.$counter = $counter;
            }

            public int read() throws IOException {
                int read2 = this.$stream.read();
                if (read2 >= 0) {
                    this.$counter.addAndGet(1L);
                }
                return read2;
            }

            public int read(byte[] b, int off2, int len) throws IOException {
                Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                int read2 = this.$stream.read(b, off2, len);
                if (read2 >= 0) {
                    this.$counter.addAndGet(read2);
                }
                return read2;
            }

            public void close() throws IOException {
                this.$stream.close();
            }

            public int available() throws IOException {
                return this.$stream.available();
            }

            public long skip(long n) throws IOException {
                long skip2 = this.$stream.skip(n);
                if (skip2 >= 0L) {
                    this.$counter.addAndGet(skip2);
                }
                return skip2;
            }

            public long getTransferredBytes() {
                return this.$counter.get();
            }
        });
    }

    public static /* synthetic */ InputStream countingStream$default(FileUtil fileUtil, InputStream inputStream, AtomicLong atomicLong, int n, Object object) {
        if ((n & 2) != 0) {
            atomicLong = new AtomicLong(0L);
        }
        return fileUtil.countingStream(inputStream, atomicLong);
    }

    @NotNull
    public final CheckedOutputStream nullOutputStream() {
        return new CheckedOutputStream(){
            private final boolean isOpen;
            private final long transferredBytes;
            {
                this.isOpen = true;
            }

            public void write(int b) {
            }

            public void write(byte[] b, int off2, int len) {
                Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            }

            public boolean isOpen() {
                return this.isOpen;
            }

            public long getTransferredBytes() {
                return this.transferredBytes;
            }
        };
    }

    @NotNull
    public final CheckedInputStream nullInputStream() {
        return new CheckedInputStream(){
            private final boolean isOpen;
            private final long transferredBytes;
            {
                this.isOpen = true;
            }

            public int read() {
                return -1;
            }

            public boolean isOpen() {
                return this.isOpen;
            }

            public long getTransferredBytes() {
                return this.transferredBytes;
            }
        };
    }

    private static final void directorySize$visit(AtomicInteger files2, AtomicLong size, File root) {
        block2: {
            File[] fileArray = root.listFiles();
            if (fileArray == null) break block2;
            File[] $this$forEach$iv = fileArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File child = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                if (child.isFile()) {
                    files2.incrementAndGet();
                    size.addAndGet(Files.size(child.toPath()));
                    continue;
                }
                if (!child.isDirectory()) continue;
                Intrinsics.checkNotNull((Object)child);
                FileUtil.directorySize$visit(files2, size, child);
            }
        }
    }
}

