/*
 * Decompiled with CFR 0.152.
 */
package libraries.io.channels;

import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Llibraries/io/channels/ByteArrayReadableChannel;", "Ljava/nio/channels/ReadableByteChannel;", "data", "", "<init>", "([B)V", "getData", "()[B", "position", "", "open", "", "read", "dst", "Ljava/nio/ByteBuffer;", "close", "", "isOpen", "libraries-io"})
public final class ByteArrayReadableChannel
implements ReadableByteChannel {
    @NotNull
    private final byte[] data;
    private int position;
    private boolean open;

    public ByteArrayReadableChannel(@NotNull byte[] data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        this.data = data2;
        this.open = true;
    }

    @NotNull
    public final byte[] getData() {
        return this.data;
    }

    @Override
    public int read(@NotNull ByteBuffer dst) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        int n = Math.min(dst.remaining(), this.data.length - this.position);
        if (n == 0) {
            return -1;
        }
        dst.put(this.data, this.position, n);
        this.position += n;
        return n;
    }

    @Override
    public void close() {
        this.open = false;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }
}

