/*
 * Decompiled with CFR 0.152.
 */
package runtime.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.core.LayoutBase;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import klogging.MDCUtilsKt;
import klogging.PlatformMDCKey;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import libraries.klogging.MDCKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.ScalarsKt;
import runtime.json.JsonBuilderContext;
import runtime.json.JsonDslKt;
import runtime.logging.JsonLogEventsLayoutKt;
import runtime.logging.SuppressedConnectionErrors;
import runtime.logging.SuppressedError;
import runtime.system.JStack;
import runtime.utils.HostKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0015J\u0018\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u0002H\u0014J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\u0002H\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0017\u001a\u00020\u0002H\u0002J\u0010\u0010\"\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\u0002H\u0002J,\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060$*\u00020\u001e2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060$H\u0002J!\u0010-\u001a\u00020\u00192\n\u0010.\u001a\u000600j\u0002`/2\u0006\u00101\u001a\u000202H\u0002\u00a2\u0006\u0002\u00103JK\u00104\u001a\u00020\u00192\u0006\u00105\u001a\u00020\u00062\n\u0010.\u001a\u000600j\u0002`/2\u0006\u00101\u001a\u0002022\f\u00106\u001a\b\u0012\u0004\u0012\u000208072\u0012\u00109\u001a\u000e\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020\u00190:H\u0002\u00a2\u0006\u0002\u0010;R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\b\"\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\b\"\u0004\b\u000f\u0010\fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u001a\u0010+\u001a\b\u0012\u0004\u0012\u00020(0'X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010*\u00a8\u0006<"}, d2={"Lruntime/logging/JsonLogEventsLayout;", "Lch/qos/logback/core/LayoutBase;", "Lch/qos/logback/classic/spi/ILoggingEvent;", "<init>", "()V", "region", "", "getRegion", "()Ljava/lang/String;", "hostName", "getHostName", "setHostName", "(Ljava/lang/String;)V", "app", "getApp", "setApp", "suppressedConnectionErrors", "Lruntime/logging/SuppressedConnectionErrors;", "suppressedErrors", "Ljava/util/HashMap;", "", "Lruntime/logging/SuppressedError;", "doLayout", "event", "addSuppressedConnectionErrors", "", "addSuppressedError", "suppressedError", "customJsonFields", "jsonBuilderContext", "Lruntime/json/JsonBuilderContext;", "isSuppressed", "", "maybeThreadDump", "isOOM", "preProcessMDCMap", "", "initialMDCMap", "mdcKeysAsFields", "", "Llibraries/klogging/MDCKey;", "getMdcKeysAsFields", "()Ljava/util/List;", "mdcKeysToRemove", "getMdcKeysToRemove", "print", "s", "Lkotlin/text/StringBuilder;", "Ljava/lang/StringBuilder;", "th", "Lch/qos/logback/classic/spi/IThrowableProxy;", "(Ljava/lang/StringBuilder;Lch/qos/logback/classic/spi/IThrowableProxy;)V", "printEnclosedStackTrace", "caption", "enclosingTrace", "", "Lch/qos/logback/classic/spi/StackTraceElementProxy;", "used", "Ljava/util/IdentityHashMap;", "(Ljava/lang/String;Ljava/lang/StringBuilder;Lch/qos/logback/classic/spi/IThrowableProxy;[Lch/qos/logback/classic/spi/StackTraceElementProxy;Ljava/util/IdentityHashMap;)V", "platform-runtime"})
@SourceDebugExtension(value={"SMAP\nJsonLogEventsLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonLogEventsLayout.kt\nruntime/logging/JsonLogEventsLayout\n+ 2 jsonDsl.kt\nruntime/json/JsonDslKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 jsonDsl.kt\nruntime/json/JsonBuilderContext\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,339:1\n143#2:340\n277#2,3:341\n281#2,3:345\n1#3:344\n1#3:350\n54#4,2:348\n56#4,2:351\n1755#5,3:353\n1863#5,2:358\n1557#5:360\n1628#5,3:361\n1557#5:364\n1628#5,3:365\n1251#6,2:356\n*S KotlinDebug\n*F\n+ 1 JsonLogEventsLayout.kt\nruntime/logging/JsonLogEventsLayout\n*L\n99#1:340\n99#1:341,3\n99#1:345,3\n99#1:344\n156#1:348,2\n156#1:351,2\n182#1:353,3\n202#1:358,2\n206#1:360\n206#1:361,3\n206#1:364\n206#1:365,3\n199#1:356,2\n*E\n"})
public class JsonLogEventsLayout
extends LayoutBase<ILoggingEvent> {
    @Nullable
    private final String region = HostKt.getApplication_region();
    @Nullable
    private String hostName;
    @Nullable
    private String app;
    @NotNull
    private final SuppressedConnectionErrors suppressedConnectionErrors = new SuppressedConnectionErrors();
    @NotNull
    private final HashMap<String, List<SuppressedError>> suppressedErrors = new HashMap();
    @NotNull
    private final List<MDCKey> mdcKeysAsFields = PlatformMDCKey.Companion.getBase();
    @NotNull
    private final List<MDCKey> mdcKeysToRemove = PlatformMDCKey.Companion.getSensitive();

    @Nullable
    public final String getRegion() {
        return this.region;
    }

    @Nullable
    public final String getHostName() {
        return this.hostName;
    }

    public final void setHostName(@Nullable String string) {
        this.hostName = string;
    }

    @Nullable
    public final String getApp() {
        return this.app;
    }

    public final void setApp(@Nullable String string) {
        this.app = string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String doLayout(@NotNull ILoggingEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        try {
            void $this$doLayout_u24lambda_u240;
            boolean $i$f$jsonObjectText = false;
            ObjectMapper objectMapper = JsonDslKt.getJsonTreeParser();
            Object baseObj$iv$iv = null;
            boolean $i$f$objectNode = false;
            JsonNodeFactory factory$iv$iv = new JsonNodeFactory(false);
            ObjectNode rootNode$iv$iv = factory$iv$iv.objectNode();
            Intrinsics.checkNotNull((Object)rootNode$iv$iv);
            JsonBuilderContext jsonBuilderContext = new JsonBuilderContext(rootNode$iv$iv, factory$iv$iv, JsonDslKt.getJsonTreeParser());
            ObjectMapper objectMapper2 = objectMapper;
            boolean bl = false;
            $this$doLayout_u24lambda_u240.put("@version", 1);
            $this$doLayout_u24lambda_u240.put("@timestamp", JsonLogEventsLayoutKt.dateFormat(event.getTimeStamp()));
            this.customJsonFields((JsonBuilderContext)$this$doLayout_u24lambda_u240, event);
            String string = objectMapper2.writeValueAsString((Object)rootNode$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
            String logstashEvent = string;
            return logstashEvent + "\n";
        }
        catch (Throwable e) {
            StringWriter stackTrace = new StringWriter();
            e.printStackTrace(new PrintWriter((Writer)stackTrace, true));
            return "FAILED TO LAYOUT A LOG EVENT\nEvent: " + event + "\nError: " + e + "\n" + stackTrace;
        }
    }

    public final void addSuppressedConnectionErrors(@NotNull SuppressedConnectionErrors suppressedConnectionErrors) {
        Intrinsics.checkNotNullParameter((Object)suppressedConnectionErrors, (String)"suppressedConnectionErrors");
        this.suppressedConnectionErrors.plusAssign(suppressedConnectionErrors);
    }

    public final void addSuppressedError(@NotNull SuppressedError suppressedError) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)suppressedError, (String)"suppressedError");
            String string = suppressedError.getLoggerName();
            if (string == null) break block2;
            String it = string;
            boolean bl = false;
            List<SuppressedError> list2 = this.suppressedErrors.get(it);
            if (list2 != null) {
                list2.add(suppressedError);
            } else {
                JsonLogEventsLayout $this$addSuppressedError_u24lambda_u242_u24lambda_u241 = this;
                boolean bl2 = false;
                Map map2 = $this$addSuppressedError_u24lambda_u242_u24lambda_u241.suppressedErrors;
                Object object = new SuppressedError[]{suppressedError};
                object = CollectionsKt.mutableListOf((Object[])object);
                map2.put(it, object);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void customJsonFields(@NotNull JsonBuilderContext jsonBuilderContext, @NotNull ILoggingEvent event) {
        JsonBuilderContext jsonBuilderContext2;
        Intrinsics.checkNotNullParameter((Object)jsonBuilderContext, (String)"jsonBuilderContext");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Level level = null;
        level = event.getLevel();
        if (Intrinsics.areEqual((Object)level, (Object)Level.ERROR) && this.isSuppressed(event)) {
            level = Level.WARN;
        }
        String threadDump = this.maybeThreadDump(event);
        JsonBuilderContext $this$customJsonFields_u24lambda_u2410 = jsonBuilderContext2 = jsonBuilderContext;
        boolean bl = false;
        String string = this.hostName;
        if (string == null) {
            string = JsonLogEventsLayoutKt.access$getComputedHostName();
        }
        $this$customJsonFields_u24lambda_u2410.put("source_host", string);
        String string2 = this.region;
        if (string2 != null) {
            String it = string2;
            boolean bl2 = false;
            $this$customJsonFields_u24lambda_u2410.put("region", it);
        }
        JsonLogEventsLayoutKt.putLogAppVersion($this$customJsonFields_u24lambda_u2410);
        $this$customJsonFields_u24lambda_u2410.put("message", event.getFormattedMessage());
        String string3 = this.app;
        if (string3 == null) {
            string3 = "platform";
        }
        $this$customJsonFields_u24lambda_u2410.put("app", string3);
        IThrowableProxy iThrowableProxy = event.getThrowableProxy();
        if (iThrowableProxy != null) {
            StringBuilder stringBuilder;
            String it;
            void this_$iv;
            IThrowableProxy proxy = iThrowableProxy;
            boolean bl3 = false;
            JsonBuilderContext jsonBuilderContext3 = $this$customJsonFields_u24lambda_u2410;
            String $this$put$iv = "exception";
            boolean $i$f$put = false;
            ObjectNode objNode$iv = this_$iv.get__factory().objectNode();
            Intrinsics.checkNotNull((Object)objNode$iv);
            JsonBuilderContext $this$customJsonFields_u24lambda_u2410_u24lambda_u249_u24lambda_u248 = new JsonBuilderContext(objNode$iv, this_$iv.get__factory(), this_$iv.get__mapper());
            boolean bl4 = false;
            String string4 = proxy.getClassName();
            if (string4 != null) {
                it = string4;
                boolean bl5 = false;
                $this$customJsonFields_u24lambda_u2410_u24lambda_u249_u24lambda_u248.put("exception_class", it);
            }
            String string5 = proxy.getMessage();
            if (string5 != null) {
                it = string5;
                boolean bl6 = false;
                $this$customJsonFields_u24lambda_u2410_u24lambda_u249_u24lambda_u248.put("exception_message", it);
            }
            StringBuilder $this$customJsonFields_u24lambda_u2410_u24lambda_u249_u24lambda_u248_u24lambda_u246 = stringBuilder = new StringBuilder();
            boolean bl7 = false;
            this.print($this$customJsonFields_u24lambda_u2410_u24lambda_u249_u24lambda_u248_u24lambda_u246, proxy);
            String string6 = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toString(...)");
            String it2 = string6;
            boolean bl8 = false;
            $this$customJsonFields_u24lambda_u2410_u24lambda_u249_u24lambda_u248.put("stacktrace", it2);
            this_$iv.get__node().set($this$put$iv, (JsonNode)objNode$iv);
        }
        $this$customJsonFields_u24lambda_u2410.put("logger_name", event.getLoggerName());
        Map map2 = event.getMDCPropertyMap();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getMDCPropertyMap(...)");
        $this$customJsonFields_u24lambda_u2410.put("mdc", this.preProcessMDCMap($this$customJsonFields_u24lambda_u2410, map2));
        $this$customJsonFields_u24lambda_u2410.put("level", level.toString());
        $this$customJsonFields_u24lambda_u2410.put("thread_name", event.getThreadName());
        if (threadDump != null) {
            $this$customJsonFields_u24lambda_u2410.put("thread_dump", threadDump);
        }
    }

    private final boolean isSuppressed(ILoggingEvent event) {
        Boolean bl;
        List<SuppressedError> list2 = this.suppressedErrors.get(event.getLoggerName());
        if (list2 != null) {
            boolean bl2;
            block5: {
                Iterable $this$any$iv = list2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        SuppressedError it = (SuppressedError)element$iv;
                        boolean bl3 = false;
                        if (!it.match(event)) continue;
                        bl2 = true;
                        break block5;
                    }
                    bl2 = false;
                }
            }
            bl = bl2;
        } else {
            bl = null;
        }
        return ScalarsKt.orFalse(bl) || this.suppressedConnectionErrors.match(event) || this.isOOM(event);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String maybeThreadDump(ILoggingEvent event) {
        String string;
        if (!this.isOOM(event)) return null;
        String string2 = event.getFormattedMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getFormattedMessage(...)");
        if (!StringsKt.contains$default((CharSequence)string2, (CharSequence)"unable to create native thread", (boolean)false, (int)2, null)) return null;
        try {
            string = JStack.dumpThreads$default(JStack.INSTANCE, null, 1, null);
        }
        catch (Throwable t) {
            return null;
        }
        String string3 = string;
        return string3;
    }

    private final boolean isOOM(ILoggingEvent event) {
        boolean bl;
        block1: {
            Sequence $this$any$iv = JsonLogEventsLayoutKt.access$getAllCauses(event.getThrowableProxy());
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                IThrowableProxy it = (IThrowableProxy)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getClassName(), (Object)"java.lang.OutOfMemoryError")) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final Map<String, String> preProcessMDCMap(JsonBuilderContext $this$preProcessMDCMap, Map<String, String> initialMDCMap) {
        MDCKey it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable $this$forEach$iv = this.getMdcKeysAsFields();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MDCKey it2 = (MDCKey)element$iv;
            boolean bl = false;
            MDCUtilsKt.extractFieldFromMap($this$preProcessMDCMap, initialMDCMap, it2);
        }
        $this$forEach$iv = this.getMdcKeysToRemove();
        Map map2 = initialMDCMap;
        boolean $i$f$map = false;
        Iterator iterator2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            MDCKey mDCKey = (MDCKey)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        $this$map$iv = this.getMdcKeysAsFields();
        map2 = MapsKt.minus(map2, (Iterable)((List)destination$iv$iv));
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (MDCKey)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        return MapsKt.minus((Map)map2, (Iterable)((List)destination$iv$iv));
    }

    @NotNull
    protected List<MDCKey> getMdcKeysAsFields() {
        return this.mdcKeysAsFields;
    }

    @NotNull
    protected List<MDCKey> getMdcKeysToRemove() {
        return this.mdcKeysToRemove;
    }

    private final void print(StringBuilder s, IThrowableProxy th) {
        IdentityHashMap<IThrowableProxy, Unit> used = new IdentityHashMap<IThrowableProxy, Unit>();
        this.printEnclosedStackTrace("", s, th, new StackTraceElementProxy[0], used);
    }

    /*
     * WARNING - void declaration
     */
    private final void printEnclosedStackTrace(String caption, StringBuilder s, IThrowableProxy th, StackTraceElementProxy[] enclosingTrace, IdentityHashMap<IThrowableProxy, Unit> used) {
        block11: {
            Object object;
            String string;
            String string2;
            StringBuilder stringBuilder;
            int framesInCommon;
            int m;
            StackTraceElementProxy[] trace2;
            StringBuilder stringBuilder2;
            block13: {
                block12: {
                    void it;
                    block10: {
                        if (!((Map)used).containsKey(th)) break block10;
                        StringBuilder stringBuilder3 = s.append("\tCIRCULAR: " + th.getClassName());
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
                        StringBuilder stringBuilder4 = stringBuilder3.append('\n');
                        stringBuilder2 = stringBuilder4;
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
                        break block11;
                    }
                    ((Map)used).put(th, Unit.INSTANCE);
                    StackTraceElementProxy[] stackTraceElementProxyArray = th.getStackTraceElementProxyArray();
                    if (stackTraceElementProxyArray == null) {
                        stackTraceElementProxyArray = new StackTraceElementProxy[]{};
                    }
                    trace2 = stackTraceElementProxyArray;
                    m = trace2.length - 1;
                    for (int n = enclosingTrace.length - 1; m >= 0 && n >= 0 && Intrinsics.areEqual((Object)trace2[m], (Object)enclosingTrace[n]); --m, --n) {
                    }
                    framesInCommon = trace2.length - 1 - m;
                    stringBuilder = s;
                    string2 = caption;
                    string = th.getClassName();
                    object = th.getMessage();
                    if (object == null) break block12;
                    String string3 = object;
                    String string4 = string;
                    String string5 = string2;
                    boolean bl = false;
                    String string6 = " " + (String)it;
                    string2 = string5;
                    string = string4;
                    String string7 = string6;
                    object = string7;
                    if (string7 != null) break block13;
                }
                object = "";
            }
            StringBuilder stringBuilder5 = stringBuilder.append(string2 + string + (String)object);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append(...)");
            int i22 = 0;
            int n = m;
            if (i22 <= n) {
                while (true) {
                    StringBuilder stringBuilder6 = s.append("\t" + trace2[i22].getSTEAsString());
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6.append('\n'), (String)"append(...)");
                    if (i22 == n) break;
                    ++i22;
                }
            }
            if (framesInCommon != 0) {
                StringBuilder stringBuilder7 = s.append("\t... " + framesInCommon + " more");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7.append('\n'), (String)"append(...)");
            }
            Iterator i22 = ArrayIteratorKt.iterator((Object[])th.getSuppressed());
            while (i22.hasNext()) {
                IThrowableProxy se = (IThrowableProxy)i22.next();
                Intrinsics.checkNotNull((Object)se);
                this.printEnclosedStackTrace("Suppressed: ", s, se, trace2, used);
            }
            IThrowableProxy cause = th.getCause();
            if (cause != null) {
                this.printEnclosedStackTrace("Caused by: ", s, cause, trace2, used);
            }
            stringBuilder2 = Unit.INSTANCE;
        }
    }
}

