/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.charts.analyser.checkers;

import com.intellij.charts.analyser.checkers.SeriesChecker;
import com.intellij.charts.dataframe.ColumnUtils;
import com.intellij.charts.dataframe.DataFrame;
import com.intellij.charts.dataframe.aggregation.Var;
import com.intellij.charts.dataframe.columns.Column;
import com.intellij.charts.dataframe.columns.ColumnId;
import com.intellij.charts.settings.data.ColumnModifier;
import com.intellij.charts.settings.data.ColumnSettings;
import com.intellij.charts.settings.data.LineSeriesSettings;
import com.intellij.charts.settings.data.SeriesSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\fH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/charts/analyser/checkers/LineSeriesChecker;", "Lcom/intellij/charts/analyser/checkers/SeriesChecker;", "<init>", "()V", "check", "", "Lcom/intellij/charts/settings/data/SeriesSettings;", "dataFrame", "Lcom/intellij/charts/dataframe/DataFrame;", "getStringColumnVariance", "", "column", "Lcom/intellij/charts/dataframe/columns/Column;", "", "intellij.charts"})
@SourceDebugExtension(value={"SMAP\nLineSeriesChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LineSeriesChecker.kt\ncom/intellij/charts/analyser/checkers/LineSeriesChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,74:1\n1080#2:75\n777#2:76\n873#2,2:77\n1080#2:80\n1#3:79\n*S KotlinDebug\n*F\n+ 1 LineSeriesChecker.kt\ncom/intellij/charts/analyser/checkers/LineSeriesChecker\n*L\n32#1:75\n33#1:76\n33#1:77,2\n47#1:80\n*E\n"})
public final class LineSeriesChecker
implements SeriesChecker {
    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<SeriesSettings> check(@NotNull DataFrame dataFrame) {
        Column it;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)dataFrame, (String)"dataFrame");
        if (dataFrame.getColumns().size() < 2) {
            return CollectionsKt.emptyList();
        }
        List<Column<Number>> numericalColumns = SeriesChecker.Companion.getNumericalColumns(dataFrame);
        if (numericalColumns.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$sortedByDescending$iv = numericalColumns;
        boolean $i$f$sortedByDescending = false;
        List numericalColumnsByVariance = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Column it = (Column)b;
                boolean bl = false;
                Comparable comparable = Var.Companion.columnVariance(it);
                it = (Column)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Var.Companion.columnVariance(it));
            }
        });
        Iterable $this$filter$iv = numericalColumnsByVariance;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Column)element$iv$iv;
            boolean bl = false;
            if (!ColumnUtils.Companion.isColumnOrdered(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List orderedNumericalColumns = (List)destination$iv$iv;
        Column possibleXColumn = null;
        Column possibleYColumn = null;
        if (!((Collection)orderedNumericalColumns).isEmpty() && numericalColumnsByVariance.size() > 1) {
            Object v0;
            block10: {
                possibleXColumn = (Column)CollectionsKt.first((List)orderedNumericalColumns);
                Iterable $i$f$filterTo2 = numericalColumnsByVariance;
                for (Object t : $i$f$filterTo2) {
                    it = (Column)t;
                    boolean bl = false;
                    if (!(!Intrinsics.areEqual((Object)it, (Object)possibleXColumn))) continue;
                    v0 = t;
                    break block10;
                }
                v0 = null;
            }
            Column column = v0;
            if (column == null) {
                return CollectionsKt.emptyList();
            }
            possibleYColumn = column;
        } else {
            List<Column<String>> stringColumns = SeriesChecker.Companion.getStringColumns(dataFrame);
            if (stringColumns.isEmpty()) {
                return CollectionsKt.emptyList();
            }
            Iterable $this$sortedByDescending$iv2 = stringColumns;
            boolean $i$f$sortedByDescending2 = false;
            List stringColumnsByVariance = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv2, (Comparator)new Comparator(this){
                final /* synthetic */ LineSeriesChecker this$0;
                {
                    this.this$0 = lineSeriesChecker;
                }

                public final int compare(T a, T b) {
                    Column it = (Column)b;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(LineSeriesChecker.access$getStringColumnVariance(this.this$0, it));
                    it = (Column)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(LineSeriesChecker.access$getStringColumnVariance(this.this$0, it)));
                }
            });
            possibleXColumn = (Column)CollectionsKt.first((List)stringColumnsByVariance);
            possibleYColumn = (Column)CollectionsKt.first((List)numericalColumnsByVariance);
        }
        ColumnId columnId = dataFrame.getColumnId(possibleXColumn);
        if (columnId == null) {
            return CollectionsKt.emptyList();
        }
        ColumnId xColumnId = columnId;
        ColumnId columnId2 = dataFrame.getColumnId(possibleYColumn);
        if (columnId2 == null) {
            return CollectionsKt.emptyList();
        }
        ColumnId yColumnId = columnId2;
        return CollectionsKt.listOf((Object)new LineSeriesSettings(CollectionsKt.listOf((Object)new ColumnSettings(xColumnId, ColumnModifier.GroupAndSort)), null, CollectionsKt.listOf((Object)new ColumnSettings(yColumnId, ColumnModifier.Mean)), false, false, false, 58, null));
    }

    private final int getStringColumnVariance(Column<String> column) {
        if (column.getSize() == 0) {
            return 0;
        }
        HashSet<String> set = new HashSet<String>();
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)column.getSize())), (int)Math.max(1, column.getSize() / 16));
        int i = intProgression.getFirst();
        int n = intProgression.getLast();
        int n2 = intProgression.getStep();
        if (n2 > 0 && i <= n || n2 < 0 && n <= i) {
            while (true) {
                set.add(column.get(i));
                if (i == n) break;
                i += n2;
            }
        }
        return set.size();
    }

    public static final /* synthetic */ int access$getStringColumnVariance(LineSeriesChecker $this, Column column) {
        return $this.getStringColumnVariance(column);
    }
}

