/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.charts.dataframe;

import com.intellij.charts.dataframe.columns.Column;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/intellij/charts/dataframe/ColumnUtils;", "", "<init>", "()V", "Companion", "intellij.charts"})
public final class ColumnUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u00a8\u0006\t"}, d2={"Lcom/intellij/charts/dataframe/ColumnUtils$Companion;", "", "<init>", "()V", "isColumnOrdered", "", "column", "Lcom/intellij/charts/dataframe/columns/Column;", "", "intellij.charts"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isColumnOrdered(@NotNull Column<Number> column) {
            Intrinsics.checkNotNullParameter(column, (String)"column");
            if (column.getSize() < 2) {
                return true;
            }
            int prev = -1;
            Boolean order = null;
            int n = column.getSize();
            for (int i = 0; i < n; ++i) {
                if (column.isNull(i)) continue;
                if (prev == -1) {
                    prev = i;
                    continue;
                }
                Number number = column.get(prev);
                if (number == null) {
                    continue;
                }
                double prevValue = number.doubleValue();
                Number number2 = column.get(i);
                if (number2 == null) {
                    continue;
                }
                double currentValue = number2.doubleValue();
                if (order == null) {
                    order = prevValue <= currentValue;
                } else if (!Intrinsics.areEqual((Object)order, (Object)(prevValue <= currentValue ? 1 : 0))) {
                    return false;
                }
                prev = i;
            }
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

