/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.charts.settings.adapters;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.charts.core.axes.settings.AxesSettings;
import com.intellij.charts.core.series.AreaSeries;
import com.intellij.charts.core.settings.ChartSettings;
import com.intellij.charts.dataframe.columns.ColumnId;
import com.intellij.charts.settings.data.AreaSeriesSettings;
import com.intellij.charts.settings.data.BarSeriesSettings;
import com.intellij.charts.settings.data.BubbleSeriesSettings;
import com.intellij.charts.settings.data.ColumnModifier;
import com.intellij.charts.settings.data.ColumnSettings;
import com.intellij.charts.settings.data.LineSeriesSettings;
import com.intellij.charts.settings.data.PieSeriesSettings;
import com.intellij.charts.settings.data.ScatterSeriesSettings;
import com.intellij.charts.settings.data.SeriesSettings;
import com.intellij.charts.settings.data.type.AreaSeriesType;
import com.intellij.charts.settings.data.type.BarSeriesType;
import com.intellij.charts.settings.data.type.LineSeriesType;
import com.intellij.charts.settings.data.type.PieSeriesType;
import com.intellij.charts.settings.data.type.ScatterSeriesType;
import com.intellij.charts.settings.data.type.SeriesType;
import com.intellij.charts.utils.ChartJsonUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001%B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\tJ\u0014\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000bJ\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J \u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u000bH\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u000bJ\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001d\u001a\u00020\u0006H\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001d\u001a\u00020\u0013H\u0002J\u001e\u0010\u001e\u001a\u00020\u00162\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\u0006\u0010 \u001a\u00020!H\u0002J\u0018\u0010\"\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020!H\u0002J\u0016\u0010#\u001a\u00020!2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\u001bR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/charts/settings/adapters/ChartSettingsZeppelinAdapter;", "", "<init>", "()V", "supportedChartTypes", "", "", "seriesTypeToZeppelinName", "seriesType", "Lcom/intellij/charts/settings/data/type/SeriesType;", "suitableChartSettingsOrNull", "Lcom/google/gson/JsonObject;", "jsonObject", "getZeppelinChartSettings", "resultsObject", "getColumnSettings", "Lcom/intellij/charts/settings/data/ColumnSettings;", "col", "fixedModifier", "Lcom/intellij/charts/settings/data/ColumnModifier;", "getColumnSettingsList", "jsonArray", "Lcom/google/gson/JsonArray;", "getGeneralColumnsSettings", "Lcom/intellij/charts/settings/adapters/ChartSettingsZeppelinAdapter$GeneralColumnsSettings;", "graph", "fromJson", "Lcom/intellij/charts/core/settings/ChartSettings;", "getColumnModifier", "modifier", "getColumnsJsonArray", "columnSettings", "withoutModifier", "", "getColumnJson", "toJson", "chartSettings", "GeneralColumnsSettings", "intellij.charts"})
@SourceDebugExtension(value={"SMAP\nChartSettingsZeppelinAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChartSettingsZeppelinAdapter.kt\ncom/intellij/charts/settings/adapters/ChartSettingsZeppelinAdapter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,354:1\n296#2,2:355\n1915#2,2:357\n1#3:359\n*S KotlinDebug\n*F\n+ 1 ChartSettingsZeppelinAdapter.kt\ncom/intellij/charts/settings/adapters/ChartSettingsZeppelinAdapter\n*L\n105#1:355,2\n205#1:357,2\n*E\n"})
public final class ChartSettingsZeppelinAdapter {
    @NotNull
    public static final ChartSettingsZeppelinAdapter INSTANCE = new ChartSettingsZeppelinAdapter();
    @NotNull
    private static final List<String> supportedChartTypes;

    private ChartSettingsZeppelinAdapter() {
    }

    @Nullable
    public final String seriesTypeToZeppelinName(@NotNull SeriesType seriesType) {
        Intrinsics.checkNotNullParameter((Object)seriesType, (String)"seriesType");
        SeriesType seriesType2 = seriesType;
        return Intrinsics.areEqual((Object)seriesType2, (Object)LineSeriesType.Companion.getInstance()) ? "lineChart" : (Intrinsics.areEqual((Object)seriesType2, (Object)BarSeriesType.Companion.getInstance()) ? "multiBarChart" : (Intrinsics.areEqual((Object)seriesType2, (Object)ScatterSeriesType.Companion.getInstance()) ? "scatterChart" : (Intrinsics.areEqual((Object)seriesType2, (Object)AreaSeriesType.Companion.getInstance()) ? "stackedAreaChart" : (Intrinsics.areEqual((Object)seriesType2, (Object)PieSeriesType.Companion.getInstance()) ? "pieChart" : null))));
    }

    private final JsonObject suitableChartSettingsOrNull(JsonObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        return jsonObject.has("keys") && jsonObject.has("values") && jsonObject.has("mode") ? jsonObject : ChartJsonUtilsKt.getAsJsonObjectOrNull(jsonObject, "graph");
    }

    @Nullable
    public final JsonObject getZeppelinChartSettings(@Nullable JsonObject resultsObject) {
        if (resultsObject == null) {
            return null;
        }
        try {
            JsonObject jsonObject;
            if (resultsObject.isJsonArray()) {
                JsonArray resultsJsonArray = resultsObject.getAsJsonArray();
                if (resultsJsonArray.size() > 0) {
                    JsonElement jsonElement = resultsJsonArray.get(0);
                    Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"get(...)");
                    jsonObject = this.suitableChartSettingsOrNull(ChartJsonUtilsKt.asJsonObjectOrNull(jsonElement));
                } else {
                    jsonObject = null;
                }
            } else if (resultsObject.isJsonObject()) {
                JsonObject jsonObject2 = resultsObject.getAsJsonObject();
                Intrinsics.checkNotNullExpressionValue((Object)jsonObject2, (String)"getAsJsonObject(...)");
                jsonObject = this.suitableChartSettingsOrNull(ChartJsonUtilsKt.getAsJsonObjectOrNull(jsonObject2, "0"));
            } else {
                return null;
            }
            return jsonObject;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private final ColumnSettings getColumnSettings(JsonObject col, ColumnModifier fixedModifier) {
        ColumnModifier columnModifier = fixedModifier;
        if (columnModifier == null) {
            if (!col.has("aggr") || !col.get("aggr").isJsonPrimitive()) {
                columnModifier = ColumnModifier.None;
            } else {
                String string = col.get("aggr").getAsString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAsString(...)");
                columnModifier = this.getColumnModifier(string);
                if (columnModifier == null) {
                    columnModifier = ColumnModifier.None;
                }
            }
        }
        ColumnModifier modifier = columnModifier;
        String string = col.get("name").getAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAsString(...)");
        return new ColumnSettings(new ColumnId(string, col.get("index").getAsInt()), modifier);
    }

    private final List<ColumnSettings> getColumnSettingsList(JsonArray jsonArray, ColumnModifier fixedModifier) {
        List result = new ArrayList();
        int n = jsonArray.size();
        for (int i = 0; i < n; ++i) {
            try {
                JsonObject jsonObject = jsonArray.get(i).getAsJsonObject();
                Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"getAsJsonObject(...)");
                result.add(this.getColumnSettings(jsonObject, fixedModifier));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private final GeneralColumnsSettings getGeneralColumnsSettings(JsonObject graph) {
        JsonArray jsonArray = ChartJsonUtilsKt.getAsJsonArrayOrNull(graph, "keys");
        if (jsonArray == null) {
            return null;
        }
        JsonArray keysArray = jsonArray;
        JsonArray jsonArray2 = ChartJsonUtilsKt.getAsJsonArrayOrNull(graph, "values");
        if (jsonArray2 == null) {
            return null;
        }
        JsonArray valuesArray = jsonArray2;
        JsonArray groupsArray = ChartJsonUtilsKt.getAsJsonArrayOrNull(graph, "groups");
        List<ColumnSettings> xColumnSettings = this.getColumnSettingsList(keysArray, ColumnModifier.GroupAndSort);
        List<ColumnSettings> yColumnSettings = this.getColumnSettingsList(valuesArray, null);
        JsonArray jsonArray3 = groupsArray;
        List<ColumnSettings> groupsSettings = jsonArray3 == null ? CollectionsKt.emptyList() : this.getColumnSettingsList(jsonArray3, ColumnModifier.None);
        return new GeneralColumnsSettings(xColumnSettings, yColumnSettings, groupsSettings);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ChartSettings fromJson(@Nullable JsonObject graph) {
        ChartSettings chartSettings;
        Object object;
        if (graph == null) {
            return null;
        }
        String graphMode = null;
        String string = ChartJsonUtilsKt.getAsStringOrNull(graph, "mode");
        if (string == null) {
            return null;
        }
        graphMode = string;
        if (Intrinsics.areEqual((Object)graphMode, (Object)"table")) {
            Object object2 = ChartJsonUtilsKt.getAsJsonObjectOrNull(graph, "setting");
            if (object2 != null && (object2 = object2.keySet()) != null) {
                Object v2;
                block31: {
                    void $this$firstOrNull$iv;
                    Iterable iterable = (Iterable)object2;
                    object = supportedChartTypes;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        String p0 = (String)element$iv;
                        boolean bl = false;
                        if (!object.contains(p0)) continue;
                        v2 = element$iv;
                        break block31;
                    }
                    v2 = null;
                }
                if ((object2 = (String)v2) != null) {
                    Object it = object2;
                    boolean bl = false;
                    graphMode = it;
                }
            }
        }
        switch (graphMode) {
            case "multiBarChart": {
                GeneralColumnsSettings generalColumnsSettings = this.getGeneralColumnsSettings(graph);
                if (generalColumnsSettings == null) {
                    return null;
                }
                GeneralColumnsSettings columnSettings = generalColumnsSettings;
                JsonObject jsonObject = ChartJsonUtilsKt.getAsJsonObjectOrNull(graph, "setting");
                JsonObject multiBarChartObject = jsonObject != null ? ChartJsonUtilsKt.getAsJsonObjectOrNull(jsonObject, "multiBarChart") : null;
                JsonObject jsonObject2 = multiBarChartObject;
                JsonObject jsonObject3 = multiBarChartObject;
                chartSettings = new ChartSettings(new AxesSettings(false, false, 3, null), CollectionsKt.listOf((Object)new BarSeriesSettings(jsonObject2 != null ? ChartJsonUtilsKt.optBoolean(jsonObject2, "horizontal") : false, jsonObject3 != null ? ChartJsonUtilsKt.optBoolean(jsonObject3, "stacked") : false, columnSettings.getXColumnSettings(), columnSettings.getGroupsSettings(), columnSettings.getYColumnSettings(), false, 32, null)));
                break;
            }
            case "pieChart": {
                GeneralColumnsSettings generalColumnsSettings = this.getGeneralColumnsSettings(graph);
                if (generalColumnsSettings == null) {
                    return null;
                }
                GeneralColumnsSettings columnSettings = generalColumnsSettings;
                JsonObject jsonObject = ChartJsonUtilsKt.getAsJsonObjectOrNull(graph, "setting");
                JsonObject pieSettings = jsonObject != null ? ChartJsonUtilsKt.getAsJsonObjectOrNull(jsonObject, "pieChart") : null;
                JsonObject jsonObject4 = pieSettings;
                chartSettings = new ChartSettings(new AxesSettings(false, false, 3, null), CollectionsKt.listOf((Object)new PieSeriesSettings(columnSettings.getYColumnSettings(), columnSettings.getGroupsSettings(), columnSettings.getXColumnSettings(), jsonObject4 != null ? ChartJsonUtilsKt.optBoolean(jsonObject4, "showPercents") : true, false, 16, null)));
                break;
            }
            case "lineChart": {
                GeneralColumnsSettings generalColumnsSettings = this.getGeneralColumnsSettings(graph);
                if (generalColumnsSettings == null) {
                    return null;
                }
                GeneralColumnsSettings columnSettings = generalColumnsSettings;
                JsonObject jsonObject = ChartJsonUtilsKt.getAsJsonObjectOrNull(graph, "setting");
                JsonObject lineSettings = jsonObject != null ? ChartJsonUtilsKt.getAsJsonObjectOrNull(jsonObject, "lineChart") : null;
                JsonObject jsonObject5 = lineSettings;
                JsonObject jsonObject6 = lineSettings;
                chartSettings = new ChartSettings(new AxesSettings(false, false, 3, null), CollectionsKt.listOf((Object)new LineSeriesSettings(columnSettings.getXColumnSettings(), columnSettings.getGroupsSettings(), columnSettings.getYColumnSettings(), jsonObject5 != null ? ChartJsonUtilsKt.optBoolean(jsonObject5, "stepped") : false, jsonObject6 != null ? ChartJsonUtilsKt.optBoolean(jsonObject6, "showPoints") : false, false, 32, null)));
                break;
            }
            case "scatterChart": {
                List size;
                JsonObject jsonObject = ChartJsonUtilsKt.getAsJsonObjectOrNull(graph, "setting");
                if (jsonObject == null || (jsonObject = ChartJsonUtilsKt.getAsJsonObjectOrNull(jsonObject, "scatterChart")) == null) {
                    return null;
                }
                JsonObject scatterObject = jsonObject;
                JsonObject xAxisJson = ChartJsonUtilsKt.getAsJsonObjectOrNull(scatterObject, "xAxis");
                JsonObject yAxisJson = ChartJsonUtilsKt.getAsJsonObjectOrNull(scatterObject, "yAxis");
                JsonObject groupJson = ChartJsonUtilsKt.getAsJsonObjectOrNull(scatterObject, "group");
                JsonObject sizeJson = ChartJsonUtilsKt.getAsJsonObjectOrNull(scatterObject, "size");
                JsonObject jsonObject7 = xAxisJson;
                List xAxis = jsonObject7 != null ? CollectionsKt.listOf((Object)this.getColumnSettings(jsonObject7, ColumnModifier.GroupAndSort)) : CollectionsKt.emptyList();
                JsonObject jsonObject8 = yAxisJson;
                List yAxis = jsonObject8 != null ? CollectionsKt.listOf((Object)this.getColumnSettings(jsonObject8, null)) : CollectionsKt.emptyList();
                JsonObject jsonObject9 = groupJson;
                List group = jsonObject9 != null ? CollectionsKt.listOf((Object)this.getColumnSettings(jsonObject9, ColumnModifier.None)) : CollectionsKt.emptyList();
                JsonObject jsonObject10 = sizeJson;
                List list = size = jsonObject10 != null ? CollectionsKt.listOf((Object)this.getColumnSettings(jsonObject10, null)) : CollectionsKt.emptyList();
                if (size.isEmpty()) {
                    chartSettings = new ChartSettings(new AxesSettings(false, false, 3, null), CollectionsKt.listOf((Object)new ScatterSeriesSettings(xAxis, group, yAxis, false, 8, null)));
                    break;
                }
                chartSettings = new ChartSettings(new AxesSettings(false, false, 3, null), CollectionsKt.listOf((Object)new BubbleSeriesSettings(xAxis, group, yAxis, size, false, 16, null)));
                break;
            }
            case "stackedAreaChart": {
                JsonElement multiBarChartObject;
                GeneralColumnsSettings generalColumnsSettings = this.getGeneralColumnsSettings(graph);
                if (generalColumnsSettings == null) {
                    return null;
                }
                GeneralColumnsSettings columnSettings = generalColumnsSettings;
                JsonObject jsonObject = ChartJsonUtilsKt.getAsJsonObjectOrNull(graph, "setting");
                JsonElement jsonElement = multiBarChartObject = jsonObject != null && (jsonObject = ChartJsonUtilsKt.getAsJsonObjectOrNull(jsonObject, "stackedAreaChart")) != null ? jsonObject.get("style") : null;
                Object object3 = object = jsonElement != null ? jsonElement.getAsString() : null;
                AreaSeries.Type areaMode = Intrinsics.areEqual((Object)object, (Object)"expand") ? AreaSeries.Type.Expanded : (Intrinsics.areEqual((Object)object, (Object)"stream") ? AreaSeries.Type.Stream : AreaSeries.Type.Stacked);
                chartSettings = new ChartSettings(new AxesSettings(false, false, 3, null), CollectionsKt.listOf((Object)new AreaSeriesSettings(columnSettings.getXColumnSettings(), columnSettings.getGroupsSettings(), columnSettings.getYColumnSettings(), areaMode, false, 16, null)));
                break;
            }
            default: {
                return null;
            }
        }
        return chartSettings;
    }

    /*
     * WARNING - bad return control flow
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final ColumnModifier getColumnModifier(String modifier) {
        ColumnModifier columnModifier;
        block12: {
            block11: {
                block10: {
                    String string = modifier;
                    switch (string.hashCode()) {
                        case 96978: {
                            if (!string.equals("avg")) {
                                return null;
                            }
                            break block10;
                        }
                        case 108114: {
                            if (!string.equals("min")) {
                                return null;
                            }
                            break block11;
                        }
                        case 107876: {
                            if (!string.equals("max")) {
                                return null;
                            }
                            break block12;
                        }
                        case 94851343: {
                            if (string.equals("count")) break;
                            return null;
                        }
                        case 114251: {
                            if (!string.equals("sum")) return null;
                            columnModifier = ColumnModifier.Sum;
                            return columnModifier;
                        }
                    }
                    columnModifier = ColumnModifier.Count;
                    return columnModifier;
                }
                columnModifier = ColumnModifier.Mean;
                return columnModifier;
            }
            columnModifier = ColumnModifier.Min;
            return columnModifier;
        }
        columnModifier = ColumnModifier.Max;
        return columnModifier;
        return null;
    }

    private final String getColumnModifier(ColumnModifier modifier) {
        return switch (WhenMappings.$EnumSwitchMapping$0[modifier.ordinal()]) {
            case 1 -> "sum";
            case 2 -> "count";
            case 3 -> "avg";
            case 4 -> "min";
            case 5 -> "max";
            default -> null;
        };
    }

    private final JsonArray getColumnsJsonArray(List<ColumnSettings> columnSettings, boolean withoutModifier) {
        JsonArray jsonArray;
        JsonArray $this$getColumnsJsonArray_u24lambda_u240 = jsonArray = new JsonArray();
        boolean bl = false;
        Iterable $this$forEach$iv = columnSettings;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ColumnSettings it = (ColumnSettings)element$iv;
            boolean bl2 = false;
            $this$getColumnsJsonArray_u24lambda_u240.add((JsonElement)INSTANCE.getColumnJson(it, withoutModifier));
        }
        return jsonArray;
    }

    private final JsonObject getColumnJson(ColumnSettings columnSettings, boolean withoutModifier) {
        JsonObject jsonObject;
        block1: {
            String modifier;
            JsonObject $this$getColumnJson_u24lambda_u240;
            block0: {
                $this$getColumnJson_u24lambda_u240 = jsonObject = new JsonObject();
                boolean bl = false;
                $this$getColumnJson_u24lambda_u240.addProperty("name", columnSettings.getColumnId().getName());
                $this$getColumnJson_u24lambda_u240.addProperty("index", (Number)columnSettings.getColumnId().getIndex());
                if (!withoutModifier) break block0;
                $this$getColumnJson_u24lambda_u240.addProperty("aggr", "sum");
                break block1;
            }
            String string = modifier = INSTANCE.getColumnModifier(columnSettings.getModifier());
            if (string == null) break block1;
            String it = string;
            boolean bl = false;
            $this$getColumnJson_u24lambda_u240.addProperty("aggr", it);
        }
        return jsonObject;
    }

    public final boolean toJson(@NotNull JsonObject graph, @NotNull ChartSettings chartSettings) {
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        Intrinsics.checkNotNullParameter((Object)chartSettings, (String)"chartSettings");
        List<SeriesSettings> seriesSettings = chartSettings.getSeriesSettings();
        if (seriesSettings.size() != 1) {
            return false;
        }
        SeriesSettings settings = seriesSettings.get(0);
        if (settings instanceof LineSeriesSettings) {
            JsonObject jsonObject;
            if (((LineSeriesSettings)settings).getKeys().isEmpty() && ((LineSeriesSettings)settings).getValues().isEmpty() && ((LineSeriesSettings)settings).getGroups().isEmpty()) {
                return false;
            }
            graph.add("keys", (JsonElement)this.getColumnsJsonArray(((LineSeriesSettings)settings).getKeys(), true));
            graph.add("groups", (JsonElement)this.getColumnsJsonArray(((LineSeriesSettings)settings).getGroups(), true));
            graph.add("values", (JsonElement)this.getColumnsJsonArray(((LineSeriesSettings)settings).getValues(), false));
            JsonObject $this$toJson_u24lambda_u240 = jsonObject = ChartJsonUtilsKt.getOrCreateJsonObject(ChartJsonUtilsKt.getOrCreateJsonObject(graph, "setting"), "lineChart");
            boolean bl = false;
            ChartJsonUtilsKt.optSetProperty($this$toJson_u24lambda_u240, "stepped", ((LineSeriesSettings)settings).getStepped());
            ChartJsonUtilsKt.optSetProperty($this$toJson_u24lambda_u240, "showPoints", ((LineSeriesSettings)settings).getShowPoints());
            graph.addProperty("mode", "lineChart");
            return true;
        }
        if (settings instanceof BarSeriesSettings) {
            JsonObject jsonObject;
            if (((BarSeriesSettings)settings).getKeys().isEmpty() && ((BarSeriesSettings)settings).getValues().isEmpty() && ((BarSeriesSettings)settings).getGroups().isEmpty()) {
                return false;
            }
            graph.add("keys", (JsonElement)this.getColumnsJsonArray(((BarSeriesSettings)settings).getKeys(), true));
            graph.add("groups", (JsonElement)this.getColumnsJsonArray(((BarSeriesSettings)settings).getGroups(), true));
            graph.add("values", (JsonElement)this.getColumnsJsonArray(((BarSeriesSettings)settings).getValues(), false));
            JsonObject $this$toJson_u24lambda_u241 = jsonObject = ChartJsonUtilsKt.getOrCreateJsonObject(ChartJsonUtilsKt.getOrCreateJsonObject(graph, "setting"), "multiBarChart");
            boolean bl = false;
            ChartJsonUtilsKt.optSetProperty($this$toJson_u24lambda_u241, "horizontal", ((BarSeriesSettings)settings).getHorizontal());
            ChartJsonUtilsKt.optSetProperty($this$toJson_u24lambda_u241, "stacked", ((BarSeriesSettings)settings).getStacked());
            graph.addProperty("mode", "multiBarChart");
            return true;
        }
        if (settings instanceof PieSeriesSettings) {
            JsonObject jsonObject;
            if (((PieSeriesSettings)settings).getKeys().isEmpty() && ((PieSeriesSettings)settings).getValues().isEmpty() && ((PieSeriesSettings)settings).getGroups().isEmpty()) {
                return false;
            }
            graph.add("keys", (JsonElement)this.getColumnsJsonArray(((PieSeriesSettings)settings).getKeys(), true));
            graph.add("groups", (JsonElement)this.getColumnsJsonArray(((PieSeriesSettings)settings).getGroups(), true));
            graph.add("values", (JsonElement)this.getColumnsJsonArray(((PieSeriesSettings)settings).getValues(), false));
            JsonObject $this$toJson_u24lambda_u242 = jsonObject = ChartJsonUtilsKt.getOrCreateJsonObject(ChartJsonUtilsKt.getOrCreateJsonObject(graph, "setting"), "pieChart");
            boolean bl = false;
            ChartJsonUtilsKt.optSetProperty($this$toJson_u24lambda_u242, "showPercents", ((PieSeriesSettings)settings).getShowPercents());
            graph.addProperty("mode", "pieChart");
            return true;
        }
        if (settings instanceof ScatterSeriesSettings || settings instanceof BubbleSeriesSettings) {
            List<ColumnSettings> keys = null;
            List<ColumnSettings> groups = null;
            List<ColumnSettings> values = null;
            List<ColumnSettings> sizes = null;
            if (settings instanceof ScatterSeriesSettings) {
                keys = ((ScatterSeriesSettings)settings).getKeys();
                groups = ((ScatterSeriesSettings)settings).getGroups();
                values = ((ScatterSeriesSettings)settings).getValues();
                sizes = CollectionsKt.emptyList();
            } else {
                BubbleSeriesSettings cfr_ignored_0 = (BubbleSeriesSettings)settings;
                keys = ((BubbleSeriesSettings)settings).getKeys();
                groups = ((BubbleSeriesSettings)settings).getGroups();
                values = ((BubbleSeriesSettings)settings).getValues();
                sizes = ((BubbleSeriesSettings)settings).getSizes();
            }
            if (keys.isEmpty() && values.isEmpty() && groups.isEmpty() && sizes.isEmpty()) {
                return false;
            }
            graph.add("keys", (JsonElement)this.getColumnsJsonArray(keys, true));
            graph.add("groups", (JsonElement)this.getColumnsJsonArray(groups, true));
            graph.add("values", (JsonElement)this.getColumnsJsonArray(values, false));
            JsonObject scatterObject = ChartJsonUtilsKt.getOrCreateJsonObject(ChartJsonUtilsKt.getOrCreateJsonObject(graph, "setting"), "scatterChart");
            if (!((Collection)keys).isEmpty()) {
                scatterObject.add("xAxis", (JsonElement)this.getColumnJson((ColumnSettings)CollectionsKt.first(keys), true));
            }
            if (!((Collection)values).isEmpty()) {
                scatterObject.add("yAxis", (JsonElement)this.getColumnJson((ColumnSettings)CollectionsKt.first(values), true));
            }
            if (!((Collection)groups).isEmpty()) {
                scatterObject.add("group", (JsonElement)this.getColumnJson((ColumnSettings)CollectionsKt.first(groups), true));
            }
            if (!((Collection)sizes).isEmpty()) {
                scatterObject.add("size", (JsonElement)this.getColumnJson((ColumnSettings)CollectionsKt.first(sizes), true));
            }
            graph.addProperty("mode", "scatterChart");
            return true;
        }
        if (settings instanceof AreaSeriesSettings) {
            JsonObject stackedAreaChartSettings = ChartJsonUtilsKt.getOrCreateJsonObject(ChartJsonUtilsKt.getOrCreateJsonObject(graph, "setting"), "stackedAreaChart");
            switch (WhenMappings.$EnumSwitchMapping$1[((AreaSeriesSettings)settings).getAreaType().ordinal()]) {
                case 1: {
                    stackedAreaChartSettings.addProperty("style", "stream");
                    break;
                }
                case 2: {
                    stackedAreaChartSettings.addProperty("style", "expand");
                    break;
                }
                default: {
                    stackedAreaChartSettings.remove("style");
                }
            }
            graph.add("keys", (JsonElement)this.getColumnsJsonArray(((AreaSeriesSettings)settings).getKeys(), true));
            graph.add("groups", (JsonElement)this.getColumnsJsonArray(((AreaSeriesSettings)settings).getGroups(), true));
            graph.add("values", (JsonElement)this.getColumnsJsonArray(((AreaSeriesSettings)settings).getValues(), false));
            graph.addProperty("mode", "stackedAreaChart");
            return true;
        }
        return false;
    }

    static {
        Object[] objectArray = new String[]{"multiBarChart", "lineChart", "pieChart", "stackedAreaChart", "scatterChart"};
        supportedChartTypes = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B1\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J9\u0010\u0010\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0014\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0014\u001a\u00020\u0015H\u00d6\u0081\u0004J\n\u0010\u0016\u001a\u00020\u0017H\u00d6\u0081\u0004R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0018"}, d2={"Lcom/intellij/charts/settings/adapters/ChartSettingsZeppelinAdapter$GeneralColumnsSettings;", "", "xColumnSettings", "", "Lcom/intellij/charts/settings/data/ColumnSettings;", "yColumnSettings", "groupsSettings", "<init>", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getXColumnSettings", "()Ljava/util/List;", "getYColumnSettings", "getGroupsSettings", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.charts"})
    public static final class GeneralColumnsSettings {
        @NotNull
        private final List<ColumnSettings> xColumnSettings;
        @NotNull
        private final List<ColumnSettings> yColumnSettings;
        @NotNull
        private final List<ColumnSettings> groupsSettings;

        public GeneralColumnsSettings(@NotNull List<ColumnSettings> xColumnSettings, @NotNull List<ColumnSettings> yColumnSettings, @NotNull List<ColumnSettings> groupsSettings) {
            Intrinsics.checkNotNullParameter(xColumnSettings, (String)"xColumnSettings");
            Intrinsics.checkNotNullParameter(yColumnSettings, (String)"yColumnSettings");
            Intrinsics.checkNotNullParameter(groupsSettings, (String)"groupsSettings");
            this.xColumnSettings = xColumnSettings;
            this.yColumnSettings = yColumnSettings;
            this.groupsSettings = groupsSettings;
        }

        @NotNull
        public final List<ColumnSettings> getXColumnSettings() {
            return this.xColumnSettings;
        }

        @NotNull
        public final List<ColumnSettings> getYColumnSettings() {
            return this.yColumnSettings;
        }

        @NotNull
        public final List<ColumnSettings> getGroupsSettings() {
            return this.groupsSettings;
        }

        @NotNull
        public final List<ColumnSettings> component1() {
            return this.xColumnSettings;
        }

        @NotNull
        public final List<ColumnSettings> component2() {
            return this.yColumnSettings;
        }

        @NotNull
        public final List<ColumnSettings> component3() {
            return this.groupsSettings;
        }

        @NotNull
        public final GeneralColumnsSettings copy(@NotNull List<ColumnSettings> xColumnSettings, @NotNull List<ColumnSettings> yColumnSettings, @NotNull List<ColumnSettings> groupsSettings) {
            Intrinsics.checkNotNullParameter(xColumnSettings, (String)"xColumnSettings");
            Intrinsics.checkNotNullParameter(yColumnSettings, (String)"yColumnSettings");
            Intrinsics.checkNotNullParameter(groupsSettings, (String)"groupsSettings");
            return new GeneralColumnsSettings(xColumnSettings, yColumnSettings, groupsSettings);
        }

        public static /* synthetic */ GeneralColumnsSettings copy$default(GeneralColumnsSettings generalColumnsSettings, List list, List list2, List list3, int n, Object object) {
            if ((n & 1) != 0) {
                list = generalColumnsSettings.xColumnSettings;
            }
            if ((n & 2) != 0) {
                list2 = generalColumnsSettings.yColumnSettings;
            }
            if ((n & 4) != 0) {
                list3 = generalColumnsSettings.groupsSettings;
            }
            return generalColumnsSettings.copy(list, list2, list3);
        }

        @NotNull
        public String toString() {
            return "GeneralColumnsSettings(xColumnSettings=" + this.xColumnSettings + ", yColumnSettings=" + this.yColumnSettings + ", groupsSettings=" + this.groupsSettings + ")";
        }

        public int hashCode() {
            int result = ((Object)this.xColumnSettings).hashCode();
            result = result * 31 + ((Object)this.yColumnSettings).hashCode();
            result = result * 31 + ((Object)this.groupsSettings).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GeneralColumnsSettings)) {
                return false;
            }
            GeneralColumnsSettings generalColumnsSettings = (GeneralColumnsSettings)other;
            if (!Intrinsics.areEqual(this.xColumnSettings, generalColumnsSettings.xColumnSettings)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.yColumnSettings, generalColumnsSettings.yColumnSettings)) {
                return false;
            }
            return Intrinsics.areEqual(this.groupsSettings, generalColumnsSettings.groupsSettings);
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ColumnModifier.values().length];
            try {
                nArray[ColumnModifier.Sum.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColumnModifier.Count.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColumnModifier.Mean.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColumnModifier.Min.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColumnModifier.Max.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[AreaSeries.Type.values().length];
            try {
                nArray[AreaSeries.Type.Stream.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AreaSeries.Type.Expanded.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

