/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.charts.settings.data;

import com.google.gson.JsonObject;
import com.intellij.charts.dataframe.columns.ColumnId;
import com.intellij.charts.settings.data.ColumnModifier;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u001b\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nJ\u0006\u0010\u0013\u001a\u00020\tJ\u0006\u0010\u0014\u001a\u00020\u0015J\u0014\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u0096\u0082\u0004J\n\u0010\u0019\u001a\u00020\u001aH\u0096\u0080\u0004R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001b"}, d2={"Lcom/intellij/charts/settings/data/ColumnSettings;", "", "columnId", "Lcom/intellij/charts/dataframe/columns/ColumnId;", "modifier", "Lcom/intellij/charts/settings/data/ColumnModifier;", "<init>", "(Lcom/intellij/charts/dataframe/columns/ColumnId;Lcom/intellij/charts/settings/data/ColumnModifier;)V", "json", "Lcom/google/gson/JsonObject;", "(Lcom/google/gson/JsonObject;)V", "getColumnId", "()Lcom/intellij/charts/dataframe/columns/ColumnId;", "setColumnId", "(Lcom/intellij/charts/dataframe/columns/ColumnId;)V", "getModifier", "()Lcom/intellij/charts/settings/data/ColumnModifier;", "setModifier", "(Lcom/intellij/charts/settings/data/ColumnModifier;)V", "toJson", "getName", "", "equals", "", "other", "hashCode", "", "intellij.charts"})
public final class ColumnSettings {
    @NotNull
    private ColumnId columnId;
    @NotNull
    private ColumnModifier modifier;

    @NotNull
    public final ColumnId getColumnId() {
        return this.columnId;
    }

    public final void setColumnId(@NotNull ColumnId columnId) {
        Intrinsics.checkNotNullParameter((Object)columnId, (String)"<set-?>");
        this.columnId = columnId;
    }

    @NotNull
    public final ColumnModifier getModifier() {
        return this.modifier;
    }

    public final void setModifier(@NotNull ColumnModifier columnModifier) {
        Intrinsics.checkNotNullParameter((Object)((Object)columnModifier), (String)"<set-?>");
        this.modifier = columnModifier;
    }

    public ColumnSettings(@NotNull ColumnId columnId, @NotNull ColumnModifier modifier) {
        Intrinsics.checkNotNullParameter((Object)columnId, (String)"columnId");
        Intrinsics.checkNotNullParameter((Object)((Object)modifier), (String)"modifier");
        this.columnId = columnId;
        this.modifier = modifier;
    }

    public /* synthetic */ ColumnSettings(ColumnId columnId, ColumnModifier columnModifier, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            columnModifier = ColumnModifier.None;
        }
        this(columnId, columnModifier);
    }

    public ColumnSettings(@NotNull JsonObject json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        String string = json.get("column").getAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAsString(...)");
        this.columnId = new ColumnId(string, json.get("index").getAsInt());
        this.modifier = json.has("modifier") ? ColumnModifier.Companion.get(json.get("modifier").getAsString()) : ColumnModifier.None;
    }

    @NotNull
    public final JsonObject toJson() {
        JsonObject jsonObject;
        JsonObject $this$toJson_u24lambda_u240 = jsonObject = new JsonObject();
        boolean bl = false;
        $this$toJson_u24lambda_u240.addProperty("column", this.columnId.getName());
        $this$toJson_u24lambda_u240.addProperty("index", (Number)this.columnId.getIndex());
        if (this.modifier != ColumnModifier.None) {
            $this$toJson_u24lambda_u240.addProperty("modifier", this.modifier.name());
        }
        return jsonObject;
    }

    @NotNull
    public final String getName() {
        return this.columnId.getName() + (String)(this.modifier != ColumnModifier.None ? " (" + this.modifier.getTitle() + ")" : "");
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof ColumnSettings && Intrinsics.areEqual((Object)((ColumnSettings)other).columnId, (Object)this.columnId) && ((ColumnSettings)other).modifier == this.modifier;
    }

    public int hashCode() {
        int result = this.columnId.hashCode();
        result = 31 * result + this.modifier.hashCode();
        return result;
    }
}

