/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.charts.settings.series;

import com.intellij.charts.dataframe.DataFrame;
import com.intellij.charts.settings.data.AreaRangeSeriesSettings;
import com.intellij.charts.settings.data.AreaSeriesSettings;
import com.intellij.charts.settings.data.BarSeriesSettings;
import com.intellij.charts.settings.data.BubbleSeriesSettings;
import com.intellij.charts.settings.data.HistogramSeriesSettings;
import com.intellij.charts.settings.data.LineSeriesSettings;
import com.intellij.charts.settings.data.PieSeriesSettings;
import com.intellij.charts.settings.data.ScatterSeriesSettings;
import com.intellij.charts.settings.data.SeriesSettings;
import com.intellij.charts.settings.data.StockSeriesSettings;
import com.intellij.charts.settings.data.type.AreaRangeSeriesType;
import com.intellij.charts.settings.data.type.AreaSeriesType;
import com.intellij.charts.settings.data.type.BarSeriesType;
import com.intellij.charts.settings.data.type.BubbleSeriesType;
import com.intellij.charts.settings.data.type.HistogramSeriesType;
import com.intellij.charts.settings.data.type.LineSeriesType;
import com.intellij.charts.settings.data.type.PieSeriesType;
import com.intellij.charts.settings.data.type.ScatterSeriesType;
import com.intellij.charts.settings.data.type.SeriesType;
import com.intellij.charts.settings.data.type.StockSeriesType;
import com.intellij.charts.settings.series.AreaRangeSeriesPanel;
import com.intellij.charts.settings.series.AreaSeriesPanel;
import com.intellij.charts.settings.series.BarSeriesPanel;
import com.intellij.charts.settings.series.BubbleSeriesPanel;
import com.intellij.charts.settings.series.HistogramSeriesPanel;
import com.intellij.charts.settings.series.LineSeriesPanel;
import com.intellij.charts.settings.series.PieSeriesPanel;
import com.intellij.charts.settings.series.ScatterSeriesPanel;
import com.intellij.charts.settings.series.SeriesBlock;
import com.intellij.charts.settings.series.StockSeriesPanel;
import com.intellij.charts.statistics.ChartsUsagesCollector;
import com.intellij.charts.utils.ChartMessagesBundle;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.RightAlignedToolbarAction;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0006\u0010\u001c\u001a\u00020\nJ\b\u0010\u001d\u001a\u00020\nH\u0002J\u0010\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u0005H\u0014J\b\u0010 \u001a\u00020!H\u0002J\u0006\u0010\"\u001a\u00020\u0005J\u0006\u0010#\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\"\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u000e\u0010\u0012\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006$"}, d2={"Lcom/intellij/charts/settings/series/BaseSeriesPanel;", "Ljavax/swing/JPanel;", "dataFrame", "Lcom/intellij/charts/dataframe/DataFrame;", "settings", "Lcom/intellij/charts/settings/data/SeriesSettings;", "<init>", "(Lcom/intellij/charts/dataframe/DataFrame;Lcom/intellij/charts/settings/data/SeriesSettings;)V", "onChange", "Lkotlin/Function0;", "", "getOnChange", "()Lkotlin/jvm/functions/Function0;", "setOnChange", "(Lkotlin/jvm/functions/Function0;)V", "onRemove", "getOnRemove", "setOnRemove", "panel", "block", "Lcom/intellij/charts/settings/series/SeriesBlock;", "showDeleteButton", "", "getShowDeleteButton", "()Z", "setShowDeleteButton", "(Z)V", "createBlock", "dispose", "settingsChanged", "populateUniqueSettings", "seriesSettings", "createActionToolBar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "getSeriesSettings", "revalidateFields", "intellij.charts"})
public class BaseSeriesPanel
extends JPanel {
    @NotNull
    private final DataFrame dataFrame;
    @Nullable
    private Function0<Unit> onChange;
    @Nullable
    private Function0<Unit> onRemove;
    @NotNull
    private final JPanel panel;
    @NotNull
    private SeriesBlock block;
    private boolean showDeleteButton;

    public BaseSeriesPanel(@NotNull DataFrame dataFrame, @NotNull SeriesSettings settings) {
        Intrinsics.checkNotNullParameter((Object)dataFrame, (String)"dataFrame");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(new BorderLayout());
        this.dataFrame = dataFrame;
        this.panel = new JPanel(new BorderLayout());
        this.showDeleteButton = true;
        this.panel.setBorder(new CompoundBorder(IdeBorderFactory.createBorder((Color)JBUI.CurrentTheme.CustomFrameDecorations.separatorForeground(), (int)2), IdeBorderFactory.createEmptyBorder((Insets)((Insets)JBUI.insets((int)10)))));
        this.add((Component)this.createActionToolBar().getComponent(), "First");
        this.add((Component)this.panel, "Center");
        this.block = this.createBlock(settings);
        this.panel.add((Component)this.block.getComponent(), "Center");
        this.block.setOnChange((Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                ((BaseSeriesPanel)this.receiver).settingsChanged();
            }
        }));
    }

    @Nullable
    public final Function0<Unit> getOnChange() {
        return this.onChange;
    }

    public final void setOnChange(@Nullable Function0<Unit> function0) {
        this.onChange = function0;
    }

    @Nullable
    public final Function0<Unit> getOnRemove() {
        return this.onRemove;
    }

    public final void setOnRemove(@Nullable Function0<Unit> function0) {
        this.onRemove = function0;
    }

    public final boolean getShowDeleteButton() {
        return this.showDeleteButton;
    }

    public final void setShowDeleteButton(boolean bl) {
        this.showDeleteButton = bl;
    }

    private final SeriesBlock createBlock(SeriesSettings settings) {
        SeriesBlock seriesBlock;
        SeriesSettings seriesSettings = settings;
        if (seriesSettings instanceof LineSeriesSettings) {
            seriesBlock = new LineSeriesPanel(this.dataFrame, (LineSeriesSettings)settings);
        } else if (seriesSettings instanceof BarSeriesSettings) {
            seriesBlock = new BarSeriesPanel(this.dataFrame, (BarSeriesSettings)settings);
        } else if (seriesSettings instanceof AreaRangeSeriesSettings) {
            seriesBlock = new AreaRangeSeriesPanel(this.dataFrame, (AreaRangeSeriesSettings)settings);
        } else if (seriesSettings instanceof PieSeriesSettings) {
            seriesBlock = new PieSeriesPanel(this.dataFrame, (PieSeriesSettings)settings);
        } else if (seriesSettings instanceof ScatterSeriesSettings) {
            seriesBlock = new ScatterSeriesPanel(this.dataFrame, (ScatterSeriesSettings)settings);
        } else if (seriesSettings instanceof StockSeriesSettings) {
            seriesBlock = new StockSeriesPanel(this.dataFrame, (StockSeriesSettings)settings);
        } else if (seriesSettings instanceof BubbleSeriesSettings) {
            seriesBlock = new BubbleSeriesPanel(this.dataFrame, (BubbleSeriesSettings)settings);
        } else if (seriesSettings instanceof AreaSeriesSettings) {
            seriesBlock = new AreaSeriesPanel(this.dataFrame, (AreaSeriesSettings)settings);
        } else if (seriesSettings instanceof HistogramSeriesSettings) {
            seriesBlock = new HistogramSeriesPanel(this.dataFrame, (HistogramSeriesSettings)settings);
        } else {
            throw new NotImplementedError("Unsupported setting type");
        }
        return seriesBlock;
    }

    public final void dispose() {
        Disposer.dispose((Disposable)this.block);
    }

    private final void settingsChanged() {
        block0: {
            Function0<Unit> function0 = this.onChange;
            if (function0 == null) break block0;
            function0.invoke();
        }
    }

    protected void populateUniqueSettings(@NotNull SeriesSettings seriesSettings) {
        Intrinsics.checkNotNullParameter((Object)seriesSettings, (String)"seriesSettings");
    }

    private final ActionToolbar createActionToolBar() {
        DefaultActionGroup group = new DefaultActionGroup();
        SeriesType[] seriesTypeArray = new SeriesType[]{BarSeriesType.Companion.getInstance(), PieSeriesType.Companion.getInstance(), AreaSeriesType.Companion.getInstance(), LineSeriesType.Companion.getInstance(), ScatterSeriesType.Companion.getInstance(), BubbleSeriesType.Companion.getInstance(), StockSeriesType.Companion.getInstance(), AreaRangeSeriesType.Companion.getInstance(), HistogramSeriesType.Companion.getInstance()};
        for (SeriesType type : seriesTypeArray) {
            String string = type.getName();
            Icon icon = type.getIcon();
            DumbAwareToggleAction action2 = new DumbAwareToggleAction(type, this, string, icon){
                final /* synthetic */ SeriesType $type;
                final /* synthetic */ BaseSeriesPanel this$0;
                {
                    this.$type = $type;
                    this.this$0 = $receiver;
                    super($super_call_param$1, null, $super_call_param$2);
                }

                public boolean isSelected(AnActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    return Intrinsics.areEqual((Object)this.$type, (Object)BaseSeriesPanel.access$getBlock$p(this.this$0).getType());
                }

                public ActionUpdateThread getActionUpdateThread() {
                    return ActionUpdateThread.BGT;
                }

                public void setSelected(AnActionEvent e, boolean state) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    SeriesSettings seriesSettings = SeriesSettings.Companion.fromType(this.$type.getId(), BaseSeriesPanel.access$getBlock$p(this.this$0).getSeriesSettings().toJson());
                    Intrinsics.checkNotNull((Object)seriesSettings);
                    SeriesSettings newSeriesSettings = seriesSettings;
                    this.this$0.populateUniqueSettings(newSeriesSettings);
                    SeriesBlock newBlock = BaseSeriesPanel.access$createBlock(this.this$0, newSeriesSettings);
                    Disposer.dispose((Disposable)BaseSeriesPanel.access$getBlock$p(this.this$0));
                    BaseSeriesPanel.access$getPanel$p(this.this$0).removeAll();
                    BaseSeriesPanel.access$setBlock$p(this.this$0, newBlock);
                    BaseSeriesPanel.access$getPanel$p(this.this$0).add((Component)BaseSeriesPanel.access$getBlock$p(this.this$0).getComponent(), "Center");
                    BaseSeriesPanel.access$getBlock$p(this.this$0).setOnChange((Function0<Unit>)((Function0)new Function0<Unit>((Object)this.this$0){

                        public final void invoke() {
                            BaseSeriesPanel.access$settingsChanged((BaseSeriesPanel)this.receiver);
                        }
                    }));
                    BaseSeriesPanel.access$settingsChanged(this.this$0);
                    this.this$0.revalidate();
                    this.this$0.repaint();
                    this.this$0.revalidateFields();
                    ChartsUsagesCollector.INSTANCE.getSeriesTypeChanged().log((Object)this.$type.getId());
                }
            };
            group.add((AnAction)action2);
        }
        String string = ChartMessagesBundle.message("series.action.remove", new Object[0]);
        Icon icon = AllIcons.General.Delete;
        group.add((AnAction)new RightAlignedToolbarAction(this, string, icon){
            final /* synthetic */ BaseSeriesPanel this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, null, $super_call_param$2);
            }

            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.BGT;
            }

            public void update(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                e.getPresentation().setEnabledAndVisible(this.this$0.getShowDeleteButton());
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Function0<Unit> function0 = this.this$0.getOnRemove();
                if (function0 != null) {
                    function0.invoke();
                }
                Function0<Unit> function02 = this.this$0.getOnChange();
                if (function02 != null) {
                    function02.invoke();
                }
                ChartsUsagesCollector.INSTANCE.getSeriesRemoved().log();
            }
        });
        Icon $this$createActionToolBar_u24lambda_u240 = icon = ActionManager.getInstance().createActionToolbar("ChartSeries", (ActionGroup)group, true);
        boolean bl = false;
        $this$createActionToolBar_u24lambda_u240.setTargetComponent(this.panel);
        Icon icon2 = icon;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"apply(...)");
        return icon2;
    }

    @NotNull
    public final SeriesSettings getSeriesSettings() {
        return this.block.getSeriesSettings();
    }

    public final void revalidateFields() {
        this.block.revalidateFields();
    }

    public static final /* synthetic */ SeriesBlock access$getBlock$p(BaseSeriesPanel $this) {
        return $this.block;
    }

    public static final /* synthetic */ SeriesBlock access$createBlock(BaseSeriesPanel $this, SeriesSettings settings) {
        return $this.createBlock(settings);
    }

    public static final /* synthetic */ JPanel access$getPanel$p(BaseSeriesPanel $this) {
        return $this.panel;
    }

    public static final /* synthetic */ void access$setBlock$p(BaseSeriesPanel $this, SeriesBlock seriesBlock) {
        $this.block = seriesBlock;
    }
}

