/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.charts.style;

import com.intellij.charts.style.ChartsJBColor;
import com.intellij.charts.style.ColorTableModel;
import com.intellij.charts.style.PaletteDialogKt;
import com.intellij.ide.PasteProvider;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.ide.CopyPasteManager;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/charts/style/ColorTablePasteProvider;", "Lcom/intellij/ide/PasteProvider;", "table", "Ljavax/swing/JTable;", "<init>", "(Ljavax/swing/JTable;)V", "performPaste", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "isPastePossible", "", "isPasteEnabled", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.charts"})
public final class ColorTablePasteProvider
implements PasteProvider {
    @NotNull
    private final JTable table;

    public ColorTablePasteProvider(@NotNull JTable table2) {
        Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
        this.table = table2;
    }

    public void performPaste(@NotNull DataContext dataContext) {
        int index;
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        TableModel tableModel = this.table.getModel();
        ColorTableModel colorTableModel = tableModel instanceof ColorTableModel ? (ColorTableModel)tableModel : null;
        if (colorTableModel == null) {
            return;
        }
        ColorTableModel model = colorTableModel;
        Transferable transferable = CopyPasteManager.getInstance().getContents();
        if (transferable == null) {
            return;
        }
        Transferable contents = transferable;
        Object object = contents.getTransferData(DataFlavor.stringFlavor);
        String string = object instanceof String ? (String)object : null;
        if (string == null) {
            return;
        }
        String data = string;
        int splitSize = 0;
        List result = new ArrayList();
        Object object2 = new char[]{'\n'};
        List lines = StringsKt.split$default((CharSequence)data, (char[])object2, (boolean)false, (int)0, (int)6, null);
        object2 = lines.iterator();
        while (object2.hasNext()) {
            boolean bl;
            String line = (String)object2.next();
            if (StringsKt.isBlank((CharSequence)line)) continue;
            char[] cArray = new char[]{';'};
            List split = StringsKt.split$default((CharSequence)line, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            if (split.size() > 2 || splitSize != 0 && split.size() != splitSize) {
                return;
            }
            splitSize = split.size();
            Integer n = PaletteDialogKt.fromHexStringToColorInt((String)split.get(0));
            if (n == null) {
                return;
            }
            int first = n;
            if (splitSize == 1) {
                bl = result.add(CollectionsKt.listOf((Object)first));
                continue;
            }
            Integer n2 = PaletteDialogKt.fromHexStringToColorInt((String)split.get(1));
            if (n2 == null) {
                return;
            }
            int second = n2;
            Object[] objectArray = new Integer[]{first, second};
            bl = result.add(CollectionsKt.listOf((Object[])objectArray));
        }
        int line = Math.min(this.table.getRowCount(), result.size());
        int n = 0;
        for (int i = this.table.getSelectedRow(); i < line; ++i) {
            index = n++;
            int i2 = i;
            if (this.table.getSelectedColumn() > 2) {
                model.setValueAt(i2, 2, ((Number)CollectionsKt.first((List)((List)result.get(index)))).intValue());
                continue;
            }
            model.setValueAt(i2, 0, ((Number)CollectionsKt.first((List)((List)result.get(index)))).intValue());
            if (splitSize <= 1) continue;
            model.setValueAt(i2, 2, ((Number)CollectionsKt.last((List)((List)result.get(index)))).intValue());
        }
        int filledRows = this.table.getRowCount() - this.table.getSelectedRow();
        n = result.size() - filledRows;
        for (int i = 0; i < n; ++i) {
            index = filledRows + i;
            if (splitSize > 1) {
                model.addRow(new ChartsJBColor(((Number)CollectionsKt.first((List)((List)result.get(index)))).intValue(), ((Number)CollectionsKt.last((List)((List)result.get(index)))).intValue()));
                continue;
            }
            model.addRow(new ChartsJBColor(((Number)CollectionsKt.first((List)((List)result.get(index)))).intValue(), ((Number)CollectionsKt.first((List)((List)result.get(index)))).intValue()));
        }
    }

    public boolean isPastePossible(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return true;
    }

    public boolean isPasteEnabled(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return true;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }
}

