/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\u0006\u0010\u000b\u001a\u00020\u0006J\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rJ$\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ,\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r\u00a8\u0006\u0010"}, d2={"Lcom/intellij/docker/agent/util/ParametersListParser;", "", "<init>", "()V", "parseToArray", "", "", "string", "(Ljava/lang/String;)[Ljava/lang/String;", "parse", "", "parameterString", "keepQuotes", "", "supportSingleQuotes", "keepEmptyParameters", "intellij.clouds.docker.agent"})
@SourceDebugExtension(value={"SMAP\nParametersListParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParametersListParser.kt\ncom/intellij/docker/agent/util/ParametersListParser\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,134:1\n37#2,2:135\n106#3:137\n78#3,22:138\n*S KotlinDebug\n*F\n+ 1 ParametersListParser.kt\ncom/intellij/docker/agent/util/ParametersListParser\n*L\n9#1:135,2\n64#1:137\n64#1:138,22\n*E\n"})
public final class ParametersListParser {
    @NotNull
    public static final ParametersListParser INSTANCE = new ParametersListParser();

    private ParametersListParser() {
    }

    @NotNull
    public final String[] parseToArray(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Collection $this$toTypedArray$iv = this.parse(string);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    @NotNull
    public final List<String> parse(@NotNull String parameterString) {
        Intrinsics.checkNotNullParameter((Object)parameterString, (String)"parameterString");
        return this.parse(parameterString, false);
    }

    @NotNull
    public final List<String> parse(@NotNull String parameterString, boolean keepQuotes) {
        Intrinsics.checkNotNullParameter((Object)parameterString, (String)"parameterString");
        return this.parse(parameterString, keepQuotes, false);
    }

    @NotNull
    public final List<String> parse(@NotNull String parameterString, boolean keepQuotes, boolean supportSingleQuotes) {
        Intrinsics.checkNotNullParameter((Object)parameterString, (String)"parameterString");
        return this.parse(parameterString, keepQuotes, supportSingleQuotes, false);
    }

    @NotNull
    public final List<String> parse(@NotNull String parameterString, boolean keepQuotes, boolean supportSingleQuotes, boolean keepEmptyParameters) {
        Intrinsics.checkNotNullParameter((Object)parameterString, (String)"parameterString");
        String parameters = parameterString;
        if (!keepEmptyParameters) {
            String $this$trim$iv = parameterString;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            parameters = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        }
        List params = new ArrayList();
        if (((CharSequence)parameters).length() == 0) {
            return params;
        }
        StringBuilder token = new StringBuilder(128);
        boolean inQuotes = false;
        boolean escapedQuote = false;
        HashSet<Integer> possibleQuoteChars = new HashSet<Integer>();
        possibleQuoteChars.add(34);
        if (supportSingleQuotes) {
            possibleQuoteChars.add(39);
        }
        char currentQuote = '\u0000';
        boolean nonEmpty = false;
        int n = ((CharSequence)parameters).length();
        for (int i = 0; i < n; ++i) {
            char ch = parameters.charAt(i);
            boolean bl = inQuotes ? currentQuote == ch : possibleQuoteChars.contains(ch);
            if (bl) {
                if (!escapedQuote) {
                    inQuotes = !inQuotes;
                    currentQuote = ch;
                    nonEmpty = true;
                    if (!keepQuotes) continue;
                }
                escapedQuote = false;
            } else if (Character.isWhitespace(ch)) {
                if (!inQuotes) {
                    if (!keepEmptyParameters && !(((CharSequence)token).length() > 0) && !nonEmpty) continue;
                    String string = token.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    params.add(string);
                    token.setLength(0);
                    nonEmpty = false;
                    continue;
                }
            } else if (ch == '\\' && i < parameters.length() - 1) {
                char nextchar = parameters.charAt(i + 1);
                boolean bl3 = inQuotes ? currentQuote == nextchar : possibleQuoteChars.contains(nextchar);
                if (bl3) {
                    escapedQuote = true;
                    if (!keepQuotes) continue;
                }
            }
            token.append(ch);
        }
        if (keepEmptyParameters || ((CharSequence)token).length() > 0 || nonEmpty) {
            String string = token.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            params.add(string);
        }
        return params;
    }
}

