/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.DockerCmdExecFactory;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.DockerClientImpl;
import com.github.dockerjava.core.LocalDirectorySSLConfig;
import com.github.dockerjava.core.RemoteApiVersion;
import com.github.dockerjava.core.SSLConfig;
import com.github.dockerjava.core.util.CertificateUtils;
import com.github.dockerjava.httpclient5.ApacheDockerHttpClient;
import com.github.dockerjava.transport.DockerHttpClient;
import com.intellij.docker.agent.ApiTaskException;
import com.intellij.docker.agent.DockerAgentConfig;
import com.intellij.docker.agent.DockerAgentContext;
import com.intellij.docker.agent.fix.HackedDefaultDockerCmdExecFactory;
import com.intellij.docker.agent.i18n.DockerAgentBundle;
import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\tH\u0016J\b\u0010\r\u001a\u00020\u000bH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/docker/agent/impl/DockerClientExtImpl;", "Lcom/intellij/docker/agent/DockerAgentContext$DockerClientExt;", "config", "Lcom/github/dockerjava/core/DockerClientConfig;", "httpClient", "Lcom/github/dockerjava/transport/DockerHttpClient;", "<init>", "(Lcom/github/dockerjava/core/DockerClientConfig;Lcom/github/dockerjava/transport/DockerHttpClient;)V", "myObjectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "myDockerClient", "Lcom/github/dockerjava/api/DockerClient;", "getObjectMapper", "getDockerClient", "close", "", "Companion", "intellij.clouds.docker.agent"})
public final class DockerClientExtImpl
implements DockerAgentContext.DockerClientExt {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ObjectMapper myObjectMapper;
    @NotNull
    private final DockerClient myDockerClient;

    public DockerClientExtImpl(@NotNull DockerClientConfig config, @Nullable DockerHttpClient httpClient) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        ObjectMapper objectMapper = config.getObjectMapper().copy();
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"copy(...)");
        this.myObjectMapper = objectMapper;
        DockerHttpClient dockerHttpClient = httpClient;
        if (dockerHttpClient == null) {
            dockerHttpClient = DockerClientExtImpl.Companion.createApacheHttpClient(config);
        }
        this.myDockerClient = DockerClientExtImpl.Companion.createDockerClient(config, dockerHttpClient);
    }

    @Override
    @NotNull
    public ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = this.myObjectMapper.copy();
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"copy(...)");
        return objectMapper;
    }

    @Override
    @NotNull
    public DockerClient getDockerClient() {
        return this.myDockerClient;
    }

    @Override
    public void close() throws IOException {
        this.myDockerClient.close();
    }

    @JvmStatic
    @NotNull
    public static final DefaultDockerClientConfig buildClientConfig(@NotNull DockerAgentConfig $this$buildClientConfig, @NotNull RemoteApiVersion remoteApiVersion) throws ApiTaskException {
        return Companion.buildClientConfig($this$buildClientConfig, remoteApiVersion);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\f\u0010\n\u001a\u00020\t*\u00020\u0007H\u0002J\u0014\u0010\u000b\u001a\u00020\f*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\f\u0010\u0010\u001a\u00020\u0011*\u00020\u0007H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/docker/agent/impl/DockerClientExtImpl$Companion;", "", "<init>", "()V", "createDockerClient", "Lcom/github/dockerjava/api/DockerClient;", "dockerClientConfig", "Lcom/github/dockerjava/core/DockerClientConfig;", "dockerHttpClient", "Lcom/github/dockerjava/transport/DockerHttpClient;", "createApacheHttpClient", "buildClientConfig", "Lcom/github/dockerjava/core/DefaultDockerClientConfig;", "Lcom/intellij/docker/agent/DockerAgentConfig;", "remoteApiVersion", "Lcom/github/dockerjava/core/RemoteApiVersion;", "validateConfig", "", "intellij.clouds.docker.agent"})
    public static final class Companion {
        private Companion() {
        }

        private final DockerClient createDockerClient(DockerClientConfig dockerClientConfig, DockerHttpClient dockerHttpClient) {
            DockerClient dockerClientImpl = DockerClientImpl.getInstance((DockerClientConfig)dockerClientConfig, (DockerHttpClient)dockerHttpClient);
            ObjectMapper objectMapper = dockerClientConfig.getObjectMapper();
            Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"getObjectMapper(...)");
            DockerCmdExecFactory hackedDockerCmdExecFactory = HackedDefaultDockerCmdExecFactory.Companion.createFactory(dockerHttpClient, objectMapper);
            Intrinsics.checkNotNull((Object)dockerClientImpl, (String)"null cannot be cast to non-null type com.github.dockerjava.core.DockerClientImpl");
            DockerClientImpl dockerClientImpl2 = ((DockerClientImpl)dockerClientImpl).withDockerCmdExecFactory(hackedDockerCmdExecFactory);
            Intrinsics.checkNotNullExpressionValue((Object)dockerClientImpl2, (String)"withDockerCmdExecFactory(...)");
            return (DockerClient)dockerClientImpl2;
        }

        private final DockerHttpClient createApacheHttpClient(DockerClientConfig $this$createApacheHttpClient) {
            ApacheDockerHttpClient apacheDockerHttpClient = new ApacheDockerHttpClient.Builder().dockerHost($this$createApacheHttpClient.getDockerHost()).sslConfig((com.github.dockerjava.transport.SSLConfig)$this$createApacheHttpClient.getSSLConfig()).connectionTimeout(Duration.ofSeconds(10L)).build();
            Intrinsics.checkNotNullExpressionValue((Object)apacheDockerHttpClient, (String)"build(...)");
            return (DockerHttpClient)apacheDockerHttpClient;
        }

        @JvmStatic
        @NotNull
        public final DefaultDockerClientConfig buildClientConfig(@NotNull DockerAgentConfig $this$buildClientConfig, @NotNull RemoteApiVersion remoteApiVersion) throws ApiTaskException {
            DefaultDockerClientConfig defaultDockerClientConfig;
            DefaultDockerClientConfig.Builder builder;
            Intrinsics.checkNotNullParameter((Object)$this$buildClientConfig, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)remoteApiVersion, (String)"remoteApiVersion");
            try {
                builder = DefaultDockerClientConfig.createDefaultConfigBuilder();
                Intrinsics.checkNotNull((Object)builder);
            }
            catch (NullPointerException e) {
                builder = new DefaultDockerClientConfig.Builder();
            }
            catch (IllegalArgumentException e) {
                builder = new DefaultDockerClientConfig.Builder();
            }
            DefaultDockerClientConfig.Builder builder2 = builder;
            String host = DockerAgentConfig.Companion.getDockerHost($this$buildClientConfig);
            if (URI.create(host).getScheme() == null) {
                throw new ApiTaskException(DockerAgentBundle.Companion.message("DockerAgentImpl.docker.scheme.is.not.specified", new Object[0]));
            }
            DefaultDockerClientConfig it = defaultDockerClientConfig = builder2.withDockerHost(host).withDockerTlsVerify(Boolean.valueOf(DockerAgentConfig.Companion.isTlsVerifyEnabled($this$buildClientConfig))).withDockerCertPath($this$buildClientConfig.getCertificatesPath()).withApiVersion(remoteApiVersion).build();
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            Companion.validateConfig((DockerClientConfig)it);
            DefaultDockerClientConfig defaultDockerClientConfig2 = defaultDockerClientConfig;
            Intrinsics.checkNotNullExpressionValue((Object)defaultDockerClientConfig2, (String)"also(...)");
            return defaultDockerClientConfig2;
        }

        private final void validateConfig(DockerClientConfig $this$validateConfig) throws ApiTaskException {
            URI uRI = $this$validateConfig.getDockerHost();
            if (uRI == null) {
                throw new ApiTaskException(DockerAgentBundle.Companion.message("DockerAgentImpl.docker.host.is.not.specified", new Object[0]));
            }
            URI targetUri = uRI;
            if (Intrinsics.areEqual((Object)"tcp", (Object)targetUri.getScheme()) && $this$validateConfig.getSSLConfig() instanceof LocalDirectorySSLConfig) {
                SSLConfig sSLConfig = $this$validateConfig.getSSLConfig();
                Intrinsics.checkNotNull((Object)sSLConfig, (String)"null cannot be cast to non-null type com.github.dockerjava.core.LocalDirectorySSLConfig");
                LocalDirectorySSLConfig sslConfigImpl = (LocalDirectorySSLConfig)sSLConfig;
                String string = sslConfigImpl.getDockerCertPath();
                if (string == null) {
                    throw new ApiTaskException(DockerAgentBundle.Companion.message("DockerAgentImpl.certificates.path.is.not.specified", new Object[0]));
                }
                String certificatesPath = string;
                if (!CertificateUtils.verifyCertificatesExist((String)certificatesPath)) {
                    Object[] objectArray = new Object[]{certificatesPath};
                    throw new ApiTaskException(DockerAgentBundle.Companion.message("DockerAgentImpl.cant.locate.certificate.files", objectArray));
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

