/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.ui.utils;

import com.intellij.docker.i18n.DockerBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class DockerDeleteConfirmation {
    @NlsContexts.DialogMessage
    @NotNull
    @Nls
    private static String getUserConfirmationText(int images, int containers) {
        if (images < 0 || containers < 0 || images + containers == 0) {
            throw new IllegalArgumentException("Request for deletion: Images: " + images + ", containers: " + containers);
        }
        String imagesPiece = null;
        if (images > 0) {
            imagesPiece = images == 1 ? DockerBundle.message("DockerDeleteProvider.confirmation.image.one", new Object[0]) : DockerBundle.message("DockerDeleteProvider.confirmation.image.many", images);
        }
        String containersPiece = null;
        if (containers > 0) {
            String string = containersPiece = containers == 1 ? DockerBundle.message("DockerDeleteProvider.confirmation.container.one", new Object[0]) : DockerBundle.message("DockerDeleteProvider.confirmation.container.many", containers);
        }
        String string = containersPiece != null && imagesPiece != null ? DockerBundle.message("DockerDeleteProvider.confirmation.text.both.types", containersPiece, imagesPiece) : DockerBundle.message("DockerDeleteProvider.confirmation.text.single.type", containersPiece != null ? containersPiece : imagesPiece);
        if (string == null) {
            DockerDeleteConfirmation.$$$reportNull$$$0(0);
        }
        return string;
    }

    public static boolean getUserConfirmation(int unspecifiedItems) {
        @NlsContexts.DialogMessage String message = unspecifiedItems == 1 ? DockerBundle.message("DockerDeleteProvider.confirmation.text.unspecified.type.one", new Object[0]) : DockerBundle.message("DockerDeleteProvider.confirmation.text.unspecified.type.many", unspecifiedItems);
        return DockerDeleteConfirmation.getUserConfirmation(message);
    }

    public static boolean getUserConfirmation(int images, int containers) {
        return DockerDeleteConfirmation.getUserConfirmation(DockerDeleteConfirmation.getUserConfirmationText(images, containers));
    }

    public static boolean getUserConfirmation(@NlsContexts.DialogMessage String message) {
        int yesNo = Messages.showYesNoDialog((Project)null, (String)message, (String)DockerBundle.message("DockerDeleteProvider.confirmation.title", new Object[0]), (Icon)Messages.getWarningIcon());
        return yesNo == 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/ui/utils/DockerDeleteConfirmation", "getUserConfirmationText"));
    }
}

