/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.splitApi;

import com.intellij.docker.CustomDockerStatus;
import com.intellij.docker.DockerComposeStatus;
import com.intellij.docker.DockerContainerStatus;
import com.intellij.docker.DockerServerStatus;
import com.intellij.docker.DockerStatus;
import com.intellij.docker.DockerTransitionStatus;
import com.intellij.docker.UnknownDockerStatus;
import com.intellij.docker.splitApi.DockerStatusDto;
import com.intellij.docker.splitApi.RemoteDockerExceptionWrapper;
import com.intellij.docker.ui.utils.DockerIconUtilsKt;
import com.intellij.ide.ui.icons.IconId;
import com.intellij.ide.ui.icons.IconIdKt;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.reflect.KProperty0;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0007\u001a\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0001H\u0007\u00a8\u0006\u0006"}, d2={"convertDockerStatusToDto", "Lcom/intellij/docker/splitApi/DockerStatusDto;", "status", "Lcom/intellij/docker/DockerStatus;", "convertDtoToDockerStatus", "statusDto", "intellij.clouds.docker.shared"})
public final class SharedDockerDtoConvertersKt {
    @ApiStatus.Internal
    @NotNull
    public static final DockerStatusDto convertDockerStatusToDto(@NotNull DockerStatus status) {
        DockerStatusDto dockerStatusDto;
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        DockerStatus dockerStatus = status;
        if (dockerStatus instanceof UnknownDockerStatus) {
            dockerStatusDto = DockerStatusDto.UnknownDockerStatusDto.INSTANCE;
        } else if (dockerStatus instanceof DockerServerStatus.NotConnected) {
            dockerStatusDto = DockerStatusDto.DockerServerStatusDto.NotConnected.INSTANCE;
        } else if (dockerStatus instanceof DockerServerStatus.Connecting) {
            dockerStatusDto = DockerStatusDto.DockerServerStatusDto.Connecting.INSTANCE;
        } else if (dockerStatus instanceof DockerServerStatus.Connected) {
            dockerStatusDto = DockerStatusDto.DockerServerStatusDto.Connected.INSTANCE;
        } else if (dockerStatus instanceof DockerServerStatus.Disconnected) {
            dockerStatusDto = DockerStatusDto.DockerServerStatusDto.Disconnected.INSTANCE;
        } else if (dockerStatus instanceof DockerServerStatus.Error) {
            String string = ((DockerServerStatus.Error)status).getReason().getMessage();
            if (string == null) {
                string = "unknown error";
            }
            dockerStatusDto = new DockerStatusDto.DockerServerStatusDto.Error(string);
        } else if (dockerStatus instanceof DockerContainerStatus.Up.Running) {
            dockerStatusDto = DockerStatusDto.DockerContainerStatusDto.Up.Running.INSTANCE;
        } else if (dockerStatus instanceof DockerContainerStatus.Up.Healthy) {
            dockerStatusDto = DockerStatusDto.DockerContainerStatusDto.Up.Healthy.INSTANCE;
        } else if (dockerStatus instanceof DockerContainerStatus.Up.CheckHealthy) {
            dockerStatusDto = DockerStatusDto.DockerContainerStatusDto.Up.CheckHealthy.INSTANCE;
        } else if (dockerStatus instanceof DockerContainerStatus.Up.Unhealthy) {
            dockerStatusDto = DockerStatusDto.DockerContainerStatusDto.Up.Unhealthy.INSTANCE;
        } else if (dockerStatus instanceof DockerContainerStatus.Stopped) {
            dockerStatusDto = DockerStatusDto.DockerContainerStatusDto.Stopped.INSTANCE;
        } else if (dockerStatus instanceof DockerContainerStatus.Stopping) {
            dockerStatusDto = DockerStatusDto.DockerContainerStatusDto.Stopping.INSTANCE;
        } else if (dockerStatus instanceof DockerContainerStatus.Paused) {
            dockerStatusDto = DockerStatusDto.DockerContainerStatusDto.Paused.INSTANCE;
        } else if (dockerStatus instanceof DockerComposeStatus.Project) {
            dockerStatusDto = new DockerStatusDto.DockerComposeStatusDto.Project(((DockerComposeStatus.Project)status).getStatus());
        } else if (dockerStatus instanceof DockerComposeStatus.Service) {
            dockerStatusDto = new DockerStatusDto.DockerComposeStatusDto.Service(((DockerComposeStatus.Service)status).getStatus(), ((DockerComposeStatus.Service)status).isScaled());
        } else if (dockerStatus instanceof DockerTransitionStatus) {
            dockerStatusDto = switch (WhenMappings.$EnumSwitchMapping$0[((DockerTransitionStatus)status).ordinal()]) {
                case 1 -> DockerStatusDto.DockerTransitionStatusDto.Stopping.INSTANCE;
                case 2 -> DockerStatusDto.DockerTransitionStatusDto.Starting.INSTANCE;
                case 3 -> DockerStatusDto.DockerTransitionStatusDto.Deleting.INSTANCE;
                default -> throw new NoWhenBranchMatchedException();
            };
        } else if (dockerStatus instanceof CustomDockerStatus) {
            IconId iconId = IconIdKt.rpcId((Icon)((CustomDockerStatus)status).getIcon());
            String string = ((CustomDockerStatus)status).getText().get();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
            dockerStatusDto = new DockerStatusDto.CustomDockerStatusDto(iconId, string, ((CustomDockerStatus)status).getIcon() == DockerIconUtilsKt.getTransparentComposeIcon());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return dockerStatusDto;
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    @NotNull
    public static final DockerStatus convertDtoToDockerStatus(@NotNull DockerStatusDto statusDto) {
        DockerStatus dockerStatus;
        Intrinsics.checkNotNullParameter((Object)statusDto, (String)"statusDto");
        DockerStatusDto dockerStatusDto = statusDto;
        if (dockerStatusDto instanceof DockerStatusDto.UnknownDockerStatusDto) {
            dockerStatus = UnknownDockerStatus.INSTANCE;
        } else if (dockerStatusDto instanceof DockerStatusDto.DockerServerStatusDto.NotConnected) {
            dockerStatus = DockerServerStatus.NotConnected.INSTANCE;
        } else if (dockerStatusDto instanceof DockerStatusDto.DockerServerStatusDto.Connecting) {
            dockerStatus = DockerServerStatus.Connecting.INSTANCE;
        } else if (dockerStatusDto instanceof DockerStatusDto.DockerServerStatusDto.Connected) {
            dockerStatus = DockerServerStatus.Connected.INSTANCE;
        } else if (dockerStatusDto instanceof DockerStatusDto.DockerServerStatusDto.Disconnected) {
            dockerStatus = DockerServerStatus.Disconnected.INSTANCE;
        } else if (dockerStatusDto instanceof DockerStatusDto.DockerServerStatusDto.Error) {
            dockerStatus = new DockerServerStatus.Error(new RemoteDockerExceptionWrapper(((DockerStatusDto.DockerServerStatusDto.Error)statusDto).getReason()));
        } else if (dockerStatusDto instanceof DockerStatusDto.DockerContainerStatusDto.Up.Running) {
            dockerStatus = new DockerContainerStatus.Up.Running();
        } else if (dockerStatusDto instanceof DockerStatusDto.DockerContainerStatusDto.Up.Healthy) {
            dockerStatus = new DockerContainerStatus.Up.Healthy();
        } else if (dockerStatusDto instanceof DockerStatusDto.DockerContainerStatusDto.Up.CheckHealthy) {
            dockerStatus = new DockerContainerStatus.Up.CheckHealthy();
        } else if (dockerStatusDto instanceof DockerStatusDto.DockerContainerStatusDto.Up.Unhealthy) {
            dockerStatus = new DockerContainerStatus.Up.Unhealthy();
        } else if (dockerStatusDto instanceof DockerStatusDto.DockerContainerStatusDto.Stopped) {
            dockerStatus = new DockerContainerStatus.Stopped();
        } else if (dockerStatusDto instanceof DockerStatusDto.DockerContainerStatusDto.Stopping) {
            dockerStatus = new DockerContainerStatus.Stopping();
        } else if (dockerStatusDto instanceof DockerStatusDto.DockerContainerStatusDto.Paused) {
            dockerStatus = new DockerContainerStatus.Paused();
        } else if (dockerStatusDto instanceof DockerStatusDto.DockerComposeStatusDto.Project) {
            dockerStatus = new DockerComposeStatus.Project(((DockerStatusDto.DockerComposeStatusDto.Project)statusDto).getStatus(), null, null, 6, null);
        } else if (dockerStatusDto instanceof DockerStatusDto.DockerComposeStatusDto.Service) {
            dockerStatus = new DockerComposeStatus.Service(((DockerStatusDto.DockerComposeStatusDto.Service)statusDto).getStatus(), ((DockerStatusDto.DockerComposeStatusDto.Service)statusDto).isScaled(), null, null, 12, null);
        } else if (dockerStatusDto instanceof DockerStatusDto.DockerTransitionStatusDto.Stopping) {
            dockerStatus = DockerTransitionStatus.STOPPING;
        } else if (dockerStatusDto instanceof DockerStatusDto.DockerTransitionStatusDto.Starting) {
            dockerStatus = DockerTransitionStatus.STARTING;
        } else if (dockerStatusDto instanceof DockerStatusDto.DockerTransitionStatusDto.Deleting) {
            dockerStatus = DockerTransitionStatus.DELETING;
        } else if (dockerStatusDto instanceof DockerStatusDto.CustomDockerStatusDto) {
            void var3_2;
            Icon it = IconIdKt.icon((IconId)((DockerStatusDto.CustomDockerStatusDto)statusDto).getIconId());
            boolean bl = false;
            Icon icon = ((DockerStatusDto.CustomDockerStatusDto)statusDto).getHasTransparentIcon() ? DockerIconUtilsKt.getTransparentComposeIcon() : var3_2;
            dockerStatus = new CustomDockerStatus(icon, () -> SharedDockerDtoConvertersKt.convertDtoToDockerStatus$lambda$1((KProperty0)new PropertyReference0Impl(statusDto){

                public Object get() {
                    return ((DockerStatusDto.CustomDockerStatusDto)this.receiver).getText();
                }
            }));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return dockerStatus;
    }

    private static final String convertDtoToDockerStatus$lambda$1(KProperty0 $tmp0) {
        return (String)((Function0)$tmp0).invoke();
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DockerTransitionStatus.values().length];
            try {
                nArray[DockerTransitionStatus.STOPPING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DockerTransitionStatus.STARTING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DockerTransitionStatus.DELETING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

