/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.runtimes;

import com.intellij.docker.runtimes.presentation.api.DockerRuntimePresentationInterface;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u0000H\u0007\u00a2\u0006\u0002\u0010\fJ\u0015\u0010\r\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000e\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000fR\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/docker/runtimes/DockerRuntimeRegistry;", "T", "Lcom/intellij/docker/runtimes/presentation/api/DockerRuntimePresentationInterface;", "", "<init>", "()V", "runtimes", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/UUID;", "registerRuntime", "", "runtime", "(Lcom/intellij/docker/runtimes/presentation/api/DockerRuntimePresentationInterface;)V", "getRuntime", "id", "(Ljava/util/UUID;)Lcom/intellij/docker/runtimes/presentation/api/DockerRuntimePresentationInterface;", "intellij.clouds.docker.shared"})
public abstract class DockerRuntimeRegistry<T extends DockerRuntimePresentationInterface> {
    @NotNull
    private final ConcurrentHashMap<UUID, T> runtimes = new ConcurrentHashMap();

    @ApiStatus.Internal
    public final void registerRuntime(@NotNull T runtime) {
        Intrinsics.checkNotNullParameter(runtime, (String)"runtime");
        UUID id = runtime.getUniqueId();
        if (Disposer.tryRegister((Disposable)((Disposable)runtime), () -> DockerRuntimeRegistry.registerRuntime$lambda$0(this, id))) {
            ((Map)this.runtimes).put(id, runtime);
        }
    }

    @Nullable
    public final T getRuntime(@NotNull UUID id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return (T)((DockerRuntimePresentationInterface)this.runtimes.get(id));
    }

    private static final void registerRuntime$lambda$0(DockerRuntimeRegistry this$0, UUID $id) {
        this$0.runtimes.remove($id);
    }
}

