/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.action.registry;

import com.intellij.docker.registry.DockerRegistryConfiguration;
import com.intellij.docker.splitApi.registry.DockerRegistryDtoConvertersKt;
import com.intellij.docker.splitApi.registry.DockerRegistryEventCollector;
import com.intellij.docker.splitApi.registry.DockerRegistryLookup;
import com.intellij.docker.view.registry.DockerRegistryProvider;
import com.intellij.docker.view.registry.node.DockerRegistryRoot;
import com.intellij.platform.project.ProjectId;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/intellij/docker/action/registry/DockerRegistryRefreshActionUtils;", "", "<init>", "()V", "executeDockerRegistryRefreshAction", "", "registryId", "", "projectId", "Lcom/intellij/platform/project/ProjectId;", "intellij.clouds.docker"})
public final class DockerRegistryRefreshActionUtils {
    @NotNull
    public static final DockerRegistryRefreshActionUtils INSTANCE = new DockerRegistryRefreshActionUtils();

    private DockerRegistryRefreshActionUtils() {
    }

    public final void executeDockerRegistryRefreshAction(@NotNull String registryId, @NotNull ProjectId projectId) {
        Intrinsics.checkNotNullParameter((Object)registryId, (String)"registryId");
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Object object = DockerRegistryLookup.INSTANCE.findDockerRegistryRootById(registryId);
        if (object == null || (object = object.getConfiguration()) == null) {
            return;
        }
        Object registry = object;
        DockerRegistryProvider provider = DockerRegistryProvider.Companion.getProvider((DockerRegistryConfiguration)((Object)registry));
        provider.refresh((DockerRegistryConfiguration)((Object)registry));
        DockerRegistryRoot dockerRegistryRoot = provider.getRegistryRoot((DockerRegistryConfiguration)((Object)registry));
        if (dockerRegistryRoot == null) {
            return;
        }
        DockerRegistryRoot refreshedRegistry = dockerRegistryRoot;
        DockerRegistryEventCollector.Companion.getInstance().fireRegistryRefreshed(registryId, DockerRegistryDtoConvertersKt.toRegistryDto(refreshedRegistry), projectId);
    }
}

