/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.registry;

import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.registry.DockerRegistryConfigurable;
import com.intellij.docker.registry.DockerRegistryConfiguration;
import com.intellij.docker.registry.DockerRegistryManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.util.IconUtil;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class DockerRegistryListConfigurable
extends MasterDetailsComponent
implements SearchableConfigurable {
    @NonNls
    public static final String ID = "DockerRegistry";
    private final Disposable myDisposable = Disposer.newDisposable();

    public DockerRegistryListConfigurable() {
        this.initTree();
    }

    @NotNull
    protected String getEmptySelectionString() {
        String string = DockerBundle.message((String)"configurable.DockerRegistryListConfigurable.empty.selection.string", (Object[])new Object[0]);
        if (string == null) {
            DockerRegistryListConfigurable.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    public String getDisplayName() {
        return DockerBundle.message((String)"configurable.DockerRegistryListConfigurable.display.name", (Object[])new Object[0]);
    }

    public void reset() {
        this.myRoot.removeAllChildren();
        for (DockerRegistryConfiguration registry : DockerRegistryManager.getInstance().getRegistries()) {
            this.addRegistryNode(registry, false);
        }
        super.reset();
    }

    private MasterDetailsComponent.MyNode addRegistryNode(DockerRegistryConfiguration registry, boolean isNew) {
        DockerRegistryConfigurable registryConfigurable = new DockerRegistryConfigurable(registry, this.TREE_UPDATER, isNew);
        MasterDetailsComponent.MyNode node = new MasterDetailsComponent.MyNode((NamedConfigurable)registryConfigurable);
        this.addNode(node, this.myRoot);
        Disposer.register((Disposable)this.myDisposable, (Disposable)registryConfigurable);
        return node;
    }

    @NotNull
    public String getId() {
        return ID;
    }

    @NotNull
    public Runnable enableSearch(String option) {
        Runnable runnable = () -> Objects.requireNonNull(SpeedSearchSupply.getSupply((JComponent)this.myTree, (boolean)true)).findAndSelectElement(option);
        if (runnable == null) {
            DockerRegistryListConfigurable.$$$reportNull$$$0(1);
        }
        return runnable;
    }

    protected void initTree() {
        super.initTree();
        TreeSpeedSearch.installOn((JTree)this.myTree, (boolean)true, treePath -> ((MasterDetailsComponent.MyNode)treePath.getLastPathComponent()).getDisplayName());
    }

    protected void processRemovedItems() {
        HashSet<DockerRegistryConfiguration> registries = new HashSet<DockerRegistryConfiguration>();
        for (NamedConfigurable<DockerRegistryConfiguration> configurable : this.getConfiguredRegistries()) {
            registries.add((DockerRegistryConfiguration)((Object)configurable.getEditableObject()));
        }
        ArrayList<DockerRegistryConfiguration> toDelete = new ArrayList<DockerRegistryConfiguration>();
        DockerRegistryManager registryManager = DockerRegistryManager.getInstance();
        for (DockerRegistryConfiguration registry : registryManager.getRegistries()) {
            if (registries.contains((Object)registry)) continue;
            toDelete.add(registry);
        }
        for (DockerRegistryConfiguration registry : toDelete) {
            registryManager.removeRegistry(registry);
        }
    }

    public void apply() throws ConfigurationException {
        super.apply();
        DockerRegistryManager registryManager = DockerRegistryManager.getInstance();
        HashSet<DockerRegistryConfiguration> registries = new HashSet<DockerRegistryConfiguration>(registryManager.getRegistries());
        for (NamedConfigurable<DockerRegistryConfiguration> configurable : this.getConfiguredRegistries()) {
            DockerRegistryConfiguration registry = (DockerRegistryConfiguration)((Object)configurable.getEditableObject());
            registry.setName(configurable.getDisplayName());
            if (registries.contains((Object)registry)) continue;
            registryManager.addRegistry(registry);
        }
    }

    public String getHelpTopic() {
        return "docker.registry";
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this.myDisposable);
        super.disposeUIResources();
    }

    @NotNull
    protected ArrayList<AnAction> createActions(boolean fromPopup) {
        ArrayList<AnAction> actions = new ArrayList<AnAction>();
        actions.add((AnAction)new AddRegistryAction());
        actions.add((AnAction)new MasterDetailsComponent.MyDeleteAction((MasterDetailsComponent)this));
        ArrayList<AnAction> arrayList = actions;
        if (arrayList == null) {
            DockerRegistryListConfigurable.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    protected boolean wasObjectStored(Object editableObject) {
        return true;
    }

    private List<NamedConfigurable<DockerRegistryConfiguration>> getConfiguredRegistries() {
        ArrayList<NamedConfigurable<DockerRegistryConfiguration>> configurables = new ArrayList<NamedConfigurable<DockerRegistryConfiguration>>();
        for (int i = 0; i < this.myRoot.getChildCount(); ++i) {
            MasterDetailsComponent.MyNode node = (MasterDetailsComponent.MyNode)this.myRoot.getChildAt(i);
            configurables.add((NamedConfigurable<DockerRegistryConfiguration>)node.getConfigurable());
        }
        return configurables;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/docker/registry/DockerRegistryListConfigurable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmptySelectionString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "enableSearch";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private final class AddRegistryAction
    extends DumbAwareAction {
        private AddRegistryAction() {
            super(DockerBundle.messagePointer((String)"configurable.DockerRegistryListConfigurable.AddRegistryAction.text", (Object[])new Object[0]), Presentation.NULL_STRING, IconUtil.getAddIcon());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AddRegistryAction.$$$reportNull$$$0(0);
            }
            String name = UniqueNameGenerator.generateUniqueName((String)"Docker Registry", s -> {
                for (NamedConfigurable<DockerRegistryConfiguration> configurable : DockerRegistryListConfigurable.this.getConfiguredRegistries()) {
                    if (!configurable.getDisplayName().equals(s)) continue;
                    return false;
                }
                return true;
            });
            MasterDetailsComponent.MyNode node = DockerRegistryListConfigurable.this.addRegistryNode(new DockerRegistryConfiguration().withName(name), true);
            DockerRegistryListConfigurable.this.selectNodeInTree((DefaultMutableTreeNode)node);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/docker/registry/DockerRegistryListConfigurable$AddRegistryAction", "actionPerformed"));
        }
    }
}

