/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.splitApi.registry;

import com.intellij.docker.splitApi.registry.DockerRegistryDto;
import com.intellij.docker.splitApi.registry.DockerRegistryEventDto;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.platform.project.ProjectId;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001e\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/docker/splitApi/registry/DockerRegistryEventCollector;", "", "<init>", "()V", "serverEvents", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lcom/intellij/docker/splitApi/registry/DockerRegistryEventDto;", "getServerEvents", "Lkotlinx/coroutines/flow/Flow;", "fireRegistryAdded", "", "registry", "Lcom/intellij/docker/splitApi/registry/DockerRegistryDto;", "fireRegistryRemoved", "fireRegistryRefreshed", "oldId", "", "projectId", "Lcom/intellij/platform/project/ProjectId;", "Companion", "intellij.clouds.docker"})
public final class DockerRegistryEventCollector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MutableSharedFlow<DockerRegistryEventDto> serverEvents = SharedFlowKt.MutableSharedFlow((int)1000, (int)1000, (BufferOverflow)BufferOverflow.DROP_OLDEST);

    @NotNull
    public final Flow<DockerRegistryEventDto> getServerEvents() {
        return (Flow)FlowKt.asSharedFlow(this.serverEvents);
    }

    public final void fireRegistryAdded(@NotNull DockerRegistryDto registry) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        this.serverEvents.tryEmit((Object)new DockerRegistryEventDto.RegistryAdded(registry));
    }

    public final void fireRegistryRemoved(@NotNull DockerRegistryDto registry) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        this.serverEvents.tryEmit((Object)new DockerRegistryEventDto.RegistryRemoved(registry));
    }

    public final void fireRegistryRefreshed(@NotNull String oldId, @NotNull DockerRegistryDto registry, @NotNull ProjectId projectId) {
        Intrinsics.checkNotNullParameter((Object)oldId, (String)"oldId");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        this.serverEvents.tryEmit((Object)new DockerRegistryEventDto.RegistryRefreshed(oldId, registry, projectId));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/docker/splitApi/registry/DockerRegistryEventCollector$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/docker/splitApi/registry/DockerRegistryEventCollector;", "intellij.clouds.docker"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DockerRegistryEventCollector getInstance() {
            Object object = ApplicationManager.getApplication().getService(DockerRegistryEventCollector.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (DockerRegistryEventCollector)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

