/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.runtimes;

import com.intellij.docker.DockerStatus;
import com.intellij.docker.DockerTransitionStatus;
import com.intellij.docker.agent.DockerAgentVolume;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.runtimes.DockerRuntimeContext;
import com.intellij.docker.runtimes.DockerVolumeRuntime;
import com.intellij.docker.runtimes.presentation.DockerVolumeRuntimeImplPresentationInterface;
import com.intellij.docker.ui.scaffold.Scaffold;
import com.intellij.docker.ui.scaffold.ScaffoldKt;
import com.intellij.docker.utils.DockerUtils;
import com.intellij.docker.view.details.DockerAbstractDashboardTabKt;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.ui.SimpleTextAttributes;
import java.util.concurrent.CompletableFuture;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00122\u00020\u00012\u00020\u0002:\u0001\u0012B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/docker/runtimes/DockerVolumeRuntimeImpl;", "Lcom/intellij/docker/runtimes/DockerVolumeRuntime;", "Lcom/intellij/docker/runtimes/presentation/DockerVolumeRuntimeImplPresentationInterface;", "context", "Lcom/intellij/docker/runtimes/DockerRuntimeContext;", "agentApplication", "Lcom/intellij/docker/agent/DockerAgentVolume;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/docker/runtimes/DockerRuntimeContext;Lcom/intellij/docker/agent/DockerAgentVolume;Lcom/intellij/openapi/project/Project;)V", "getHeaderComponent", "Lcom/intellij/docker/ui/scaffold/Scaffold$SimpleSegment;", "scaffold", "Lcom/intellij/docker/ui/scaffold/Scaffold;", "deleteVolume", "Ljava/util/concurrent/CompletableFuture;", "", "Companion", "intellij.clouds.docker"})
public final class DockerVolumeRuntimeImpl
extends DockerVolumeRuntime
implements DockerVolumeRuntimeImplPresentationInterface {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Regex SHA256 = new Regex("[0-9a-f]{64}");

    public DockerVolumeRuntimeImpl(@NotNull DockerRuntimeContext context, @NotNull DockerAgentVolume agentApplication, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)agentApplication, (String)"agentApplication");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(context, agentApplication, project);
    }

    @Override
    @NotNull
    public Scaffold.SimpleSegment getHeaderComponent(@NotNull Scaffold scaffold) {
        Intrinsics.checkNotNullParameter((Object)scaffold, (String)"scaffold");
        DockerVolumeRuntimeImpl runtime = this;
        Scaffold $this$getHeaderComponent_u24lambda_u240 = scaffold;
        boolean bl = false;
        return $this$getHeaderComponent_u24lambda_u240.segment(arg_0 -> DockerVolumeRuntimeImpl.getHeaderComponent$lambda$0$0(runtime, arg_0));
    }

    @Override
    @NotNull
    public CompletableFuture<Unit> deleteVolume() {
        return this.runStatusTransition((DockerStatus)DockerTransitionStatus.DELETING, this.getAgentApplication().deleteVolume());
    }

    private static final Unit getHeaderComponent$lambda$0$0$0(DockerVolumeRuntimeImpl $runtime, Scaffold.SimpleSegment.TextFragment $this$textFragment) {
        Intrinsics.checkNotNullParameter((Object)$this$textFragment, (String)"$this$textFragment");
        boolean isInUse = DockerUtils.isInUse($runtime);
        $this$textFragment.setIcon($runtime.getStatus().getIcon());
        String string = $runtime.getVolume().getName();
        if (string != null) {
            String name = string;
            boolean bl = false;
            if (DockerVolumeRuntimeImpl.Companion.isSha256(name)) {
                $this$textFragment.append(DockerAbstractDashboardTabKt.shortenDockerId(name), SimpleTextAttributes.GRAYED_ATTRIBUTES);
                $this$textFragment.setToolTipText(name);
            } else {
                $this$textFragment.append(name, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            }
        }
        if (isInUse) {
            $this$textFragment.append("  " + DockerBundle.message((String)"DockerVolumeDashboardTab.in.use", (Object[])new Object[0]), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        }
        return Unit.INSTANCE;
    }

    private static final Unit getHeaderComponent$lambda$0$0$1(DockerVolumeRuntimeImpl $runtime, Scaffold.SimpleSegment.TextFragment $this$textFragment) {
        String driver;
        Intrinsics.checkNotNullParameter((Object)$this$textFragment, (String)"$this$textFragment");
        String string = $runtime.getVolume().getDriver();
        if (string == null) {
            string = "";
        }
        if (((CharSequence)(driver = string)).length() > 0) {
            $this$textFragment.append(DockerBundle.message((String)"DockerVolumeDetails.VolumePropertiesEditor.property.driver", (Object[])new Object[0]), SimpleTextAttributes.GRAYED_ATTRIBUTES);
            $this$textFragment.append("   " + driver, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
        return Unit.INSTANCE;
    }

    private static final Unit getHeaderComponent$lambda$0$0(DockerVolumeRuntimeImpl $runtime, Scaffold.SimpleSegment $this$segment) {
        Intrinsics.checkNotNullParameter((Object)$this$segment, (String)"$this$segment");
        $this$segment.textFragment(arg_0 -> DockerVolumeRuntimeImpl.getHeaderComponent$lambda$0$0$0($runtime, arg_0));
        $this$segment.textFragment(arg_0 -> DockerVolumeRuntimeImpl.getHeaderComponent$lambda$0$0$1($runtime, arg_0));
        ScaffoldKt.button$default((Scaffold.SimpleSegment)$this$segment, null, null, (String)"Docker.RemoteServers.InspectContainerOrImage", null, (int)11, null);
        ScaffoldKt.button$default((Scaffold.SimpleSegment)$this$segment, (Icon)AllIcons.Actions.GC, (String)DockerBundle.message((String)"DockerAbstractDashboardTab.action.remove.hint", (Object[])new Object[0]), (String)"Docker.RemoteServers.DeleteVolume", null, (int)8, null);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u0007*\u0004\u0018\u00010\bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/docker/runtimes/DockerVolumeRuntimeImpl$Companion;", "", "<init>", "()V", "SHA256", "Lkotlin/text/Regex;", "isSha256", "", "", "intellij.clouds.docker"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isSha256(String $this$isSha256) {
            CharSequence charSequence = $this$isSha256;
            return !(charSequence == null || charSequence.length() == 0) && SHA256.matches((CharSequence)$this$isSha256);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

