/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.ijent;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.ijent.DockerContainerEelMachine;
import com.intellij.docker.ijent.DockerDevcontainerEelMachine;
import com.intellij.docker.ijent.DockerEelDescriptor;
import com.intellij.docker.ijent.DockerEelDescriptorKt;
import com.intellij.docker.ijent.DockerEelMachine;
import com.intellij.docker.ijent.DockerEelPathFormat;
import com.intellij.docker.utils.InternalUtilsKt;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.provider.EelMachineResolver;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.remoteServer.configuration.RemoteServer;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\fH\u0096@\u00a2\u0006\u0002\u0010\rJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u000f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0096@\u00a2\u0006\u0002\u0010\u0012J+\u0010\u0013\u001a\u00020\t\"\b\b\u0000\u0010\u0014*\u00020\b*\u0002H\u00142\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0016H\u0002\u00a2\u0006\u0002\u0010\u0018J\f\u0010\u0019\u001a\u00020\u0003*\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/docker/ijent/DockerEelMachineResolver;", "Lcom/intellij/platform/eel/provider/EelMachineResolver;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "cache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/docker/ijent/DockerEelPathFormat$ContainerIdentifier;", "Lcom/intellij/docker/ijent/DockerEelMachine;", "resolveEelMachine", "eelDescriptor", "Lcom/intellij/platform/eel/EelDescriptor;", "(Lcom/intellij/platform/eel/EelDescriptor;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getResolvedEelMachine", "resolveEelMachineByInternalName", "internalName", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createMachine", "I", "server", "Lcom/intellij/remoteServer/configuration/RemoteServer;", "Lcom/intellij/docker/DockerCloudConfiguration;", "(Lcom/intellij/docker/ijent/DockerEelPathFormat$ContainerIdentifier;Lcom/intellij/remoteServer/configuration/RemoteServer;)Lcom/intellij/docker/ijent/DockerEelMachine;", "childScope", "intellij.clouds.docker"})
public final class DockerEelMachineResolver
implements EelMachineResolver {
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final ConcurrentHashMap<DockerEelPathFormat.ContainerIdentifier, DockerEelMachine> cache;

    public DockerEelMachineResolver(@NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.scope = scope;
        this.cache = new ConcurrentHashMap();
    }

    @Nullable
    public Object resolveEelMachine(@NotNull EelDescriptor eelDescriptor, @NotNull Continuation<? super DockerEelMachine> $completion) {
        return this.getResolvedEelMachine(eelDescriptor);
    }

    @Nullable
    public DockerEelMachine getResolvedEelMachine(@NotNull EelDescriptor eelDescriptor) {
        Intrinsics.checkNotNullParameter((Object)eelDescriptor, (String)"eelDescriptor");
        DockerEelDescriptor dockerEelDescriptor = eelDescriptor instanceof DockerEelDescriptor ? (DockerEelDescriptor)eelDescriptor : null;
        if (dockerEelDescriptor == null) {
            return null;
        }
        DockerEelDescriptor descriptor2 = dockerEelDescriptor;
        DockerEelPathFormat.ContainerIdentifier identifier = descriptor2.getContainerIdentifier();
        return this.cache.computeIfAbsent(identifier, arg_0 -> DockerEelMachineResolver.getResolvedEelMachine$lambda$1(arg_0 -> DockerEelMachineResolver.getResolvedEelMachine$lambda$0(descriptor2, this, identifier, arg_0), arg_0));
    }

    @Nullable
    public Object resolveEelMachineByInternalName(@NotNull String internalName, @NotNull Continuation<? super DockerEelMachine> $completion) {
        DockerEelPathFormat.ContainerIdentifier containerIdentifier;
        String string = InternalUtilsKt.substringAfterPrefix(internalName, "Docker-");
        if (string != null) {
            String it = string;
            boolean bl = false;
            containerIdentifier = DockerEelPathFormat.ContainerIdentifier.Id.box-impl(DockerEelPathFormat.ContainerIdentifier.Id.constructor-impl(it));
        } else {
            String string2 = InternalUtilsKt.substringAfterPrefix(internalName, "Devcontainer-");
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                containerIdentifier = DockerEelPathFormat.ContainerIdentifier.DevcontainerId.box-impl(DockerEelPathFormat.ContainerIdentifier.DevcontainerId.constructor-impl(it));
            } else {
                return null;
            }
        }
        DockerEelPathFormat.ContainerIdentifier.Id containerIdentifier2 = containerIdentifier;
        return this.cache.computeIfAbsent(containerIdentifier2, arg_0 -> DockerEelMachineResolver.resolveEelMachineByInternalName$lambda$3(arg_0 -> DockerEelMachineResolver.resolveEelMachineByInternalName$lambda$2(this, containerIdentifier2, arg_0), arg_0));
    }

    private final <I extends DockerEelPathFormat.ContainerIdentifier> DockerEelMachine createMachine(I $this$createMachine, RemoteServer<DockerCloudConfiguration> server2) {
        DockerEelMachine dockerEelMachine;
        I i = $this$createMachine;
        if (i instanceof DockerEelPathFormat.ContainerIdentifier.DevcontainerId) {
            dockerEelMachine = new DockerDevcontainerEelMachine(((DockerEelPathFormat.ContainerIdentifier.DevcontainerId)$this$createMachine).unbox-impl(), server2, this.childScope($this$createMachine), null);
        } else if (i instanceof DockerEelPathFormat.ContainerIdentifier.Id) {
            dockerEelMachine = new DockerContainerEelMachine(((DockerEelPathFormat.ContainerIdentifier.Id)$this$createMachine).unbox-impl(), server2, this.childScope($this$createMachine), null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return dockerEelMachine;
    }

    private final CoroutineScope childScope(DockerEelPathFormat.ContainerIdentifier $this$childScope) {
        return CoroutineScopeKt.childScope$default((CoroutineScope)this.scope, (String)("Scope for docker machine: " + $this$childScope.getClass().getSimpleName() + " " + $this$childScope.getValue()), null, (boolean)false, (int)6, null);
    }

    private static final DockerEelMachine getResolvedEelMachine$lambda$0(DockerEelDescriptor $descriptor, DockerEelMachineResolver this$0, DockerEelPathFormat.ContainerIdentifier $identifier, DockerEelPathFormat.ContainerIdentifier it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        RemoteServer<DockerCloudConfiguration> server2 = DockerEelDescriptorKt.tryFindDockerServer($descriptor);
        return this$0.createMachine($identifier, server2);
    }

    private static final DockerEelMachine getResolvedEelMachine$lambda$1(Function1 $tmp0, Object p0) {
        return (DockerEelMachine)$tmp0.invoke(p0);
    }

    private static final DockerEelMachine resolveEelMachineByInternalName$lambda$2(DockerEelMachineResolver this$0, DockerEelPathFormat.ContainerIdentifier $containerIdentifier, DockerEelPathFormat.ContainerIdentifier it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.createMachine($containerIdentifier, null);
    }

    private static final DockerEelMachine resolveEelMachineByInternalName$lambda$3(Function1 $tmp0, Object p0) {
        return (DockerEelMachine)$tmp0.invoke(p0);
    }
}

