/*
 * Copyright 2000-2017 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.intellij.completion.ml.personalization

import com.intellij.completion.ml.personalization.impl.ApplicationUserFactorStorage
import com.intellij.completion.ml.personalization.impl.ProjectUserFactorStorage
import com.intellij.openapi.components.service
import com.intellij.openapi.project.Project

/**
 * @author Vitaliy.Bibaev
 */
interface UserFactorStorage {
  companion object {
    fun getInstance(): UserFactorStorage = service<ApplicationUserFactorStorage>()
    fun getInstance(project: Project): UserFactorStorage = project.service<ProjectUserFactorStorage>()

    fun <U : FactorUpdater> applyOnBoth(project: Project, description: UserFactorDescription<U, *>, updater: (U) -> Unit) {
      updater(getInstance().getFactorUpdater(description))
      updater(getInstance(project).getFactorUpdater(description))
    }
  }

  fun <U : FactorUpdater> getFactorUpdater(description: UserFactorDescription<U, *>): U
  fun <R : FactorReader> getFactorReader(description: UserFactorDescription<*, R>): R
}