/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.personalization.impl;

import com.intellij.completion.ml.personalization.DateUtil;
import com.intellij.completion.ml.personalization.Day;
import com.intellij.completion.ml.personalization.FactorReader;
import com.intellij.completion.ml.personalization.FactorUpdater;
import com.intellij.completion.ml.personalization.UserFactorDescription;
import com.intellij.completion.ml.personalization.UserFactorDescriptions;
import com.intellij.completion.ml.personalization.UserFactorStorage;
import com.intellij.completion.ml.personalization.impl.DayImpl;
import com.intellij.completion.ml.personalization.impl.MutableDoubleFactor;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.diagnostic.Logger;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b&\u0018\u0000 \u001a2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0004\u001a\u001b\u001c\u001dB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J)\u0010\b\u001a\u0002H\t\"\b\b\u0000\u0010\t*\u00020\n2\u0010\u0010\u000b\u001a\f\u0012\u0004\u0012\u0002H\t\u0012\u0002\b\u00030\fH\u0016\u00a2\u0006\u0002\u0010\rJ)\u0010\u000e\u001a\u0002H\u000f\"\b\b\u0000\u0010\u000f*\u00020\u00102\u0010\u0010\u000b\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u0002H\u000f0\fH\u0016\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\u0003H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/completion/ml/personalization/impl/UserFactorStorageBase;", "Lcom/intellij/completion/ml/personalization/UserFactorStorage;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "<init>", "()V", "state", "Lcom/intellij/completion/ml/personalization/impl/UserFactorStorageBase$CollectorState;", "getFactorUpdater", "U", "Lcom/intellij/completion/ml/personalization/FactorUpdater;", "description", "Lcom/intellij/completion/ml/personalization/UserFactorDescription;", "(Lcom/intellij/completion/ml/personalization/UserFactorDescription;)Lcom/intellij/completion/ml/personalization/FactorUpdater;", "getFactorReader", "R", "Lcom/intellij/completion/ml/personalization/FactorReader;", "(Lcom/intellij/completion/ml/personalization/UserFactorDescription;)Lcom/intellij/completion/ml/personalization/FactorReader;", "getState", "loadState", "", "newState", "getAggregateFactor", "Lcom/intellij/completion/ml/personalization/impl/MutableDoubleFactor;", "factorId", "", "Companion", "CollectorState", "DailyAggregateFactor", "DailyData", "intellij.completionMlRanking"})
public abstract class UserFactorStorageBase
implements UserFactorStorage,
PersistentStateComponent<Element> {
    @NotNull
    private static final Companion Companion;
    @NotNull
    private final CollectorState state = new CollectorState();
    @NotNull
    private static final DecimalFormat DOUBLE_VALUE_FORMATTER;

    @Override
    @NotNull
    public <U extends FactorUpdater> U getFactorUpdater(@NotNull UserFactorDescription<? extends U, ?> description) {
        Intrinsics.checkNotNullParameter(description, (String)"description");
        return (U)((FactorUpdater)description.getUpdaterFactory().invoke((Object)this.getAggregateFactor(description.getFactorId())));
    }

    @Override
    @NotNull
    public <R extends FactorReader> R getFactorReader(@NotNull UserFactorDescription<?, ? extends R> description) {
        Intrinsics.checkNotNullParameter(description, (String)"description");
        return (R)((FactorReader)description.getReaderFactory().invoke((Object)this.getAggregateFactor(description.getFactorId())));
    }

    @NotNull
    public Element getState() {
        Element element = new Element("component");
        this.state.writeState(element);
        return element;
    }

    public void loadState(@NotNull Element newState) {
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        this.state.applyState(newState);
    }

    private final MutableDoubleFactor getAggregateFactor(String factorId) {
        DailyAggregateFactor dailyAggregateFactor = this.state.getAggregateFactors().computeIfAbsent(factorId, arg_0 -> UserFactorStorageBase.getAggregateFactor$lambda$1(UserFactorStorageBase::getAggregateFactor$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)dailyAggregateFactor, (String)"computeIfAbsent(...)");
        return dailyAggregateFactor;
    }

    private static final DailyAggregateFactor getAggregateFactor$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new DailyAggregateFactor();
    }

    private static final DailyAggregateFactor getAggregateFactor$lambda$1(Function1 $tmp0, Object p0) {
        return (DailyAggregateFactor)$tmp0.invoke(p0);
    }

    static {
        DecimalFormat decimalFormat;
        Companion = new Companion(null);
        DecimalFormat $this$DOUBLE_VALUE_FORMATTER_u24lambda_u240 = decimalFormat = new DecimalFormat();
        boolean bl = false;
        $this$DOUBLE_VALUE_FORMATTER_u24lambda_u240.setMaximumFractionDigits(6);
        $this$DOUBLE_VALUE_FORMATTER_u24lambda_u240.setMinimumFractionDigits(1);
        $this$DOUBLE_VALUE_FORMATTER_u24lambda_u240.setGroupingUsed(false);
        DOUBLE_VALUE_FORMATTER = decimalFormat;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"Lcom/intellij/completion/ml/personalization/impl/UserFactorStorageBase$CollectorState;", "", "<init>", "()V", "aggregateFactors", "", "", "Lcom/intellij/completion/ml/personalization/impl/UserFactorStorageBase$DailyAggregateFactor;", "getAggregateFactors", "()Ljava/util/Map;", "applyState", "", "element", "Lorg/jdom/Element;", "writeState", "intellij.completionMlRanking"})
    @SourceDebugExtension(value={"SMAP\nUserFactorStorageBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserFactorStorageBase.kt\ncom/intellij/completion/ml/personalization/impl/UserFactorStorageBase$CollectorState\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,181:1\n614#2:182\n*S KotlinDebug\n*F\n+ 1 UserFactorStorageBase.kt\ncom/intellij/completion/ml/personalization/impl/UserFactorStorageBase$CollectorState\n*L\n64#1:182\n*E\n"})
    private static final class CollectorState {
        @NotNull
        private final Map<String, DailyAggregateFactor> aggregateFactors = new HashMap();

        @NotNull
        public final Map<String, DailyAggregateFactor> getAggregateFactors() {
            return this.aggregateFactors;
        }

        public final void applyState(@NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            this.aggregateFactors.clear();
            for (Element child : element.getChildren()) {
                String factorId = child.getAttributeValue("id");
                if (!Intrinsics.areEqual((Object)child.getName(), (Object)"factor") || factorId == null || !UserFactorDescriptions.INSTANCE.isKnownFactor(factorId)) continue;
                Intrinsics.checkNotNull((Object)child);
                DailyAggregateFactor factor = DailyAggregateFactor.Companion.restore(child);
                if (factor == null) continue;
                this.aggregateFactors.put(factorId, factor);
            }
        }

        public final void writeState(@NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Sequence $this$sortedBy$iv = MapsKt.asSequence(this.aggregateFactors);
            boolean $i$f$sortedBy = false;
            for (Map.Entry entry : SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Map.Entry it = (Map.Entry)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)((String)it.getKey()));
                    it = (Map.Entry)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((String)it.getKey()))));
                }
            })) {
                String id = (String)entry.getKey();
                DailyAggregateFactor factor = (DailyAggregateFactor)entry.getValue();
                Element factorElement = new Element("factor");
                factorElement.setAttribute("id", id);
                factor.writeState(factorElement);
                element.addContent(factorElement);
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/completion/ml/personalization/impl/UserFactorStorageBase$Companion;", "", "<init>", "()V", "DOUBLE_VALUE_FORMATTER", "Ljava/text/DecimalFormat;", "getDOUBLE_VALUE_FORMATTER", "()Ljava/text/DecimalFormat;", "intellij.completionMlRanking"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DecimalFormat getDOUBLE_VALUE_FORMATTER() {
            return DOUBLE_VALUE_FORMATTER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u001f\b\u0002\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007B\t\b\u0016\u00a2\u0006\u0004\b\u0006\u0010\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001e\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u0004H\u0016J5\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00042#\u0010\u0018\u001a\u001f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00150\u001a\u0012\u0004\u0012\u00020\n0\u0019\u00a2\u0006\u0002\b\u001bH\u0016J\b\u0010\u001c\u001a\u00020\nH\u0002R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/completion/ml/personalization/impl/UserFactorStorageBase$DailyAggregateFactor;", "Lcom/intellij/completion/ml/personalization/impl/MutableDoubleFactor;", "aggregates", "Ljava/util/SortedMap;", "Lcom/intellij/completion/ml/personalization/Day;", "Lcom/intellij/completion/ml/personalization/impl/UserFactorStorageBase$DailyData;", "<init>", "(Ljava/util/SortedMap;)V", "()V", "writeState", "", "element", "Lorg/jdom/Element;", "availableDays", "", "incrementOnToday", "", "key", "", "onDate", "", "", "date", "updateOnDate", "updater", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "ensureLimit", "Companion", "intellij.completionMlRanking"})
    public static final class DailyAggregateFactor
    implements MutableDoubleFactor {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final SortedMap<Day, DailyData> aggregates;
        private static final int DAYS_LIMIT = 10;

        private DailyAggregateFactor(SortedMap<Day, DailyData> aggregates) {
            this.aggregates = aggregates;
            this.ensureLimit();
        }

        /* synthetic */ DailyAggregateFactor(SortedMap sortedMap, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                sortedMap = MapsKt.sortedMapOf((Pair[])new Pair[0]);
            }
            this(sortedMap);
        }

        public DailyAggregateFactor() {
            this(MapsKt.sortedMapOf((Pair[])new Pair[0]));
        }

        public final void writeState(@NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            for (Map.Entry entry : ((Map)this.aggregates).entrySet()) {
                Day day = (Day)entry.getKey();
                DailyData data = (DailyData)entry.getValue();
                Element dailyDataElement = new Element("dailyData");
                dailyDataElement.setAttribute("date", day.toString());
                data.writeState(dailyDataElement);
                element.addContent(dailyDataElement);
            }
        }

        @Override
        @NotNull
        public List<Day> availableDays() {
            Set<Day> set = this.aggregates.keySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
            return CollectionsKt.toList((Iterable)set);
        }

        @Override
        public boolean incrementOnToday(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return this.updateOnDate(DateUtil.INSTANCE.today(), (Function1<? super Map<String, Double>, Unit>)((Function1)arg_0 -> DailyAggregateFactor.incrementOnToday$lambda$0(key, arg_0)));
        }

        @Override
        @Nullable
        public Map<String, Double> onDate(@NotNull Day date) {
            Intrinsics.checkNotNullParameter((Object)date, (String)"date");
            DailyData dailyData = (DailyData)this.aggregates.get(date);
            return dailyData != null ? dailyData.getData() : null;
        }

        @Override
        public boolean updateOnDate(@NotNull Day date, @NotNull Function1<? super Map<String, Double>, Unit> updater) {
            Intrinsics.checkNotNullParameter((Object)date, (String)"date");
            Intrinsics.checkNotNullParameter(updater, (String)"updater");
            DailyData old = (DailyData)this.aggregates.get(date);
            if (old != null) {
                updater.invoke(old.getData());
                return true;
            }
            if (this.aggregates.size() < 10 || this.aggregates.firstKey().compareTo(date) < 0) {
                DailyData data = new DailyData(null, 1, null);
                updater.invoke(data.getData());
                this.aggregates.put(date, data);
                this.ensureLimit();
                return true;
            }
            return false;
        }

        private final void ensureLimit() {
            while (this.aggregates.size() > 10) {
                this.aggregates.remove(this.aggregates.firstKey());
            }
        }

        private static final Double incrementOnToday$lambda$0$0(String string, Double oldValue) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
            Double d = oldValue;
            return d == null ? Double.valueOf(1.0) : Double.valueOf(d + 1.0);
        }

        private static final Double incrementOnToday$lambda$0$1(Function2 $tmp0, Object p0, Object p1) {
            return (Double)$tmp0.invoke(p0, p1);
        }

        private static final Unit incrementOnToday$lambda$0(String $key, Map $this$updateOnDate) {
            Intrinsics.checkNotNullParameter((Object)$this$updateOnDate, (String)"$this$updateOnDate");
            $this$updateOnDate.compute($key, (arg_0, arg_1) -> DailyAggregateFactor.incrementOnToday$lambda$0$1(DailyAggregateFactor::incrementOnToday$lambda$0$0, arg_0, arg_1));
            return Unit.INSTANCE;
        }

        public /* synthetic */ DailyAggregateFactor(SortedMap aggregates, DefaultConstructorMarker $constructor_marker) {
            this(aggregates);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/completion/ml/personalization/impl/UserFactorStorageBase$DailyAggregateFactor$Companion;", "", "<init>", "()V", "DAYS_LIMIT", "", "restore", "Lcom/intellij/completion/ml/personalization/impl/UserFactorStorageBase$DailyAggregateFactor;", "element", "Lorg/jdom/Element;", "intellij.completionMlRanking"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final DailyAggregateFactor restore(@NotNull Element element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                SortedMap data = MapsKt.sortedMapOf((Pair[])new Pair[0]);
                for (Element child : element.getChildren()) {
                    String date = child.getAttributeValue("date");
                    Intrinsics.checkNotNull((Object)date);
                    Day day = DayImpl.Companion.fromString(date);
                    if (!Intrinsics.areEqual((Object)child.getName(), (Object)"dailyData") || day == null) continue;
                    Intrinsics.checkNotNull((Object)child);
                    DailyData dailyData = DailyData.Companion.restore(child);
                    if (dailyData == null) continue;
                    data.put(day, dailyData);
                }
                if (data.isEmpty()) {
                    return null;
                }
                return new DailyAggregateFactor(data, null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u001d\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"Lcom/intellij/completion/ml/personalization/impl/UserFactorStorageBase$DailyData;", "", "data", "", "", "", "<init>", "(Ljava/util/Map;)V", "getData", "()Ljava/util/Map;", "writeState", "", "element", "Lorg/jdom/Element;", "Companion", "intellij.completionMlRanking"})
    @SourceDebugExtension(value={"SMAP\nUserFactorStorageBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserFactorStorageBase.kt\ncom/intellij/completion/ml/personalization/impl/UserFactorStorageBase$DailyData\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,181:1\n614#2:182\n13#3:183\n*S KotlinDebug\n*F\n+ 1 UserFactorStorageBase.kt\ncom/intellij/completion/ml/personalization/impl/UserFactorStorageBase$DailyData\n*L\n173#1:182\n146#1:183\n*E\n"})
    private static final class DailyData {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Map<String, Double> data;
        @NotNull
        private static final Logger LOG;

        public DailyData(@NotNull Map<String, Double> data) {
            Intrinsics.checkNotNullParameter(data, (String)"data");
            this.data = data;
        }

        public /* synthetic */ DailyData(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = new HashMap();
            }
            this(map);
        }

        @NotNull
        public final Map<String, Double> getData() {
            return this.data;
        }

        public final void writeState(@NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Sequence $this$sortedBy$iv = MapsKt.asSequence(this.data);
            boolean $i$f$sortedBy = false;
            for (Map.Entry entry : SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Map.Entry it = (Map.Entry)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)((String)it.getKey()));
                    it = (Map.Entry)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((String)it.getKey()))));
                }
            })) {
                String key = (String)entry.getKey();
                double value = ((Number)entry.getValue()).doubleValue();
                Element observation = new Element("observation");
                observation.setAttribute("name", key);
                observation.setAttribute("value", Companion.getDOUBLE_VALUE_FORMATTER().format(value));
                element.addContent(observation);
            }
        }

        public DailyData() {
            this(null, 1, null);
        }

        static {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(DailyData.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            LOG = logger;
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/completion/ml/personalization/impl/UserFactorStorageBase$DailyData$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "restore", "Lcom/intellij/completion/ml/personalization/impl/UserFactorStorageBase$DailyData;", "element", "Lorg/jdom/Element;", "intellij.completionMlRanking"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final DailyData restore(@NotNull Element element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Map data = new LinkedHashMap();
                for (Element child : element.getChildren()) {
                    double d;
                    if (!Intrinsics.areEqual((Object)child.getName(), (Object)"observation")) continue;
                    String dataKey = child.getAttributeValue("name");
                    String dataValue = child.getAttributeValue("value");
                    try {
                        d = Companion.getDOUBLE_VALUE_FORMATTER().parse(dataValue).doubleValue();
                    }
                    catch (ParseException e) {
                        LOG.error((Throwable)e);
                        return null;
                    }
                    double value = d;
                    data.put(dataKey, value);
                }
                if (data.isEmpty()) {
                    return null;
                }
                return new DailyData(data);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

