/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.basic.BasicModNamespace;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.database.view.DbSchemaNode;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbNamespaceNode
extends DbSchemaNode<DbNamespaceNode> {
    private CurNode myCurNode = null;
    private List<DbNamespaceNode> myFilterChildren = null;

    public DbNamespaceNode(String name, BasicMetaObject<?> meta, Object object) {
        super(name, meta, object);
    }

    @Nullable
    public CurNode getCurrentSibling() {
        DbNamespaceNode parent = (DbNamespaceNode)this.getParent();
        return parent == null ? null : parent.getCurNode();
    }

    @Nullable
    public CurNode getCurNode() {
        return this.myCurNode;
    }

    @Override
    @NotNull
    protected DbNamespaceNode createAll(@NotNull BasicMetaObject<?> meta) {
        if (meta == null) {
            DbNamespaceNode.$$$reportNull$$$0(0);
        }
        DbNamespaceNode node = new DbNamespaceNode("All", meta, "*");
        node.setHasAllAndCur(true);
        DbNamespaceNode dbNamespaceNode = node;
        if (dbNamespaceNode == null) {
            DbNamespaceNode.$$$reportNull$$$0(1);
        }
        return dbNamespaceNode;
    }

    @Override
    @NotNull
    public Iterable<DbNamespaceNode> getSimpleChildNodes() {
        JBIterable jBIterable = JBIterable.of((Object)this.myCurNode).append(this.myFilterChildren).append(super.getSimpleChildNodes());
        if (jBIterable == null) {
            DbNamespaceNode.$$$reportNull$$$0(2);
        }
        return jBIterable;
    }

    @NotNull
    public List<DbNamespaceNode> getFilterChildren() {
        List list = (List)ObjectUtils.chooseNotNull(this.myFilterChildren, Collections.emptyList());
        if (list == null) {
            DbNamespaceNode.$$$reportNull$$$0(3);
        }
        return list;
    }

    public void setFilterChildren(@Nullable Collection<DbNamespaceNode> filters) {
        DbNamespaceNode.reparent(this.myFilterChildren, null);
        this.myFilterChildren = ContainerUtil.isEmpty(filters) ? null : new SmartList(filters);
        this.reparent(this.myFilterChildren);
    }

    public void setHasAllAndCur(boolean has) {
        this.setHasAll(has);
        if (has == (this.myCurNode != null)) {
            return;
        }
        BasicMetaObject<?> child = this.findChild(DbNamespaceNode::canBeCurrent);
        if (has && child != null) {
            this.myCurNode = new CurNode(child, null);
            this.myCurNode.setHasAllAndCur(true);
            this.reparent(Collections.singletonList(this.myCurNode));
        } else {
            this.myCurNode = null;
        }
    }

    private static boolean canBeCurrent(@NotNull BasicMetaObject<?> obj) {
        if (obj == null) {
            DbNamespaceNode.$$$reportNull$$$0(4);
        }
        if (!obj.kindOf(BasicNamespace.class)) {
            return false;
        }
        BasicMetaProperty curProperty = obj.getObjectProperty(BasicModNamespace.CURRENT);
        return curProperty != null && !curProperty.isAbstract();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/DbNamespaceNode";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/DbNamespaceNode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createAll";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSimpleChildNodes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createAll";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "canBeCurrent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }

    public static class CurNode
    extends DbNamespaceNode {
        private DasObject myCurObject;

        CurNode(BasicMetaObject<?> meta, DasObject curObject) {
            super("Current", meta, "@");
            this.myCurObject = curObject;
        }

        public DasObject getCurObject() {
            return this.myCurObject;
        }

        public void setCurObject(DasObject curObject) {
            this.myCurObject = curObject;
        }
    }
}

