/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.session;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.concurrency.ThreadContext;
import com.intellij.database.DataBus;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.connection.throwable.info.ThrowableInfo;
import com.intellij.database.connection.throwable.info.ThrowableInfoUtil;
import com.intellij.database.console.client.DatabaseSessionClient;
import com.intellij.database.console.client.VisibleDatabaseSessionClient;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.console.session.DatabaseSessionManagerListener;
import com.intellij.database.console.session.DatabaseSessionViewService;
import com.intellij.database.console.session.MessageBusSession;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.InterruptibleDatabaseConnection;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.ConnectionRequestor;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.dataSource.connection.audit.AdvancedAuditService;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.GridDataRequest;
import com.intellij.database.introspection.DbmsMismatchException;
import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.database.remote.jdbc.RemoteDatabaseMetaData;
import com.intellij.database.remote.jdbc.RemoteSavepoint;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.AsyncUtil;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.GuardedRef;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.Version;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u000b6789:;<=>?@B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0003J$\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\n\b\u0001\u0010\u0012\u001a\u0004\u0018\u00010\rH\u0003J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u00182\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u001e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u00182\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J(\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u00182\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0007J\u0018\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J$\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\n\b\u0001\u0010\u001e\u001a\u0004\u0018\u00010\rH\u0007J\"\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u001e\u001a\u00020\rH\u0007J$\u0010 \u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\n\b\u0001\u0010\u001e\u001a\u0004\u0018\u00010\rH\u0007JB\u0010!\u001a\u00020\"2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010#\u001a\u0004\u0018\u00010$2\n\b\u0002\u0010%\u001a\u0004\u0018\u00010&2\n\b\u0002\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020*H\u0007JH\u0010!\u001a\u00020\"2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010#\u001a\u0004\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010+\u001a\u00020,2\n\b\u0002\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020*H\u0007J@\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010+\u001a\u00020,2\n\b\u0003\u0010\u001e\u001a\u0004\u0018\u00010\r2\b\b\u0002\u0010-\u001a\u00020.H\u0003J\u0010\u0010/\u001a\u0002002\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J!\u00101\u001a\u0002H2\"\u0004\b\u0000\u001022\f\u00103\u001a\b\u0012\u0004\u0012\u0002H204H\u0002\u00a2\u0006\u0002\u00105R/\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\b8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\t\u0010\u0003\u001a\u0004\b\n\u0010\u000b\u00a8\u0006A"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager;", "", "<init>", "()V", "topic", "Lcom/intellij/util/messages/Topic;", "Lcom/intellij/database/console/session/DatabaseSessionManagerListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getTopic$annotations", "getTopic", "()Lcom/intellij/util/messages/Topic;", "generateNameForSession", "", "project", "Lcom/intellij/openapi/project/Project;", "connectionPoint", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "prefix", "findSession", "Lcom/intellij/database/console/session/DatabaseSession;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getSessions", "", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "configuration", "Lcom/intellij/database/run/ConsoleRunConfiguration;", "getSession", "title", "getExactSession", "openSession", "getFacade", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade;", "credentialsStore", "Lcom/intellij/database/access/DatabaseCredentials;", "path", "Lcom/intellij/database/util/SearchPath;", "handler", "Lcom/intellij/database/util/ErrorHandler;", "department", "Lcom/intellij/database/dataSource/connection/DatabaseDepartment;", "silent", "", "type", "Lcom/intellij/database/console/session/DatabaseSessionManager$SessionType;", "projectScopedSessions", "Lcom/intellij/database/console/session/DatabaseSessionManager$ProjectSessions;", "onEdt", "T", "computable", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "ProjectSessions", "Factories", "Factory", "MultiConnection", "SingleConnection", "Facade", "WrapperRequest", "TemporaryClient", "Indexer", "SessionType", "ConnectionWithClient", "intellij.database.connectivity"})
@SourceDebugExtension(value={"SMAP\nDatabaseSessionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseSessionManager.kt\ncom/intellij/database/console/session/DatabaseSessionManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,687:1\n873#2,2:688\n1021#2,2:690\n777#2:692\n873#2,2:693\n777#2:695\n873#2,2:696\n1#3:698\n30#4,2:699\n*S KotlinDebug\n*F\n+ 1 DatabaseSessionManager.kt\ncom/intellij/database/console/session/DatabaseSessionManager\n*L\n76#1:688,2\n77#1:690,2\n83#1:692\n83#1:693,2\n88#1:695\n88#1:696,2\n146#1:699,2\n*E\n"})
public final class DatabaseSessionManager {
    @NotNull
    public static final DatabaseSessionManager INSTANCE = new DatabaseSessionManager();
    @NotNull
    private static final Topic<DatabaseSessionManagerListener> topic;

    private DatabaseSessionManager() {
    }

    @NotNull
    public static final Topic<DatabaseSessionManagerListener> getTopic() {
        return topic;
    }

    @JvmStatic
    public static /* synthetic */ void getTopic$annotations() {
    }

    @Nls
    private final String generateNameForSession(Project project, DatabaseConnectionPoint connectionPoint) {
        return this.generateNameForSession(project, connectionPoint, null);
    }

    @Nls
    private final String generateNameForSession(Project project, DatabaseConnectionPoint connectionPoint, @Nls String prefix) {
        Object object;
        LocalDataSource localDataSource = connectionPoint.getDataSource();
        Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
        Sequence sessions = SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)DatabaseSessionManager.getSessions(project, localDataSource)), arg_0 -> DatabaseSessionManager.generateNameForSession$lambda$0(prefix, arg_0)), DatabaseSessionManager::generateNameForSession$lambda$1);
        Long idx = Indexer.INSTANCE.generateIndex(SequencesKt.toList((Sequence)SequencesKt.distinct((Sequence)SequencesKt.plus((Sequence)sessions, (Object)"default"))), prefix);
        if (prefix == null) {
            object = idx;
            if (object == null || (object = String.valueOf((Long)object)) == null) {
                object = "1";
            }
        } else {
            object = idx == null ? prefix : prefix + " " + idx;
        }
        return object;
    }

    @JvmStatic
    @Nullable
    public static final DatabaseSession findSession(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return DatabaseSessionViewService.Companion.getInstance().findDatabaseSession(e);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<DatabaseSession> getSessions(@NotNull Project project) {
        void $this$filterTo$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Iterable iterable = INSTANCE.projectScopedSessions(project).getSessions();
        Collection destination$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            DatabaseSession it = (DatabaseSession)element$iv;
            boolean bl = false;
            if (!(!it.isInternal())) continue;
            destination$iv.add(element$iv);
        }
        ArrayList sessions = (ArrayList)destination$iv;
        List $this$sortBy$iv = sessions;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    DatabaseSession it = (DatabaseSession)a;
                    boolean bl = false;
                    int n = it.isService() ? 0 : 1;
                    it = (DatabaseSession)b;
                    Comparable comparable = Integer.valueOf(n);
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(it.isService() ? 0 : 1));
                }
            });
        }
        return sessions;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<DatabaseSession> getSessions(@NotNull Project project, @NotNull LocalDataSource dataSource) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Iterable $this$filter$iv = DatabaseSessionManager.getSessions(project);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DatabaseSession it = (DatabaseSession)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getTarget(), (Object)dataSource)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<DatabaseSession> getSessions(@NotNull Project project, @NotNull LocalDataSource dataSource, @Nullable ConsoleRunConfiguration configuration) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Iterable $this$filter$iv = DatabaseSessionManager.getSessions(project, dataSource);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DatabaseSession it = (DatabaseSession)element$iv$iv;
            boolean bl = false;
            if (!(configuration == null || Intrinsics.areEqual((Object)((Object)it.getConfiguration()), (Object)((Object)configuration)))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @JvmStatic
    @NotNull
    public static final DatabaseSession getSession(@NotNull Project project, @NotNull DatabaseConnectionPoint connectionPoint) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)connectionPoint, (String)"connectionPoint");
        return DatabaseSessionManager.getSession$default(project, connectionPoint, null, false, null, null, 32, null);
    }

    @JvmStatic
    @NotNull
    public static final DatabaseSession getSession(@NotNull Project project, @NotNull DatabaseConnectionPoint connectionPoint, @Nls @Nullable String title) {
        DatabaseSession databaseSession;
        Object v1;
        block2: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)connectionPoint, (String)"connectionPoint");
            LocalDataSource localDataSource = connectionPoint.getDataSource();
            Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
            Iterable iterable = DatabaseSessionManager.getSessions(project, localDataSource);
            for (Object t : iterable) {
                DatabaseSession it = (DatabaseSession)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getTitle(), (Object)title)) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        if ((databaseSession = (DatabaseSession)v1) == null) {
            databaseSession = DatabaseSessionManager.getSession$default(project, connectionPoint, null, false, title, null, 32, null);
        }
        return databaseSession;
    }

    @JvmStatic
    @NotNull
    public static final DatabaseSession getExactSession(@NotNull Project project, @NotNull DatabaseConnectionPoint connectionPoint, @Nls @NotNull String title) {
        DatabaseSession databaseSession;
        Object v1;
        block2: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)connectionPoint, (String)"connectionPoint");
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            LocalDataSource localDataSource = connectionPoint.getDataSource();
            Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
            Iterable iterable = DatabaseSessionManager.getSessions(project, localDataSource);
            for (Object t : iterable) {
                DatabaseSession it = (DatabaseSession)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getTitle(), (Object)title)) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        if ((databaseSession = (DatabaseSession)v1) == null) {
            databaseSession = DatabaseSessionManager.getSession(project, connectionPoint, null, false, title, SessionType.NEW);
        }
        return databaseSession;
    }

    @JvmStatic
    @NotNull
    public static final DatabaseSession openSession(@NotNull Project project, @NotNull DatabaseConnectionPoint connectionPoint, @Nls @Nullable String title) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)connectionPoint, (String)"connectionPoint");
        return DatabaseSessionManager.getSession(project, connectionPoint, null, false, INSTANCE.generateNameForSession(project, connectionPoint, title), SessionType.NEW);
    }

    @JvmStatic
    @NotNull
    public static final Facade getFacade(@NotNull Project project, @NotNull DatabaseConnectionPoint connectionPoint, @Nullable DatabaseCredentials credentialsStore, @Nullable SearchPath path, @Nullable ErrorHandler handler, @NotNull DatabaseDepartment department) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)connectionPoint, (String)"connectionPoint");
        Intrinsics.checkNotNullParameter((Object)department, (String)"department");
        return DatabaseSessionManager.getFacade(project, connectionPoint, credentialsStore, path, false, handler, department);
    }

    public static /* synthetic */ Facade getFacade$default(Project project, DatabaseConnectionPoint databaseConnectionPoint, DatabaseCredentials databaseCredentials, SearchPath searchPath, ErrorHandler errorHandler, DatabaseDepartment databaseDepartment, int n, Object object) {
        if ((n & 8) != 0) {
            searchPath = null;
        }
        if ((n & 0x10) != 0) {
            errorHandler = null;
        }
        return DatabaseSessionManager.getFacade(project, databaseConnectionPoint, databaseCredentials, searchPath, errorHandler, databaseDepartment);
    }

    @JvmStatic
    @NotNull
    public static final Facade getFacade(@NotNull Project project, @NotNull DatabaseConnectionPoint connectionPoint, @Nullable DatabaseCredentials credentialsStore, @Nullable SearchPath path, boolean silent, @Nullable ErrorHandler handler, @NotNull DatabaseDepartment department) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)connectionPoint, (String)"connectionPoint");
        Intrinsics.checkNotNullParameter((Object)department, (String)"department");
        return new Facade(connectionPoint, credentialsStore, project, path, silent, handler, department);
    }

    public static /* synthetic */ Facade getFacade$default(Project project, DatabaseConnectionPoint databaseConnectionPoint, DatabaseCredentials databaseCredentials, SearchPath searchPath, boolean bl, ErrorHandler errorHandler, DatabaseDepartment databaseDepartment, int n, Object object) {
        if ((n & 0x20) != 0) {
            errorHandler = null;
        }
        return DatabaseSessionManager.getFacade(project, databaseConnectionPoint, databaseCredentials, searchPath, bl, errorHandler, databaseDepartment);
    }

    @JvmStatic
    private static final DatabaseSession getSession(Project project, DatabaseConnectionPoint connectionPoint, DatabaseCredentials credentialsStore, boolean silent, @Nls String title, SessionType type) {
        String sessionTitle = Intrinsics.areEqual((Object)title, (Object)"default") ? INSTANCE.generateNameForSession(project, connectionPoint, "default") : title;
        return INSTANCE.projectScopedSessions(project).getSession(project, connectionPoint, credentialsStore, silent, sessionTitle, type);
    }

    static /* synthetic */ DatabaseSession getSession$default(Project project, DatabaseConnectionPoint databaseConnectionPoint, DatabaseCredentials databaseCredentials, boolean bl, String string, SessionType sessionType, int n, Object object) {
        if ((n & 0x10) != 0) {
            string = null;
        }
        if ((n & 0x20) != 0) {
            sessionType = SessionType.NOT_IMPORTANT;
        }
        return DatabaseSessionManager.getSession(project, databaseConnectionPoint, databaseCredentials, bl, string, sessionType);
    }

    private final ProjectSessions projectScopedSessions(Project project) {
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<ProjectSessions> serviceClass$iv = ProjectSessions.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return (ProjectSessions)object;
    }

    private final <T> T onEdt(Function0<? extends T> computable) {
        Ref.ObjectRef result = new Ref.ObjectRef();
        ActionsKt.invokeAndWaitIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> DatabaseSessionManager.onEdt$lambda$0(result, computable));
        Object object = result.element;
        Intrinsics.checkNotNull((Object)object);
        Object object2 = ((Result)object).unbox-impl();
        ResultKt.throwOnFailure((Object)object2);
        return (T)object2;
    }

    private static final boolean generateNameForSession$lambda$0(String $prefix, DatabaseSession it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $prefix == null && StringUtil.isNotNegativeNumber((CharSequence)it.getTitle()) || $prefix != null && StringsKt.startsWith$default((String)it.getTitle(), (String)$prefix, (boolean)false, (int)2, null);
    }

    private static final String generateNameForSession$lambda$1(DatabaseSession it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getTitle();
    }

    private static final Unit onEdt$lambda$0(Ref.ObjectRef $result, Function0 $computable) {
        Object object;
        DatabaseSessionManager databaseSessionManager = INSTANCE;
        Ref.ObjectRef objectRef = $result;
        try {
            DatabaseSessionManager $this$onEdt_u24lambda_u240_u240 = databaseSessionManager;
            boolean bl = false;
            object = Result.constructor-impl((Object)$computable.invoke());
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        objectRef.element = Result.box-impl((Object)object);
        return Unit.INSTANCE;
    }

    static {
        Topic topic = Topic.create((String)"database session manager topic", DatabaseSessionManagerListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"create(...)");
        DatabaseSessionManager.topic = topic;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016J\t\u0010\u000f\u001a\u00020\u0001H\u00c2\u0003J\t\u0010\u0010\u001a\u00020\u0006H\u00c2\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00012\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\t\u0010\u0012\u001a\u00020\u000eH\u0096\u0001J\u0014\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0083\u0004J\u0013\u0010\u0017\u001a\f0\u0018\u00a2\u0006\u0002\b\u0019\u00a2\u0006\u0002\b\u001aH\u0097\u0001J\t\u0010\u001b\u001a\u00020\u0014H\u0096\u0001J\u0013\u0010\u001c\u001a\f0\u001d\u00a2\u0006\u0002\b\u0019\u00a2\u0006\u0002\b\u001aH\u0097\u0001J\u0013\u0010\u001e\u001a\f0\u001f\u00a2\u0006\u0002\b\u0019\u00a2\u0006\u0002\b\u001aH\u0097\u0001J\u0013\u0010 \u001a\f0!\u00a2\u0006\u0002\b\u0019\u00a2\u0006\u0002\b\u001aH\u0097\u0001J\u0013\u0010\"\u001a\f0#\u00a2\u0006\u0002\b\u0019\u00a2\u0006\u0002\b\u001aH\u0097\u0001J\u0013\u0010$\u001a\f0%\u00a2\u0006\u0002\b\u0019\u00a2\u0006\u0002\b\u001aH\u0097\u0001J\u0015\u0010&\u001a\u000e\u0018\u00010'\u00a2\u0006\u0002\b(\u00a2\u0006\u0002\b\u001aH\u0097\u0001J\u0013\u0010)\u001a\f0*\u00a2\u0006\u0002\b\u0019\u00a2\u0006\u0002\b\u001aH\u0097\u0001J\u0013\u0010+\u001a\f0#\u00a2\u0006\u0002\b\u0019\u00a2\u0006\u0002\b\u001aH\u0097\u0001J\n\u0010,\u001a\u00020-H\u00d6\u0081\u0004J\t\u0010.\u001a\u00020\u0014H\u0096\u0001J\u001d\u0010/\u001a\u00020\u000e2\u0012\b\u0001\u00100\u001a\f01\u00a2\u0006\u0002\b\u0019\u00a2\u0006\u0002\b\u001aH\u0096\u0001J\t\u00102\u001a\u00020\u000eH\u0096\u0001J\u001d\u00102\u001a\u00020\u000e2\u0012\b\u0001\u00100\u001a\f01\u00a2\u0006\u0002\b\u0019\u00a2\u0006\u0002\b\u001aH\u0096\u0001J\u0011\u00103\u001a\u00020\u000e2\u0006\u00104\u001a\u00020\u0014H\u0096\u0001J\u0011\u00105\u001a\u00020\u000e2\u0006\u00106\u001a\u00020\u0014H\u0096\u0001J\u0011\u00107\u001a\n 8*\u0004\u0018\u00010101H\u0096\u0001J\n\u00109\u001a\u00020:H\u00d6\u0081\u0004R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006;"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$ConnectionWithClient;", "Lcom/intellij/database/dataSource/DatabaseConnection;", "Lcom/intellij/database/dataSource/InterruptibleDatabaseConnection;", "Lcom/intellij/database/dataSource/connection/statements/SmartStatements$PurposedConnection;", "connection", "client", "Lcom/intellij/database/console/client/DatabaseSessionClient;", "<init>", "(Lcom/intellij/database/dataSource/DatabaseConnection;Lcom/intellij/database/console/client/DatabaseSessionClient;)V", "department", "Lcom/intellij/database/dataSource/connection/DatabaseDepartment;", "getDepartment", "()Lcom/intellij/database/dataSource/connection/DatabaseDepartment;", "interrupt", "", "component1", "component2", "copy", "commit", "equals", "", "other", "", "getAuditService", "Lcom/intellij/database/dataSource/connection/audit/AdvancedAuditService;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "getAutoCommit", "getConfiguration", "Lcom/intellij/database/run/ConsoleRunConfiguration;", "getConnectionPoint", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "getDbms", "Lcom/intellij/database/Dbms;", "getDriverVersion", "Lcom/intellij/database/util/Version;", "getRemoteConnection", "Lcom/intellij/database/remote/jdbc/RemoteConnection;", "getRemoteMetaData", "Lcom/intellij/database/remote/jdbc/RemoteDatabaseMetaData;", "Lorg/jetbrains/annotations/Nullable;", "getRequestor", "Lcom/intellij/database/dataSource/connection/ConnectionRequestor;", "getVersion", "hashCode", "", "isReadOnly", "releaseSavepoint", "savepoint", "Lcom/intellij/database/remote/jdbc/RemoteSavepoint;", "rollback", "setAutoCommit", "p0", "setReadOnly", "only", "setSavepoint", "kotlin.jvm.PlatformType", "toString", "", "intellij.database.connectivity"})
    private static final class ConnectionWithClient
    implements DatabaseConnection,
    InterruptibleDatabaseConnection,
    SmartStatements.PurposedConnection {
        @NotNull
        private final DatabaseConnection connection;
        @NotNull
        private final DatabaseSessionClient client;

        public ConnectionWithClient(@NotNull DatabaseConnection connection2, @NotNull DatabaseSessionClient client) {
            Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            this.connection = connection2;
            this.client = client;
        }

        @Override
        @NotNull
        public DatabaseDepartment getDepartment() {
            DatabaseDepartment databaseDepartment = this.client.getDepartment();
            Intrinsics.checkNotNullExpressionValue((Object)databaseDepartment, (String)"getDepartment(...)");
            return databaseDepartment;
        }

        @Override
        public void interrupt() {
            this.client.getMessageBus().getDataProducer().processRequest((GridDataRequest)new DataRequest.Cancel((DataRequest.OwnerEx)this.client));
        }

        private final DatabaseConnection component1() {
            return this.connection;
        }

        private final DatabaseSessionClient component2() {
            return this.client;
        }

        @NotNull
        public final ConnectionWithClient copy(@NotNull DatabaseConnection connection2, @NotNull DatabaseSessionClient client) {
            Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            return new ConnectionWithClient(connection2, client);
        }

        public static /* synthetic */ ConnectionWithClient copy$default(ConnectionWithClient connectionWithClient, DatabaseConnection databaseConnection, DatabaseSessionClient databaseSessionClient, int n, Object object) {
            if ((n & 1) != 0) {
                databaseConnection = connectionWithClient.connection;
            }
            if ((n & 2) != 0) {
                databaseSessionClient = connectionWithClient.client;
            }
            return connectionWithClient.copy(databaseConnection, databaseSessionClient);
        }

        @NotNull
        public String toString() {
            return "ConnectionWithClient(connection=" + this.connection + ", client=" + this.client + ")";
        }

        public int hashCode() {
            int result = this.connection.hashCode();
            result = result * 31 + this.client.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ConnectionWithClient)) {
                return false;
            }
            ConnectionWithClient connectionWithClient = (ConnectionWithClient)other;
            if (!Intrinsics.areEqual((Object)this.connection, (Object)connectionWithClient.connection)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.client, (Object)connectionWithClient.client);
        }

        @Override
        @NotNull
        public DatabaseConnectionPoint getConnectionPoint() {
            DatabaseConnectionPoint databaseConnectionPoint = this.connection.getConnectionPoint();
            Intrinsics.checkNotNullExpressionValue((Object)databaseConnectionPoint, (String)"getConnectionPoint(...)");
            return databaseConnectionPoint;
        }

        @Override
        @NotNull
        public ConnectionRequestor getRequestor() {
            ConnectionRequestor connectionRequestor = this.connection.getRequestor();
            Intrinsics.checkNotNullExpressionValue((Object)connectionRequestor, (String)"getRequestor(...)");
            return connectionRequestor;
        }

        @Override
        @NotNull
        public ConsoleRunConfiguration getConfiguration() {
            ConsoleRunConfiguration consoleRunConfiguration = this.connection.getConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)consoleRunConfiguration), (String)"getConfiguration(...)");
            return consoleRunConfiguration;
        }

        @Override
        public void setReadOnly(boolean only) {
            this.connection.setReadOnly(only);
        }

        @Override
        public boolean isReadOnly() {
            return this.connection.isReadOnly();
        }

        @Override
        public void rollback() {
            this.connection.rollback();
        }

        @Override
        public void rollback(@NotNull RemoteSavepoint savepoint) {
            Intrinsics.checkNotNullParameter((Object)savepoint, (String)"savepoint");
            this.connection.rollback(savepoint);
        }

        @Override
        public void releaseSavepoint(@NotNull RemoteSavepoint savepoint) {
            Intrinsics.checkNotNullParameter((Object)savepoint, (String)"savepoint");
            this.connection.releaseSavepoint(savepoint);
        }

        @Override
        public RemoteSavepoint setSavepoint() {
            return this.connection.setSavepoint();
        }

        @NotNull
        public RemoteConnection getRemoteConnection() {
            RemoteConnection remoteConnection = this.connection.getRemoteConnection();
            Intrinsics.checkNotNullExpressionValue((Object)remoteConnection, (String)"getRemoteConnection(...)");
            return remoteConnection;
        }

        @NotNull
        public Dbms getDbms() {
            Dbms dbms = this.connection.getDbms();
            Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
            return dbms;
        }

        @NotNull
        public Version getVersion() {
            Version version = this.connection.getVersion();
            Intrinsics.checkNotNullExpressionValue((Object)version, (String)"getVersion(...)");
            return version;
        }

        @NotNull
        public Version getDriverVersion() {
            Version version = this.connection.getDriverVersion();
            Intrinsics.checkNotNullExpressionValue((Object)version, (String)"getDriverVersion(...)");
            return version;
        }

        public boolean getAutoCommit() {
            return this.connection.getAutoCommit();
        }

        public void setAutoCommit(boolean p0) {
            this.connection.setAutoCommit(p0);
        }

        public void commit() {
            this.connection.commit();
        }

        @Nullable
        public RemoteDatabaseMetaData getRemoteMetaData() {
            return this.connection.getRemoteMetaData();
        }

        @NotNull
        public AdvancedAuditService getAuditService() {
            AdvancedAuditService advancedAuditService = this.connection.getAuditService();
            Intrinsics.checkNotNullExpressionValue((Object)advancedAuditService, (String)"getAuditService(...)");
            return advancedAuditService;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 92\u00020\u0001:\t9:;<=>?@ABM\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J(\u0010\u0016\u001a\u0002H\u0017\"\u0004\b\u0000\u0010\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u0002H\u00170\u0019H\u0086@\u00a2\u0006\u0002\u0010\u001bJ&\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u00170\u001d\"\u0004\b\u0000\u0010\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u0002H\u00170\u0019J%\u0010\u001e\u001a\u0002H\u0017\"\u0004\b\u0000\u0010\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u0002H\u00170\u0019\u00a2\u0006\u0002\u0010\u001fJ%\u0010 \u001a\u0002H\u0017\"\u0004\b\u0000\u0010\u00172\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u0002H\u00170\u0019\u00a2\u0006\u0002\u0010\u001fJ\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$J\u0010\u0010&\u001a\n\u0012\u0004\u0012\u00020'\u0018\u00010$H\u0002J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020'0$H\u0002J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020'H\u0002J\u0006\u0010,\u001a\u00020-J\u000e\u0010,\u001a\u00020.2\u0006\u0010/\u001a\u000200J/\u00101\u001a\u0002H\u0017\"\u0004\b\u0000\u0010\u00172\u0006\u0010+\u001a\u00020'2\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u0002H\u00170\u0019H\u0002\u00a2\u0006\u0002\u00102JA\u00101\u001a\u0002H\u0017\"\u0004\b\u0000\u0010\u0017\"\b\b\u0001\u00103*\u00020%2\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u0002H3\u0012\u0004\u0012\u0002H\u00170\u00192\u0006\u0010(\u001a\u0002H32\u0006\u00104\u001a\u000205H\u0002\u00a2\u0006\u0002\u00106J(\u00107\u001a\u0002H\u0017\"\u0004\b\u0000\u0010\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u0002H\u00170\u0019H\u0082@\u00a2\u0006\u0002\u0010\u001bJ0\u00107\u001a\u0002H\u0017\"\u0004\b\u0000\u0010\u00172\u0006\u0010,\u001a\u00020-2\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u0002H\u00170\u0019H\u0082@\u00a2\u0006\u0002\u00108R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$Facade;", "", "connectionPoint", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "credentialsStore", "Lcom/intellij/database/access/DatabaseCredentials;", "project", "Lcom/intellij/openapi/project/Project;", "path", "Lcom/intellij/database/util/SearchPath;", "silent", "", "handler", "Lcom/intellij/database/util/ErrorHandler;", "department", "Lcom/intellij/database/dataSource/connection/DatabaseDepartment;", "<init>", "(Lcom/intellij/database/dataSource/DatabaseConnectionPoint;Lcom/intellij/database/access/DatabaseCredentials;Lcom/intellij/openapi/project/Project;Lcom/intellij/database/util/SearchPath;ZLcom/intellij/database/util/ErrorHandler;Lcom/intellij/database/dataSource/connection/DatabaseDepartment;)V", "getConnectionPoint", "()Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "getPath", "()Lcom/intellij/database/util/SearchPath;", "run", "T", "work", "Lkotlin/Function1;", "Lcom/intellij/database/dataSource/InterruptibleDatabaseConnection;", "(Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "runAsync", "Lcom/intellij/database/util/AsyncTask;", "runSync", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "multiRunSync", "worker", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$Runner;", "connect", "Lcom/intellij/database/util/GuardedRef;", "Lcom/intellij/database/dataSource/DatabaseConnection;", "currentConnection", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionInfo;", "connection", "checkBounds", "", "info", "client", "Lcom/intellij/database/console/client/DatabaseSessionClient;", "Lcom/intellij/database/console/client/VisibleDatabaseSessionClient;", "session", "Lcom/intellij/database/console/session/DatabaseSession;", "compute", "(Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionInfo;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "C", "context", "Lcom/intellij/database/datagrid/DataRequest$Context;", "(Lkotlin/jvm/functions/Function1;Lcom/intellij/database/dataSource/DatabaseConnection;Lcom/intellij/database/datagrid/DataRequest$Context;)Ljava/lang/Object;", "perform", "(Lcom/intellij/database/console/client/DatabaseSessionClient;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "Runner", "ConnectionInfo", "ConnectionReference", "Lockpick", "ConnectionsRouter", "SingleSessionRouter", "MultipleSessionsRouter", "Routers", "intellij.database.connectivity"})
    @SourceDebugExtension(value={"SMAP\nDatabaseSessionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseSessionManager.kt\ncom/intellij/database/console/session/DatabaseSessionManager$Facade\n+ 2 extensions.kt\ncom/intellij/openapi/util/ExtensionsKt\n+ 3 CancellableContinuation.kt\nkotlinx/coroutines/CancellableContinuationKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,687:1\n22#2,6:688\n22#2,6:694\n426#3,11:700\n1#4:711\n*S KotlinDebug\n*F\n+ 1 DatabaseSessionManager.kt\ncom/intellij/database/console/session/DatabaseSessionManager$Facade\n*L\n304#1:688,6\n414#1:694,6\n421#1:700,11\n*E\n"})
    public static final class Facade {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @NotNull
        private final DatabaseConnectionPoint connectionPoint;
        @Nullable
        private final DatabaseCredentials credentialsStore;
        @NotNull
        private final Project project;
        @Nullable
        private final SearchPath path;
        private final boolean silent;
        @Nullable
        private final ErrorHandler handler;
        @NotNull
        private final DatabaseDepartment department;
        @NotNull
        private static final Routers routers = new Routers(MultipleSessionsRouter.INSTANCE, new SingleSessionRouter());

        public Facade(@NotNull DatabaseConnectionPoint connectionPoint, @Nullable DatabaseCredentials credentialsStore, @NotNull Project project, @Nullable SearchPath path, boolean silent, @Nullable ErrorHandler handler, @NotNull DatabaseDepartment department) {
            Intrinsics.checkNotNullParameter((Object)connectionPoint, (String)"connectionPoint");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)department, (String)"department");
            this.connectionPoint = connectionPoint;
            this.credentialsStore = credentialsStore;
            this.project = project;
            this.path = path;
            this.silent = silent;
            this.handler = handler;
            this.department = department;
        }

        public /* synthetic */ Facade(DatabaseConnectionPoint databaseConnectionPoint, DatabaseCredentials databaseCredentials, Project project, SearchPath searchPath, boolean bl, ErrorHandler errorHandler, DatabaseDepartment databaseDepartment, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                searchPath = null;
            }
            if ((n & 0x10) != 0) {
                bl = false;
            }
            if ((n & 0x20) != 0) {
                errorHandler = null;
            }
            this(databaseConnectionPoint, databaseCredentials, project, searchPath, bl, errorHandler, databaseDepartment);
        }

        @NotNull
        public final DatabaseConnectionPoint getConnectionPoint() {
            return this.connectionPoint;
        }

        @Nullable
        public final SearchPath getPath() {
            return this.path;
        }

        @Nullable
        public final <T> Object run(@NotNull Function1<? super InterruptibleDatabaseConnection, ? extends T> work, @NotNull Continuation<? super T> $completion) {
            return this.perform(arg_0 -> Facade.run$lambda$0(this, work, arg_0), $completion);
        }

        @NotNull
        public final <T> AsyncTask<T> runAsync(@NotNull Function1<? super InterruptibleDatabaseConnection, ? extends T> work) {
            Intrinsics.checkNotNullParameter(work, (String)"work");
            return AsyncTask.Frame.asAsyncTask$default((AsyncTask.Frame)AsyncTask.Companion.currentFrame(), null, (Function2)new Function2<CoroutineScope, Continuation<? super T>, Object>(this, work, null){
                int label;
                final /* synthetic */ Facade this$0;
                final /* synthetic */ Function1<InterruptibleDatabaseConnection, T> $work;
                {
                    this.this$0 = $receiver;
                    this.$work = $work;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = this.this$0.run(this.$work, (Continuation)this);
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super T> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, (int)1, null);
        }

        public final <T> T runSync(@NotNull Function1<? super InterruptibleDatabaseConnection, ? extends T> work) {
            Intrinsics.checkNotNullParameter(work, (String)"work");
            return this.multiRunSync(arg_0 -> Facade.runSync$lambda$0(work, arg_0));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final <T> T multiRunSync(@NotNull Function1<? super Runner, ? extends T> worker) {
            Object object;
            Intrinsics.checkNotNullParameter(worker, (String)"worker");
            GuardedRef<ConnectionInfo> guardedRef = this.currentConnection();
            if (guardedRef != null) {
                AutoCloseable autoCloseable = (AutoCloseable)guardedRef;
                Throwable throwable = null;
                try {
                    GuardedRef info = (GuardedRef)autoCloseable;
                    boolean bl = false;
                    Object object2 = worker.invoke((Object)new Runner(this, (GuardedRef<ConnectionInfo>)info){
                        final /* synthetic */ Facade this$0;
                        final /* synthetic */ GuardedRef<ConnectionInfo> $info;
                        {
                            this.this$0 = $receiver;
                            this.$info = $info;
                        }

                        public <T> T perform(Function1<? super InterruptibleDatabaseConnection, ? extends T> work) {
                            Intrinsics.checkNotNullParameter(work, (String)"work");
                            Object object = this.$info.get();
                            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                            return (T)Facade.access$compute(this.this$0, (ConnectionInfo)object, work);
                        }
                    });
                    return (T)object2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
            }
            Disposable $this$use$iv = this.client();
            boolean $i$f$use = false;
            try {
                DatabaseSessionClient client = (DatabaseSessionClient)$this$use$iv;
                boolean bl = false;
                object = worker.invoke((Object)new Runner(this, client){
                    final /* synthetic */ Facade this$0;
                    final /* synthetic */ DatabaseSessionClient $client;
                    {
                        this.this$0 = $receiver;
                        this.$client = $client;
                    }

                    public <T> T perform(Function1<? super InterruptibleDatabaseConnection, ? extends T> work) {
                        Intrinsics.checkNotNullParameter(work, (String)"work");
                        return (T)CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super T>, Object>(this.this$0, this.$client, work, null){
                            int label;
                            final /* synthetic */ Facade this$0;
                            final /* synthetic */ DatabaseSessionClient $client;
                            final /* synthetic */ Function1<InterruptibleDatabaseConnection, T> $work;
                            {
                                this.this$0 = $receiver;
                                this.$client = $client;
                                this.$work = $work;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        Object object2 = Facade.access$perform(this.this$0, this.$client, arg_0 -> multiRunSync.2.perform.1.invokeSuspend$lambda$0(this.this$0, this.$work, arg_0), (Continuation)this);
                                        if (object2 != object) return object2;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return object2;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super T> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }

                            private static final Object invokeSuspend$lambda$0(Facade this$0, Function1 $work, ConnectionInfo info) {
                                return Facade.access$compute(this$0, info, $work);
                            }
                        }));
                    }
                });
            }
            finally {
                if ($this$use$iv != null) {
                    Disposer.dispose((Disposable)$this$use$iv);
                }
            }
            return (T)object;
        }

        @NotNull
        public final GuardedRef<DatabaseConnection> connect() throws Exception {
            GuardedRef<ConnectionInfo> infoRef = this.connection();
            InterruptibleDatabaseConnection interruptibleDatabaseConnection = ((ConnectionInfo)infoRef.get()).getConnection();
            return (GuardedRef)new GuardedRef<DatabaseConnection>(infoRef, interruptibleDatabaseConnection){
                final /* synthetic */ GuardedRef<ConnectionInfo> $infoRef;
                {
                    this.$infoRef = $infoRef;
                    super((Object)$super_call_param$1);
                }

                protected void close(DatabaseConnection ref) {
                    Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
                    this.$infoRef.close();
                }
            };
        }

        private final GuardedRef<ConnectionInfo> currentConnection() {
            LocalDataSource localDataSource = this.connectionPoint.getDataSource();
            Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
            ConnectionsRouter router = routers.choose(localDataSource);
            ConnectionReference current = router.getCurrent();
            if (current != null) {
                this.checkBounds(current.getResource());
                return new Lockpick(current, router);
            }
            return null;
        }

        private final GuardedRef<ConnectionInfo> connection() {
            LocalDataSource localDataSource = this.connectionPoint.getDataSource();
            Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
            ConnectionsRouter router = routers.choose(localDataSource);
            GuardedRef<ConnectionInfo> guardedRef = this.currentConnection();
            if (guardedRef != null) {
                GuardedRef<ConnectionInfo> it = guardedRef;
                boolean bl = false;
                return it;
            }
            CountDownLatch latch = new CountDownLatch(1);
            CompletableFuture<ConnectionInfo> resultFuture = new CompletableFuture<ConnectionInfo>();
            String string = DatabaseBundle.message((String)"progress.title.block.request.until.connection.released", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            AsyncTask.Frame.asAsyncTask$default((AsyncTask.Frame)AsyncTask.Companion.frame(string), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, resultFuture, latch, null){
                int label;
                final /* synthetic */ Facade this$0;
                final /* synthetic */ CompletableFuture<ConnectionInfo> $resultFuture;
                final /* synthetic */ CountDownLatch $latch;
                {
                    this.this$0 = $receiver;
                    this.$resultFuture = $resultFuture;
                    this.$latch = $latch;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = Facade.access$perform(this.this$0, arg_0 -> connection.2.invokeSuspend$lambda$0(this.$resultFuture, this.$latch, arg_0), (Continuation)this);
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }

                private static final Unit invokeSuspend$lambda$0(CompletableFuture $resultFuture, CountDownLatch $latch, ConnectionInfo it) {
                    $resultFuture.complete(it);
                    $latch.await();
                    return Unit.INSTANCE;
                }
            }), (int)1, null).whenComplete(null, (arg_0, arg_1) -> Facade.connection$lambda$2((arg_0, arg_1) -> Facade.connection$lambda$1(resultFuture, arg_0, arg_1), arg_0, arg_1));
            try {
                ConnectionInfo result = resultFuture.get();
                Intrinsics.checkNotNull((Object)result);
                ConnectionReference reference = new ConnectionReference(result, latch);
                router.save(reference);
                return new Lockpick(reference, router);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                Throwable throwable = cause;
                if (throwable == null) {
                    throwable = new ProcessCanceledException();
                }
                throw throwable;
            }
        }

        private final void checkBounds(ConnectionInfo info) {
            if (this.path == null) {
                return;
            }
            SearchPath searchPath = info.getContext().getSearchPath();
            if (!JdbcUrlParserUtil.outOfBounds((DatabaseConnectionPoint)info.getConnection().getConnectionPoint(), (ObjectPath)(searchPath != null ? searchPath.getCurrent() : null), (ObjectPath)this.path.getCurrent())) {
                return;
            }
            throw new IllegalStateException("Cannot switch a database. The connection is used by another client. Disable the single connection mode and try again");
        }

        @NotNull
        public final DatabaseSessionClient client() {
            SessionType sessionType = this.department.isService() ? SessionType.SERVICE : SessionType.NOT_IMPORTANT;
            DatabaseSession session = DatabaseSessionManager.getSession(this.project, this.connectionPoint, this.credentialsStore, this.silent, null, sessionType);
            return this.client(session);
        }

        @NotNull
        public final VisibleDatabaseSessionClient client(@NotNull DatabaseSession session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            TemporaryClient client = new TemporaryClient(session, this.department, this.path);
            session.attach(client);
            return client;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final <T> T compute(ConnectionInfo info, Function1<? super InterruptibleDatabaseConnection, ? extends T> work) {
            T t;
            ConnectionReference reference = new ConnectionReference(info, null, 2, null);
            LocalDataSource localDataSource = this.connectionPoint.getDataSource();
            Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
            ConnectionsRouter router = routers.choose(localDataSource);
            router.save(reference);
            try {
                t = this.compute(work, (DatabaseConnection)info.getConnection(), info.getContext());
            }
            finally {
                router.remove();
            }
            return t;
        }

        private final <T, C extends DatabaseConnection> T compute(Function1<? super C, ? extends T> work, C connection2, DataRequest.Context context) {
            Object object;
            try {
                object = work.invoke(connection2);
            }
            catch (DbmsMismatchException e) {
                throw e;
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                if (!AsyncUtil.isCancellation((Throwable)e)) {
                    context.error((Throwable)e);
                }
                throw new ProcessCanceledException((Throwable)e);
            }
            return (T)object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private final <T> Object perform(Function1<? super ConnectionInfo, ? extends T> work, Continuation<? super T> $completion) {
            if (!($completion instanceof perform.1)) ** GOTO lbl-1000
            var10_3 = $completion;
            if ((var10_3.label & -2147483648) != 0) {
                var10_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    int I$0;
                    int I$1;
                    /* synthetic */ Object result;
                    final /* synthetic */ Facade this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return Facade.access$perform(this.this$0, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var11_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $this$use$iv = this.client();
                    $i$f$use = 0;
                    it = (DatabaseSessionClient)$this$use$iv;
                    $i$a$-use-DatabaseSessionManager$Facade$perform$2 = 0;
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)work);
                    $continuation.L$1 = $this$use$iv;
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)it);
                    $continuation.I$0 = $i$f$use;
                    $continuation.I$1 = $i$a$-use-DatabaseSessionManager$Facade$perform$2;
                    $continuation.label = 1;
                    v0 = this.perform(it, (Function1<? super ConnectionInfo, ? extends T>)work, (Continuation<? super T>)$continuation);
                    ** if (v0 != var11_5) goto lbl27
lbl26:
                    // 1 sources

                    return var11_5;
lbl27:
                    // 1 sources

                    ** GOTO lbl39
                }
                case 1: {
                    $i$a$-use-DatabaseSessionManager$Facade$perform$2 = $continuation.I$1;
                    $i$f$use = $continuation.I$0;
                    it = (DatabaseSessionClient)$continuation.L$2;
                    $this$use$iv = (Disposable)$continuation.L$1;
                    work = (Function1)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl39:
                        // 2 sources

                        var7_13 = v0;
                    }
                    catch (Throwable var8_14) {
                        throw var8_14;
                    }
                    finally {
                        if ($this$use$iv != null) {
                            Disposer.dispose((Disposable)$this$use$iv);
                        }
                    }
                    return var7_13;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        private final <T> Object perform(DatabaseSessionClient client, Function1<? super ConnectionInfo, ? extends T> work, Continuation<? super T> $completion) {
            boolean $i$f$suspendCancellableCoroutine = false;
            Continuation<? super T> uCont$iv = $completion;
            boolean bl = false;
            CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv), 1);
            cancellable$iv.initCancellability();
            CancellableContinuation cont = (CancellableContinuation)cancellable$iv;
            boolean bl2 = false;
            ThreadContext.installThreadContext((CoroutineContext)cont.getContext(), (boolean)true, (Function0)((Function0)new Function0<Unit>(this, cont, client, work){
                final /* synthetic */ Facade this$0;
                final /* synthetic */ CancellableContinuation<T> $cont;
                final /* synthetic */ DatabaseSessionClient $client;
                final /* synthetic */ Function1<ConnectionInfo, T> $work;
                {
                    this.this$0 = $receiver;
                    this.$cont = $cont;
                    this.$client = $client;
                    this.$work = $work;
                }

                public final void invoke() {
                    CoroutinesKt.blockingContextToIndicator((Function0)((Function0)new Function0<Unit>(this.this$0, this.$cont, this.$client, this.$work){
                        final /* synthetic */ Facade this$0;
                        final /* synthetic */ CancellableContinuation<T> $cont;
                        final /* synthetic */ DatabaseSessionClient $client;
                        final /* synthetic */ Function1<ConnectionInfo, T> $work;
                        {
                            this.this$0 = $receiver;
                            this.$cont = $cont;
                            this.$client = $client;
                            this.$work = $work;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final void invoke() {
                            boolean submitted = false;
                            try {
                                ErrorHandler errorHandler = Facade.access$getHandler$p(this.this$0);
                                WrapperRequest<T> request2 = new WrapperRequest<T>(this.$client, this.$cont, this.$work, errorHandler){
                                    final /* synthetic */ DatabaseSessionClient $client;
                                    final /* synthetic */ Function1<ConnectionInfo, T> $work;
                                    {
                                        this.$client = $client;
                                        this.$work = $work;
                                        super($client, $cont, $super_call_param$1);
                                    }

                                    public T process(DataRequest.Context context, DatabaseConnectionCore connection2) {
                                        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                                        Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
                                        return (T)this.$work.invoke((Object)new ConnectionInfo(new ConnectionWithClient((DatabaseConnection)connection2, this.$client), context));
                                    }
                                };
                                submitted = request2.submit();
                                if (submitted) return;
                            }
                            catch (Throwable throwable) {
                                CancellableContinuation.DefaultImpls.cancel$default(this.$cont, null, (int)1, null);
                                throw throwable;
                            }
                            CancellableContinuation.DefaultImpls.cancel$default(this.$cont, null, (int)1, null);
                        }
                    }));
                }
            }));
            Object object = cancellable$iv.getResult();
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                DebugProbesKt.probeCoroutineSuspended($completion);
            }
            return object;
        }

        private static final Object run$lambda$0(Facade this$0, Function1 $work, ConnectionInfo info) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            return this$0.compute(info, $work);
        }

        private static final Object runSync$lambda$0(Function1 $work, Runner r) {
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            return r.perform($work);
        }

        private static final Unit connection$lambda$1(CompletableFuture $resultFuture, Unit unit, Throwable ex) {
            block0: {
                Throwable throwable = ex;
                if (throwable == null) break block0;
                Throwable p0 = throwable;
                boolean bl = false;
                $resultFuture.completeExceptionally(p0);
            }
            return Unit.INSTANCE;
        }

        private static final void connection$lambda$2(Function2 $tmp0, Object p0, Object p1) {
            $tmp0.invoke(p0, p1);
        }

        public static final /* synthetic */ Object access$compute(Facade $this, ConnectionInfo info, Function1 work) {
            return $this.compute(info, work);
        }

        public static final /* synthetic */ Object access$perform(Facade $this, DatabaseSessionClient client, Function1 work, Continuation $completion) {
            return $this.perform(client, work, $completion);
        }

        public static final /* synthetic */ Object access$perform(Facade $this, Function1 work, Continuation $completion) {
            return $this.perform(work, $completion);
        }

        public static final /* synthetic */ ErrorHandler access$getHandler$p(Facade $this) {
            return $this.handler;
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$Companion;", "", "<init>", "()V", "routers", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$Routers;", "getRouters", "()Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$Routers;", "intellij.database.connectivity"})
        private static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Routers getRouters() {
                return routers;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0012\u001a\u00020\u0013H\u00d6\u0081\u0004J\n\u0010\u0014\u001a\u00020\u0015H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionInfo;", "", "connection", "Lcom/intellij/database/dataSource/InterruptibleDatabaseConnection;", "context", "Lcom/intellij/database/datagrid/DataRequest$Context;", "<init>", "(Lcom/intellij/database/dataSource/InterruptibleDatabaseConnection;Lcom/intellij/database/datagrid/DataRequest$Context;)V", "getConnection", "()Lcom/intellij/database/dataSource/InterruptibleDatabaseConnection;", "getContext", "()Lcom/intellij/database/datagrid/DataRequest$Context;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.database.connectivity"})
        private static final class ConnectionInfo {
            @NotNull
            private final InterruptibleDatabaseConnection connection;
            @NotNull
            private final DataRequest.Context context;

            public ConnectionInfo(@NotNull InterruptibleDatabaseConnection connection2, @NotNull DataRequest.Context context) {
                Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                this.connection = connection2;
                this.context = context;
            }

            @NotNull
            public final InterruptibleDatabaseConnection getConnection() {
                return this.connection;
            }

            @NotNull
            public final DataRequest.Context getContext() {
                return this.context;
            }

            @NotNull
            public final InterruptibleDatabaseConnection component1() {
                return this.connection;
            }

            @NotNull
            public final DataRequest.Context component2() {
                return this.context;
            }

            @NotNull
            public final ConnectionInfo copy(@NotNull InterruptibleDatabaseConnection connection2, @NotNull DataRequest.Context context) {
                Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                return new ConnectionInfo(connection2, context);
            }

            public static /* synthetic */ ConnectionInfo copy$default(ConnectionInfo connectionInfo, InterruptibleDatabaseConnection interruptibleDatabaseConnection, DataRequest.Context context, int n, Object object) {
                if ((n & 1) != 0) {
                    interruptibleDatabaseConnection = connectionInfo.connection;
                }
                if ((n & 2) != 0) {
                    context = connectionInfo.context;
                }
                return connectionInfo.copy(interruptibleDatabaseConnection, context);
            }

            @NotNull
            public String toString() {
                return "ConnectionInfo(connection=" + this.connection + ", context=" + this.context + ")";
            }

            public int hashCode() {
                int result = this.connection.hashCode();
                result = result * 31 + this.context.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ConnectionInfo)) {
                    return false;
                }
                ConnectionInfo connectionInfo = (ConnectionInfo)other;
                if (!Intrinsics.areEqual((Object)this.connection, (Object)connectionInfo.connection)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.context, (Object)connectionInfo.context);
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0014\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0018\u001a\u00020\rH\u00d6\u0081\u0004J\n\u0010\u0019\u001a\u00020\u001aH\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionReference;", "", "resource", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionInfo;", "engineLatch", "Ljava/util/concurrent/CountDownLatch;", "<init>", "(Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionInfo;Ljava/util/concurrent/CountDownLatch;)V", "getResource", "()Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionInfo;", "getEngineLatch", "()Ljava/util/concurrent/CountDownLatch;", "referenced", "", "getReferenced", "()I", "setReferenced", "(I)V", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.database.connectivity"})
        private static final class ConnectionReference {
            @NotNull
            private final ConnectionInfo resource;
            @Nullable
            private final CountDownLatch engineLatch;
            private int referenced;

            public ConnectionReference(@NotNull ConnectionInfo resource, @Nullable CountDownLatch engineLatch) {
                Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
                this.resource = resource;
                this.engineLatch = engineLatch;
            }

            public /* synthetic */ ConnectionReference(ConnectionInfo connectionInfo, CountDownLatch countDownLatch, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    countDownLatch = null;
                }
                this(connectionInfo, countDownLatch);
            }

            @NotNull
            public final ConnectionInfo getResource() {
                return this.resource;
            }

            @Nullable
            public final CountDownLatch getEngineLatch() {
                return this.engineLatch;
            }

            public final int getReferenced() {
                return this.referenced;
            }

            public final void setReferenced(int n) {
                this.referenced = n;
            }

            @NotNull
            public final ConnectionInfo component1() {
                return this.resource;
            }

            @Nullable
            public final CountDownLatch component2() {
                return this.engineLatch;
            }

            @NotNull
            public final ConnectionReference copy(@NotNull ConnectionInfo resource, @Nullable CountDownLatch engineLatch) {
                Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
                return new ConnectionReference(resource, engineLatch);
            }

            public static /* synthetic */ ConnectionReference copy$default(ConnectionReference connectionReference, ConnectionInfo connectionInfo, CountDownLatch countDownLatch, int n, Object object) {
                if ((n & 1) != 0) {
                    connectionInfo = connectionReference.resource;
                }
                if ((n & 2) != 0) {
                    countDownLatch = connectionReference.engineLatch;
                }
                return connectionReference.copy(connectionInfo, countDownLatch);
            }

            @NotNull
            public String toString() {
                return "ConnectionReference(resource=" + this.resource + ", engineLatch=" + this.engineLatch + ")";
            }

            public int hashCode() {
                int result = this.resource.hashCode();
                result = result * 31 + (this.engineLatch == null ? 0 : this.engineLatch.hashCode());
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ConnectionReference)) {
                    return false;
                }
                ConnectionReference connectionReference = (ConnectionReference)other;
                if (!Intrinsics.areEqual((Object)this.resource, (Object)connectionReference.resource)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.engineLatch, (Object)connectionReference.engineLatch);
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\bb\u0018\u00002\u00020\u0001J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H&J\b\u0010\t\u001a\u00020\u0007H&R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionsRouter;", "", "current", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionReference;", "getCurrent", "()Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionReference;", "save", "", "reference", "remove", "intellij.database.connectivity"})
        private static interface ConnectionsRouter {
            @Nullable
            public ConnectionReference getCurrent();

            public void save(@NotNull ConnectionReference var1);

            public void remove();
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0014R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$Lockpick;", "Lcom/intellij/database/util/GuardedRef;", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionInfo;", "reference", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionReference;", "router", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionsRouter;", "<init>", "(Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionReference;Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionsRouter;)V", "getReference", "()Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionReference;", "close", "", "info", "intellij.database.connectivity"})
        private static final class Lockpick
        extends GuardedRef<ConnectionInfo> {
            @NotNull
            private final ConnectionReference reference;
            @NotNull
            private final ConnectionsRouter router;

            public Lockpick(@NotNull ConnectionReference reference, @NotNull ConnectionsRouter router) {
                Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
                Intrinsics.checkNotNullParameter((Object)router, (String)"router");
                super((Object)reference.getResource());
                this.reference = reference;
                this.router = router;
                ConnectionReference connectionReference = this.reference;
                int n = connectionReference.getReferenced();
                connectionReference.setReferenced(n + 1);
            }

            @NotNull
            public final ConnectionReference getReference() {
                return this.reference;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void close(@NotNull ConnectionInfo info) {
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                ConnectionReference connectionReference = this.reference;
                int n = connectionReference.getReferenced();
                connectionReference.setReferenced(n + -1);
                if (this.reference.getReferenced() != 0) {
                    return;
                }
                try {
                    this.router.remove();
                }
                finally {
                    CountDownLatch countDownLatch = this.reference.getEngineLatch();
                    if (countDownLatch != null) {
                        countDownLatch.countDown();
                    }
                }
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0016J\b\u0010\u000b\u001a\u00020\tH\u0016R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$MultipleSessionsRouter;", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionsRouter;", "<init>", "()V", "current", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionReference;", "getCurrent", "()Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionReference;", "save", "", "reference", "remove", "intellij.database.connectivity"})
        private static final class MultipleSessionsRouter
        implements ConnectionsRouter {
            @NotNull
            public static final MultipleSessionsRouter INSTANCE = new MultipleSessionsRouter();
            @Nullable
            private static final ConnectionReference current;

            private MultipleSessionsRouter() {
            }

            @Override
            @Nullable
            public ConnectionReference getCurrent() {
                return current;
            }

            @Override
            public void save(@NotNull ConnectionReference reference) {
                Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
            }

            @Override
            public void remove() {
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\t\u0010\f\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c2\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0012\u001a\u00020\u0013H\u00d6\u0081\u0004J\n\u0010\u0014\u001a\u00020\u0015H\u00d6\u0081\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$Routers;", "", "multi", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$MultipleSessionsRouter;", "single", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$SingleSessionRouter;", "<init>", "(Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$MultipleSessionsRouter;Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$SingleSessionRouter;)V", "choose", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionsRouter;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.database.connectivity"})
        private static final class Routers {
            @NotNull
            private final MultipleSessionsRouter multi;
            @NotNull
            private final SingleSessionRouter single;

            public Routers(@NotNull MultipleSessionsRouter multi, @NotNull SingleSessionRouter single) {
                Intrinsics.checkNotNullParameter((Object)multi, (String)"multi");
                Intrinsics.checkNotNullParameter((Object)single, (String)"single");
                this.multi = multi;
                this.single = single;
            }

            @NotNull
            public final ConnectionsRouter choose(@NotNull LocalDataSource dataSource) {
                Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
                return dataSource.isSingleConnection() ? (ConnectionsRouter)this.single : (ConnectionsRouter)this.multi;
            }

            private final MultipleSessionsRouter component1() {
                return this.multi;
            }

            private final SingleSessionRouter component2() {
                return this.single;
            }

            @NotNull
            public final Routers copy(@NotNull MultipleSessionsRouter multi, @NotNull SingleSessionRouter single) {
                Intrinsics.checkNotNullParameter((Object)multi, (String)"multi");
                Intrinsics.checkNotNullParameter((Object)single, (String)"single");
                return new Routers(multi, single);
            }

            public static /* synthetic */ Routers copy$default(Routers routers, MultipleSessionsRouter multipleSessionsRouter, SingleSessionRouter singleSessionRouter, int n, Object object) {
                if ((n & 1) != 0) {
                    multipleSessionsRouter = routers.multi;
                }
                if ((n & 2) != 0) {
                    singleSessionRouter = routers.single;
                }
                return routers.copy(multipleSessionsRouter, singleSessionRouter);
            }

            @NotNull
            public String toString() {
                return "Routers(multi=" + this.multi + ", single=" + this.single + ")";
            }

            public int hashCode() {
                int result = this.multi.hashCode();
                result = result * 31 + this.single.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Routers)) {
                    return false;
                }
                Routers routers = (Routers)other;
                if (!Intrinsics.areEqual((Object)this.multi, (Object)routers.multi)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.single, (Object)routers.single);
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J'\u0010\u0002\u001a\u0002H\u0003\"\u0004\b\u0000\u0010\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002H\u00030\u0005H&\u00a2\u0006\u0002\u0010\u0007\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$Runner;", "", "perform", "T", "work", "Lkotlin/Function1;", "Lcom/intellij/database/dataSource/InterruptibleDatabaseConnection;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "intellij.database.connectivity"})
        public static interface Runner {
            public <T> T perform(@NotNull Function1<? super InterruptibleDatabaseConnection, ? extends T> var1);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006H\u0016J\b\u0010\r\u001a\u00020\u000bH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$SingleSessionRouter;", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionsRouter;", "<init>", "()V", "localRefs", "Ljava/lang/ThreadLocal;", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionReference;", "current", "getCurrent", "()Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionReference;", "save", "", "reference", "remove", "intellij.database.connectivity"})
        private static final class SingleSessionRouter
        implements ConnectionsRouter {
            @NotNull
            private final ThreadLocal<ConnectionReference> localRefs = new ThreadLocal();

            @Override
            @Nullable
            public ConnectionReference getCurrent() {
                return this.localRefs.get();
            }

            @Override
            public void save(@NotNull ConnectionReference reference) {
                Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
                this.localRefs.set(reference);
            }

            @Override
            public void remove() {
                this.localRefs.remove();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$Factories;", "", "<init>", "()V", "singleConnection", "Lcom/intellij/database/console/session/DatabaseSessionManager$SingleConnection;", "chooseOneFor", "Lcom/intellij/database/console/session/DatabaseSessionManager$Factory;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "sessionType", "Lcom/intellij/database/console/session/DatabaseSessionManager$SessionType;", "intellij.database.connectivity"})
    private static final class Factories {
        @NotNull
        private final SingleConnection singleConnection = new SingleConnection(MultiConnection.INSTANCE);

        @NotNull
        public final Factory chooseOneFor(@NotNull LocalDataSource dataSource, @NotNull SessionType sessionType) {
            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
            Intrinsics.checkNotNullParameter((Object)((Object)sessionType), (String)"sessionType");
            return sessionType == SessionType.SERVICE || dataSource.isSingleConnection() && sessionType == SessionType.NOT_IMPORTANT ? (Factory)this.singleConnection : (Factory)MultiConnection.INSTANCE;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0003\u0010\b\u001a\u0004\u0018\u00010\tH&J6\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\n\b\u0003\u0010\b\u001a\u0004\u0018\u00010\tH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000e\u00c0\u0006\u0001"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$Factory;", "", "instance", "Lcom/intellij/database/console/session/DatabaseSession;", "project", "Lcom/intellij/openapi/project/Project;", "connectionPoint", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "title", "", "credentialsStore", "Lcom/intellij/database/access/DatabaseCredentials;", "silent", "", "intellij.database.connectivity"})
    public static interface Factory {
        @NotNull
        public DatabaseSession instance(@NotNull Project var1, @NotNull DatabaseConnectionPoint var2, @Nls @Nullable String var3);

        public static /* synthetic */ DatabaseSession instance$default(Factory factory, Project project, DatabaseConnectionPoint databaseConnectionPoint, String string, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: instance");
            }
            if ((n & 4) != 0) {
                string = null;
            }
            return factory.instance(project, databaseConnectionPoint, string);
        }

        @NotNull
        public DatabaseSession instance(@NotNull Project var1, @NotNull DatabaseConnectionPoint var2, @Nullable DatabaseCredentials var3, boolean var4, @Nls @Nullable String var5);

        public static /* synthetic */ DatabaseSession instance$default(Factory factory, Project project, DatabaseConnectionPoint databaseConnectionPoint, DatabaseCredentials databaseCredentials, boolean bl, String string, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: instance");
            }
            if ((n & 0x10) != 0) {
                string = null;
            }
            return factory.instance(project, databaseConnectionPoint, databaseCredentials, bl, string);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u0004\u001a\u0004\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\nJ\u001a\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$Indexer;", "", "<init>", "()V", "generateIndex", "", "sessions", "", "", "prefix", "(Ljava/util/List;Ljava/lang/String;)Ljava/lang/Long;", "retrieveIndex", "session", "intellij.database.connectivity"})
    @SourceDebugExtension(value={"SMAP\nDatabaseSessionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseSessionManager.kt\ncom/intellij/database/console/session/DatabaseSessionManager$Indexer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,687:1\n2792#2,3:688\n1#3:691\n*S KotlinDebug\n*F\n+ 1 DatabaseSessionManager.kt\ncom/intellij/database/console/session/DatabaseSessionManager$Indexer\n*L\n643#1:688,3\n*E\n"})
    private static final class Indexer {
        @NotNull
        public static final Indexer INSTANCE = new Indexer();

        private Indexer() {
        }

        @Nullable
        public final Long generateIndex(@NotNull List<String> sessions, @Nullable String prefix) {
            block11: {
                block10: {
                    boolean bl;
                    block9: {
                        Intrinsics.checkNotNullParameter(sessions, (String)"sessions");
                        if (sessions.isEmpty()) break block10;
                        if (prefix == null) break block11;
                        Iterable $this$none$iv = sessions;
                        boolean $i$f$none = false;
                        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                            bl = true;
                        } else {
                            for (Object element$iv : $this$none$iv) {
                                String it = (String)element$iv;
                                boolean bl2 = false;
                                if (!Intrinsics.areEqual((Object)it, (Object)prefix)) continue;
                                bl = false;
                                break block9;
                            }
                            bl = true;
                        }
                    }
                    if (!bl) break block11;
                }
                return null;
            }
            List sortedSessions = CollectionsKt.sortedWith((Iterable)sessions, Indexer::generateIndex$lambda$1);
            long index = 1L;
            for (String session : sortedSessions) {
                long idxOfSession = this.retrieveIndex(session, prefix);
                if (idxOfSession == -1L) continue;
                if (idxOfSession == index) {
                    long l = index;
                    index = l + 1L;
                }
                if (idxOfSession <= index) continue;
                return index;
            }
            return index;
        }

        public static /* synthetic */ Long generateIndex$default(Indexer indexer, List list, String string, int n, Object object) {
            if ((n & 2) != 0) {
                string = null;
            }
            return indexer.generateIndex(list, string);
        }

        private final long retrieveIndex(String session, String prefix) {
            int idx;
            String it = session;
            boolean bl = false;
            String string = prefix;
            char[] cArray = (string != null ? StringsKt.substringAfter$default((String)it, (String)string, null, (int)2, null) : it).toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
            char[] title = cArray;
            for (idx = title.length - 1; idx > -1 && idx < title.length && Character.isDigit(title[idx]); --idx) {
            }
            int shift = prefix != null && StringsKt.startsWith$default((String)session, (String)prefix, (boolean)false, (int)2, null) ? prefix.length() : 0;
            String string2 = session.substring(shift + idx + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String numericSuffix = string2;
            Long l = StringsKt.toLongOrNull((String)numericSuffix);
            return l != null ? l : -1L;
        }

        private static final int generateIndex$lambda$1(String s1, String s2) {
            return StringUtil.naturalCompare((String)s1, (String)s2);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\n\b\u0001\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J6\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\n\b\u0001\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$MultiConnection;", "Lcom/intellij/database/console/session/DatabaseSessionManager$Factory;", "<init>", "()V", "instance", "Lcom/intellij/database/console/session/DatabaseSession;", "project", "Lcom/intellij/openapi/project/Project;", "connectionPoint", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "title", "", "credentialsStore", "Lcom/intellij/database/access/DatabaseCredentials;", "silent", "", "intellij.database.connectivity"})
    private static final class MultiConnection
    implements Factory {
        @NotNull
        public static final MultiConnection INSTANCE = new MultiConnection();

        private MultiConnection() {
        }

        @Override
        @NotNull
        public DatabaseSession instance(@NotNull Project project, @NotNull DatabaseConnectionPoint connectionPoint, @Nls @Nullable String title) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)connectionPoint, (String)"connectionPoint");
            String string = title;
            if (string == null) {
                string = INSTANCE.generateNameForSession(project, connectionPoint);
            }
            String resultTitle = string;
            return new MessageBusSession(project, connectionPoint, new MessageBusSession.NaturalKernel(project, resultTitle, connectionPoint, null, false), resultTitle);
        }

        @Override
        @NotNull
        public DatabaseSession instance(@NotNull Project project, @NotNull DatabaseConnectionPoint connectionPoint, @Nullable DatabaseCredentials credentialsStore, boolean silent, @Nls @Nullable String title) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)connectionPoint, (String)"connectionPoint");
            String string = title;
            if (string == null) {
                string = INSTANCE.generateNameForSession(project, connectionPoint);
            }
            String resultTitle = string;
            return new MessageBusSession(project, connectionPoint, new MessageBusSession.NaturalKernel(project, resultTitle, connectionPoint, credentialsStore, silent), resultTitle);
        }
    }

    @Service(value={Service.Level.PROJECT})
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J>\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\n\b\u0001\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u0019J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\fH\u0002J\u0010\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\bH\u0002J\u001f\u0010 \u001a\u0002H!\"\b\b\u0000\u0010!*\u00020\f2\u0006\u0010\u001d\u001a\u0002H!H\u0002\u00a2\u0006\u0002\u0010\"R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006#"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$ProjectSessions;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "map", "", "Lcom/intellij/database/dataSource/LocalDataSource;", "Lcom/intellij/database/console/session/DatabaseSessionManager$Factories;", "sessions", "", "Lcom/intellij/database/console/session/DatabaseSession;", "getSessions", "()Ljava/util/Set;", "getSession", "connectionPoint", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "credentialsStore", "Lcom/intellij/database/access/DatabaseCredentials;", "silent", "", "title", "", "sessionType", "Lcom/intellij/database/console/session/DatabaseSessionManager$SessionType;", "dispose", "", "remember", "session", "getFactories", "dataSource", "index", "T", "(Lcom/intellij/database/console/session/DatabaseSession;)Lcom/intellij/database/console/session/DatabaseSession;", "intellij.database.connectivity"})
    @SourceDebugExtension(value={"SMAP\nDatabaseSessionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseSessionManager.kt\ncom/intellij/database/console/session/DatabaseSessionManager$ProjectSessions\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,687:1\n383#2,7:688\n*S KotlinDebug\n*F\n+ 1 DatabaseSessionManager.kt\ncom/intellij/database/console/session/DatabaseSessionManager$ProjectSessions\n*L\n199#1:688,7\n*E\n"})
    private static final class ProjectSessions
    implements Disposable {
        @NotNull
        private final Project project;
        @NotNull
        private final Map<LocalDataSource, Factories> map;
        @NotNull
        private final Set<DatabaseSession> sessions;

        public ProjectSessions(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
            this.map = new HashMap();
            Set set = ConcurrentCollectionFactory.createConcurrentSet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createConcurrentSet(...)");
            this.sessions = set;
            MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this);
            Topic topic = DataSourceStorage.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            messageBusConnection.subscribe(topic, (Object)new DataSourceStorage.Listener(){

                public void dataSourceRemoved(LocalDataSource dataSource) {
                    Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
                    INSTANCE.onEdt(() -> 1.dataSourceRemoved$lambda$0(this, dataSource));
                }

                /*
                 * WARNING - void declaration
                 */
                private static final Factories dataSourceRemoved$lambda$0(ProjectSessions this$0, LocalDataSource $dataSource) {
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv = this$0.getSessions();
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        DatabaseSession it = (DatabaseSession)element$iv$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getTarget(), (Object)$dataSource)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    Iterable $this$forEach$iv = (List)destination$iv$iv;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        DatabaseSession it = (DatabaseSession)element$iv;
                        boolean bl = false;
                        SessionsUtil.close(it);
                    }
                    return (Factories)this$0.map.remove($dataSource);
                }
            });
        }

        @NotNull
        public final Set<DatabaseSession> getSessions() {
            return this.sessions;
        }

        @NotNull
        public final DatabaseSession getSession(@NotNull Project project, @NotNull DatabaseConnectionPoint connectionPoint, @Nullable DatabaseCredentials credentialsStore, boolean silent, @Nls @Nullable String title, @NotNull SessionType sessionType) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)connectionPoint, (String)"connectionPoint");
            Intrinsics.checkNotNullParameter((Object)((Object)sessionType), (String)"sessionType");
            return (DatabaseSession)INSTANCE.onEdt(() -> ProjectSessions.getSession$lambda$0(this, connectionPoint, sessionType, project, credentialsStore, silent, title));
        }

        public static /* synthetic */ DatabaseSession getSession$default(ProjectSessions projectSessions, Project project, DatabaseConnectionPoint databaseConnectionPoint, DatabaseCredentials databaseCredentials, boolean bl, String string, SessionType sessionType, int n, Object object) {
            if ((n & 0x20) != 0) {
                sessionType = SessionType.NOT_IMPORTANT;
            }
            return projectSessions.getSession(project, databaseConnectionPoint, databaseCredentials, bl, string, sessionType);
        }

        public void dispose() {
        }

        private final DatabaseSession remember(DatabaseSession session) {
            if (this.sessions.contains(session)) {
                return session;
            }
            Disposer.register((Disposable)session, () -> ProjectSessions.remember$lambda$0(this, session));
            ((Collection)this.sessions).add(session);
            ((DatabaseSessionManagerListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(DatabaseSessionManager.getTopic())).sessionOpened(session);
            return session;
        }

        /*
         * WARNING - void declaration
         */
        private final Factories getFactories(LocalDataSource dataSource) {
            Object object;
            void $this$getOrPut$iv;
            Map<LocalDataSource, Factories> map = this.map;
            LocalDataSource key$iv = dataSource;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                Factories answer$iv = new Factories();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            return (Factories)object;
        }

        private final <T extends DatabaseSession> T index(T session) {
            if (this.sessions.contains(session)) {
                return session;
            }
            Disposer.register((Disposable)this, (Disposable)session);
            return session;
        }

        private static final DatabaseSession getSession$lambda$0(ProjectSessions this$0, DatabaseConnectionPoint $connectionPoint, SessionType $sessionType, Project $project, DatabaseCredentials $credentialsStore, boolean $silent, String $title) {
            LocalDataSource localDataSource = $connectionPoint.getDataSource();
            Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
            Factories factories = this$0.getFactories(localDataSource);
            LocalDataSource localDataSource2 = $connectionPoint.getDataSource();
            Intrinsics.checkNotNullExpressionValue((Object)localDataSource2, (String)"getDataSource(...)");
            return this$0.remember(this$0.index(factories.chooseOneFor(localDataSource2, $sessionType).instance($project, $connectionPoint, $credentialsStore, $silent, $title)));
        }

        private static final void remember$lambda$0(ProjectSessions this$0, DatabaseSession $session) {
            ((Collection)this$0.sessions).remove($session);
            ((DatabaseSessionManagerListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(DatabaseSessionManager.getTopic())).sessionClosed($session);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$SessionType;", "", "<init>", "(Ljava/lang/String;I)V", "SERVICE", "NOT_IMPORTANT", "NEW", "intellij.database.connectivity"})
    public static final class SessionType
    extends Enum<SessionType> {
        public static final /* enum */ SessionType SERVICE = new SessionType();
        public static final /* enum */ SessionType NOT_IMPORTANT = new SessionType();
        public static final /* enum */ SessionType NEW = new SessionType();
        private static final /* synthetic */ SessionType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static SessionType[] values() {
            return (SessionType[])$VALUES.clone();
        }

        public static SessionType valueOf(String value) {
            return Enum.valueOf(SessionType.class, value);
        }

        @NotNull
        public static EnumEntries<SessionType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = sessionTypeArray = new SessionType[]{SessionType.SERVICE, SessionType.NOT_IMPORTANT, SessionType.NEW};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\"\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J4\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J*\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$SingleConnection;", "Lcom/intellij/database/console/session/DatabaseSessionManager$Factory;", "honestFactory", "<init>", "(Lcom/intellij/database/console/session/DatabaseSessionManager$Factory;)V", "session", "Lcom/intellij/database/console/session/DatabaseSession;", "instance", "project", "Lcom/intellij/openapi/project/Project;", "connectionPoint", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "title", "", "credentialsStore", "Lcom/intellij/database/access/DatabaseCredentials;", "silent", "", "intellij.database.connectivity"})
    private static final class SingleConnection
    implements Factory {
        @NotNull
        private final Factory honestFactory;
        @Nullable
        private DatabaseSession session;

        public SingleConnection(@NotNull Factory honestFactory) {
            Intrinsics.checkNotNullParameter((Object)honestFactory, (String)"honestFactory");
            this.honestFactory = honestFactory;
        }

        @Override
        @NotNull
        public DatabaseSession instance(@NotNull Project project, @NotNull DatabaseConnectionPoint connectionPoint, @Nullable String title) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)connectionPoint, (String)"connectionPoint");
            return this.session(project, connectionPoint, null, false);
        }

        @Override
        @NotNull
        public DatabaseSession instance(@NotNull Project project, @NotNull DatabaseConnectionPoint connectionPoint, @Nullable DatabaseCredentials credentialsStore, boolean silent, @Nullable String title) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)connectionPoint, (String)"connectionPoint");
            return this.session(project, connectionPoint, credentialsStore, silent);
        }

        private final DatabaseSession session(Project project, DatabaseConnectionPoint connectionPoint, DatabaseCredentials credentialsStore, boolean silent) {
            ThreadingAssertions.assertEventDispatchThread();
            if (this.session == null) {
                DatabaseSession databaseSession = this.session = this.honestFactory.instance(project, connectionPoint, credentialsStore, silent, "");
                Intrinsics.checkNotNull((Object)databaseSession);
                Disposer.register((Disposable)databaseSession, () -> SingleConnection.session$lambda$0(this));
            }
            DatabaseSession databaseSession = this.session;
            Intrinsics.checkNotNull((Object)databaseSession);
            return databaseSession;
        }

        private static final Unit session$lambda$0$0(SingleConnection this$0) {
            this$0.session = null;
            return Unit.INSTANCE;
        }

        private static final void session$lambda$0(SingleConnection this$0) {
            INSTANCE.onEdt(() -> SingleConnection.session$lambda$0$0(this$0));
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001eH\u0016J\u0010\u0010\"\u001a\u00020\u00122\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\u00122\u0006\u0010#\u001a\u00020$H\u0016J\b\u0010)\u001a\u00020\u0012H\u0016J\b\u0010*\u001a\u00020\u0012H\u0016J\b\u0010+\u001a\u00020\u0006H\u0016J\n\u0010,\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010-\u001a\u00020.H\u0016J\b\u0010/\u001a\u00020\u0016H\u0016J\b\u00100\u001a\u00020\u001bH\u0016J\b\u00101\u001a\u00020\u0012H\u0016J\u0010\u00102\u001a\u00020 2\u0006\u00103\u001a\u00020\u0012H\u0016J\b\u00104\u001a\u00020 H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\n \u001c*\u0004\u0018\u00010\u001b0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$TemporaryClient;", "Lcom/intellij/database/console/client/VisibleDatabaseSessionClient;", "Lcom/intellij/database/datagrid/DataRequest$CustomSearchPathOwner;", "session", "Lcom/intellij/database/console/session/DatabaseSession;", "department", "Lcom/intellij/database/dataSource/connection/DatabaseDepartment;", "path", "Lcom/intellij/database/util/SearchPath;", "<init>", "(Lcom/intellij/database/console/session/DatabaseSession;Lcom/intellij/database/dataSource/connection/DatabaseDepartment;Lcom/intellij/database/util/SearchPath;)V", "getSession", "()Lcom/intellij/database/console/session/DatabaseSession;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "showOnActivity", "", "getShowOnActivity", "()Z", "title", "", "getTitle", "()Ljava/lang/String;", "disposed", "messageBus", "Lcom/intellij/database/DataBus$Consuming;", "kotlin.jvm.PlatformType", "getTxIsolation", "", "setTxIsolation", "", "isolation", "showOnAttention", "context", "Lcom/intellij/database/datagrid/DataRequest$Context;", "detached", "trigger", "Lcom/intellij/database/console/client/DatabaseSessionClient$DetachTrigger;", "focusOnError", "isActive", "isValid", "getDepartment", "getSearchPath", "getCurrentTx", "Lcom/intellij/database/datagrid/DataRequest$TxMarker;", "getDisplayName", "getMessageBus", "isEphemeral", "setAutoCommit", "autoCommit", "dispose", "intellij.database.connectivity"})
    private static final class TemporaryClient
    implements VisibleDatabaseSessionClient,
    DataRequest.CustomSearchPathOwner {
        @NotNull
        private final DatabaseSession session;
        @NotNull
        private final DatabaseDepartment department;
        @Nullable
        private final SearchPath path;
        @NotNull
        private final String title;
        private volatile boolean disposed;
        private final DataBus.Consuming messageBus;

        public TemporaryClient(@NotNull DatabaseSession session, @NotNull DatabaseDepartment department, @Nullable SearchPath path) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)department, (String)"department");
            this.session = session;
            this.department = department;
            this.path = path;
            this.title = this.department.getDepartmentName();
            this.messageBus = this.getSession().getMessageBus().filterFor((DataRequest.Owner)this);
        }

        @Override
        @NotNull
        public DatabaseSession getSession() {
            return this.session;
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return this.department.getIcon();
        }

        @Override
        public boolean getShowOnActivity() {
            return false;
        }

        @Override
        @NotNull
        public String getTitle() {
            return this.title;
        }

        public int getTxIsolation() {
            return this.getSession().getTxIsolation();
        }

        public void setTxIsolation(int isolation) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean showOnAttention(@NotNull DataRequest.Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return false;
        }

        @Override
        public void detached(@NotNull DatabaseSessionClient.DetachTrigger trigger) {
            Intrinsics.checkNotNullParameter((Object)((Object)trigger), (String)"trigger");
        }

        @Override
        public boolean focusOnError(@NotNull DataRequest.Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return false;
        }

        @Override
        public boolean isActive() {
            return !this.disposed;
        }

        @Override
        public boolean isValid() {
            return !this.disposed;
        }

        @NotNull
        public DatabaseDepartment getDepartment() {
            return this.department;
        }

        @Nullable
        public SearchPath getSearchPath() {
            return this.path;
        }

        @NotNull
        public DataRequest.TxMarker getCurrentTx() {
            DataRequest.TxMarker txMarker = this.getSession().getCurrentTx();
            Intrinsics.checkNotNullExpressionValue((Object)txMarker, (String)"getCurrentTx(...)");
            return txMarker;
        }

        @NotNull
        public String getDisplayName() {
            return this.getTitle();
        }

        @Override
        @NotNull
        public DataBus.Consuming getMessageBus() {
            DataBus.Consuming consuming = this.messageBus;
            Intrinsics.checkNotNullExpressionValue((Object)consuming, (String)"messageBus");
            return consuming;
        }

        public boolean isEphemeral() {
            return true;
        }

        public void setAutoCommit(boolean autoCommit) {
            this.getSession().setAutoCommit(autoCommit);
        }

        public void dispose() {
            this.disposed = true;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\"\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u001cB'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H&\u00a2\u0006\u0002\u0010\u0016J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0019\u001a\u00020\u0004H\u0016J\u0006\u0010\u001a\u001a\u00020\u001bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR!\u0010\r\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u000eR\b\u0012\u0004\u0012\u00028\u00000\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$WrapperRequest;", "T", "Lcom/intellij/database/datagrid/DataRequest$RawRequest;", "owner", "Lcom/intellij/database/datagrid/DataRequest$OwnerEx;", "cont", "Lkotlinx/coroutines/CancellableContinuation;", "errorHandler", "Lcom/intellij/database/util/ErrorHandler;", "<init>", "(Lcom/intellij/database/datagrid/DataRequest$OwnerEx;Lkotlinx/coroutines/CancellableContinuation;Lcom/intellij/database/util/ErrorHandler;)V", "getCont", "()Lkotlinx/coroutines/CancellableContinuation;", "auditor", "Lcom/intellij/database/console/session/DatabaseSessionManager$WrapperRequest$TemporaryAuditor;", "getAuditor", "()Lcom/intellij/database/console/session/DatabaseSessionManager$WrapperRequest$TemporaryAuditor;", "process", "context", "Lcom/intellij/database/datagrid/DataRequest$Context;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnectionCore;", "(Lcom/intellij/database/datagrid/DataRequest$Context;Lcom/intellij/database/dataSource/DatabaseConnectionCore;)Ljava/lang/Object;", "processRaw", "", "getOwner", "submit", "", "TemporaryAuditor", "intellij.database.connectivity"})
    private static abstract class WrapperRequest<T>
    extends DataRequest.RawRequest {
        @NotNull
        private final CancellableContinuation<T> cont;
        @NotNull
        private final TemporaryAuditor<T> auditor;

        public WrapperRequest(@NotNull DataRequest.OwnerEx owner, @NotNull CancellableContinuation<? super T> cont, @Nullable ErrorHandler errorHandler) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter(cont, (String)"cont");
            super(owner);
            this.cont = cont;
            this.auditor = new TemporaryAuditor(errorHandler);
        }

        @NotNull
        public final CancellableContinuation<T> getCont() {
            return this.cont;
        }

        @NotNull
        public final TemporaryAuditor<T> getAuditor() {
            return this.auditor;
        }

        public abstract T process(@NotNull DataRequest.Context var1, @NotNull DatabaseConnectionCore var2);

        public final void processRaw(@NotNull DataRequest.Context context, @NotNull DatabaseConnectionCore connection2) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
            if (this.auditor.hasErrors()) {
                return;
            }
            try {
                this.cont.resume(this.process(context, connection2), null);
            }
            catch (InterruptedException e) {
                CancellableContinuation.DefaultImpls.cancel$default(this.cont, null, (int)1, null);
                throw new ProcessCanceledException((Throwable)e);
            }
            catch (ProcessCanceledException e) {
                CancellableContinuation.DefaultImpls.cancel$default(this.cont, null, (int)1, null);
                throw e;
            }
            catch (Throwable t) {
                ((Continuation)this.cont).resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)t)));
                throw new ProcessCanceledException(t);
            }
        }

        @NotNull
        public DataRequest.OwnerEx getOwner() {
            DataRequest.Owner owner = super.getOwner();
            Intrinsics.checkNotNull((Object)owner, (String)"null cannot be cast to non-null type com.intellij.database.datagrid.DataRequest.OwnerEx");
            return (DataRequest.OwnerEx)owner;
        }

        public final boolean submit() {
            this.getOwner().getMessageBus().addAuditor((DataAuditor)this.auditor);
            this.getOwner().getMessageBus().getDataProducer().processRequest((GridDataRequest)this);
            return this.auditor.getSubmitted();
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0006\u0010\u0015\u001a\u00020\bJ\u0018\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001c\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$WrapperRequest$TemporaryAuditor;", "T", "Lcom/intellij/database/datagrid/DataAuditor;", "handler", "Lcom/intellij/database/util/ErrorHandler;", "<init>", "(Lcom/intellij/database/console/session/DatabaseSessionManager$WrapperRequest;Lcom/intellij/database/util/ErrorHandler;)V", "connected", "", "wasError", "submitted", "getSubmitted", "()Z", "setSubmitted", "(Z)V", "error", "", "context", "Lcom/intellij/database/datagrid/DataRequest$Context;", "errorInfo", "Lcom/intellij/database/connection/throwable/info/ErrorInfo;", "hasErrors", "jobSubmitted", "request", "Lcom/intellij/database/datagrid/DataRequest;", "producer", "Lcom/intellij/database/datagrid/DataProducer;", "jobFinished", "isMy", "intellij.database.connectivity"})
        private final class TemporaryAuditor<T>
        implements DataAuditor {
            @Nullable
            private final ErrorHandler handler;
            private volatile boolean connected;
            private volatile boolean wasError;
            private boolean submitted;

            public TemporaryAuditor(ErrorHandler handler) {
                this.handler = handler;
            }

            public final boolean getSubmitted() {
                return this.submitted;
            }

            public final void setSubmitted(boolean bl) {
                this.submitted = bl;
            }

            public void error(@NotNull DataRequest.Context context, @NotNull ErrorInfo errorInfo) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)errorInfo, (String)"errorInfo");
                DataRequest dataRequest = context.request;
                Intrinsics.checkNotNullExpressionValue((Object)dataRequest, (String)"request");
                if (!this.isMy(dataRequest)) {
                    return;
                }
                ErrorHandler errorHandler = this.handler;
                if (errorHandler != null) {
                    errorHandler.add(errorInfo);
                }
                this.wasError = true;
                if (this.connected) {
                    return;
                }
                if (this.handler != null) {
                    CancellableContinuation.DefaultImpls.cancel$default(WrapperRequest.this.getCont(), null, (int)1, null);
                } else {
                    Continuation continuation = (Continuation)WrapperRequest.this.getCont();
                    Throwable throwable = ThrowableInfoUtil.getActualThrowable((ThrowableInfo)((ThrowableInfo)errorInfo));
                    Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"getActualThrowable(...)");
                    Throwable throwable2 = throwable;
                    continuation.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2)));
                }
            }

            public final boolean hasErrors() {
                this.connected = true;
                return this.wasError;
            }

            public void jobSubmitted(@NotNull DataRequest request2, @NotNull DataProducer producer) {
                Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
                Intrinsics.checkNotNullParameter((Object)producer, (String)"producer");
                if (!this.isMy(request2)) {
                    return;
                }
                this.submitted = true;
            }

            public void jobFinished(@NotNull DataRequest request2, @NotNull DataProducer producer) {
                Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
                Intrinsics.checkNotNullParameter((Object)producer, (String)"producer");
                if (this.isMy(request2) && !WrapperRequest.this.getCont().isCompleted()) {
                    CancellableContinuation.DefaultImpls.cancel$default(WrapperRequest.this.getCont(), null, (int)1, null);
                }
            }

            private final boolean isMy(DataRequest request2) {
                return Intrinsics.areEqual(WrapperRequest.this, (Object)request2);
            }
        }
    }
}

