/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.ClasspathModificationTrackerKt;
import com.intellij.database.dataSource.ServiceState;
import com.intellij.database.dataSource.SnapshotBean;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@State(name="ClasspathModificationTracker", storages={@Storage(value="ClasspathModificationTracker.xml")})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u00122\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/dataSource/ClasspathModificationTracker;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/database/dataSource/ServiceState;", "<init>", "()V", "cache", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/intellij/database/dataSource/SnapshotBean;", "state", "getState", "loadState", "", "checkAndUpdate", "", "path", "Ljava/nio/file/Path;", "checkAndGetUpdateCallback", "Lkotlin/Function0;", "normalize", "readSnapshotBean", "Companion", "intellij.database.connectivity"})
@SourceDebugExtension(value={"SMAP\nClasspathModificationTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClasspathModificationTracker.kt\ncom/intellij/database/dataSource/ClasspathModificationTracker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n1#2:87\n*E\n"})
public final class ClasspathModificationTracker
implements PersistentStateComponent<ServiceState> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentHashMap<String, SnapshotBean> cache = new ConcurrentHashMap();
    @NotNull
    private ServiceState state = new ServiceState(null, 1, null);

    @NotNull
    public ServiceState getState() {
        this.state.getFiles().clear();
        this.state.getFiles().putAll((Map<String, SnapshotBean>)this.cache);
        return this.state;
    }

    public void loadState(@NotNull ServiceState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Object object = XmlSerializerUtil.createCopy((Object)state);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"createCopy(...)");
        this.state = (ServiceState)object;
        this.cache.clear();
        this.cache.putAll(this.state.getFiles());
    }

    public final boolean checkAndUpdate(@NotNull Path path) {
        Function0<Unit> function0;
        block0: {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Function0<Unit> it = function0 = this.checkAndGetUpdateCallback(path);
            boolean bl = false;
            Function0<Unit> function02 = it;
            if (function02 == null) break block0;
            function02.invoke();
        }
        return function0 != null;
    }

    @Nullable
    public final Function0<Unit> checkAndGetUpdateCallback(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String key = this.normalize(path);
        Path path2 = Paths.get(key, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        SnapshotBean currentBean = this.readSnapshotBean(path2);
        SnapshotBean prevBean = this.cache.get(key);
        return !Intrinsics.areEqual((Object)prevBean, (Object)currentBean) ? () -> ClasspathModificationTracker.checkAndGetUpdateCallback$lambda$0(this, key, currentBean) : null;
    }

    private final String normalize(Path path) {
        String string;
        try {
            string = ((Object)path.toRealPath(new LinkOption[0])).toString();
        }
        catch (Exception exception) {
            string = ((Object)path.toAbsolutePath().normalize()).toString();
        }
        return string;
    }

    private final SnapshotBean readSnapshotBean(Path path) {
        SnapshotBean snapshotBean;
        try {
            SnapshotBean snapshotBean2;
            if (!Files.exists(path, new LinkOption[0])) {
                snapshotBean2 = new SnapshotBean(false, -1L, -1L);
            } else {
                BasicFileAttributes basicFileAttributes = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
                Intrinsics.checkNotNullExpressionValue((Object)basicFileAttributes, (String)"readAttributes(...)");
                BasicFileAttributes attrs = basicFileAttributes;
                snapshotBean2 = new SnapshotBean(true, attrs.lastModifiedTime().toMillis(), attrs.size());
            }
            snapshotBean = snapshotBean2;
        }
        catch (Throwable t) {
            ClasspathModificationTrackerKt.access$getLog$p().debug("Failed to read attributes for " + path, t);
            snapshotBean = new SnapshotBean(false, -1L, -1L);
        }
        return snapshotBean;
    }

    private static final Unit checkAndGetUpdateCallback$lambda$0(ClasspathModificationTracker this$0, String $key, SnapshotBean $currentBean) {
        ((Map)this$0.cache).put($key, $currentBean);
        return Unit.INSTANCE;
    }

    @JvmStatic
    @NotNull
    public static final ClasspathModificationTracker getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/dataSource/ClasspathModificationTracker$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/database/dataSource/ClasspathModificationTracker;", "intellij.database.connectivity"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ClasspathModificationTracker getInstance() {
            Object object = ApplicationManager.getApplication().getService(ClasspathModificationTracker.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (ClasspathModificationTracker)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

