/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.connectivity.dataSource;

import com.intellij.database.connectivity.dataSource.BasicDataSourceManager;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001f\b\u0014\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u00002\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0015\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/connectivity/dataSource/AbstractDataSourceManager;", "T", "Lcom/intellij/database/dataSource/AbstractDataSource;", "Lcom/intellij/database/connectivity/dataSource/BasicDataSourceManager;", "project", "Lcom/intellij/openapi/project/Project;", "dataSources", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;)V", "setGroupName", "", "dataSource", "groupName", "", "(Lcom/intellij/database/dataSource/AbstractDataSource;Ljava/lang/String;)V", "saveDataSource", "(Lcom/intellij/database/dataSource/AbstractDataSource;)V", "intellij.database.connectivity"})
public abstract class AbstractDataSourceManager<T extends AbstractDataSource>
extends BasicDataSourceManager<T> {
    protected AbstractDataSourceManager(@NotNull Project project, @NotNull List<? extends T> dataSources) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(dataSources, (String)"dataSources");
        super(project, dataSources);
    }

    public final void setGroupName(@NotNull T dataSource, @Nullable String groupName) {
        Intrinsics.checkNotNullParameter(dataSource, (String)"dataSource");
        String oldGroupName = dataSource.getGroupName();
        if (Intrinsics.areEqual((Object)oldGroupName, (Object)groupName)) {
            return;
        }
        dataSource.modify(() -> AbstractDataSourceManager.setGroupName$lambda$0(dataSource, groupName));
        this.saveDataSource(dataSource);
        MessageBus messageBus = this.myProject.getMessageBus();
        Topic topic = BasicDataSourceManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        ((DataSourceManager.Listener)messageBus.syncPublisher(topic)).dataSourceGroupChanged((RawDataSource)dataSource, oldGroupName, dataSource.getGroupName());
    }

    protected abstract void saveDataSource(@NotNull T var1);

    private static final void setGroupName$lambda$0(AbstractDataSource $dataSource, String $groupName) {
        $dataSource.setGroupName($groupName);
    }
}

